/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.Sorting;
import cern.colt.function.FloatProcedure;
import cern.colt.list.AbstractFloatList;
import cern.jet.math.Arithmetic;
import cern.jet.random.Uniform;
import cern.jet.random.engine.DRand;
import java.util.Date;

public class FloatArrayList
extends AbstractFloatList {
    protected float[] elements;

    public FloatArrayList() {
        this(10);
    }

    public FloatArrayList(float[] elements) {
        this.elements(elements);
    }

    public FloatArrayList(int initialCapacity) {
        this(new float[initialCapacity]);
        this.setSizeRaw(0);
    }

    @Override
    public void add(float element) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size++] = element;
    }

    @Override
    public void beforeInsert(int index, float element) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elements, index, this.elements, index + 1, this.size - index);
        this.elements[index] = element;
        ++this.size;
    }

    @Override
    public int binarySearchFromTo(float key, int from, int to) {
        return Sorting.binarySearchFromTo(this.elements, key, from, to);
    }

    @Override
    public Object clone() {
        FloatArrayList clone = new FloatArrayList((float[])this.elements.clone());
        clone.setSizeRaw(this.size);
        return clone;
    }

    public FloatArrayList copy() {
        return (FloatArrayList)this.clone();
    }

    @Override
    public float[] elements() {
        return this.elements;
    }

    @Override
    public AbstractFloatList elements(float[] elements) {
        this.elements = elements;
        this.size = elements.length;
        return this;
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        this.elements = Arrays.ensureCapacity(this.elements, minCapacity);
    }

    @Override
    public boolean equals(Object otherObj) {
        if (!(otherObj instanceof FloatArrayList)) {
            return super.equals(otherObj);
        }
        if (this == otherObj) {
            return true;
        }
        if (otherObj == null) {
            return false;
        }
        FloatArrayList other = (FloatArrayList)otherObj;
        if (this.size() != other.size()) {
            return false;
        }
        float[] theElements = this.elements();
        float[] otherElements = other.elements();
        int i = this.size();
        while (--i >= 0) {
            if (theElements[i] == otherElements[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEach(FloatProcedure procedure) {
        float[] theElements = this.elements;
        int theSize = this.size;
        int i = 0;
        while (i < theSize) {
            if (procedure.apply(theElements[i++])) continue;
            return false;
        }
        return true;
    }

    @Override
    public float get(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.elements[index];
    }

    @Override
    public float getQuick(int index) {
        return this.elements[index];
    }

    @Override
    public int indexOfFromTo(float element, int from, int to) {
        if (this.size == 0) {
            return -1;
        }
        FloatArrayList.checkRangeFromTo(from, to, this.size);
        float[] theElements = this.elements;
        for (int i = from; i <= to; ++i) {
            if (element != theElements[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOfFromTo(float element, int from, int to) {
        if (this.size == 0) {
            return -1;
        }
        FloatArrayList.checkRangeFromTo(from, to, this.size);
        float[] theElements = this.elements;
        for (int i = to; i >= from; --i) {
            if (element != theElements[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public AbstractFloatList partFromTo(int from, int to) {
        if (this.size == 0) {
            return new FloatArrayList(0);
        }
        FloatArrayList.checkRangeFromTo(from, to, this.size);
        float[] part = new float[to - from + 1];
        System.arraycopy(this.elements, from, part, 0, to - from + 1);
        return new FloatArrayList(part);
    }

    @Override
    public boolean removeAll(AbstractFloatList other) {
        double M2;
        if (!(other instanceof FloatArrayList)) {
            return super.removeAll(other);
        }
        if (other.size() == 0) {
            return false;
        }
        int limit = other.size() - 1;
        int j = 0;
        float[] theElements = this.elements;
        int mySize = this.size();
        double N = other.size();
        if ((N + (M2 = (double)mySize)) * Arithmetic.log2(N) < M2 * N) {
            FloatArrayList sortedList = (FloatArrayList)other.clone();
            sortedList.quickSort();
            for (int i = 0; i < mySize; ++i) {
                if (sortedList.binarySearchFromTo(theElements[i], 0, limit) >= 0) continue;
                theElements[j++] = theElements[i];
            }
        } else {
            for (int i = 0; i < mySize; ++i) {
                if (other.indexOfFromTo(theElements[i], 0, limit) >= 0) continue;
                theElements[j++] = theElements[i];
            }
        }
        boolean modified = j != mySize;
        this.setSize(j);
        return modified;
    }

    @Override
    public void replaceFromToWithFrom(int from, int to, AbstractFloatList other, int otherFrom) {
        if (!(other instanceof FloatArrayList)) {
            super.replaceFromToWithFrom(from, to, other, otherFrom);
            return;
        }
        int length = to - from + 1;
        if (length > 0) {
            FloatArrayList.checkRangeFromTo(from, to, this.size());
            FloatArrayList.checkRangeFromTo(otherFrom, otherFrom + length - 1, other.size());
            System.arraycopy(((FloatArrayList)other).elements, otherFrom, this.elements, from, length);
        }
    }

    @Override
    public boolean retainAll(AbstractFloatList other) {
        double M2;
        if (!(other instanceof FloatArrayList)) {
            return super.retainAll(other);
        }
        int limit = other.size() - 1;
        int j = 0;
        float[] theElements = this.elements;
        int mySize = this.size();
        double N = other.size();
        if ((N + (M2 = (double)mySize)) * Arithmetic.log2(N) < M2 * N) {
            FloatArrayList sortedList = (FloatArrayList)other.clone();
            sortedList.quickSort();
            for (int i = 0; i < mySize; ++i) {
                if (sortedList.binarySearchFromTo(theElements[i], 0, limit) < 0) continue;
                theElements[j++] = theElements[i];
            }
        } else {
            for (int i = 0; i < mySize; ++i) {
                if (other.indexOfFromTo(theElements[i], 0, limit) < 0) continue;
                theElements[j++] = theElements[i];
            }
        }
        boolean modified = j != mySize;
        this.setSize(j);
        return modified;
    }

    @Override
    public void reverse() {
        int limit = this.size / 2;
        int j = this.size - 1;
        float[] theElements = this.elements;
        int i = 0;
        while (i < limit) {
            float tmp = theElements[i];
            theElements[i++] = theElements[j];
            theElements[j--] = tmp;
        }
    }

    @Override
    public void set(int index, float element) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.elements[index] = element;
    }

    @Override
    public void setQuick(int index, float element) {
        this.elements[index] = element;
    }

    @Override
    public void shuffleFromTo(int from, int to) {
        if (this.size == 0) {
            return;
        }
        FloatArrayList.checkRangeFromTo(from, to, this.size);
        Uniform gen = new Uniform(new DRand(new Date()));
        float[] theElements = this.elements;
        for (int i = from; i < to; ++i) {
            int random = gen.nextIntFromTo(i, to);
            float tmpElement = theElements[random];
            theElements[random] = theElements[i];
            theElements[i] = tmpElement;
        }
    }

    @Override
    public void trimToSize() {
        this.elements = Arrays.trimToCapacity(this.elements, this.size());
    }
}

