/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix;

import cern.colt.PersistentObject;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.impl.RCDoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cern.jet.math.Functions;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.sampling.RandomSamplingAssistant;

public class DoubleFactory2D
extends PersistentObject {
    public static final DoubleFactory2D dense = new DoubleFactory2D();
    public static final DoubleFactory2D sparse = new DoubleFactory2D();
    public static final DoubleFactory2D rowCompressed = new DoubleFactory2D();

    protected DoubleFactory2D() {
    }

    public DoubleMatrix2D appendColumns(DoubleMatrix2D A2, DoubleMatrix2D B) {
        if (B.rows() > A2.rows()) {
            B = B.viewPart(0, 0, A2.rows(), B.columns());
        } else if (B.rows() < A2.rows()) {
            A2 = A2.viewPart(0, 0, B.rows(), A2.columns());
        }
        int ac = A2.columns();
        int bc = B.columns();
        int r = A2.rows();
        DoubleMatrix2D matrix = this.make(r, ac + bc);
        matrix.viewPart(0, 0, r, ac).assign(A2);
        matrix.viewPart(0, ac, r, bc).assign(B);
        return matrix;
    }

    public DoubleMatrix2D appendRows(DoubleMatrix2D A2, DoubleMatrix2D B) {
        if (B.columns() > A2.columns()) {
            B = B.viewPart(0, 0, B.rows(), A2.columns());
        } else if (B.columns() < A2.columns()) {
            A2 = A2.viewPart(0, 0, A2.rows(), B.columns());
        }
        int ar = A2.rows();
        int br = B.rows();
        int c = A2.columns();
        DoubleMatrix2D matrix = this.make(ar + br, c);
        matrix.viewPart(0, 0, ar, c).assign(A2);
        matrix.viewPart(ar, 0, br, c).assign(B);
        return matrix;
    }

    public DoubleMatrix2D ascending(int rows, int columns) {
        Functions F = Functions.functions;
        return this.descending(rows, columns).assign(Functions.chain(Functions.neg, Functions.minus(columns * rows)));
    }

    protected static void checkRectangularShape(double[][] array) {
        int columns = -1;
        int row = array.length;
        while (--row >= 0) {
            if (array[row] == null) continue;
            if (columns == -1) {
                columns = array[row].length;
            }
            if (array[row].length == columns) continue;
            throw new IllegalArgumentException("All rows of array must have same number of columns.");
        }
    }

    protected static void checkRectangularShape(DoubleMatrix2D[][] array) {
        int columns = -1;
        int row = array.length;
        while (--row >= 0) {
            if (array[row] == null) continue;
            if (columns == -1) {
                columns = array[row].length;
            }
            if (array[row].length == columns) continue;
            throw new IllegalArgumentException("All rows of array must have same number of columns.");
        }
    }

    public DoubleMatrix2D compose(DoubleMatrix2D[][] parts) {
        int row;
        DoubleFactory2D.checkRectangularShape(parts);
        int rows = parts.length;
        int columns = 0;
        if (parts.length > 0) {
            columns = parts[0].length;
        }
        DoubleMatrix2D empty = this.make(0, 0);
        if (rows == 0 || columns == 0) {
            return empty;
        }
        int[] maxWidths = new int[columns];
        int column = columns;
        while (--column >= 0) {
            int maxWidth = 0;
            row = rows;
            while (--row >= 0) {
                DoubleMatrix2D part = parts[row][column];
                if (part == null) continue;
                int width = part.columns();
                if (maxWidth > 0 && width > 0 && width != maxWidth) {
                    throw new IllegalArgumentException("Different number of columns.");
                }
                maxWidth = Math.max(maxWidth, width);
            }
            maxWidths[column] = maxWidth;
        }
        int[] maxHeights = new int[rows];
        int row2 = rows;
        while (--row2 >= 0) {
            int maxHeight = 0;
            int column2 = columns;
            while (--column2 >= 0) {
                DoubleMatrix2D part = parts[row2][column2];
                if (part == null) continue;
                int height = part.rows();
                if (maxHeight > 0 && height > 0 && height != maxHeight) {
                    throw new IllegalArgumentException("Different number of rows.");
                }
                maxHeight = Math.max(maxHeight, height);
            }
            maxHeights[row2] = maxHeight;
        }
        int resultRows = 0;
        row = rows;
        while (--row >= 0) {
            resultRows += maxHeights[row];
        }
        int resultCols = 0;
        int column3 = columns;
        while (--column3 >= 0) {
            resultCols += maxWidths[column3];
        }
        DoubleMatrix2D matrix = this.make(resultRows, resultCols);
        int r = 0;
        for (int row3 = 0; row3 < rows; ++row3) {
            int c = 0;
            for (int column4 = 0; column4 < columns; ++column4) {
                DoubleMatrix2D part = parts[row3][column4];
                if (part != null) {
                    matrix.viewPart(r, c, part.rows(), part.columns()).assign(part);
                }
                c += maxWidths[column4];
            }
            r += maxHeights[row3];
        }
        return matrix;
    }

    public DoubleMatrix2D composeDiagonal(DoubleMatrix2D A2, DoubleMatrix2D B) {
        int ar = A2.rows();
        int ac = A2.columns();
        int br = B.rows();
        int bc = B.columns();
        DoubleMatrix2D sum = this.make(ar + br, ac + bc);
        sum.viewPart(0, 0, ar, ac).assign(A2);
        sum.viewPart(ar, ac, br, bc).assign(B);
        return sum;
    }

    public DoubleMatrix2D composeDiagonal(DoubleMatrix2D A2, DoubleMatrix2D B, DoubleMatrix2D C) {
        DoubleMatrix2D diag = this.make(A2.rows() + B.rows() + C.rows(), A2.columns() + B.columns() + C.columns());
        diag.viewPart(0, 0, A2.rows(), A2.columns()).assign(A2);
        diag.viewPart(A2.rows(), A2.columns(), B.rows(), B.columns()).assign(B);
        diag.viewPart(A2.rows() + B.rows(), A2.columns() + B.columns(), C.rows(), C.columns()).assign(C);
        return diag;
    }

    public void decompose(DoubleMatrix2D[][] parts, DoubleMatrix2D matrix) {
        int row;
        DoubleFactory2D.checkRectangularShape(parts);
        int rows = parts.length;
        int columns = 0;
        if (parts.length > 0) {
            columns = parts[0].length;
        }
        if (rows == 0 || columns == 0) {
            return;
        }
        int[] maxWidths = new int[columns];
        int column = columns;
        while (--column >= 0) {
            int maxWidth = 0;
            row = rows;
            while (--row >= 0) {
                DoubleMatrix2D part = parts[row][column];
                if (part == null) continue;
                int width = part.columns();
                if (maxWidth > 0 && width > 0 && width != maxWidth) {
                    throw new IllegalArgumentException("Different number of columns.");
                }
                maxWidth = Math.max(maxWidth, width);
            }
            maxWidths[column] = maxWidth;
        }
        int[] maxHeights = new int[rows];
        int row2 = rows;
        while (--row2 >= 0) {
            int maxHeight = 0;
            int column2 = columns;
            while (--column2 >= 0) {
                DoubleMatrix2D part = parts[row2][column2];
                if (part == null) continue;
                int height = part.rows();
                if (maxHeight > 0 && height > 0 && height != maxHeight) {
                    throw new IllegalArgumentException("Different number of rows.");
                }
                maxHeight = Math.max(maxHeight, height);
            }
            maxHeights[row2] = maxHeight;
        }
        int resultRows = 0;
        row = rows;
        while (--row >= 0) {
            resultRows += maxHeights[row];
        }
        int resultCols = 0;
        int column3 = columns;
        while (--column3 >= 0) {
            resultCols += maxWidths[column3];
        }
        if (matrix.rows() < resultRows || matrix.columns() < resultCols) {
            throw new IllegalArgumentException("Parts larger than matrix.");
        }
        int r = 0;
        for (int row3 = 0; row3 < rows; ++row3) {
            int c = 0;
            for (int column4 = 0; column4 < columns; ++column4) {
                DoubleMatrix2D part = parts[row3][column4];
                if (part != null) {
                    part.assign(matrix.viewPart(r, c, part.rows(), part.columns()));
                }
                c += maxWidths[column4];
            }
            r += maxHeights[row3];
        }
    }

    public void demo1() {
        System.out.println("\n\n");
        DoubleMatrix2D[][] parts1 = new DoubleMatrix2D[][]{{null, this.make(2, 2, 1.0), null}, {this.make(4, 4, 2.0), null, this.make(4, 3, 3.0)}, {null, this.make(2, 2, 4.0), null}};
        System.out.println("\n" + this.compose(parts1));
        DoubleMatrix2D[][] parts3 = new DoubleMatrix2D[][]{{this.identity(3), null}, {null, this.identity(3).viewColumnFlip()}, {this.identity(3).viewRowFlip(), null}};
        System.out.println("\n" + this.compose(parts3));
        DoubleMatrix2D A2 = this.ascending(2, 2);
        DoubleMatrix2D B = this.descending(2, 2);
        Object _ = null;
        DoubleMatrix2D[][] parts4 = new DoubleMatrix2D[][]{{A2, _, A2, _}, {_, A2, _, B}};
        System.out.println("\n" + this.compose(parts4));
    }

    public void demo2() {
        System.out.println("\n\n");
        Object _ = null;
        DoubleMatrix2D A2 = this.make(2, 2, 1.0);
        DoubleMatrix2D B = this.make(4, 4, 2.0);
        DoubleMatrix2D C = this.make(4, 3, 3.0);
        DoubleMatrix2D D = this.make(2, 2, 4.0);
        DoubleMatrix2D[][] parts1 = new DoubleMatrix2D[][]{{_, A2, _}, {B, _, C}, {_, D, _}};
        DoubleMatrix2D matrix = this.compose(parts1);
        System.out.println("\n" + matrix);
        A2.assign(9.0);
        B.assign(9.0);
        C.assign(9.0);
        D.assign(9.0);
        this.decompose(parts1, matrix);
        System.out.println(A2);
        System.out.println(B);
        System.out.println(C);
        System.out.println(D);
    }

    public DoubleMatrix2D descending(int rows, int columns) {
        DoubleMatrix2D matrix = this.make(rows, columns);
        int v = 0;
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                matrix.setQuick(row, column, v++);
            }
        }
        return matrix;
    }

    public DoubleMatrix2D diagonal(DoubleMatrix1D vector) {
        int size = vector.size();
        DoubleMatrix2D diag = this.make(size, size);
        int i = size;
        while (--i >= 0) {
            diag.setQuick(i, i, vector.getQuick(i));
        }
        return diag;
    }

    public DoubleMatrix1D diagonal(DoubleMatrix2D A2) {
        int min = Math.min(A2.rows(), A2.columns());
        DoubleMatrix1D diag = this.make1D(min);
        int i = min;
        while (--i >= 0) {
            diag.setQuick(i, A2.getQuick(i, i));
        }
        return diag;
    }

    public DoubleMatrix2D identity(int rowsAndColumns) {
        DoubleMatrix2D matrix = this.make(rowsAndColumns, rowsAndColumns);
        int i = rowsAndColumns;
        while (--i >= 0) {
            matrix.setQuick(i, i, 1.0);
        }
        return matrix;
    }

    public DoubleMatrix2D make(double[][] values) {
        if (this == sparse) {
            return new SparseDoubleMatrix2D(values);
        }
        return new DenseDoubleMatrix2D(values);
    }

    public DoubleMatrix2D make(double[] values, int rows) {
        int columns;
        int n = columns = rows != 0 ? values.length / rows : 0;
        if (rows * columns != values.length) {
            throw new IllegalArgumentException("Array length must be a multiple of m.");
        }
        DoubleMatrix2D matrix = this.make(rows, columns);
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                matrix.setQuick(row, column, values[row + column * rows]);
            }
        }
        return matrix;
    }

    public DoubleMatrix2D make(int rows, int columns) {
        if (this == sparse) {
            return new SparseDoubleMatrix2D(rows, columns);
        }
        if (this == rowCompressed) {
            return new RCDoubleMatrix2D(rows, columns);
        }
        return new DenseDoubleMatrix2D(rows, columns);
    }

    public DoubleMatrix2D make(int rows, int columns, double initialValue) {
        if (initialValue == 0.0) {
            return this.make(rows, columns);
        }
        return this.make(rows, columns).assign(initialValue);
    }

    protected DoubleMatrix1D make1D(int size) {
        return this.make(0, 0).like1D(size);
    }

    public DoubleMatrix2D random(int rows, int columns) {
        return this.make(rows, columns).assign(Functions.random());
    }

    public DoubleMatrix2D repeat(DoubleMatrix2D A2, int rowRepeat, int columnRepeat) {
        int r = A2.rows();
        int c = A2.columns();
        DoubleMatrix2D matrix = this.make(r * rowRepeat, c * columnRepeat);
        int i = rowRepeat;
        while (--i >= 0) {
            int j = columnRepeat;
            while (--j >= 0) {
                matrix.viewPart(r * i, c * j, r, c).assign(A2);
            }
        }
        return matrix;
    }

    public DoubleMatrix2D sample(int rows, int columns, double value, double nonZeroFraction) {
        DoubleMatrix2D matrix = this.make(rows, columns);
        this.sample(matrix, value, nonZeroFraction);
        return matrix;
    }

    public DoubleMatrix2D sample(DoubleMatrix2D matrix, double value, double nonZeroFraction) {
        int rows = matrix.rows();
        int columns = matrix.columns();
        double epsilon = 1.0E-9;
        if (nonZeroFraction < 0.0 - epsilon || nonZeroFraction > 1.0 + epsilon) {
            throw new IllegalArgumentException();
        }
        if (nonZeroFraction < 0.0) {
            nonZeroFraction = 0.0;
        }
        if (nonZeroFraction > 1.0) {
            nonZeroFraction = 1.0;
        }
        matrix.assign(0.0);
        int size = rows * columns;
        int n = (int)Math.round((double)size * nonZeroFraction);
        if (n == 0) {
            return matrix;
        }
        RandomSamplingAssistant sampler = new RandomSamplingAssistant(n, size, new MersenneTwister());
        for (int i = 0; i < size; ++i) {
            if (!sampler.sampleNextElement()) continue;
            int row = i / columns;
            int column = i % columns;
            matrix.set(row, column, value);
        }
        return matrix;
    }
}

