/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix;

import cern.colt.PersistentObject;
import cern.colt.list.ObjectArrayList;
import cern.colt.matrix.ObjectMatrix1D;
import cern.colt.matrix.impl.DenseObjectMatrix1D;
import cern.colt.matrix.impl.SparseObjectMatrix1D;

public class ObjectFactory1D
extends PersistentObject {
    public static final ObjectFactory1D dense = new ObjectFactory1D();
    public static final ObjectFactory1D sparse = new ObjectFactory1D();

    protected ObjectFactory1D() {
    }

    public ObjectMatrix1D append(ObjectMatrix1D A2, ObjectMatrix1D B) {
        ObjectMatrix1D matrix = this.make(A2.size() + B.size());
        matrix.viewPart(0, A2.size()).assign(A2);
        matrix.viewPart(A2.size(), B.size()).assign(B);
        return matrix;
    }

    public ObjectMatrix1D make(ObjectMatrix1D[] parts) {
        if (parts.length == 0) {
            return this.make(0);
        }
        int size = 0;
        for (int i = 0; i < parts.length; ++i) {
            size += parts[i].size();
        }
        ObjectMatrix1D vector = this.make(size);
        size = 0;
        for (int i = 0; i < parts.length; ++i) {
            vector.viewPart(size, parts[i].size()).assign(parts[i]);
            size += parts[i].size();
        }
        return vector;
    }

    public ObjectMatrix1D make(Object[] values) {
        if (this == sparse) {
            return new SparseObjectMatrix1D(values);
        }
        return new DenseObjectMatrix1D(values);
    }

    public ObjectMatrix1D make(int size) {
        if (this == sparse) {
            return new SparseObjectMatrix1D(size);
        }
        return new DenseObjectMatrix1D(size);
    }

    public ObjectMatrix1D make(int size, Object initialValue) {
        return this.make(size).assign(initialValue);
    }

    public ObjectMatrix1D make(ObjectArrayList values) {
        int size = values.size();
        ObjectMatrix1D vector = this.make(size);
        int i = size;
        while (--i >= 0) {
            vector.set(i, values.get(i));
        }
        return vector;
    }

    public ObjectMatrix1D repeat(ObjectMatrix1D A2, int repeat) {
        int size = A2.size();
        ObjectMatrix1D matrix = this.make(repeat * size);
        int i = repeat;
        while (--i >= 0) {
            matrix.viewPart(size * i, size).assign(A2);
        }
        return matrix;
    }

    public ObjectArrayList toList(ObjectMatrix1D values) {
        int size = values.size();
        ObjectArrayList list = new ObjectArrayList(size);
        list.setSize(size);
        int i = size;
        while (--i >= 0) {
            list.set(i, values.get(i));
        }
        return list;
    }
}

