/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.linalg;

import cern.colt.GenericSorting;
import cern.colt.PersistentObject;
import cern.colt.Swapper;
import cern.colt.function.IntComparator;
import cern.colt.list.ObjectArrayList;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.DoubleMatrix3D;
import cern.colt.matrix.doublealgo.Formatter;
import cern.colt.matrix.linalg.Algebra;
import cern.jet.math.Functions;

public class Property
extends PersistentObject {
    public static final Property DEFAULT = new Property(1.0E-9);
    public static final Property ZERO = new Property(0.0);
    public static final Property TWELVE = new Property(1.0E-12);
    protected double tolerance;

    private Property() {
        this(1.0E-9);
    }

    public Property(double newTolerance) {
        this.tolerance = Math.abs(newTolerance);
    }

    protected static String blanks(int length) {
        if (length < 0) {
            length = 0;
        }
        StringBuffer buf = new StringBuffer(length);
        for (int k = 0; k < length; ++k) {
            buf.append(' ');
        }
        return buf.toString();
    }

    public void checkRectangular(DoubleMatrix2D A2) {
        if (A2.rows() < A2.columns()) {
            throw new IllegalArgumentException("Matrix must be rectangular: " + Formatter.shape(A2));
        }
    }

    public void checkSquare(DoubleMatrix2D A2) {
        if (A2.rows() != A2.columns()) {
            throw new IllegalArgumentException("Matrix must be square: " + Formatter.shape(A2));
        }
    }

    public double density(DoubleMatrix2D A2) {
        return (double)A2.cardinality() / (double)A2.size();
    }

    public boolean equals(DoubleMatrix1D A2, double value) {
        if (A2 == null) {
            return false;
        }
        double epsilon = this.tolerance();
        int i = A2.size();
        while (--i >= 0) {
            double x = A2.getQuick(i);
            double diff = Math.abs(value - x);
            if (diff != diff && (value != value && x != x || value == x)) {
                diff = 0.0;
            }
            if (diff <= epsilon) continue;
            return false;
        }
        return true;
    }

    public boolean equals(DoubleMatrix1D A2, DoubleMatrix1D B) {
        if (A2 == B) {
            return true;
        }
        if (A2 == null || B == null) {
            return false;
        }
        int size = A2.size();
        if (size != B.size()) {
            return false;
        }
        double epsilon = this.tolerance();
        int i = size;
        while (--i >= 0) {
            double x = A2.getQuick(i);
            double value = B.getQuick(i);
            double diff = Math.abs(value - x);
            if (diff != diff && (value != value && x != x || value == x)) {
                diff = 0.0;
            }
            if (diff <= epsilon) continue;
            return false;
        }
        return true;
    }

    public boolean equals(DoubleMatrix2D A2, double value) {
        if (A2 == null) {
            return false;
        }
        int rows = A2.rows();
        int columns = A2.columns();
        double epsilon = this.tolerance();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                double x = A2.getQuick(row, column);
                double diff = Math.abs(value - x);
                if (diff != diff && (value != value && x != x || value == x)) {
                    diff = 0.0;
                }
                if (diff <= epsilon) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(DoubleMatrix2D A2, DoubleMatrix2D B) {
        if (A2 == B) {
            return true;
        }
        if (A2 == null || B == null) {
            return false;
        }
        int rows = A2.rows();
        int columns = A2.columns();
        if (columns != B.columns() || rows != B.rows()) {
            return false;
        }
        double epsilon = this.tolerance();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                double x = A2.getQuick(row, column);
                double value = B.getQuick(row, column);
                double diff = Math.abs(value - x);
                if (diff != diff && (value != value && x != x || value == x)) {
                    diff = 0.0;
                }
                if (diff <= epsilon) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(DoubleMatrix3D A2, double value) {
        if (A2 == null) {
            return false;
        }
        int rows = A2.rows();
        int columns = A2.columns();
        double epsilon = this.tolerance();
        int slice = A2.slices();
        while (--slice >= 0) {
            int row = rows;
            while (--row >= 0) {
                int column = columns;
                while (--column >= 0) {
                    double x = A2.getQuick(slice, row, column);
                    double diff = Math.abs(value - x);
                    if (diff != diff && (value != value && x != x || value == x)) {
                        diff = 0.0;
                    }
                    if (diff <= epsilon) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean equals(DoubleMatrix3D A2, DoubleMatrix3D B) {
        if (A2 == B) {
            return true;
        }
        if (A2 == null || B == null) {
            return false;
        }
        int slices = A2.slices();
        int rows = A2.rows();
        int columns = A2.columns();
        if (columns != B.columns() || rows != B.rows() || slices != B.slices()) {
            return false;
        }
        double epsilon = this.tolerance();
        int slice = slices;
        while (--slice >= 0) {
            int row = rows;
            while (--row >= 0) {
                int column = columns;
                while (--column >= 0) {
                    double x = A2.getQuick(slice, row, column);
                    double value = B.getQuick(slice, row, column);
                    double diff = Math.abs(value - x);
                    if (diff != diff && (value != value && x != x || value == x)) {
                        diff = 0.0;
                    }
                    if (diff <= epsilon) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void generateNonSingular(DoubleMatrix2D A2) {
        int min;
        this.checkSquare(A2);
        Functions F = Functions.functions;
        int i = min = Math.min(A2.rows(), A2.columns());
        while (--i >= 0) {
            A2.setQuick(i, i, 0.0);
        }
        i = min;
        while (--i >= 0) {
            double rowSum = A2.viewRow(i).aggregate(Functions.plus, Functions.abs);
            double colSum = A2.viewColumn(i).aggregate(Functions.plus, Functions.abs);
            A2.setQuick(i, i, Math.max(rowSum, colSum) + (double)i + 1.0);
        }
    }

    protected static String get(ObjectArrayList list, int index) {
        return (String)list.get(index);
    }

    public boolean isDiagonal(DoubleMatrix2D A2) {
        double epsilon = this.tolerance();
        int rows = A2.rows();
        int columns = A2.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (row == column || Math.abs(A2.getQuick(row, column)) <= epsilon) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isDiagonallyDominantByColumn(DoubleMatrix2D A2) {
        int min;
        Functions F = Functions.functions;
        double epsilon = this.tolerance();
        int i = min = Math.min(A2.rows(), A2.columns());
        while (--i >= 0) {
            double diag = Math.abs(A2.getQuick(i, i));
            diag += diag;
            if (!(diag <= A2.viewColumn(i).aggregate(Functions.plus, Functions.abs))) continue;
            return false;
        }
        return true;
    }

    public boolean isDiagonallyDominantByRow(DoubleMatrix2D A2) {
        int min;
        Functions F = Functions.functions;
        double epsilon = this.tolerance();
        int i = min = Math.min(A2.rows(), A2.columns());
        while (--i >= 0) {
            double diag = Math.abs(A2.getQuick(i, i));
            diag += diag;
            if (!(diag <= A2.viewRow(i).aggregate(Functions.plus, Functions.abs))) continue;
            return false;
        }
        return true;
    }

    public boolean isIdentity(DoubleMatrix2D A2) {
        double epsilon = this.tolerance();
        int rows = A2.rows();
        int columns = A2.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                double v = A2.getQuick(row, column);
                if (!(row == column ? !(Math.abs(1.0 - v) < epsilon) : !(Math.abs(v) <= epsilon))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isLowerBidiagonal(DoubleMatrix2D A2) {
        double epsilon = this.tolerance();
        int rows = A2.rows();
        int columns = A2.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (row == column || row == column + 1 || Math.abs(A2.getQuick(row, column)) <= epsilon) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isLowerTriangular(DoubleMatrix2D A2) {
        int columns;
        double epsilon = this.tolerance();
        int rows = A2.rows();
        int column = columns = A2.columns();
        while (--column >= 0) {
            int row = Math.min(column, rows);
            while (--row >= 0) {
                if (Math.abs(A2.getQuick(row, column)) <= epsilon) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isNonNegative(DoubleMatrix2D A2) {
        int rows = A2.rows();
        int columns = A2.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (A2.getQuick(row, column) >= 0.0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isOrthogonal(DoubleMatrix2D A2) {
        this.checkSquare(A2);
        return this.equals(A2.zMult(A2, null, 1.0, 0.0, false, true), DoubleFactory2D.dense.identity(A2.rows()));
    }

    public boolean isPositive(DoubleMatrix2D A2) {
        int rows = A2.rows();
        int columns = A2.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (A2.getQuick(row, column) > 0.0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSingular(DoubleMatrix2D A2) {
        return !(Math.abs(Algebra.DEFAULT.det(A2)) >= this.tolerance());
    }

    public boolean isSkewSymmetric(DoubleMatrix2D A2) {
        this.checkSquare(A2);
        double epsilon = this.tolerance();
        int rows = A2.rows();
        int columns = A2.columns();
        int row = rows;
        while (--row >= 0) {
            int column = rows;
            while (--column >= 0) {
                if (Math.abs(A2.getQuick(row, column) + A2.getQuick(column, row)) <= epsilon) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSquare(DoubleMatrix2D A2) {
        return A2.rows() == A2.columns();
    }

    public boolean isStrictlyLowerTriangular(DoubleMatrix2D A2) {
        int columns;
        double epsilon = this.tolerance();
        int rows = A2.rows();
        int column = columns = A2.columns();
        while (--column >= 0) {
            int row = Math.min(rows, column + 1);
            while (--row >= 0) {
                if (Math.abs(A2.getQuick(row, column)) <= epsilon) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isStrictlyTriangular(DoubleMatrix2D A2) {
        if (!this.isTriangular(A2)) {
            return false;
        }
        double epsilon = this.tolerance();
        int i = Math.min(A2.rows(), A2.columns());
        while (--i >= 0) {
            if (Math.abs(A2.getQuick(i, i)) <= epsilon) continue;
            return false;
        }
        return true;
    }

    public boolean isStrictlyUpperTriangular(DoubleMatrix2D A2) {
        int columns;
        double epsilon = this.tolerance();
        int rows = A2.rows();
        int column = columns = A2.columns();
        while (--column >= 0) {
            int row = rows;
            while (--row >= column) {
                if (Math.abs(A2.getQuick(row, column)) <= epsilon) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSymmetric(DoubleMatrix2D A2) {
        this.checkSquare(A2);
        return this.equals(A2, A2.viewDice());
    }

    public boolean isTriangular(DoubleMatrix2D A2) {
        return this.isLowerTriangular(A2) || this.isUpperTriangular(A2);
    }

    public boolean isTridiagonal(DoubleMatrix2D A2) {
        double epsilon = this.tolerance();
        int rows = A2.rows();
        int columns = A2.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (Math.abs(row - column) <= 1 || Math.abs(A2.getQuick(row, column)) <= epsilon) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isUnitTriangular(DoubleMatrix2D A2) {
        if (!this.isTriangular(A2)) {
            return false;
        }
        double epsilon = this.tolerance();
        int i = Math.min(A2.rows(), A2.columns());
        while (--i >= 0) {
            if (Math.abs(1.0 - A2.getQuick(i, i)) <= epsilon) continue;
            return false;
        }
        return true;
    }

    public boolean isUpperBidiagonal(DoubleMatrix2D A2) {
        double epsilon = this.tolerance();
        int rows = A2.rows();
        int columns = A2.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (row == column || row == column - 1 || Math.abs(A2.getQuick(row, column)) <= epsilon) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isUpperTriangular(DoubleMatrix2D A2) {
        int columns;
        double epsilon = this.tolerance();
        int rows = A2.rows();
        int column = columns = A2.columns();
        while (--column >= 0) {
            int row = rows;
            while (--row > column) {
                if (Math.abs(A2.getQuick(row, column)) <= epsilon) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isZero(DoubleMatrix2D A2) {
        return this.equals(A2, 0.0);
    }

    public int lowerBandwidth(DoubleMatrix2D A2) {
        int rows;
        this.checkSquare(A2);
        double epsilon = this.tolerance();
        int k = rows = A2.rows();
        while (--k >= 0) {
            int i = rows - k;
            while (--i >= 0) {
                int j = i + k;
                if (Math.abs(A2.getQuick(j, i)) <= epsilon) continue;
                return k;
            }
        }
        return 0;
    }

    public int semiBandwidth(DoubleMatrix2D A2) {
        int rows;
        this.checkSquare(A2);
        double epsilon = this.tolerance();
        int k = rows = A2.rows();
        while (--k >= 0) {
            int i = rows - k;
            while (--i >= 0) {
                int j = i + k;
                if (!(Math.abs(A2.getQuick(j, i)) <= epsilon)) {
                    return k + 1;
                }
                if (Math.abs(A2.getQuick(i, j)) <= epsilon) continue;
                return k + 1;
            }
        }
        return 1;
    }

    public void setTolerance(double newTolerance) {
        if (this == DEFAULT || this == ZERO || this == TWELVE) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        this.tolerance = Math.abs(newTolerance);
    }

    public double tolerance() {
        return this.tolerance;
    }

    public String toString(DoubleMatrix2D A2) {
        final ObjectArrayList names = new ObjectArrayList();
        final ObjectArrayList values = new ObjectArrayList();
        String unknown = "Illegal operation or error: ";
        names.add("density");
        try {
            values.add(String.valueOf(this.density(A2)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isDiagonal");
        try {
            values.add(String.valueOf(this.isDiagonal(A2)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isDiagonallyDominantByRow");
        try {
            values.add(String.valueOf(this.isDiagonallyDominantByRow(A2)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isDiagonallyDominantByColumn");
        try {
            values.add(String.valueOf(this.isDiagonallyDominantByColumn(A2)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isIdentity");
        try {
            values.add(String.valueOf(this.isIdentity(A2)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isLowerBidiagonal");
        try {
            values.add(String.valueOf(this.isLowerBidiagonal(A2)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isLowerTriangular");
        try {
            values.add(String.valueOf(this.isLowerTriangular(A2)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isNonNegative");
        try {
            values.add(String.valueOf(this.isNonNegative(A2)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isOrthogonal");
        try {
            values.add(String.valueOf(this.isOrthogonal(A2)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isPositive");
        try {
            values.add(String.valueOf(this.isPositive(A2)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isSingular");
        try {
            values.add(String.valueOf(this.isSingular(A2)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isSkewSymmetric");
        try {
            values.add(String.valueOf(this.isSkewSymmetric(A2)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isSquare");
        try {
            values.add(String.valueOf(this.isSquare(A2)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isStrictlyLowerTriangular");
        try {
            values.add(String.valueOf(this.isStrictlyLowerTriangular(A2)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isStrictlyTriangular");
        try {
            values.add(String.valueOf(this.isStrictlyTriangular(A2)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isStrictlyUpperTriangular");
        try {
            values.add(String.valueOf(this.isStrictlyUpperTriangular(A2)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isSymmetric");
        try {
            values.add(String.valueOf(this.isSymmetric(A2)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isTriangular");
        try {
            values.add(String.valueOf(this.isTriangular(A2)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isTridiagonal");
        try {
            values.add(String.valueOf(this.isTridiagonal(A2)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isUnitTriangular");
        try {
            values.add(String.valueOf(this.isUnitTriangular(A2)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isUpperBidiagonal");
        try {
            values.add(String.valueOf(this.isUpperBidiagonal(A2)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isUpperTriangular");
        try {
            values.add(String.valueOf(this.isUpperTriangular(A2)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("isZero");
        try {
            values.add(String.valueOf(this.isZero(A2)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("lowerBandwidth");
        try {
            values.add(String.valueOf(this.lowerBandwidth(A2)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("semiBandwidth");
        try {
            values.add(String.valueOf(this.semiBandwidth(A2)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        names.add("upperBandwidth");
        try {
            values.add(String.valueOf(this.upperBandwidth(A2)));
        }
        catch (IllegalArgumentException exc) {
            values.add(unknown + exc.getMessage());
        }
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                return Property.get(names, a).compareTo(Property.get(names, b));
            }
        };
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int a, int b) {
                Object tmp = names.get(a);
                names.set(a, names.get(b));
                names.set(b, tmp);
                tmp = values.get(a);
                values.set(a, values.get(b));
                values.set(b, tmp);
            }
        };
        GenericSorting.quickSort(0, names.size(), comp, swapper);
        int maxLength = 0;
        for (int i = 0; i < names.size(); ++i) {
            int length = ((String)names.get(i)).length();
            maxLength = Math.max(length, maxLength);
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            buf.append(name);
            buf.append(Property.blanks(maxLength - name.length()));
            buf.append(" : ");
            buf.append(values.get(i));
            if (i >= names.size() - 1) continue;
            buf.append('\n');
        }
        return buf.toString();
    }

    public int upperBandwidth(DoubleMatrix2D A2) {
        int rows;
        this.checkSquare(A2);
        double epsilon = this.tolerance();
        int k = rows = A2.rows();
        while (--k >= 0) {
            int i = rows - k;
            while (--i >= 0) {
                int j = i + k;
                if (Math.abs(A2.getQuick(i, j)) <= epsilon) continue;
                return k;
            }
        }
        return 0;
    }
}

