/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.linalg;

import cern.colt.function.DoubleDoubleFunction;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.Property;
import cern.jet.math.Functions;
import java.io.Serializable;

public class QRDecomposition
implements Serializable {
    static final long serialVersionUID = 1020L;
    private DoubleMatrix2D QR;
    private int m;
    private int n;
    private DoubleMatrix1D Rdiag;

    public QRDecomposition(DoubleMatrix2D A2) {
        int k;
        Property.DEFAULT.checkRectangular(A2);
        Functions F = Functions.functions;
        this.QR = A2.copy();
        this.m = A2.rows();
        this.n = A2.columns();
        this.Rdiag = A2.like1D(this.n);
        DoubleDoubleFunction hypot = Algebra.hypotFunction();
        DoubleMatrix1D[] QRcolumns = new DoubleMatrix1D[this.n];
        DoubleMatrix1D[] QRcolumnsPart = new DoubleMatrix1D[this.n];
        for (k = 0; k < this.n; ++k) {
            QRcolumns[k] = this.QR.viewColumn(k);
            QRcolumnsPart[k] = this.QR.viewColumn(k).viewPart(k, this.m - k);
        }
        for (k = 0; k < this.n; ++k) {
            double nrm = 0.0;
            for (int i = k; i < this.m; ++i) {
                nrm = Algebra.hypot(nrm, this.QR.getQuick(i, k));
            }
            if (nrm != 0.0) {
                if (this.QR.getQuick(k, k) < 0.0) {
                    nrm = -nrm;
                }
                QRcolumnsPart[k].assign(Functions.div(nrm));
                this.QR.setQuick(k, k, this.QR.getQuick(k, k) + 1.0);
                for (int j = k + 1; j < this.n; ++j) {
                    DoubleMatrix1D QRcolj = this.QR.viewColumn(j).viewPart(k, this.m - k);
                    double s = QRcolumnsPart[k].zDotProduct(QRcolj);
                    s = -s / this.QR.getQuick(k, k);
                    for (int i = k; i < this.m; ++i) {
                        this.QR.setQuick(i, j, this.QR.getQuick(i, j) + s * this.QR.getQuick(i, k));
                    }
                }
            }
            this.Rdiag.setQuick(k, -nrm);
        }
    }

    public DoubleMatrix2D getH() {
        return Algebra.DEFAULT.trapezoidalLower(this.QR.copy());
    }

    public DoubleMatrix2D getQ() {
        Functions F = Functions.functions;
        DoubleMatrix2D Q = this.QR.like();
        for (int k = this.n - 1; k >= 0; --k) {
            DoubleMatrix1D QRcolk = this.QR.viewColumn(k).viewPart(k, this.m - k);
            Q.setQuick(k, k, 1.0);
            for (int j = k; j < this.n; ++j) {
                if (this.QR.getQuick(k, k) == 0.0) continue;
                DoubleMatrix1D Qcolj = Q.viewColumn(j).viewPart(k, this.m - k);
                double s = QRcolk.zDotProduct(Qcolj);
                s = -s / this.QR.getQuick(k, k);
                Qcolj.assign(QRcolk, Functions.plusMult(s));
            }
        }
        return Q;
    }

    public DoubleMatrix2D getR() {
        DoubleMatrix2D R = this.QR.like(this.n, this.n);
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                if (i < j) {
                    R.setQuick(i, j, this.QR.getQuick(i, j));
                    continue;
                }
                if (i == j) {
                    R.setQuick(i, j, this.Rdiag.getQuick(i));
                    continue;
                }
                R.setQuick(i, j, 0.0);
            }
        }
        return R;
    }

    public boolean hasFullRank() {
        for (int j = 0; j < this.n; ++j) {
            if (this.Rdiag.getQuick(j) != 0.0) continue;
            return false;
        }
        return true;
    }

    public DoubleMatrix2D solve(DoubleMatrix2D B) {
        int j;
        int k;
        Functions F = Functions.functions;
        if (B.rows() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.hasFullRank()) {
            throw new IllegalArgumentException("Matrix is rank deficient.");
        }
        int nx = B.columns();
        DoubleMatrix2D X = B.copy();
        for (k = 0; k < this.n; ++k) {
            for (j = 0; j < nx; ++j) {
                int i;
                double s = 0.0;
                for (i = k; i < this.m; ++i) {
                    s += this.QR.getQuick(i, k) * X.getQuick(i, j);
                }
                s = -s / this.QR.getQuick(k, k);
                for (i = k; i < this.m; ++i) {
                    X.setQuick(i, j, X.getQuick(i, j) + s * this.QR.getQuick(i, k));
                }
            }
        }
        for (k = this.n - 1; k >= 0; --k) {
            for (j = 0; j < nx; ++j) {
                X.setQuick(k, j, X.getQuick(k, j) / this.Rdiag.getQuick(k));
            }
            for (int i = 0; i < k; ++i) {
                for (int j2 = 0; j2 < nx; ++j2) {
                    X.setQuick(i, j2, X.getQuick(i, j2) - X.getQuick(k, j2) * this.QR.getQuick(i, k));
                }
            }
        }
        return X.viewPart(0, 0, this.n, nx);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String unknown = "Illegal operation or error: ";
        buf.append("-----------------------------------------------------------------\n");
        buf.append("QRDecomposition(A) --> hasFullRank(A), H, Q, R, pseudo inverse(A)\n");
        buf.append("-----------------------------------------------------------------\n");
        buf.append("hasFullRank = ");
        try {
            buf.append(String.valueOf(this.hasFullRank()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown + exc.getMessage());
        }
        buf.append("\n\nH = ");
        try {
            buf.append(String.valueOf(this.getH()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown + exc.getMessage());
        }
        buf.append("\n\nQ = ");
        try {
            buf.append(String.valueOf(this.getQ()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown + exc.getMessage());
        }
        buf.append("\n\nR = ");
        try {
            buf.append(String.valueOf(this.getR()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown + exc.getMessage());
        }
        buf.append("\n\npseudo inverse(A) = ");
        try {
            buf.append(String.valueOf(this.solve(DoubleFactory2D.dense.identity(this.QR.rows()))));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown + exc.getMessage());
        }
        return buf.toString();
    }
}

