/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.linalg;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Matrix2DMatrix2DFunction;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveAction;

class Smp {
    protected ForkJoinPool taskGroup;
    protected int maxThreads;

    protected Smp(int maxThreads) {
        this.maxThreads = maxThreads = Math.max(1, maxThreads);
        this.taskGroup = maxThreads > 1 ? new ForkJoinPool(maxThreads) : null;
    }

    protected void run(final DoubleMatrix2D[] blocksA, final DoubleMatrix2D[] blocksB, final double[] results, final Matrix2DMatrix2DFunction function) {
        final RecursiveAction[] subTasks = new RecursiveAction[blocksA.length];
        for (int i = 0; i < blocksA.length; ++i) {
            final int k = i;
            subTasks[i] = new RecursiveAction(){

                @Override
                protected void compute() {
                    double result = function.apply(blocksA[k], blocksB != null ? blocksB[k] : null);
                    if (results != null) {
                        results[k] = result;
                    }
                }
            };
        }
        this.taskGroup.invoke(new RecursiveAction(){

            @Override
            protected void compute() {
                2.invokeAll(subTasks);
            }
        });
    }

    protected DoubleMatrix2D[] splitBlockedNN(DoubleMatrix2D A2, int threshold, long flops) {
        int noOfTasks = (int)Math.min(flops / (long)threshold, (long)this.maxThreads);
        boolean splitHoriz = A2.columns() < noOfTasks;
        int p = splitHoriz ? A2.rows() : A2.columns();
        noOfTasks = Math.min(p, noOfTasks);
        if (noOfTasks < 2) {
            return null;
        }
        int span = p / noOfTasks;
        DoubleMatrix2D[] blocks = new DoubleMatrix2D[noOfTasks];
        for (int i = 0; i < noOfTasks; ++i) {
            int offset = i * span;
            if (i == noOfTasks - 1) {
                span = p - span * i;
            }
            blocks[i] = !splitHoriz ? A2.viewPart(0, offset, A2.rows(), span) : A2.viewPart(offset, 0, span, A2.columns());
        }
        return blocks;
    }

    protected DoubleMatrix2D[][] splitBlockedNN(DoubleMatrix2D A2, DoubleMatrix2D B, int threshold, long flops) {
        DoubleMatrix2D[] blocksA = this.splitBlockedNN(A2, threshold, flops);
        if (blocksA == null) {
            return null;
        }
        DoubleMatrix2D[] blocksB = this.splitBlockedNN(B, threshold, flops);
        if (blocksB == null) {
            return null;
        }
        DoubleMatrix2D[][] blocks = new DoubleMatrix2D[][]{blocksA, blocksB};
        return blocks;
    }

    protected DoubleMatrix2D[] splitStridedNN(DoubleMatrix2D A2, int threshold, long flops) {
        int noOfTasks = (int)Math.min(flops / (long)threshold, (long)this.maxThreads);
        boolean splitHoriz = A2.columns() < noOfTasks;
        int p = splitHoriz ? A2.rows() : A2.columns();
        noOfTasks = Math.min(p, noOfTasks);
        if (noOfTasks < 2) {
            return null;
        }
        int span = p / noOfTasks;
        DoubleMatrix2D[] blocks = new DoubleMatrix2D[noOfTasks];
        for (int i = 0; i < noOfTasks; ++i) {
            int offset = i * span;
            if (i == noOfTasks - 1) {
                span = p - span * i;
            }
            blocks[i] = !splitHoriz ? A2.viewPart(0, i, A2.rows(), A2.columns() - i).viewStrides(1, noOfTasks) : A2.viewPart(i, 0, A2.rows() - i, A2.columns()).viewStrides(noOfTasks, 1);
        }
        return blocks;
    }
}

