/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.linalg;

import cern.colt.function.DoubleDoubleFunction;
import cern.colt.function.DoubleFunction;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Blas;
import cern.colt.matrix.linalg.Matrix2DMatrix2DFunction;
import cern.colt.matrix.linalg.SeqBlas;
import cern.colt.matrix.linalg.Smp;
import java.util.concurrent.RecursiveAction;

public class SmpBlas
implements Blas {
    public static Blas smpBlas = SeqBlas.seqBlas;
    protected Blas seqBlas;
    protected Smp smp;
    protected int maxThreads;
    protected static int NN_THRESHOLD = 30000;

    protected SmpBlas(int maxThreads, Blas seqBlas) {
        this.seqBlas = seqBlas;
        this.maxThreads = maxThreads;
        this.smp = new Smp(maxThreads);
    }

    public static void allocateBlas(int maxThreads, Blas seqBlas) {
        if (smpBlas instanceof SmpBlas) {
            SmpBlas s = (SmpBlas)smpBlas;
            if (s.maxThreads == maxThreads && s.seqBlas == seqBlas) {
                return;
            }
        }
        smpBlas = maxThreads <= 1 ? seqBlas : new SmpBlas(maxThreads, seqBlas);
    }

    @Override
    public void assign(DoubleMatrix2D A2, final DoubleFunction function) {
        this.run(A2, false, new Matrix2DMatrix2DFunction(){

            @Override
            public double apply(DoubleMatrix2D AA, DoubleMatrix2D BB) {
                SmpBlas.this.seqBlas.assign(AA, function);
                return 0.0;
            }
        });
    }

    @Override
    public void assign(DoubleMatrix2D A2, DoubleMatrix2D B, final DoubleDoubleFunction function) {
        this.run(A2, B, false, new Matrix2DMatrix2DFunction(){

            @Override
            public double apply(DoubleMatrix2D AA, DoubleMatrix2D BB) {
                SmpBlas.this.seqBlas.assign(AA, BB, function);
                return 0.0;
            }
        });
    }

    @Override
    public double dasum(DoubleMatrix1D x) {
        return this.seqBlas.dasum(x);
    }

    @Override
    public void daxpy(double alpha, DoubleMatrix1D x, DoubleMatrix1D y) {
        this.seqBlas.daxpy(alpha, x, y);
    }

    @Override
    public void daxpy(double alpha, DoubleMatrix2D A2, DoubleMatrix2D B) {
        this.seqBlas.daxpy(alpha, A2, B);
    }

    @Override
    public void dcopy(DoubleMatrix1D x, DoubleMatrix1D y) {
        this.seqBlas.dcopy(x, y);
    }

    @Override
    public void dcopy(DoubleMatrix2D A2, DoubleMatrix2D B) {
        this.seqBlas.dcopy(A2, B);
    }

    @Override
    public double ddot(DoubleMatrix1D x, DoubleMatrix1D y) {
        return this.seqBlas.ddot(x, y);
    }

    @Override
    public void dgemm(final boolean transposeA, final boolean transposeB, final double alpha, DoubleMatrix2D A2, DoubleMatrix2D B, final double beta, DoubleMatrix2D C) {
        if (transposeA) {
            this.dgemm(false, transposeB, alpha, A2.viewDice(), B, beta, C);
            return;
        }
        if (transposeB) {
            this.dgemm(transposeA, false, alpha, A2, B.viewDice(), beta, C);
            return;
        }
        int m = A2.rows();
        int n = A2.columns();
        int p = B.columns();
        if (B.rows() != n) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + A2.toStringShort() + ", " + B.toStringShort());
        }
        if (C.rows() != m || C.columns() != p) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + A2.toStringShort() + ", " + B.toStringShort() + ", " + C.toStringShort());
        }
        if (A2 == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        long flops = 2L * (long)m * (long)n * (long)p;
        int noOfTasks = (int)Math.min(flops / 30000L, (long)this.maxThreads);
        boolean splitB = p >= noOfTasks;
        int width = splitB ? p : m;
        noOfTasks = Math.min(width, noOfTasks);
        if (noOfTasks < 2) {
            this.seqBlas.dgemm(transposeA, transposeB, alpha, A2, B, beta, C);
            return;
        }
        int span = width / noOfTasks;
        final RecursiveAction[] subTasks = new RecursiveAction[noOfTasks];
        for (int i = 0; i < noOfTasks; ++i) {
            DoubleMatrix2D CC2;
            DoubleMatrix2D BB;
            DoubleMatrix2D AA;
            int offset = i * span;
            if (i == noOfTasks - 1) {
                span = width - span * i;
            }
            if (splitB) {
                AA = A2;
                BB = B.viewPart(0, offset, n, span);
                CC2 = C.viewPart(0, offset, m, span);
            } else {
                AA = A2.viewPart(offset, 0, span, n);
                BB = B;
                CC2 = C.viewPart(offset, 0, span, p);
            }
            subTasks[i] = new RecursiveAction(){

                @Override
                protected void compute() {
                    SmpBlas.this.seqBlas.dgemm(transposeA, transposeB, alpha, AA, BB, beta, CC2);
                }
            };
        }
        this.smp.taskGroup.invoke(new RecursiveAction(){

            @Override
            protected void compute() {
                4.invokeAll(subTasks);
            }
        });
    }

    @Override
    public void dgemv(final boolean transposeA, final double alpha, DoubleMatrix2D A2, final DoubleMatrix1D x, final double beta, DoubleMatrix1D y) {
        if (transposeA) {
            this.dgemv(false, alpha, A2.viewDice(), x, beta, y);
            return;
        }
        int m = A2.rows();
        int n = A2.columns();
        long flops = 2L * (long)m * (long)n;
        int noOfTasks = (int)Math.min(flops / 30000L, (long)this.maxThreads);
        int width = A2.rows();
        noOfTasks = Math.min(width, noOfTasks);
        if (noOfTasks < 2) {
            this.seqBlas.dgemv(transposeA, alpha, A2, x, beta, y);
            return;
        }
        int span = width / noOfTasks;
        final RecursiveAction[] subTasks = new RecursiveAction[noOfTasks];
        for (int i = 0; i < noOfTasks; ++i) {
            int offset = i * span;
            if (i == noOfTasks - 1) {
                span = width - span * i;
            }
            final DoubleMatrix2D AA = A2.viewPart(offset, 0, span, n);
            final DoubleMatrix1D yy = y.viewPart(offset, span);
            subTasks[i] = new RecursiveAction(){

                @Override
                protected void compute() {
                    SmpBlas.this.seqBlas.dgemv(transposeA, alpha, AA, x, beta, yy);
                }
            };
        }
        this.smp.taskGroup.invoke(new RecursiveAction(){

            @Override
            public void compute() {
                6.invokeAll(subTasks);
            }
        });
    }

    @Override
    public void dger(double alpha, DoubleMatrix1D x, DoubleMatrix1D y, DoubleMatrix2D A2) {
        this.seqBlas.dger(alpha, x, y, A2);
    }

    @Override
    public double dnrm2(DoubleMatrix1D x) {
        return this.seqBlas.dnrm2(x);
    }

    @Override
    public void drot(DoubleMatrix1D x, DoubleMatrix1D y, double c, double s) {
        this.seqBlas.drot(x, y, c, s);
    }

    @Override
    public void drotg(double a, double b, double[] rotvec) {
        this.seqBlas.drotg(a, b, rotvec);
    }

    @Override
    public void dscal(double alpha, DoubleMatrix1D x) {
        this.seqBlas.dscal(alpha, x);
    }

    @Override
    public void dscal(double alpha, DoubleMatrix2D A2) {
        this.seqBlas.dscal(alpha, A2);
    }

    @Override
    public void dswap(DoubleMatrix1D x, DoubleMatrix1D y) {
        this.seqBlas.dswap(x, y);
    }

    @Override
    public void dswap(DoubleMatrix2D A2, DoubleMatrix2D B) {
        this.seqBlas.dswap(A2, B);
    }

    @Override
    public void dsymv(boolean isUpperTriangular, double alpha, DoubleMatrix2D A2, DoubleMatrix1D x, double beta, DoubleMatrix1D y) {
        this.seqBlas.dsymv(isUpperTriangular, alpha, A2, x, beta, y);
    }

    @Override
    public void dtrmv(boolean isUpperTriangular, boolean transposeA, boolean isUnitTriangular, DoubleMatrix2D A2, DoubleMatrix1D x) {
        this.seqBlas.dtrmv(isUpperTriangular, transposeA, isUnitTriangular, A2, x);
    }

    @Override
    public int idamax(DoubleMatrix1D x) {
        return this.seqBlas.idamax(x);
    }

    protected double[] run(DoubleMatrix2D A2, DoubleMatrix2D B, boolean collectResults, Matrix2DMatrix2DFunction fun) {
        double[] results;
        DoubleMatrix2D[][] blocks = this.smp.splitBlockedNN(A2, B, NN_THRESHOLD, A2.rows() * A2.columns());
        int b = blocks != null ? blocks[0].length : 1;
        double[] dArray = results = collectResults ? new double[b] : null;
        if (blocks == null) {
            double result = fun.apply(A2, B);
            if (collectResults) {
                results[0] = result;
            }
            return results;
        }
        this.smp.run(blocks[0], blocks[1], results, fun);
        return results;
    }

    protected double[] run(DoubleMatrix2D A2, boolean collectResults, Matrix2DMatrix2DFunction fun) {
        double[] results;
        DoubleMatrix2D[] blocks = this.smp.splitBlockedNN(A2, NN_THRESHOLD, A2.rows() * A2.columns());
        int b = blocks != null ? blocks.length : 1;
        double[] dArray = results = collectResults ? new double[b] : null;
        if (blocks == null) {
            double result = fun.apply(A2, null);
            if (collectResults) {
                results[0] = result;
            }
            return results;
        }
        this.smp.run(blocks, null, results, fun);
        return results;
    }

    private double xsum(DoubleMatrix2D A2) {
        double[] sums = this.run(A2, true, new Matrix2DMatrix2DFunction(){

            @Override
            public double apply(DoubleMatrix2D AA, DoubleMatrix2D BB) {
                return AA.zSum();
            }
        });
        double sum = 0.0;
        int i = sums.length;
        while (--i >= 0) {
            sum += sums[i];
        }
        return sum;
    }
}

