/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bfs;

import com.bigdata.bfs.AtomicBlockAppendProc;
import com.bigdata.bfs.AtomicBlockWriteProc;
import com.bigdata.bfs.BlobOverflowHandler;
import com.bigdata.bfs.BlockIdentifierIterator;
import com.bigdata.bfs.Document;
import com.bigdata.bfs.DocumentHeader;
import com.bigdata.bfs.FileMetadataSchema;
import com.bigdata.bfs.FileVersionDeleter;
import com.bigdata.bfs.FileVersionInputStream;
import com.bigdata.bfs.FileVersionOutputStream;
import com.bigdata.bfs.IContentRepository;
import com.bigdata.bfs.RepositoryDocumentImpl;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.IndexTypeEnum;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.io.DataInputBuffer;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.IResourceLock;
import com.bigdata.journal.Journal;
import com.bigdata.rawstore.IBlock;
import com.bigdata.rawstore.WormAddressManager;
import com.bigdata.relation.AbstractResource;
import com.bigdata.relation.IDatabase;
import com.bigdata.relation.RelationSchema;
import com.bigdata.sparse.AutoIncIntegerCounter;
import com.bigdata.sparse.IRowStoreConstants;
import com.bigdata.sparse.ITPS;
import com.bigdata.sparse.ITPV;
import com.bigdata.sparse.LogicalRowSplitHandler;
import com.bigdata.sparse.SparseRowStore;
import com.bigdata.sparse.TPS;
import cutthecrap.utils.striterators.Resolver;
import cutthecrap.utils.striterators.Striterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BigdataFileSystem
extends AbstractResource<IDatabase<BigdataFileSystem>>
implements IContentRepository,
IRowStoreConstants {
    protected static final Logger log = Logger.getLogger(BigdataFileSystem.class);
    protected static final boolean INFO = log.isInfoEnabled();
    protected static final boolean DEBUG = log.isDebugEnabled();
    private final int offsetBits;
    private final int blockSize;
    protected static final long MAX_BLOCK = 0x7FFFFFFFFFFFFFFEL;
    public static final String FILE_METADATA_INDEX_BASENAME = "fileMetadata";
    public static final String FILE_DATA_INDEX_BASENAME = "fileData";
    public static final FileMetadataSchema metadataSchema = new FileMetadataSchema();
    private SparseRowStore fileMetadataIndex;
    private IIndex fileDataIndex;

    public final int getOffsetBits() {
        return this.offsetBits;
    }

    public final int getBlockSize() {
        return this.blockSize;
    }

    protected static void assertString(Map<String, Object> properties, String name) {
        Object val = properties.get(name);
        if (val == null) {
            throw new IllegalArgumentException(name + " is null");
        }
        if (!(val instanceof String)) {
            throw new IllegalArgumentException(name + " must be String");
        }
    }

    protected static void assertLong(Map<String, Object> properties, String name) {
        Object val = properties.get(name);
        if (val == null) {
            throw new IllegalArgumentException(name + " is null");
        }
        if (!(val instanceof Long)) {
            throw new IllegalArgumentException(name + " must be Long");
        }
    }

    public BigdataFileSystem(IIndexManager indexManager, String namespace, Long timestamp, Properties properties) {
        super(indexManager, namespace, timestamp, properties);
        this.offsetBits = Integer.parseInt(properties.getProperty(Options.OFFSET_BITS, Integer.toString(indexManager instanceof Journal ? 42 : 38)));
        this.blockSize = WormAddressManager.getMaxByteCount(this.offsetBits) - 1;
        if (INFO) {
            log.info("offsetBits=" + this.offsetBits + ", blockSize=" + this.blockSize);
        }
    }

    public SparseRowStore getFileMetadataIndex() {
        if (this.fileMetadataIndex == null) {
            throw new IllegalStateException();
        }
        return this.fileMetadataIndex;
    }

    public IIndex getFileDataIndex() {
        if (this.fileDataIndex == null) {
            throw new IllegalStateException();
        }
        return this.fileDataIndex;
    }

    @Override
    public boolean isReadOnly() {
        return this.getTimestamp() != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create() {
        this.assertWritable();
        IResourceLock resourceLock = this.acquireExclusiveLock();
        try {
            Properties tmp = this.getProperties();
            tmp.setProperty(RelationSchema.CONTAINER, this.getNamespace());
            super.create();
            IIndexManager indexManager = this.getIndexManager();
            String name = this.getNamespace() + "." + FILE_METADATA_INDEX_BASENAME;
            IndexMetadata md = new IndexMetadata(indexManager, tmp, name, UUID.randomUUID(), IndexTypeEnum.BTree);
            md.setSplitHandler(LogicalRowSplitHandler.INSTANCE);
            indexManager.registerIndex(md);
            IIndex ndx = indexManager.getIndex(name, this.getTimestamp());
            this.fileMetadataIndex = new SparseRowStore(ndx);
            name = this.getNamespace() + "." + FILE_DATA_INDEX_BASENAME;
            md = new IndexMetadata(indexManager, tmp, name, UUID.randomUUID(), IndexTypeEnum.BTree);
            md.setOverflowHandler(new BlobOverflowHandler());
            indexManager.registerIndex(md);
            this.fileDataIndex = indexManager.getIndex(name, this.getTimestamp());
        }
        finally {
            this.unlock(resourceLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this.assertWritable();
        IResourceLock resourceLock = this.acquireExclusiveLock();
        try {
            this.getIndexManager().dropIndex(this.getNamespace() + "." + FILE_METADATA_INDEX_BASENAME);
            this.getIndexManager().dropIndex(this.getNamespace() + "." + FILE_DATA_INDEX_BASENAME);
            super.destroy();
        }
        finally {
            this.unlock(resourceLock);
        }
    }

    public int create(Map<String, Object> metadata) {
        if (metadata == null) {
            throw new IllegalArgumentException();
        }
        BigdataFileSystem.assertString(metadata, FileMetadataSchema.ID);
        metadata = new HashMap<String, Object>(metadata);
        metadata.put(FileMetadataSchema.VERSION, AutoIncIntegerCounter.INSTANCE);
        TPS tps = this.getFileMetadataIndex().write(metadataSchema, metadata, -2L, null, null);
        int version = (Integer)tps.get(FileMetadataSchema.VERSION).getValue();
        if (INFO) {
            log.info("Created new version: id=" + metadata.get(FileMetadataSchema.ID) + ", version=" + version);
        }
        return version;
    }

    @Override
    public int create(Document doc) {
        if (doc == null) {
            throw new IllegalArgumentException();
        }
        String id = doc.getId();
        if (id == null) {
            throw new RuntimeException("The " + FileMetadataSchema.ID + " property must be defined.");
        }
        Map<String, Object> metadata = doc.asMap();
        int version = this.create(metadata);
        this.copyStream(id, version, doc.getInputStream());
        return version;
    }

    @Override
    public Document read(String id) {
        RepositoryDocumentImpl doc = new RepositoryDocumentImpl(this, id);
        if (!doc.exists()) {
            if (INFO) {
                log.info("No current version: id=" + id);
            }
            return null;
        }
        return doc;
    }

    public ITPS readMetadata(String id, long timestamp) {
        return this.getFileMetadataIndex().read(metadataSchema, id, timestamp, timestamp + 1L, null);
    }

    public Map<String, Object> updateMetadata(String id, Map<String, Object> metadata) {
        metadata = new HashMap<String, Object>(metadata);
        metadata.put(FileMetadataSchema.ID, id);
        metadata.remove(FileMetadataSchema.VERSION);
        return this.getFileMetadataIndex().write(metadataSchema, metadata, -2L, null, null).asMap();
    }

    @Override
    public int update(Document doc) {
        Map<String, Object> metadata = doc.asMap();
        String id = (String)metadata.get(FileMetadataSchema.ID);
        this.delete(id);
        return this.create(doc);
    }

    @Override
    public long delete(String id) {
        RepositoryDocumentImpl doc = (RepositoryDocumentImpl)this.read(id);
        if (!doc.exists()) {
            log.warn("No current version: id=" + id);
            return 0L;
        }
        int version = doc.getVersion();
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put(FileMetadataSchema.ID, id);
        metadata.put(FileMetadataSchema.VERSION, null);
        this.getFileMetadataIndex().write(metadataSchema, metadata, -2L, null, null);
        long blockCount = 0L;
        IKeyBuilder keyBuilder = this.getFileDataIndex().getIndexMetadata().getKeyBuilder();
        byte[] fromKey = keyBuilder.reset().appendText(id, true, false).append(version).getKey();
        byte[] toKey = keyBuilder.reset().appendText(id, true, false).append(version + 1).getKey();
        ITupleIterator itr = this.getFileDataIndex().rangeIterator(fromKey, toKey, 0, 16, null);
        while (itr.hasNext()) {
            itr.next();
            ++blockCount;
        }
        if (INFO) {
            log.info("Deleted " + blockCount + " blocks : id=" + id + ", version=" + version);
        }
        return blockCount;
    }

    public ITPV[] getAllVersionInfo(String id) {
        ITPS tps = this.readMetadata(id, Long.MAX_VALUE);
        Vector<ITPV> vec = new Vector<ITPV>();
        Iterator<ITPV> itr = tps.iterator();
        while (itr.hasNext()) {
            ITPV tpv = itr.next();
            if (!tpv.getName().equals(FileMetadataSchema.VERSION)) continue;
            vec.add(tpv);
        }
        return vec.toArray(new ITPV[vec.size()]);
    }

    @Override
    public Iterator<? extends DocumentHeader> getDocumentHeaders(String fromId, String toId) {
        return new Striterator(this.getFileMetadataIndex().rangeIterator(metadataSchema, fromId, toId)).addFilter(new Resolver(){
            private static final long serialVersionUID = 1L;

            @Override
            protected Object resolve(Object arg0) {
                ITPS tps = (ITPS)arg0;
                String id = (String)tps.get(FileMetadataSchema.ID).getValue();
                return new RepositoryDocumentImpl(BigdataFileSystem.this, id, tps);
            }
        });
    }

    @Override
    public long deleteAll(String fromId, String toId) {
        IKeyBuilder keyBuilder = this.getFileDataIndex().getIndexMetadata().getKeyBuilder();
        byte[] fromKey = keyBuilder.reset().appendText(fromId, true, false).getKey();
        byte[] toKey = keyBuilder.reset().appendText(toId, true, true).getKey();
        long ndeleted = 0L;
        this.getFileMetadataIndex().getIndex().rangeIterator(fromKey, toKey, 0, 32, new FileVersionDeleter(-2L));
        ITupleIterator itr = this.getFileDataIndex().rangeIterator(fromKey, toKey, 0, 16, null);
        long blockCount = 0L;
        while (itr.hasNext()) {
            itr.next();
            ++blockCount;
        }
        return ndeleted;
    }

    @Override
    public Iterator<String> search(String query) {
        throw new UnsupportedOperationException();
    }

    public Iterator<Long> blocks(String id, int version) {
        IKeyBuilder keyBuilder = this.getFileDataIndex().getIndexMetadata().getKeyBuilder();
        byte[] fromKey = keyBuilder.reset().appendText(id, true, false).append(version).getKey();
        byte[] toKey = keyBuilder.reset().appendText(id, true, false).append(version + 1).getKey();
        boolean flags = true;
        ITupleIterator itr = this.getFileDataIndex().rangeIterator(fromKey, toKey, 0, 1, null);
        return new BlockIdentifierIterator(id, version, itr);
    }

    public long copyBlocks(String fromId, int fromVersion, String toId, int toVersion) {
        Iterator<Long> src = this.blocks(fromId, fromVersion);
        long nblocks = 0L;
        while (src.hasNext()) {
            long blockId = src.next();
            byte[] block = this.readBlock(fromId, fromVersion, blockId);
            this.appendBlock(toId, toVersion, block, 0, block.length);
            ++nblocks;
        }
        return nblocks;
    }

    public boolean writeBlock(String id, int version, long block, byte[] b, int off, int len) {
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (version < 0) {
            throw new IllegalArgumentException();
        }
        if (block < 0L) {
            throw new IllegalArgumentException();
        }
        if (block > 0x7FFFFFFFFFFFFFFEL) {
            throw new IllegalArgumentException();
        }
        if (b == null) {
            throw new IllegalArgumentException();
        }
        if (off < 0 || off > b.length) {
            throw new IllegalArgumentException("off=" + off + ", b.length=" + b.length);
        }
        if (len < 0 || off + len > b.length) {
            throw new IllegalArgumentException("off=" + off + ", len=" + len + ", b.length=" + b.length);
        }
        if (len > this.blockSize) {
            throw new IllegalArgumentException();
        }
        AtomicBlockWriteProc proc = new AtomicBlockWriteProc(this, id, version, block, b, off, len);
        IKeyBuilder keyBuilder = this.getFileDataIndex().getIndexMetadata().getKeyBuilder();
        byte[] key = keyBuilder.reset().appendText(id, true, false).append(version).append(block).getKey();
        return (Boolean)this.getFileDataIndex().submit(key, proc);
    }

    public long deleteHead(String id, int version) {
        if (INFO) {
            log.info("id=" + id + ", version=" + version);
        }
        IKeyBuilder keyBuilder = this.getFileDataIndex().getIndexMetadata().getKeyBuilder();
        byte[] fromKey = keyBuilder.reset().appendText(id, true, false).append(version).getKey();
        byte[] toKey = keyBuilder.reset().appendText(id, true, false).append(version + 1).getKey();
        ITupleIterator itr = this.getFileDataIndex().rangeIterator(fromKey, toKey, 1, 17, null);
        if (!itr.hasNext()) {
            log.warn("Nothing to delete: id=" + id + ", version=" + version);
            return -1L;
        }
        long block = new BlockIdentifierIterator(id, version, itr).next();
        if (INFO) {
            log.info("id=" + id + ", version=" + version + " : deleted block=" + block);
        }
        return block;
    }

    public boolean deleteBlock(String id, int version, long block) {
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (version < 0) {
            throw new IllegalArgumentException();
        }
        if (block < 0L) {
            throw new IllegalArgumentException();
        }
        if (block > 0x7FFFFFFFFFFFFFFEL) {
            throw new IllegalArgumentException();
        }
        IKeyBuilder keyBuilder = this.getFileDataIndex().getIndexMetadata().getKeyBuilder();
        byte[] key = keyBuilder.reset().appendText(id, true, false).append(version).append(block).getKey();
        boolean deleted = this.getFileDataIndex().remove(key) != null;
        return deleted;
    }

    public byte[] readHead(String id, int version) {
        IKeyBuilder keyBuilder = this.getFileDataIndex().getIndexMetadata().getKeyBuilder();
        byte[] fromKey = keyBuilder.reset().appendText(id, true, false).append(version).append(0L).getKey();
        byte[] toKey = keyBuilder.reset().appendText(id, true, false).append(version).append(Long.MAX_VALUE).getKey();
        ITupleIterator itr = this.getFileDataIndex().rangeIterator(fromKey, toKey, 1, 3, null);
        if (!itr.hasNext()) {
            if (INFO) {
                log.info("id=" + id + ", version=" + version + " : no blocks");
            }
            return null;
        }
        return this.readBlock(id, version, itr.next());
    }

    public byte[] readBlock(String id, int version, long block) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        IKeyBuilder keyBuilder = this.getFileDataIndex().getIndexMetadata().getKeyBuilder();
        byte[] fromKey = keyBuilder.reset().appendText(id, true, false).append(version).append(block).getKey();
        byte[] toKey = keyBuilder.reset().appendText(id, true, false).append(version).append(block + 1L).getKey();
        ITupleIterator itr = this.getFileDataIndex().rangeIterator(fromKey, toKey, 1, 3, null);
        if (!itr.hasNext()) {
            if (INFO) {
                log.info("id=" + id + ", version=" + version + ", block=" + block + " : does not exist");
            }
            return null;
        }
        return this.readBlock(id, version, itr.next());
    }

    private byte[] readBlock(String id, int version, ITuple tuple) {
        long addr;
        byte[] key = tuple.getKey();
        long block = KeyBuilder.decodeLong(key, key.length - 8);
        try {
            DataInputBuffer in = tuple.getValueStream();
            addr = in.readLong();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (addr == 0L) {
            if (INFO) {
                log.info("id=" + id + ", version=" + version + ", block=" + block + " : empty block.");
            }
            return new byte[0];
        }
        IBlock tmp = tuple.readBlock(addr);
        int len = tmp.length();
        if (INFO) {
            log.info("id=" + id + ", version=" + version + ", block=" + block + " : " + len + " bytes");
        }
        byte[] data = new byte[len];
        try {
            int nread = tmp.inputStream().read(data, 0, len);
            if (nread != len) {
                throw new RuntimeException("Expecting to read " + len + " bytes but read " + nread + " bytes");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return data;
    }

    public long appendBlock(String id, int version, byte[] b, int off, int len) {
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (version < 0) {
            throw new IllegalArgumentException();
        }
        if (b == null) {
            throw new IllegalArgumentException();
        }
        if (off < 0 || off > b.length) {
            throw new IllegalArgumentException("off=" + off + ", b.length=" + b.length);
        }
        if (len < 0 || off + len > b.length) {
            throw new IllegalArgumentException("off=" + off + ", len=" + len + ", b.length=" + b.length);
        }
        if (len > this.blockSize) {
            throw new IllegalArgumentException();
        }
        AtomicBlockAppendProc proc = new AtomicBlockAppendProc(this, id, version, b, off, len);
        IKeyBuilder keyBuilder = this.getFileDataIndex().getIndexMetadata().getKeyBuilder();
        byte[] key = keyBuilder.reset().appendText(id, true, true).append(version).append(-1L).getKey();
        return (Long)this.getFileDataIndex().submit(key, proc);
    }

    public long getBlockCount(String id, int version) {
        IKeyBuilder keyBuilder = this.getFileDataIndex().getIndexMetadata().getKeyBuilder();
        byte[] fromKey = keyBuilder.reset().appendText(id, true, false).append(version).getKey();
        byte[] toKey = keyBuilder.reset().appendText(id, true, false).append(version + 1).getKey();
        long nblocks = this.getFileDataIndex().rangeCount(fromKey, toKey);
        if (INFO) {
            log.info("id=" + id + ", version=" + version + ", nblocks=" + nblocks);
        }
        return nblocks;
    }

    public Writer writer(String id, int version, String encoding) throws UnsupportedEncodingException {
        if (INFO) {
            log.info("id=" + id + ", version=" + version + ", encoding=" + encoding);
        }
        return new OutputStreamWriter(this.outputStream(id, version), encoding);
    }

    public Reader reader(String id, int version, String encoding) throws UnsupportedEncodingException {
        if (INFO) {
            log.info("id=" + id + ", version=" + version + ", encoding=" + encoding);
        }
        if (encoding == null) {
            throw new IllegalStateException();
        }
        return new InputStreamReader((InputStream)this.inputStream(id, version), encoding);
    }

    public FileVersionInputStream inputStream(String id, int version) {
        return this.inputStream(id, version, 0L);
    }

    public FileVersionInputStream inputStream(String id, int version, long tx) {
        if (INFO) {
            log.info("id=" + id + ", version=" + version + ", tx=" + tx);
        }
        if (tx == 0L && this.getBlockCount(id, version) == 0L) {
            if (INFO) {
                log.info("No data: id=" + id + ", version=" + version);
            }
            return null;
        }
        IKeyBuilder keyBuilder = this.getFileDataIndex().getIndexMetadata().getKeyBuilder();
        byte[] fromKey = keyBuilder.reset().appendText(id, true, false).append(version).getKey();
        byte[] toKey = keyBuilder.reset().appendText(id, true, false).append(version + 1).getKey();
        int capacity = 1000;
        int flags = 3;
        IIndex dataIndex = tx == 0L ? this.getFileDataIndex() : this.getIndexManager().getIndex(this.getNamespace() + "." + FILE_DATA_INDEX_BASENAME, tx);
        ITupleIterator itr = dataIndex.rangeIterator(fromKey, toKey, 1000, 3, null);
        return new FileVersionInputStream(id, version, itr);
    }

    public OutputStream outputStream(String id, int version) {
        if (INFO) {
            log.info("id=" + id + ", version=" + version);
        }
        return new FileVersionOutputStream(this, id, version);
    }

    public long copyStream(String id, int version, InputStream is) {
        long ncopied;
        FileVersionOutputStream os = (FileVersionOutputStream)this.outputStream(id, version);
        try {
            ncopied = os.copyStream(is);
            if (ncopied == 0L) {
                this.appendBlock(id, version, new byte[0], 0, 0);
            }
            os.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return ncopied;
    }

    public static interface Options
    extends com.bigdata.journal.Options,
    KeyBuilder.Options {
    }
}

