/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bfs;

import com.bigdata.bfs.BigdataFileSystem;
import com.bigdata.btree.IOverflowHandler;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.io.DataInputBuffer;
import com.bigdata.io.DataOutputBuffer;
import com.bigdata.rawstore.IBlock;
import com.bigdata.rawstore.IRawStore;
import java.io.IOException;
import java.io.InputStream;

public class BlobOverflowHandler
implements IOverflowHandler {
    private static final long serialVersionUID = -8180664203349900189L;
    private transient DataOutputBuffer buf;

    @Override
    public void close() {
        this.buf = null;
    }

    @Override
    public byte[] handle(ITuple tuple, IRawStore target) {
        long addr2;
        long addr;
        if (this.buf == null) {
            this.buf = new DataOutputBuffer();
        }
        try {
            DataInputBuffer in = tuple.getValueStream();
            addr = in.readLong();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        KeyBuilder keyBuilder = new KeyBuilder(8);
        if (addr == 0L) {
            return keyBuilder.append(0L).getKey();
        }
        IBlock block = tuple.readBlock(addr);
        int len = block.length();
        this.buf.ensureCapacity(len);
        this.buf.reset();
        InputStream bin = block.inputStream();
        try {
            int nread = bin.read(this.buf.array(), 0, len);
            if (nread != len) {
                throw new RuntimeException("Premature end of block: expected=" + len + ", actual=" + nread);
            }
            addr2 = target.write(this.buf.asByteBuffer());
        }
        catch (IOException ex) {
            BigdataFileSystem.log.warn("Problem copying block: addr=" + addr + ", len=" + len, ex);
            throw new RuntimeException(ex);
        }
        finally {
            try {
                bin.close();
            }
            catch (IOException ex) {
                BigdataFileSystem.log.warn(ex);
            }
        }
        return keyBuilder.append(addr2).getKey();
    }
}

