/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bfs;

import com.bigdata.bfs.Document;
import com.bigdata.bfs.DocumentHeader;
import com.bigdata.bfs.DocumentHeaderImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Map;

public class DocumentImpl
extends DocumentHeaderImpl
implements Document {
    private byte[] content;

    public DocumentImpl() {
    }

    public DocumentImpl(Map<String, Object> metadata) {
        super(metadata);
    }

    public DocumentImpl(DocumentHeader header) {
        super(header);
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.content);
    }

    @Override
    public Reader getReader() throws UnsupportedEncodingException {
        return new InputStreamReader((InputStream)new ByteArrayInputStream(this.content), this.getContentEncoding());
    }

    public void copyStream(byte[] b, int off, int len) {
        super.setContentEncoding(null);
        this.content = new byte[len];
        System.arraycopy(b, off, this.content, 0, len);
    }

    public void copyStream(byte[] b) {
        this.copyStream(b, 0, b.length);
    }

    public void copyStream(InputStream is) throws IOException {
        int b;
        super.setContentEncoding(null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((b = is.read()) != -1) {
        }
        this.content = baos.toByteArray();
        is.close();
    }

    public void copyString(String encoding, String s) throws UnsupportedEncodingException {
        super.setContentEncoding(encoding);
        this.content = s.getBytes(encoding);
    }

    public void copyReader(String encoding, Reader r) throws IOException {
        super.setContentEncoding(encoding);
        String s = DocumentImpl.readString(r);
        this.content = s.getBytes(encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readString(Reader reader) throws IOException {
        StringWriter writer = new StringWriter();
        try {
            int i;
            while ((i = reader.read()) != -1) {
                writer.write(i);
            }
        }
        finally {
            try {
                reader.close();
                writer.close();
            }
            catch (Exception ex) {
                log.warn("Could not close reader/writer: " + ex, ex);
            }
        }
        return writer.toString();
    }
}

