/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bfs;

import com.bigdata.bfs.BigdataFileSystem;
import com.bigdata.journal.IIndexManager;
import java.util.Properties;
import org.apache.log4j.Logger;

public class GlobalFileSystemHelper {
    public static final transient String GLOBAL_FILE_SYSTEM_NAMESPACE = "__globalFileSystem";
    private final IIndexManager indexManager;
    protected static final transient Logger log = Logger.getLogger(GlobalFileSystemHelper.class);
    protected static final boolean INFO = log.isInfoEnabled();
    private transient BigdataFileSystem globalRowStore;

    public GlobalFileSystemHelper(IIndexManager indexManager) {
        if (indexManager == null) {
            throw new IllegalArgumentException();
        }
        this.indexManager = indexManager;
    }

    public synchronized BigdataFileSystem getGlobalFileSystem() {
        if (INFO) {
            log.info("");
        }
        if (this.globalRowStore == null) {
            this.globalRowStore = new BigdataFileSystem(this.indexManager, GLOBAL_FILE_SYSTEM_NAMESPACE, 0L, new Properties());
            this.globalRowStore.create();
        }
        return this.globalRowStore;
    }

    public BigdataFileSystem getReadCommitted() {
        if (INFO) {
            log.info("");
        }
        return (BigdataFileSystem)this.indexManager.getResourceLocator().locate(GLOBAL_FILE_SYSTEM_NAMESPACE, -1L);
    }
}

