/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.blueprints;

import com.bigdata.blueprints.BigdataElement;
import com.bigdata.blueprints.BigdataGraph;
import com.bigdata.blueprints.BigdataVertex;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;

public class BigdataEdge
extends BigdataElement
implements Edge {
    private static final transient Logger log = Logger.getLogger(BigdataEdge.class);
    private static final List<String> blacklist = Arrays.asList("id", "", "label");
    protected final Statement stmt;

    public BigdataEdge(Statement stmt, BigdataGraph graph) {
        super(stmt.getPredicate(), graph);
        this.stmt = stmt;
    }

    @Override
    public Object getId() {
        if (log.isInfoEnabled()) {
            log.info("");
        }
        return this.graph.factory.fromURI(this.uri);
    }

    @Override
    public void remove() {
        if (log.isInfoEnabled()) {
            log.info("");
        }
        this.graph.removeEdge(this);
    }

    @Override
    public String getLabel() {
        if (log.isInfoEnabled()) {
            log.info("");
        }
        return (String)this.graph.getProperty(this.uri, this.graph.getValueFactory().getLabelURI());
    }

    @Override
    public Vertex getVertex(Direction dir) throws IllegalArgumentException {
        if (log.isInfoEnabled()) {
            log.info("(" + (Object)((Object)dir) + ")");
        }
        if (dir == Direction.BOTH) {
            throw new IllegalArgumentException();
        }
        URI uri = (URI)(dir == Direction.OUT ? this.stmt.getSubject() : this.stmt.getObject());
        String id = this.graph.factory.fromURI(uri);
        return this.graph.getVertex(id);
    }

    public BigdataVertex getFrom() {
        return new BigdataVertex((URI)this.stmt.getSubject(), this.graph);
    }

    public BigdataVertex getTo() {
        return new BigdataVertex((URI)this.stmt.getObject(), this.graph);
    }

    @Override
    public void setProperty(String prop, Object val) {
        if (log.isInfoEnabled()) {
            log.info("(" + prop + ", " + val + ")");
        }
        if (prop == null || blacklist.contains(prop)) {
            throw new IllegalArgumentException();
        }
        super.setProperty(prop, val);
    }

    @Override
    public String toString() {
        URI s = (URI)this.stmt.getSubject();
        URI p = this.stmt.getPredicate();
        URI o = (URI)this.stmt.getObject();
        return "e[" + p.getLocalName() + "][" + s.getLocalName() + "->" + o.getLocalName() + "]";
    }

    @Override
    public <T> T getProperty(String prop) {
        if (log.isInfoEnabled()) {
            log.info("(" + prop + ")");
        }
        return super.getProperty(prop);
    }

    @Override
    public Set<String> getPropertyKeys() {
        if (log.isInfoEnabled()) {
            log.info("");
        }
        return super.getPropertyKeys();
    }

    @Override
    public <T> T removeProperty(String prop) {
        if (log.isInfoEnabled()) {
            log.info("(" + prop + ")");
        }
        return super.removeProperty(prop);
    }
}

