/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.blueprints;

import com.bigdata.blueprints.BigdataGraph;
import com.tinkerpop.blueprints.Element;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.openrdf.model.URI;

public abstract class BigdataElement
implements Element {
    private static final List<String> blacklist = Arrays.asList("id", "");
    protected final URI uri;
    protected final BigdataGraph graph;

    public BigdataElement(URI uri, BigdataGraph graph) {
        this.uri = uri;
        this.graph = graph;
    }

    @Override
    public <T> T getProperty(String property) {
        return (T)this.graph.getProperty(this.uri, property);
    }

    @Override
    public Set<String> getPropertyKeys() {
        return this.graph.getPropertyKeys(this.uri);
    }

    @Override
    public <T> T removeProperty(String property) {
        return (T)this.graph.removeProperty(this.uri, property);
    }

    @Override
    public void setProperty(String prop, Object val) {
        if (prop == null || blacklist.contains(prop)) {
            throw new IllegalArgumentException();
        }
        this.graph.setProperty(this.uri, prop, val);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.graph == null ? 0 : this.graph.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigdataElement other = (BigdataElement)obj;
        if (this.graph == null ? other.graph != null : !this.graph.equals(other.graph)) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }

    public String toString() {
        return this.uri.toString();
    }
}

