/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.blueprints;

import com.bigdata.blueprints.BigdataBindingSet;
import com.bigdata.blueprints.BigdataEdge;
import com.bigdata.blueprints.BigdataGraphAtom;
import com.bigdata.blueprints.BigdataGraphEdit;
import com.bigdata.blueprints.BigdataGraphQuery;
import com.bigdata.blueprints.BigdataVertex;
import com.bigdata.blueprints.BlueprintsValueFactory;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.internal.impl.extensions.DateTimeExtension;
import com.bigdata.rdf.sail.BigdataSailBooleanQuery;
import com.bigdata.rdf.sail.BigdataSailGraphQuery;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.BigdataSailTupleQuery;
import com.bigdata.rdf.sail.QueryCancelledException;
import com.bigdata.rdf.sail.RDRHistory;
import com.bigdata.rdf.sail.model.RunningQuery;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Features;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.io.graphml.GraphMLReader;
import cutthecrap.utils.striterators.Filter;
import cutthecrap.utils.striterators.ICloseableIterator;
import cutthecrap.utils.striterators.Resolver;
import cutthecrap.utils.striterators.Striterator;
import info.aduna.iteration.CloseableIteration;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.Query;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.Update;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryResult;

public abstract class BigdataGraph
implements Graph {
    private static final transient Logger log = Logger.getLogger(BigdataGraph.class);
    private static final transient Logger sparqlLog = Logger.getLogger(BigdataGraph.class.getName() + ".SparqlLogger");
    public static final int SPARQL_LOG_MAX = 10000;
    protected final int maxQueryTime;
    protected final URI TYPE;
    protected final URI VERTEX;
    protected final URI EDGE;
    protected final URI LABEL;
    protected final BlueprintsValueFactory factory;
    private final boolean laxEdges;
    protected final boolean laxProperties;
    private static final String HISTORY_TEMPLATE = "prefix hint: <http://www.bigdata.com/queryHints#>\nselect ?s ?p ?o ?action ?time\nwhere {\n    bind(<< ?s ?p ?o >> as ?sid) . \n    hint:Prior hint:history true . \n    ?sid ?action ?time . \n}";
    protected static final Features FEATURES = new Features();

    public BigdataGraph(BlueprintsValueFactory factory) {
        this(factory, new Properties());
    }

    public BigdataGraph(BlueprintsValueFactory factory, Properties props) {
        this.factory = factory;
        this.laxEdges = Boolean.valueOf(props.getProperty(Options.LAX_EDGES, "false"));
        this.laxProperties = Boolean.valueOf(props.getProperty(Options.LAX_PROPERTIES, "false"));
        this.maxQueryTime = Integer.parseInt(props.getProperty(Options.MAX_QUERY_TIME, "0"));
        this.TYPE = factory.getTypeURI();
        this.VERTEX = factory.getVertexURI();
        this.EDGE = factory.getEdgeURI();
        this.LABEL = factory.getLabelURI();
    }

    public String toString() {
        return this.getClass().getSimpleName().toLowerCase();
    }

    public BlueprintsValueFactory getValueFactory() {
        return this.factory;
    }

    public abstract RepositoryConnection cxn() throws Exception;

    public Object getProperty(URI uri, String prop) {
        return this.getProperty(uri, this.factory.toPropertyURI(prop));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getProperty(URI uri, URI prop) {
        try (RepositoryResult<Statement> result = this.cxn().getStatements(uri, prop, null, false, new Resource[0]);){
            if (result.hasNext()) {
                Statement stmt = result.next();
                if (!result.hasNext()) {
                    Object object = this.getProperty(stmt.getObject());
                    return object;
                }
                LinkedList<Object> list = new LinkedList<Object>();
                list.add(this.getProperty(stmt.getObject()));
                while (true) {
                    if (!result.hasNext()) {
                        LinkedList<Object> linkedList = list;
                        return linkedList;
                    }
                    list.add(this.getProperty(result.next().getObject()));
                }
            }
            Object var4_7 = null;
            return var4_7;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Object getProperty(Value value) {
        if (!(value instanceof Literal)) {
            throw new RuntimeException("not a property: " + value);
        }
        Literal lit = (Literal)value;
        Object o = this.factory.fromLiteral(lit);
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getPropertyKeys(URI uri) {
        LinkedHashSet<String> linkedHashSet;
        RepositoryResult<Statement> result = this.cxn().getStatements(uri, null, null, false, new Resource[0]);
        try {
            LinkedHashSet<String> properties = new LinkedHashSet<String>();
            while (result.hasNext()) {
                Statement stmt = result.next();
                if (!(stmt.getObject() instanceof Literal) || stmt.getPredicate().equals(this.LABEL)) continue;
                String p = this.factory.fromURI(stmt.getPredicate());
                properties.add(p);
            }
            linkedHashSet = properties;
        }
        catch (Throwable throwable) {
            try {
                result.close();
                throw throwable;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        result.close();
        return linkedHashSet;
    }

    public Object removeProperty(URI uri, String prop) {
        return this.removeProperty(uri, this.factory.toPropertyURI(prop));
    }

    public Object removeProperty(URI uri, URI prop) {
        try {
            Object oldVal = this.getProperty(uri, prop);
            this.cxn().remove(uri, prop, null, new Resource[0]);
            return oldVal;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setProperty(URI s, String prop, Object val) {
        this.setProperty(s, this.factory.toPropertyURI(prop), this.toLiterals(val));
    }

    protected Collection<Literal> toLiterals(Object val) {
        LinkedList<Literal> literals = new LinkedList<Literal>();
        if (val instanceof Collection) {
            Collection vals = (Collection)val;
            for (Object o : vals) {
                literals.add(this.factory.toLiteral(o));
            }
        } else if (val.getClass().isArray()) {
            int len = Array.getLength(val);
            for (int i = 0; i < len; ++i) {
                Object o = Array.get(val, i);
                literals.add(this.factory.toLiteral(o));
            }
        } else {
            literals.add(this.factory.toLiteral(val));
        }
        return literals;
    }

    public void setProperty(URI uri, URI prop, Collection<Literal> vals) {
        try {
            RepositoryConnection cxn = this.cxn();
            if (!this.laxProperties) {
                cxn.remove(uri, prop, null, new Resource[0]);
            }
            for (Literal val : vals) {
                cxn.add(uri, prop, val, new Resource[0]);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void loadGraphML(String file) throws Exception {
        GraphMLReader.inputGraph((Graph)this, file);
    }

    @Override
    public Edge addEdge(Object key, Vertex from, Vertex to, String label) {
        return this.addEdge(key, from, to, label, false);
    }

    public Edge addEdge(Object key, Vertex from, Vertex to, boolean anonymous) {
        return this.addEdge(key, from, to, null, anonymous);
    }

    public Edge addEdge(Object key, Vertex from, Vertex to, String label, boolean anonymous) {
        Edge edge;
        if (log.isInfoEnabled()) {
            log.info("(" + key + ", " + from + ", " + to + ", " + label + ")");
        }
        if (label == null && !this.laxEdges) {
            throw new IllegalArgumentException();
        }
        if (!(key == null || this.laxEdges || (edge = this.getEdge(key)) == null || edge.getVertex(Direction.OUT).equals(from) && edge.getVertex(Direction.IN).equals(to))) {
            throw new IllegalArgumentException("edge already exists: " + key);
        }
        String eid = key != null ? key.toString() : UUID.randomUUID().toString();
        URI edgeURI = this.factory.toEdgeURI(eid);
        try {
            URI fromURI = this.factory.toVertexURI(from.getId().toString());
            URI toURI = this.factory.toVertexURI(to.getId().toString());
            RepositoryConnection cxn = this.cxn();
            cxn.add(fromURI, edgeURI, (Value)toURI, new Resource[0]);
            if (label != null) {
                cxn.add(edgeURI, this.LABEL, this.factory.toLiteral(label), new Resource[0]);
                if (!anonymous) {
                    cxn.add(edgeURI, this.TYPE, (Value)this.EDGE, new Resource[0]);
                }
            }
            return new BigdataEdge(new StatementImpl(fromURI, edgeURI, toURI), this);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Vertex addVertex(Object key) {
        if (log.isInfoEnabled()) {
            log.info("(" + key + ")");
        }
        try {
            String vid = key != null ? key.toString() : UUID.randomUUID().toString();
            URI uri = this.factory.toVertexURI(vid);
            this.cxn().add(uri, this.TYPE, (Value)this.VERTEX, new Resource[0]);
            return new BigdataVertex(uri, this);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Edge getEdge(Object key) {
        if (log.isInfoEnabled()) {
            log.info("(" + key + ")");
        }
        if (key == null) {
            throw new IllegalArgumentException();
        }
        try {
            URI edge = this.factory.toEdgeURI(key.toString());
            try (RepositoryResult<Statement> result = this.cxn().getStatements(null, edge, null, false, new Resource[0]);){
                if (result.hasNext()) {
                    Statement stmt = result.next();
                    if (result.hasNext()) {
                        throw new RuntimeException("duplicate edge: " + key);
                    }
                    BigdataEdge bigdataEdge = new BigdataEdge(stmt, this);
                    return bigdataEdge;
                }
                Edge edge2 = null;
                return edge2;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterable<Edge> getEdges() {
        if (log.isInfoEnabled()) {
            log.info("");
        }
        try {
            URI wild = null;
            return this.getEdges(wild, wild, new String[0]);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    Iterable<Edge> getEdges(URI from, URI to, String ... labels) throws Exception {
        GraphQueryResult stmts = this.getElements(from, to, labels);
        return new EdgeIterable(stmts);
    }

    protected GraphQueryResult getElements(URI from, URI to, String ... labels) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("construct { ?from ?edge ?to . } where {\n");
        sb.append("  ?edge <" + this.TYPE + "> <" + this.EDGE + "> .\n");
        sb.append("  ?from ?edge ?to .\n");
        if (labels != null && labels.length > 0) {
            if (labels.length == 1) {
                sb.append("  ?edge <" + this.LABEL + "> \"").append(labels[0]).append("\" .\n");
            } else {
                sb.append("  ?edge <" + this.LABEL + "> ?label .\n");
                sb.append("  filter(?label in (");
                for (String label : labels) {
                    sb.append("\"" + label + "\", ");
                }
                sb.setLength(sb.length() - 2);
                sb.append(")) .\n");
            }
        }
        sb.append("}");
        String queryStr = sb.toString().replace("?from", from != null ? "<" + from + ">" : "?from").replace("?to", to != null ? "<" + to + ">" : "?to");
        GraphQuery query = this.cxn().prepareGraphQuery(QueryLanguage.SPARQL, queryStr);
        GraphQueryResult stmts = query.evaluate();
        return stmts;
    }

    Iterable<Edge> getEdges(String queryStr) throws Exception {
        GraphQuery query = this.cxn().prepareGraphQuery(QueryLanguage.SPARQL, queryStr);
        GraphQueryResult stmts = query.evaluate();
        return new EdgeIterable(stmts);
    }

    Iterable<Vertex> getVertices(URI from, URI to, String ... labels) throws Exception {
        if (from != null && to != null) {
            throw new IllegalArgumentException();
        }
        if (from == null && to == null) {
            throw new IllegalArgumentException();
        }
        GraphQueryResult stmts = this.getElements(from, to, labels);
        return new VertexIterable(stmts, from == null);
    }

    Iterable<Vertex> getVertices(String queryStr, boolean subject) throws Exception {
        GraphQuery query = this.cxn().prepareGraphQuery(QueryLanguage.SPARQL, queryStr);
        GraphQueryResult stmts = query.evaluate();
        return new VertexIterable(stmts, subject);
    }

    @Override
    public Iterable<Edge> getEdges(String prop, Object val) {
        if (log.isInfoEnabled()) {
            log.info("(" + prop + ", " + val + ")");
        }
        URI p = this.factory.toPropertyURI(prop);
        Literal o = this.factory.toLiteral(val);
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("construct { ?from ?edge ?to . } where {\n");
            sb.append("  ?edge <" + p + "> " + o + " .\n");
            sb.append("  ?from ?edge ?to .\n");
            sb.append("}");
            String queryStr = sb.toString();
            return this.getEdges(queryStr);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Vertex getVertex(Object key) {
        if (log.isInfoEnabled()) {
            log.info("(" + key + ")");
        }
        if (key == null) {
            throw new IllegalArgumentException();
        }
        URI uri = this.factory.toVertexURI(key.toString());
        try {
            if (this.cxn().hasStatement(uri, this.TYPE, (Value)this.VERTEX, false, new Resource[0])) {
                return new BigdataVertex(uri, this);
            }
            return null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterable<Vertex> getVertices() {
        if (log.isInfoEnabled()) {
            log.info("");
        }
        try {
            RepositoryResult<Statement> result = this.cxn().getStatements(null, this.TYPE, this.VERTEX, false, new Resource[0]);
            return new VertexIterable(result, true);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterable<Vertex> getVertices(String prop, Object val) {
        if (log.isInfoEnabled()) {
            log.info("(" + prop + ", " + val + ")");
        }
        URI p = this.factory.toPropertyURI(prop);
        Literal o = this.factory.toLiteral(val);
        try {
            RepositoryResult<Statement> result = this.cxn().getStatements(null, p, o, false, new Resource[0]);
            return new VertexIterable(result, true);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public com.tinkerpop.blueprints.GraphQuery query() {
        if (log.isInfoEnabled()) {
            log.info("");
        }
        return new BigdataGraphQuery(this);
    }

    @Override
    public void removeEdge(Edge edge) {
        try {
            RepositoryConnection cxn = this.cxn();
            URI uri = this.factory.toURI(edge);
            if (!cxn.hasStatement(uri, this.TYPE, (Value)this.EDGE, false, new Resource[0])) {
                throw new IllegalStateException();
            }
            URI wild = null;
            cxn.remove(wild, uri, wild, new Resource[0]);
            cxn.remove(uri, wild, wild, new Resource[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void removeVertex(Vertex vertex) {
        try {
            RepositoryConnection cxn = this.cxn();
            URI uri = this.factory.toURI(vertex);
            if (!cxn.hasStatement(uri, this.TYPE, (Value)this.VERTEX, false, new Resource[0])) {
                throw new IllegalStateException();
            }
            URI wild = null;
            cxn.remove(uri, wild, wild, new Resource[0]);
            cxn.remove(wild, wild, (Value)uri, new Resource[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final <T> Iterable<T> fuse(Iterable<T> ... args) {
        return new FusedIterable<T>(args);
    }

    public ICloseableIterator<BigdataGraphAtom> project(String queryStr) throws Exception {
        return this.project(queryStr, UUID.randomUUID().toString());
    }

    public ICloseableIterator<BigdataGraphAtom> project(String queryStr, String externalQueryId) throws Exception {
        GraphQueryResult result;
        RepositoryConnection cxn = this.cxn();
        if (sparqlLog.isTraceEnabled()) {
            sparqlLog.trace("query:\n" + (queryStr.length() <= 10000 ? queryStr : queryStr.substring(0, 10000) + " ..."));
        }
        UUID queryId = null;
        try {
            GraphQuery query = cxn.prepareGraphQuery(QueryLanguage.SPARQL, queryStr);
            this.setMaxQueryTime(query);
            if (query instanceof BigdataSailGraphQuery && cxn instanceof BigdataSailRepositoryConnection) {
                BigdataSailGraphQuery bdtq = (BigdataSailGraphQuery)query;
                queryId = this.setupQuery((BigdataSailRepositoryConnection)cxn, bdtq.getASTContainer(), QueryType.CONSTRUCT, externalQueryId);
            }
            if (sparqlLog.isTraceEnabled() && query instanceof BigdataSailGraphQuery) {
                BigdataSailGraphQuery bdgq = (BigdataSailGraphQuery)query;
                sparqlLog.trace("optimized AST:\n" + bdgq.optimize());
            }
            result = query.evaluate();
        }
        catch (Exception ex) {
            if (queryId != null) {
                this.finalizeQuery(queryId);
            }
            throw ex;
        }
        Striterator sitr = new Striterator(new WrappedResult<Statement>(result, queryId));
        sitr.addFilter(new Filter(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isValid(Object e) {
                Statement stmt = (Statement)e;
                return stmt.getSubject() instanceof URI;
            }
        });
        sitr.addFilter(new Resolver(){
            private static final long serialVersionUID = 1L;

            @Override
            protected Object resolve(Object e) {
                Statement stmt = (Statement)e;
                return BigdataGraph.this.toGraphAtom(stmt);
            }
        });
        return sitr;
    }

    protected BigdataGraphAtom toGraphAtom(Statement stmt) {
        URI s = (URI)stmt.getSubject();
        URI p = stmt.getPredicate();
        Value o = stmt.getObject();
        return this.toGraphAtom(s, p, o);
    }

    protected BigdataGraphAtom toGraphAtom(URI s, URI p, Value o) {
        BigdataGraphAtom atom;
        String sid = this.factory.fromURI(s);
        String pid = this.factory.fromURI(p);
        if (o instanceof URI) {
            if (p.equals(this.factory.getTypeURI()) && (o.equals(this.factory.getVertexURI()) || o.equals(this.factory.getEdgeURI()))) {
                atom = o.equals(this.factory.getVertexURI()) ? new BigdataGraphAtom.ExistenceAtom(sid, BigdataGraphAtom.ElementType.VERTEX) : new BigdataGraphAtom.ExistenceAtom(sid, BigdataGraphAtom.ElementType.EDGE);
            } else {
                String oid = this.factory.fromURI((URI)o);
                atom = new BigdataGraphAtom.EdgeAtom(pid, sid, oid);
            }
        } else if (p.equals(this.factory.getLabelURI())) {
            String label = this.factory.fromLiteral((Literal)o).toString();
            atom = new BigdataGraphAtom.EdgeLabelAtom(sid, label);
        } else {
            Object oval = this.factory.fromLiteral((Literal)o);
            atom = new BigdataGraphAtom.PropertyAtom(sid, pid, oval);
        }
        return atom;
    }

    public ICloseableIterator<BigdataBindingSet> select(String queryStr) throws Exception {
        return this.select(queryStr, UUID.randomUUID().toString());
    }

    public ICloseableIterator<BigdataBindingSet> select(String queryStr, String externalQueryId) throws Exception {
        TupleQueryResult result;
        RepositoryConnection cxn = this.cxn();
        if (sparqlLog.isTraceEnabled()) {
            sparqlLog.trace("query:\n" + (queryStr.length() <= 10000 ? queryStr : queryStr.substring(0, 10000) + " ..."));
        }
        UUID queryId = null;
        try {
            BigdataSailTupleQuery bdtq;
            TupleQuery query = cxn.prepareTupleQuery(QueryLanguage.SPARQL, queryStr);
            this.setMaxQueryTime(query);
            if (query instanceof BigdataSailTupleQuery && cxn instanceof BigdataSailRepositoryConnection) {
                bdtq = (BigdataSailTupleQuery)query;
                queryId = this.setupQuery((BigdataSailRepositoryConnection)cxn, bdtq.getASTContainer(), QueryType.SELECT, externalQueryId);
            }
            if (sparqlLog.isTraceEnabled() && query instanceof BigdataSailTupleQuery) {
                bdtq = (BigdataSailTupleQuery)query;
                sparqlLog.trace("optimized AST:\n" + bdtq.optimize());
            }
            result = query.evaluate();
        }
        catch (Exception ex) {
            if (queryId != null) {
                this.finalizeQuery(queryId);
            }
            throw ex;
        }
        Striterator sitr = new Striterator(new WrappedResult<BindingSet>(result, queryId));
        sitr.addFilter(new Resolver(){
            private static final long serialVersionUID = 1L;

            @Override
            protected Object resolve(Object e) {
                BindingSet bs = (BindingSet)e;
                return BigdataGraph.this.convert(bs);
            }
        });
        return sitr;
    }

    protected BigdataBindingSet convert(BindingSet bs) {
        BigdataBindingSet bbs = new BigdataBindingSet();
        for (String key : bs.getBindingNames()) {
            Object o;
            Value val = bs.getBinding(key).getValue();
            if (val instanceof Literal) {
                o = this.factory.fromLiteral((Literal)val);
            } else {
                if (!(val instanceof URI)) continue;
                o = this.factory.fromURI((URI)val);
            }
            bbs.put(key, o);
        }
        return bbs;
    }

    public boolean ask(String queryStr) throws Exception {
        return this.ask(queryStr, UUID.randomUUID().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ask(String queryStr, String externalQueryId) throws Exception {
        RepositoryConnection cxn = this.cxn();
        UUID queryId = null;
        try {
            boolean result;
            BooleanQuery query = cxn.prepareBooleanQuery(QueryLanguage.SPARQL, queryStr);
            this.setMaxQueryTime(query);
            if (query instanceof BigdataSailBooleanQuery && cxn instanceof BigdataSailRepositoryConnection) {
                BigdataSailBooleanQuery bdtq = (BigdataSailBooleanQuery)query;
                queryId = this.setupQuery((BigdataSailRepositoryConnection)cxn, bdtq.getASTContainer(), QueryType.ASK, externalQueryId);
            }
            boolean bl = result = query.evaluate();
            return bl;
        }
        finally {
            if (queryId != null) {
                this.finalizeQuery(queryId);
            }
        }
    }

    public void update(String queryStr) throws Exception {
        String randomUUID = UUID.randomUUID().toString();
        this.update(queryStr, randomUUID);
    }

    public void update(String queryStr, String extQueryId) throws Exception {
        try {
            Update update = this.cxn().prepareUpdate(QueryLanguage.SPARQL, queryStr);
            update.execute();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ICloseableIterator<BigdataGraphEdit> history(List<URI> ids) throws Exception {
        String randomUUID = UUID.randomUUID().toString();
        return this.history(ids, randomUUID);
    }

    public ICloseableIterator<BigdataGraphEdit> history(List<URI> ids, String extQueryId) throws Exception {
        TupleQueryResult result;
        RepositoryConnection cxn = this.cxn();
        StringBuilder sb = new StringBuilder(HISTORY_TEMPLATE);
        if (ids.size() > 0) {
            StringBuilder vc = new StringBuilder();
            vc.append("    values (?s) { \n");
            for (URI id : ids) {
                vc.append("        (<" + id + ">) \n");
            }
            vc.append("    } \n");
            sb.insert(sb.length() - 1, vc.toString());
        }
        String queryStr = sb.toString();
        if (sparqlLog.isTraceEnabled()) {
            sparqlLog.trace("query:\n" + (queryStr.length() <= 10000 ? queryStr : queryStr.substring(0, 10000) + " ..."));
        }
        UUID queryId = null;
        try {
            BigdataSailTupleQuery bdtq;
            TupleQuery query = cxn.prepareTupleQuery(QueryLanguage.SPARQL, queryStr);
            if (query instanceof BigdataSailTupleQuery && cxn instanceof BigdataSailRepositoryConnection) {
                bdtq = (BigdataSailTupleQuery)query;
                queryId = this.setupQuery((BigdataSailRepositoryConnection)cxn, bdtq.getASTContainer(), QueryType.SELECT, extQueryId);
            }
            if (sparqlLog.isTraceEnabled() && query instanceof BigdataSailTupleQuery) {
                bdtq = (BigdataSailTupleQuery)query;
                sparqlLog.trace("optimized AST:\n" + bdtq.optimize());
            }
            result = query.evaluate();
        }
        catch (Exception ex) {
            if (queryId != null) {
                this.finalizeQuery(queryId);
            }
            throw ex;
        }
        Striterator sitr = new Striterator(new WrappedResult<BindingSet>(result, queryId));
        sitr.addFilter(new Resolver(){
            private static final long serialVersionUID = 1L;

            @Override
            protected Object resolve(Object e) {
                BigdataGraphEdit.Action action;
                BindingSet bs = (BindingSet)e;
                URI s = (URI)bs.getValue("s");
                URI p = (URI)bs.getValue("p");
                Value o = bs.getValue("o");
                URI a = (URI)bs.getValue("action");
                Literal t = (Literal)bs.getValue("time");
                if (!t.getDatatype().equals(XSD.DATETIME)) {
                    throw new RuntimeException("Unexpected timestamp in result: " + bs);
                }
                if (a.equals(RDRHistory.Vocab.ADDED)) {
                    action = BigdataGraphEdit.Action.Add;
                } else if (a.equals(RDRHistory.Vocab.REMOVED)) {
                    action = BigdataGraphEdit.Action.Remove;
                } else {
                    throw new RuntimeException("Unexpected action in result: " + bs);
                }
                BigdataGraphAtom atom = BigdataGraph.this.toGraphAtom(s, p, o);
                long timestamp = DateTimeExtension.getTimestamp(t.getLabel());
                return new BigdataGraphEdit(action, atom, timestamp);
            }
        });
        return sitr;
    }

    @Override
    public Features getFeatures() {
        return FEATURES;
    }

    protected void setMaxQueryTime(Query query) {
        if (this.maxQueryTime > 0) {
            query.setMaxQueryTime(this.maxQueryTime);
        }
    }

    public abstract Collection<RunningQuery> getRunningQueries();

    public abstract void cancel(UUID var1);

    public abstract void cancel(String var1);

    public abstract void cancel(RunningQuery var1);

    public abstract RunningQuery getQueryById(UUID var1);

    public abstract RunningQuery getQueryByExternalId(String var1);

    protected abstract UUID setupQuery(BigdataSailRepositoryConnection var1, ASTContainer var2, QueryType var3, String var4);

    protected void finalizeQuery(UUID queryId) throws QueryCancelledException {
        boolean isQueryCancelled = this.isQueryCancelled(queryId);
        this.tearDownQuery(queryId);
        if (isQueryCancelled) {
            if (log.isDebugEnabled()) {
                log.debug(queryId + " execution canceled.");
            }
            throw new QueryCancelledException(queryId + " execution canceled.", queryId);
        }
    }

    protected abstract void tearDownQuery(UUID var1);

    protected abstract boolean isQueryCancelled(UUID var1);

    public abstract boolean isReadOnly();

    static {
        BigdataGraph.FEATURES.supportsSerializableObjectProperty = false;
        BigdataGraph.FEATURES.supportsBooleanProperty = true;
        BigdataGraph.FEATURES.supportsDoubleProperty = true;
        BigdataGraph.FEATURES.supportsFloatProperty = true;
        BigdataGraph.FEATURES.supportsIntegerProperty = true;
        BigdataGraph.FEATURES.supportsPrimitiveArrayProperty = true;
        BigdataGraph.FEATURES.supportsUniformListProperty = true;
        BigdataGraph.FEATURES.supportsMixedListProperty = true;
        BigdataGraph.FEATURES.supportsLongProperty = true;
        BigdataGraph.FEATURES.supportsMapProperty = false;
        BigdataGraph.FEATURES.supportsStringProperty = true;
        BigdataGraph.FEATURES.supportsDuplicateEdges = true;
        BigdataGraph.FEATURES.supportsSelfLoops = true;
        BigdataGraph.FEATURES.isPersistent = true;
        BigdataGraph.FEATURES.isWrapper = false;
        BigdataGraph.FEATURES.supportsVertexIteration = true;
        BigdataGraph.FEATURES.supportsEdgeIteration = true;
        BigdataGraph.FEATURES.supportsVertexIndex = false;
        BigdataGraph.FEATURES.supportsEdgeIndex = false;
        BigdataGraph.FEATURES.ignoresSuppliedIds = false;
        BigdataGraph.FEATURES.supportsTransactions = false;
        BigdataGraph.FEATURES.supportsIndices = true;
        BigdataGraph.FEATURES.supportsKeyIndices = true;
        BigdataGraph.FEATURES.supportsVertexKeyIndex = true;
        BigdataGraph.FEATURES.supportsEdgeKeyIndex = true;
        BigdataGraph.FEATURES.supportsEdgeRetrieval = true;
        BigdataGraph.FEATURES.supportsVertexProperties = true;
        BigdataGraph.FEATURES.supportsEdgeProperties = true;
        BigdataGraph.FEATURES.supportsThreadedTransactions = false;
    }

    public class WrappedResult<E>
    implements ICloseableIterator<E> {
        private final CloseableIteration<E, ?> it;
        private final UUID queryId;

        public WrappedResult(CloseableIteration<E, ?> it) {
            this.it = it;
            this.queryId = null;
        }

        public WrappedResult(CloseableIteration<E, ?> it, UUID queryId) {
            this.it = it;
            this.queryId = queryId;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.it.hasNext();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public E next() {
            try {
                return this.it.next();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
            try {
                BigdataGraph.this.finalizeQuery(this.queryId);
                this.it.close();
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public class FusedIterable<T>
    implements Iterable<T>,
    Iterator<T> {
        private final Iterable<T>[] args;
        private transient int i = 0;
        private transient Iterator<T> curr;

        public FusedIterable(Iterable<T> ... args) {
            this.args = args;
            this.curr = args[0].iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.curr.hasNext()) {
                return true;
            }
            while (!this.curr.hasNext() && this.i < this.args.length - 1) {
                this.curr = this.args[++this.i].iterator();
                if (!this.curr.hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public T next() {
            return this.curr.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }
    }

    public class EdgeIterable
    implements Iterable<Edge>,
    Iterator<Edge> {
        private final CloseableIteration<Statement, ? extends OpenRDFException> stmts;
        private final List<Edge> cache;

        public EdgeIterable(CloseableIteration<Statement, ? extends OpenRDFException> stmts) {
            this.stmts = stmts;
            this.cache = new LinkedList<Edge>();
        }

        @Override
        public boolean hasNext() {
            try {
                return this.stmts.hasNext();
            }
            catch (OpenRDFException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Edge next() {
            try {
                Statement stmt = (Statement)this.stmts.next();
                BigdataEdge edge = new BigdataEdge(stmt, BigdataGraph.this);
                this.cache.add(edge);
                BigdataEdge bigdataEdge = edge;
                return bigdataEdge;
            }
            catch (OpenRDFException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (!this.hasNext()) {
                    try {
                        this.stmts.close();
                    }
                    catch (OpenRDFException e) {
                        log.warn("Could not close result");
                    }
                }
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Edge> iterator() {
            return this.hasNext() ? this : this.cache.iterator();
        }
    }

    public class VertexIterable
    implements Iterable<Vertex>,
    Iterator<Vertex> {
        private final CloseableIteration<Statement, ? extends OpenRDFException> stmts;
        private final boolean subject;
        private final List<Vertex> cache;

        public VertexIterable(CloseableIteration<Statement, ? extends OpenRDFException> stmts, boolean subject) {
            this.stmts = stmts;
            this.subject = subject;
            this.cache = new LinkedList<Vertex>();
        }

        @Override
        public boolean hasNext() {
            try {
                return this.stmts.hasNext();
            }
            catch (OpenRDFException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Vertex next() {
            try {
                Statement stmt = (Statement)this.stmts.next();
                URI v = (URI)(this.subject ? stmt.getSubject() : stmt.getObject());
                BigdataVertex vertex = new BigdataVertex(v, BigdataGraph.this);
                this.cache.add(vertex);
                BigdataVertex bigdataVertex = vertex;
                return bigdataVertex;
            }
            catch (OpenRDFException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (!this.hasNext()) {
                    try {
                        this.stmts.close();
                    }
                    catch (OpenRDFException e) {
                        log.warn("Could not close result");
                    }
                }
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Vertex> iterator() {
            return this.hasNext() ? this : this.cache.iterator();
        }
    }

    public static interface Options {
        public static final String LAX_EDGES = BigdataGraph.class.getName() + ".laxEdges";
        public static final String LAX_PROPERTIES = BigdataGraph.class.getName() + ".laxProperties";
        public static final String MAX_QUERY_TIME = BigdataGraph.class.getName() + ".maxQueryTime";
    }
}

