/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.blueprints;

import com.bigdata.blueprints.BigdataEdge;
import com.bigdata.blueprints.BigdataGraph;
import com.bigdata.blueprints.BigdataRDFFactory;
import com.bigdata.blueprints.BigdataVertex;
import com.bigdata.blueprints.BlueprintsValueFactory;
import com.bigdata.rdf.changesets.IChangeLog;
import com.bigdata.rdf.changesets.IChangeRecord;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.model.RunningQuery;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.GraphQuery;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.Vertex;
import java.util.Collection;
import java.util.UUID;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.repository.RepositoryConnection;

public class BigdataGraphBulkLoad
extends BigdataGraph
implements TransactionalGraph,
IChangeLog {
    private final BigdataSailRepositoryConnection cxn;
    private transient long mutationCountTotal = 0L;
    private transient long mutationCountCurrentCommit = 0L;
    private transient long mutationCountLastCommit = 0L;

    public BigdataGraphBulkLoad(BigdataSailRepositoryConnection cxn) {
        this(cxn, BigdataRDFFactory.INSTANCE);
    }

    public BigdataGraphBulkLoad(BigdataSailRepositoryConnection cxn, BlueprintsValueFactory factory) {
        super(factory);
        this.cxn = cxn;
        this.cxn.addChangeLog(this);
    }

    @Override
    public RepositoryConnection cxn() throws Exception {
        return this.cxn;
    }

    @Override
    public void commit() {
        try {
            this.cxn.commit();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void rollback() {
        try {
            this.cxn.rollback();
            this.cxn.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void shutdown() {
        try {
            this.cxn.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Deprecated
    public void stopTransaction(TransactionalGraph.Conclusion arg0) {
    }

    @Override
    public Edge getEdge(Object arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<Edge> getEdges() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<Edge> getEdges(String arg0, Object arg1) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vertex getVertex(Object key) {
        block7: {
            if (key == null) {
                throw new IllegalArgumentException();
            }
            URI uri = this.factory.toVertexURI(key.toString());
            if (!this.cxn.hasStatement(uri, this.TYPE, (Value)this.VERTEX, false, new Resource[0])) break block7;
            BigdataVertex bigdataVertex = new BigdataVertex(uri, this);
            return bigdataVertex;
        }
        try {
            Vertex vertex = null;
            return vertex;
        }
        catch (Throwable throwable) {
            try {
                throw throwable;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Iterable<Vertex> getVertices() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<Vertex> getVertices(String arg0, Object arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GraphQuery query() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeEdge(Edge arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeVertex(Vertex arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setProperty(URI uri, URI prop, Collection<Literal> vals) {
        try {
            RepositoryConnection cxn = this.cxn();
            for (Literal val : vals) {
                cxn.add(uri, prop, val, new Resource[0]);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Vertex addVertex(Object key) {
        try {
            String vid = key != null ? key.toString() : UUID.randomUUID().toString();
            URI uri = this.factory.toVertexURI(vid);
            this.cxn().add(uri, this.TYPE, (Value)this.VERTEX, new Resource[0]);
            return new BigdataVertex(uri, this);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Edge addEdge(Object key, Vertex from, Vertex to, String label) {
        if (label == null) {
            throw new IllegalArgumentException();
        }
        String eid = key != null ? key.toString() : UUID.randomUUID().toString();
        URI edgeURI = this.factory.toEdgeURI(eid);
        try {
            URI fromURI = this.factory.toVertexURI(from.getId().toString());
            URI toURI = this.factory.toVertexURI(to.getId().toString());
            RepositoryConnection cxn = this.cxn();
            cxn.add(fromURI, edgeURI, (Value)toURI, new Resource[0]);
            cxn.add(edgeURI, this.TYPE, (Value)this.EDGE, new Resource[0]);
            cxn.add(edgeURI, this.LABEL, this.factory.toLiteral(label), new Resource[0]);
            return new BigdataEdge(new StatementImpl(fromURI, edgeURI, toURI), (BigdataGraph)this);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void changeEvent(IChangeRecord record) {
        ++this.mutationCountTotal;
        ++this.mutationCountCurrentCommit;
    }

    @Override
    public void transactionBegin() {
    }

    @Override
    public void transactionPrepare() {
    }

    @Override
    public void transactionCommited(long commitTime) {
        this.mutationCountLastCommit = this.mutationCountCurrentCommit;
        this.mutationCountCurrentCommit = 0L;
    }

    @Override
    public void transactionAborted() {
    }

    @Override
    public void close() {
    }

    public long getMutationCountTotal() {
        return this.mutationCountTotal;
    }

    public long getMutationCountCurrentCommit() {
        return this.mutationCountCurrentCommit;
    }

    public long getMutationCountLastCommit() {
        return this.mutationCountLastCommit;
    }

    @Override
    protected UUID setupQuery(BigdataSailRepositoryConnection cxn, ASTContainer astContainer, QueryType queryType, String extQueryId) {
        throw new RuntimeException("Method is not implemented for BigdataGraphBulkLoad.");
    }

    @Override
    protected void tearDownQuery(UUID queryId) {
        throw new RuntimeException("Method is not implemented for BigdataGraphBulkLoad.");
    }

    @Override
    public Collection<RunningQuery> getRunningQueries() {
        throw new RuntimeException("Method is not implemented for BigdataGraphBulkLoad.");
    }

    @Override
    public void cancel(UUID queryId) {
        throw new RuntimeException("Method is not implemented for BigdataGraphBulkLoad.");
    }

    @Override
    public void cancel(String externalQueryId) {
        throw new RuntimeException("Method is not implemented for BigdataGraphBulkLoad.");
    }

    @Override
    public void cancel(RunningQuery r) {
        throw new RuntimeException("Method is not implemented for BigdataGraphBulkLoad.");
    }

    @Override
    public RunningQuery getQueryById(UUID queryId2) {
        throw new RuntimeException("Method is not implemented for BigdataGraphBulkLoad.");
    }

    @Override
    public RunningQuery getQueryByExternalId(String extQueryId) {
        throw new RuntimeException("Method is not implemented for BigdataGraphBulkLoad.");
    }

    @Override
    protected boolean isQueryCancelled(UUID queryId) {
        throw new RuntimeException("Method is not implemented for BigdataGraphBulkLoad.");
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    static {
        BigdataGraphBulkLoad.FEATURES.supportsTransactions = true;
    }
}

