/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.blueprints;

import com.bigdata.blueprints.BigdataGraph;
import com.bigdata.blueprints.BigdataRDFFactory;
import com.bigdata.blueprints.BlueprintsValueFactory;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.model.RunningQuery;
import com.bigdata.rdf.sail.remote.BigdataSailFactory;
import com.bigdata.rdf.sail.remote.BigdataSailRemoteRepository;
import com.bigdata.rdf.sail.remote.BigdataSailRemoteRepositoryConnection;
import com.bigdata.rdf.sail.webapp.client.RemoteRepository;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.tinkerpop.blueprints.Features;
import java.util.Collection;
import java.util.Properties;
import java.util.UUID;
import org.apache.log4j.Logger;

public class BigdataGraphClient
extends BigdataGraph {
    private static final transient Logger log = Logger.getLogger(BigdataGraphClient.class);
    private static final Properties props = new Properties();
    final BigdataSailRemoteRepository repo;
    transient BigdataSailRemoteRepositoryConnection cxn;
    protected static final Features FEATURES = new Features();

    public BigdataGraphClient(String sparqlEndpointURL) {
        this(sparqlEndpointURL, (BlueprintsValueFactory)BigdataRDFFactory.INSTANCE);
    }

    public BigdataGraphClient(String sparqlEndpointURL, BlueprintsValueFactory factory) {
        this(BigdataSailFactory.connect(sparqlEndpointURL), factory);
    }

    public BigdataGraphClient(RemoteRepository repo) {
        this(repo, (BlueprintsValueFactory)BigdataRDFFactory.INSTANCE);
    }

    public BigdataGraphClient(RemoteRepository repo, BlueprintsValueFactory factory) {
        this(repo.getBigdataSailRemoteRepository(), factory);
    }

    public BigdataGraphClient(BigdataSailRemoteRepository repo) {
        this(repo, (BlueprintsValueFactory)BigdataRDFFactory.INSTANCE);
    }

    public BigdataGraphClient(BigdataSailRemoteRepository repo, BlueprintsValueFactory factory) {
        super(factory, props);
        if (repo == null) {
            throw new IllegalArgumentException();
        }
        this.repo = repo;
    }

    @Override
    public void loadGraphML(String file) throws Exception {
        this.repo.getRemoteRepository().postGraphML(file);
    }

    @Override
    public BigdataSailRemoteRepositoryConnection cxn() throws Exception {
        if (this.cxn == null) {
            this.cxn = this.repo.getConnection();
        }
        return this.cxn;
    }

    @Override
    public void shutdown() {
        try {
            if (this.cxn != null) {
                this.cxn.close();
            }
            this.repo.shutDown();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Features getFeatures() {
        return FEATURES;
    }

    @Override
    protected UUID setupQuery(BigdataSailRepositoryConnection cxn, ASTContainer astContainer, QueryType queryType, String extQueryId) {
        return null;
    }

    @Override
    protected void tearDownQuery(UUID queryId) {
    }

    @Override
    public Collection<RunningQuery> getRunningQueries() {
        try {
            return this.repo.showQueries();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug(e);
            }
            throw new RuntimeException("Error while showing queries.");
        }
    }

    @Override
    public void cancel(UUID queryId) {
        block3: {
            assert (queryId != null);
            try {
                this.repo.cancel(queryId);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug(e);
            }
        }
    }

    @Override
    public void cancel(String queryId) {
        assert (queryId != null);
        this.cancel(UUID.fromString(queryId));
    }

    @Override
    public void cancel(RunningQuery r) {
        assert (r != null);
        this.cancel(r.getQueryUuid());
    }

    @Override
    public RunningQuery getQueryById(UUID queryId2) {
        return null;
    }

    @Override
    public RunningQuery getQueryByExternalId(String extQueryId) {
        return null;
    }

    @Override
    protected boolean isQueryCancelled(UUID queryId) {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    static {
        BigdataGraphClient.FEATURES.supportsSerializableObjectProperty = BigdataGraph.FEATURES.supportsSerializableObjectProperty;
        BigdataGraphClient.FEATURES.supportsBooleanProperty = BigdataGraph.FEATURES.supportsBooleanProperty;
        BigdataGraphClient.FEATURES.supportsDoubleProperty = BigdataGraph.FEATURES.supportsDoubleProperty;
        BigdataGraphClient.FEATURES.supportsFloatProperty = BigdataGraph.FEATURES.supportsFloatProperty;
        BigdataGraphClient.FEATURES.supportsIntegerProperty = BigdataGraph.FEATURES.supportsIntegerProperty;
        BigdataGraphClient.FEATURES.supportsPrimitiveArrayProperty = BigdataGraph.FEATURES.supportsPrimitiveArrayProperty;
        BigdataGraphClient.FEATURES.supportsUniformListProperty = BigdataGraph.FEATURES.supportsUniformListProperty;
        BigdataGraphClient.FEATURES.supportsMixedListProperty = BigdataGraph.FEATURES.supportsMixedListProperty;
        BigdataGraphClient.FEATURES.supportsLongProperty = BigdataGraph.FEATURES.supportsLongProperty;
        BigdataGraphClient.FEATURES.supportsMapProperty = BigdataGraph.FEATURES.supportsMapProperty;
        BigdataGraphClient.FEATURES.supportsStringProperty = BigdataGraph.FEATURES.supportsStringProperty;
        BigdataGraphClient.FEATURES.supportsDuplicateEdges = BigdataGraph.FEATURES.supportsDuplicateEdges;
        BigdataGraphClient.FEATURES.supportsSelfLoops = BigdataGraph.FEATURES.supportsSelfLoops;
        BigdataGraphClient.FEATURES.isPersistent = BigdataGraph.FEATURES.isPersistent;
        BigdataGraphClient.FEATURES.isWrapper = BigdataGraph.FEATURES.isWrapper;
        BigdataGraphClient.FEATURES.supportsVertexIteration = BigdataGraph.FEATURES.supportsVertexIteration;
        BigdataGraphClient.FEATURES.supportsEdgeIteration = BigdataGraph.FEATURES.supportsEdgeIteration;
        BigdataGraphClient.FEATURES.supportsVertexIndex = BigdataGraph.FEATURES.supportsVertexIndex;
        BigdataGraphClient.FEATURES.supportsEdgeIndex = BigdataGraph.FEATURES.supportsEdgeIndex;
        BigdataGraphClient.FEATURES.ignoresSuppliedIds = BigdataGraph.FEATURES.ignoresSuppliedIds;
        BigdataGraphClient.FEATURES.supportsIndices = BigdataGraph.FEATURES.supportsIndices;
        BigdataGraphClient.FEATURES.supportsKeyIndices = BigdataGraph.FEATURES.supportsKeyIndices;
        BigdataGraphClient.FEATURES.supportsVertexKeyIndex = BigdataGraph.FEATURES.supportsVertexKeyIndex;
        BigdataGraphClient.FEATURES.supportsEdgeKeyIndex = BigdataGraph.FEATURES.supportsEdgeKeyIndex;
        BigdataGraphClient.FEATURES.supportsEdgeRetrieval = BigdataGraph.FEATURES.supportsEdgeRetrieval;
        BigdataGraphClient.FEATURES.supportsVertexProperties = BigdataGraph.FEATURES.supportsVertexProperties;
        BigdataGraphClient.FEATURES.supportsEdgeProperties = BigdataGraph.FEATURES.supportsEdgeProperties;
        BigdataGraphClient.FEATURES.supportsThreadedTransactions = BigdataGraph.FEATURES.supportsThreadedTransactions;
        BigdataGraphClient.FEATURES.supportsTransactions = false;
    }
}

