/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.blueprints;

import com.bigdata.blueprints.BigdataGraph;
import com.bigdata.blueprints.BigdataGraphAtom;
import com.bigdata.blueprints.BigdataGraphEdit;
import com.bigdata.blueprints.BigdataGraphListener;
import com.bigdata.blueprints.BigdataRDFFactory;
import com.bigdata.blueprints.BlueprintsValueFactory;
import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.fed.QueryEngineFactory;
import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.changesets.ChangeAction;
import com.bigdata.rdf.changesets.ChangeRecord;
import com.bigdata.rdf.changesets.IChangeLog;
import com.bigdata.rdf.changesets.IChangeRecord;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.QueryCancellationHelper;
import com.bigdata.rdf.sail.model.RunningQuery;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.BigdataStatementIterator;
import com.bigdata.striterator.ChunkedArrayIterator;
import com.tinkerpop.blueprints.Features;
import com.tinkerpop.blueprints.TransactionalGraph;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.openrdf.model.BNode;

public class BigdataGraphEmbedded
extends BigdataGraph
implements TransactionalGraph,
IChangeLog {
    private static final transient Logger log = Logger.getLogger(BigdataGraphEmbedded.class);
    protected final BigdataSailRepository repo;
    protected final boolean autocommitOnShutdown;
    final List<BigdataGraphListener> listeners = Collections.synchronizedList(new LinkedList());
    private final ReentrantLock lock = new ReentrantLock();
    private transient BigdataSailRepositoryConnection cxn = null;
    private transient String heldBy = null;
    protected static final Features FEATURES = new Features();
    private final List<IChangeRecord> removes = new LinkedList<IChangeRecord>();
    private static final ConcurrentHashMap<String, RunningQuery> m_queries;
    private static final ConcurrentHashMap<UUID, RunningQuery> m_queries2;

    public BigdataGraphEmbedded(BigdataSail sail) {
        this(sail, BigdataRDFFactory.INSTANCE);
    }

    public BigdataGraphEmbedded(BigdataSail sail, BlueprintsValueFactory factory) {
        this(new BigdataSailRepository(sail), factory, new Properties());
    }

    public BigdataGraphEmbedded(BigdataSail sail, BlueprintsValueFactory factory, Properties props) {
        this(new BigdataSailRepository(sail), factory, props);
    }

    public BigdataGraphEmbedded(BigdataSailRepository repo) {
        this(repo, (BlueprintsValueFactory)BigdataRDFFactory.INSTANCE, new Properties());
    }

    public BigdataGraphEmbedded(BigdataSailRepository repo, BlueprintsValueFactory factory, Properties props) {
        super(factory, props);
        this.repo = repo;
        this.autocommitOnShutdown = Boolean.valueOf(props.getProperty(Options.AUTO_COMMIT_ON_SHUTDOWN, Boolean.toString(false)));
    }

    public BigdataSailRepository getRepository() {
        return this.repo;
    }

    @Override
    public BigdataSailRepositoryConnection cxn() throws Exception {
        if (!this.lock.isHeldByCurrentThread()) {
            this.lock.lock();
        }
        if (this.cxn == null) {
            this.cxn = this.repo.getUnisolatedConnection();
            this.cxn.addChangeLog(this);
        }
        return this.cxn;
    }

    public BigdataReadOnlyGraph getReadOnlyView() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("get read-only view: " + Thread.currentThread().getName());
        }
        return new BigdataReadOnlyGraph(this.repo.getReadOnlyConnection(), this.factory, this.maxQueryTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        block13: {
            if (!this.lock.isHeldByCurrentThread()) {
                this.lock.lock();
            }
            try {
                try {
                    if (this.cxn == null) break block13;
                    try {
                        this.cxn.commit();
                    }
                    finally {
                        this.cxn.close();
                    }
                }
                finally {
                    this.cxn = null;
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        block13: {
            if (!this.lock.isHeldByCurrentThread()) {
                this.lock.lock();
            }
            try {
                try {
                    if (this.cxn == null) break block13;
                    try {
                        this.cxn.rollback();
                    }
                    finally {
                        this.cxn.close();
                    }
                }
                finally {
                    this.cxn = null;
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        try {
            try {
                if (this.autocommitOnShutdown) {
                    this.commit();
                }
            }
            finally {
                this.repo.shutDown();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Deprecated
    public void stopTransaction(TransactionalGraph.Conclusion arg0) {
    }

    public StringBuilder dumpStore() throws Exception {
        BigdataSailRepositoryConnection cxn = this.cxn();
        cxn.flush();
        return cxn.getTripleStore().dumpStore();
    }

    @Override
    public Features getFeatures() {
        return FEATURES;
    }

    public void addListener(BigdataGraphListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(BigdataGraphListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeEvent(IChangeRecord record) {
        if (record.getStatement().getSubject() instanceof BNode) {
            return;
        }
        if (record.getChangeAction() == ChangeAction.REMOVED) {
            List<IChangeRecord> list = this.removes;
            synchronized (list) {
                this.removes.add(record);
            }
        } else {
            this.notify(record);
        }
    }

    protected void notify(IChangeRecord record) {
        BigdataGraphEdit edit = this.toGraphEdit(record);
        if (edit != null) {
            for (BigdataGraphListener listener : this.listeners) {
                listener.graphEdited(edit, record.toString());
            }
        }
    }

    protected BigdataGraphEdit toGraphEdit(IChangeRecord record) {
        BigdataGraphEdit.Action action;
        if (record.getChangeAction() == ChangeAction.INSERTED) {
            action = BigdataGraphEdit.Action.Add;
        } else if (record.getChangeAction() == ChangeAction.REMOVED) {
            action = BigdataGraphEdit.Action.Remove;
        } else {
            return null;
        }
        BigdataGraphAtom atom = super.toGraphAtom(record.getStatement());
        return new BigdataGraphEdit(action, atom);
    }

    protected List<IChangeRecord> materialize(List<IChangeRecord> records) {
        try {
            LinkedList<IChangeRecord> materialized = new LinkedList<IChangeRecord>();
            AbstractTripleStore db = this.cxn().getTripleStore();
            ISPO[] spos = new ISPO[records.size()];
            int i = 0;
            for (IChangeRecord rec : records) {
                spos[i++] = rec.getStatement();
            }
            BigdataStatementIterator it = db.asStatementIterator(new ChunkedArrayIterator<ISPO>(i, spos, null));
            for (IChangeRecord rec : records) {
                BigdataStatement stmt = (BigdataStatement)it.next();
                materialized.add(new ChangeRecord(stmt, rec.getChangeAction()));
            }
            return materialized;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void transactionBegin() {
        for (BigdataGraphListener listener : this.listeners) {
            listener.transactionBegin();
        }
    }

    @Override
    public void transactionPrepare() {
        this.notifyRemoves();
        for (BigdataGraphListener listener : this.listeners) {
            listener.transactionPrepare();
        }
    }

    @Override
    public void transactionCommited(long commitTime) {
        for (BigdataGraphListener listener : this.listeners) {
            listener.transactionCommited(commitTime);
        }
    }

    @Override
    public void transactionAborted() {
        for (BigdataGraphListener listener : this.listeners) {
            listener.transactionAborted();
        }
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyRemoves() {
        if (this.listeners.size() > 0) {
            List<IChangeRecord> removes;
            List<IChangeRecord> list = this.removes;
            synchronized (list) {
                removes = this.materialize(this.removes);
                this.removes.clear();
            }
            for (IChangeRecord remove : removes) {
                this.notify(remove);
            }
        } else {
            List<IChangeRecord> list = this.removes;
            synchronized (list) {
                this.removes.clear();
            }
        }
    }

    protected QueryEngine getQueryEngine() {
        QueryEngine queryEngine = QueryEngineFactory.getInstance().getQueryController(this.getIndexManager());
        return queryEngine;
    }

    private IIndexManager getIndexManager() {
        BigdataSailRepository repo = this.getRepository();
        IIndexManager indexMgr = repo.getSail().getIndexManager();
        return indexMgr;
    }

    @Override
    protected UUID setupQuery(BigdataSailRepositoryConnection cxn, ASTContainer astContainer, QueryType queryType, String extId) {
        String extQueryId;
        long begin = System.nanoTime();
        UUID queryUuid = this.setQueryId(astContainer, UUID.randomUUID());
        String string = extQueryId = extId == null ? queryUuid.toString() : extId;
        if (log.isDebugEnabled() && extId == null) {
            log.debug("Received null external query ID.  Using " + queryUuid.toString());
        }
        boolean isUpdateQuery = queryType != QueryType.ASK && queryType != QueryType.CONSTRUCT && queryType != QueryType.DESCRIBE && queryType != QueryType.SELECT;
        RunningQuery r = new RunningQuery(extQueryId, queryUuid, begin, isUpdateQuery);
        m_queries.put(extQueryId, r);
        m_queries2.put(queryUuid, r);
        if (log.isDebugEnabled()) {
            log.debug("Setup Query (External ID, UUID):  ( " + extQueryId + " , " + queryUuid + " )");
            log.debug("External query for " + queryUuid + " is :\n" + this.getQueryById(queryUuid).getExtQueryId());
            log.debug(this.runningQueriesToString());
        }
        return queryUuid;
    }

    protected UUID setQueryId(ASTContainer astContainer, UUID queryUuid) {
        String queryIdStr = astContainer.getQueryHint("queryId");
        if (queryIdStr == null) {
            queryUuid = UUID.randomUUID();
        }
        astContainer.setQueryHint("queryId", queryUuid.toString());
        return queryUuid;
    }

    @Override
    public RunningQuery getQueryById(UUID queryUuid) {
        return m_queries2.get(queryUuid);
    }

    @Override
    public RunningQuery getQueryByExternalId(String extQueryId) {
        return m_queries.get(extQueryId);
    }

    @Override
    protected void tearDownQuery(UUID queryId) {
        if (queryId != null) {
            RunningQuery r;
            if (log.isDebugEnabled()) {
                log.debug("Tearing down query: " + queryId);
                log.debug("m_queries2 has " + m_queries2.size());
            }
            if ((r = m_queries2.get(queryId)) != null) {
                m_queries.remove(r.getExtQueryId(), r);
                m_queries2.remove(queryId);
                if (log.isDebugEnabled()) {
                    log.debug("Tearing down query: " + queryId);
                    log.debug("m_queries2 has " + m_queries2.size());
                }
            }
        }
    }

    @Override
    protected boolean isQueryCancelled(UUID queryId) {
        if (log.isDebugEnabled()) {
            log.debug(queryId);
        }
        RunningQuery q = this.getQueryById(queryId);
        if (log.isDebugEnabled() && q != null) {
            log.debug(queryId + " isCancelled: " + q.isCancelled());
        }
        if (q != null) {
            return q.isCancelled();
        }
        return false;
    }

    public String runningQueriesToString() {
        Collection<RunningQuery> queries = m_queries2.values();
        Iterator<RunningQuery> iter2 = queries.iterator();
        StringBuffer sb = new StringBuffer();
        while (iter2.hasNext()) {
            RunningQuery r = iter2.next();
            sb.append(r.getQueryUuid() + " : \n" + r.getExtQueryId());
        }
        return sb.toString();
    }

    @Override
    public Collection<RunningQuery> getRunningQueries() {
        Collection<RunningQuery> queries = m_queries2.values();
        return queries;
    }

    @Override
    public void cancel(UUID queryId) {
        assert (queryId != null);
        QueryCancellationHelper.cancelQuery(queryId, this.getQueryEngine());
        RunningQuery q = this.getQueryById(queryId);
        if (q != null) {
            q.setCancelled(true);
        }
    }

    @Override
    public void cancel(String uuid) {
        this.cancel(UUID.fromString(uuid));
    }

    @Override
    public void cancel(RunningQuery rQuery) {
        if (rQuery != null) {
            UUID queryId = rQuery.getQueryUuid();
            this.cancel(queryId);
        }
    }

    private static Properties properties(int maxQueryTime) {
        Properties props = new Properties();
        props.setProperty(BigdataGraph.Options.MAX_QUERY_TIME, Integer.toString(maxQueryTime));
        return props;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    static {
        BigdataGraphEmbedded.FEATURES.supportsSerializableObjectProperty = BigdataGraph.FEATURES.supportsSerializableObjectProperty;
        BigdataGraphEmbedded.FEATURES.supportsBooleanProperty = BigdataGraph.FEATURES.supportsBooleanProperty;
        BigdataGraphEmbedded.FEATURES.supportsDoubleProperty = BigdataGraph.FEATURES.supportsDoubleProperty;
        BigdataGraphEmbedded.FEATURES.supportsFloatProperty = BigdataGraph.FEATURES.supportsFloatProperty;
        BigdataGraphEmbedded.FEATURES.supportsIntegerProperty = BigdataGraph.FEATURES.supportsIntegerProperty;
        BigdataGraphEmbedded.FEATURES.supportsPrimitiveArrayProperty = BigdataGraph.FEATURES.supportsPrimitiveArrayProperty;
        BigdataGraphEmbedded.FEATURES.supportsUniformListProperty = BigdataGraph.FEATURES.supportsUniformListProperty;
        BigdataGraphEmbedded.FEATURES.supportsMixedListProperty = BigdataGraph.FEATURES.supportsMixedListProperty;
        BigdataGraphEmbedded.FEATURES.supportsLongProperty = BigdataGraph.FEATURES.supportsLongProperty;
        BigdataGraphEmbedded.FEATURES.supportsMapProperty = BigdataGraph.FEATURES.supportsMapProperty;
        BigdataGraphEmbedded.FEATURES.supportsStringProperty = BigdataGraph.FEATURES.supportsStringProperty;
        BigdataGraphEmbedded.FEATURES.supportsDuplicateEdges = BigdataGraph.FEATURES.supportsDuplicateEdges;
        BigdataGraphEmbedded.FEATURES.supportsSelfLoops = BigdataGraph.FEATURES.supportsSelfLoops;
        BigdataGraphEmbedded.FEATURES.isPersistent = BigdataGraph.FEATURES.isPersistent;
        BigdataGraphEmbedded.FEATURES.isWrapper = BigdataGraph.FEATURES.isWrapper;
        BigdataGraphEmbedded.FEATURES.supportsVertexIteration = BigdataGraph.FEATURES.supportsVertexIteration;
        BigdataGraphEmbedded.FEATURES.supportsEdgeIteration = BigdataGraph.FEATURES.supportsEdgeIteration;
        BigdataGraphEmbedded.FEATURES.supportsVertexIndex = BigdataGraph.FEATURES.supportsVertexIndex;
        BigdataGraphEmbedded.FEATURES.supportsEdgeIndex = BigdataGraph.FEATURES.supportsEdgeIndex;
        BigdataGraphEmbedded.FEATURES.ignoresSuppliedIds = BigdataGraph.FEATURES.ignoresSuppliedIds;
        BigdataGraphEmbedded.FEATURES.supportsIndices = BigdataGraph.FEATURES.supportsIndices;
        BigdataGraphEmbedded.FEATURES.supportsKeyIndices = BigdataGraph.FEATURES.supportsKeyIndices;
        BigdataGraphEmbedded.FEATURES.supportsVertexKeyIndex = BigdataGraph.FEATURES.supportsVertexKeyIndex;
        BigdataGraphEmbedded.FEATURES.supportsEdgeKeyIndex = BigdataGraph.FEATURES.supportsEdgeKeyIndex;
        BigdataGraphEmbedded.FEATURES.supportsEdgeRetrieval = BigdataGraph.FEATURES.supportsEdgeRetrieval;
        BigdataGraphEmbedded.FEATURES.supportsVertexProperties = BigdataGraph.FEATURES.supportsVertexProperties;
        BigdataGraphEmbedded.FEATURES.supportsEdgeProperties = BigdataGraph.FEATURES.supportsEdgeProperties;
        BigdataGraphEmbedded.FEATURES.supportsThreadedTransactions = BigdataGraph.FEATURES.supportsThreadedTransactions;
        BigdataGraphEmbedded.FEATURES.supportsTransactions = true;
        m_queries = new ConcurrentHashMap();
        m_queries2 = new ConcurrentHashMap();
    }

    public class BigdataReadOnlyGraph
    extends BigdataGraph {
        private final BigdataSailRepositoryConnection cxn;

        private BigdataReadOnlyGraph(BigdataSailRepositoryConnection cxn, BlueprintsValueFactory factory, int maxQueryTime) {
            super(factory, BigdataGraphEmbedded.properties(maxQueryTime));
            this.cxn = cxn;
        }

        @Override
        public void shutdown() {
            try {
                this.cxn.close();
            }
            catch (Exception ex) {
                log.warn("Error closing connection: " + ex);
            }
        }

        @Override
        public BigdataSailRepositoryConnection cxn() throws Exception {
            return this.cxn;
        }

        @Override
        public Collection<RunningQuery> getRunningQueries() {
            return BigdataGraphEmbedded.this.getRunningQueries();
        }

        @Override
        public void cancel(UUID queryId) {
            BigdataGraphEmbedded.this.cancel(queryId);
        }

        @Override
        public void cancel(String uuid) {
            BigdataGraphEmbedded.this.cancel(uuid);
        }

        @Override
        public void cancel(RunningQuery r) {
            BigdataGraphEmbedded.this.cancel(r);
        }

        @Override
        public RunningQuery getQueryById(UUID queryId2) {
            return BigdataGraphEmbedded.this.getQueryById(queryId2);
        }

        @Override
        public RunningQuery getQueryByExternalId(String extQueryId) {
            return BigdataGraphEmbedded.this.getQueryByExternalId(extQueryId);
        }

        @Override
        protected UUID setupQuery(BigdataSailRepositoryConnection cxn, ASTContainer astContainer, QueryType queryType, String extQueryId) {
            return BigdataGraphEmbedded.this.setupQuery(cxn, astContainer, queryType, extQueryId);
        }

        @Override
        protected void tearDownQuery(UUID queryId) {
            BigdataGraphEmbedded.this.tearDownQuery(queryId);
        }

        @Override
        protected boolean isQueryCancelled(UUID queryId) {
            return BigdataGraphEmbedded.this.isQueryCancelled(queryId);
        }

        public StringBuilder dumpStore() throws Exception {
            return this.cxn.getTripleStore().dumpStore();
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }
    }

    public static interface Options {
        public static final String AUTO_COMMIT_ON_SHUTDOWN = BigdataGraphEmbedded.class.getName() + ".autoCommitOnShutdown";
        public static final boolean DEFAULT_AUTO_COMMIT_ON_SHUTDOWN = false;
    }
}

