/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.blueprints;

import com.bigdata.blueprints.BigdataGraph;
import com.bigdata.blueprints.BigdataGraphClient;
import com.bigdata.blueprints.BigdataGraphEmbedded;
import com.bigdata.blueprints.BigdataRDFFactory;
import com.bigdata.blueprints.BlueprintsValueFactory;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.remote.BigdataSailFactory;
import java.util.Properties;

public class BigdataGraphFactory {
    public static BigdataGraph connect(String host, int port) {
        return BigdataGraphFactory.connect("http://" + host + ":" + port + "/bigdata" + "/sparql");
    }

    public static BigdataGraph connect(String sparqlEndpointURL) {
        return new BigdataGraphClient(BigdataSailFactory.connect(sparqlEndpointURL));
    }

    public static BigdataGraph open(String file, boolean create) throws Exception {
        BigdataSail sail = (BigdataSail)BigdataSailFactory.openSail(file, create);
        sail.initialize();
        return new BigdataGraphEmbedded(sail);
    }

    public static BigdataGraph create(String file) throws Exception {
        BigdataSail sail = (BigdataSail)BigdataSailFactory.openSail(file, true);
        sail.initialize();
        return new BigdataGraphEmbedded(sail);
    }

    public static BigdataGraph create() throws Exception {
        return BigdataGraphFactory.create(BigdataRDFFactory.INSTANCE);
    }

    public static BigdataGraph create(BlueprintsValueFactory vf) throws Exception {
        return BigdataGraphFactory.create(vf, new Properties());
    }

    public static BigdataGraph create(BlueprintsValueFactory vf, Properties props) throws Exception {
        BigdataSail sail = (BigdataSail)BigdataSailFactory.createSail(new BigdataSailFactory.Option[0]);
        sail.initialize();
        return new BigdataGraphEmbedded(sail, vf, props);
    }
}

