/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.blueprints;

import com.bigdata.blueprints.BigdataElement;
import com.bigdata.blueprints.BigdataGraph;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.VertexQuery;
import com.tinkerpop.blueprints.util.DefaultVertexQuery;
import java.util.Arrays;
import java.util.Set;
import org.apache.log4j.Logger;
import org.openrdf.model.URI;

public class BigdataVertex
extends BigdataElement
implements Vertex {
    private static final transient Logger log = Logger.getLogger(BigdataVertex.class);

    public BigdataVertex(URI uri, BigdataGraph graph) {
        super(uri, graph);
    }

    @Override
    public Object getId() {
        if (log.isInfoEnabled()) {
            log.info("");
        }
        return this.graph.factory.fromURI(this.uri);
    }

    @Override
    public void remove() {
        if (log.isInfoEnabled()) {
            log.info("");
        }
        this.graph.removeVertex(this);
    }

    @Override
    public Edge addEdge(String label, Vertex to) {
        if (log.isInfoEnabled()) {
            log.info("(" + label + ", " + to + ")");
        }
        return this.graph.addEdge(null, (Vertex)this, to, label);
    }

    @Override
    public Iterable<Edge> getEdges(Direction dir, String ... labels) {
        if (log.isInfoEnabled()) {
            log.info("(" + (Object)((Object)dir) + (labels != null ? ", " + Arrays.toString(labels) : "") + ")");
        }
        URI wild = null;
        try {
            if (dir == Direction.OUT) {
                return this.graph.getEdges(this.uri, wild, labels);
            }
            if (dir == Direction.IN) {
                return this.graph.getEdges(wild, this.uri, labels);
            }
            return this.graph.fuse(this.graph.getEdges(this.uri, wild, labels), this.graph.getEdges(wild, this.uri, labels));
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Iterable<Vertex> getVertices(Direction dir, String ... labels) {
        if (log.isInfoEnabled()) {
            log.info("(" + (Object)((Object)dir) + (labels != null ? ", " + Arrays.toString(labels) : "") + ")");
        }
        URI wild = null;
        try {
            if (dir == Direction.OUT) {
                return this.graph.getVertices(this.uri, wild, labels);
            }
            if (dir == Direction.IN) {
                return this.graph.getVertices(wild, this.uri, labels);
            }
            return this.graph.fuse(this.graph.getVertices(this.uri, wild, labels), this.graph.getVertices(wild, this.uri, labels));
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public VertexQuery query() {
        if (log.isInfoEnabled()) {
            log.info("");
        }
        return new DefaultVertexQuery(this);
    }

    @Override
    public String toString() {
        return "v[" + this.uri.getLocalName() + "]";
    }

    @Override
    public <T> T getProperty(String prop) {
        if (log.isInfoEnabled()) {
            log.info("(" + prop + ")");
        }
        return super.getProperty(prop);
    }

    @Override
    public Set<String> getPropertyKeys() {
        if (log.isInfoEnabled()) {
            log.info("");
        }
        return super.getPropertyKeys();
    }

    @Override
    public <T> T removeProperty(String prop) {
        if (log.isInfoEnabled()) {
            log.info("(" + prop + ")");
        }
        return super.removeProperty(prop);
    }

    @Override
    public void setProperty(String prop, Object val) {
        if (log.isInfoEnabled()) {
            log.info("(" + prop + ", " + val + ")");
        }
        super.setProperty(prop, val);
    }
}

