/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.blueprints;

import com.bigdata.blueprints.BlueprintsValueFactory;
import com.bigdata.rdf.internal.XSD;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.RDFS;

public class DefaultBlueprintsValueFactory
implements BlueprintsValueFactory {
    public final String GRAPH_NAMESPACE;
    public final String VERTEX_NAMESPACE;
    public final String EDGE_NAMESPACE;
    public final URI TYPE;
    public final URI VERTEX;
    public final URI EDGE;
    public final URI LABEL;
    protected final ValueFactory vf;

    public DefaultBlueprintsValueFactory(String graphNamespace, String vertexNamespace, String edgeNamespace, URI type, URI vertex, URI edge, URI label) {
        this(new ValueFactoryImpl(), graphNamespace, vertexNamespace, edgeNamespace, type, vertex, edge, label);
    }

    public DefaultBlueprintsValueFactory(ValueFactory vf, String graphNamespace, String vertexNamespace, String edgeNamespace, URI type, URI vertex, URI edge, URI label) {
        this.vf = vf;
        this.GRAPH_NAMESPACE = graphNamespace;
        this.VERTEX_NAMESPACE = vertexNamespace;
        this.EDGE_NAMESPACE = edgeNamespace;
        this.TYPE = type;
        this.VERTEX = vertex;
        this.EDGE = edge;
        this.LABEL = label;
    }

    @Override
    public URI getTypeURI() {
        return this.TYPE;
    }

    @Override
    public URI getVertexURI() {
        return this.VERTEX;
    }

    @Override
    public URI getEdgeURI() {
        return this.EDGE;
    }

    @Override
    public URI getLabelURI() {
        return this.LABEL;
    }

    @Override
    public URI toVertexURI(Object key) {
        try {
            String id = key.toString();
            return this.vf.createURI(this.VERTEX_NAMESPACE, URLEncoder.encode(id, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public URI toEdgeURI(Object key) {
        try {
            String id = key.toString();
            return this.vf.createURI(this.EDGE_NAMESPACE, URLEncoder.encode(id, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public URI toURI(Element e) {
        if (e instanceof Edge) {
            return this.toEdgeURI(e.getId());
        }
        return this.toVertexURI(e.getId());
    }

    @Override
    public URI toPropertyURI(String property) {
        try {
            if (property.equals("label")) {
                return RDFS.LABEL;
            }
            return this.vf.createURI(this.GRAPH_NAMESPACE, URLEncoder.encode(property, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String fromURI(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        try {
            return URLDecoder.decode(uri.getLocalName(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Literal toLiteral(Object value) {
        if (value instanceof Float) {
            return this.vf.createLiteral(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return this.vf.createLiteral((Double)value);
        }
        if (value instanceof Integer) {
            return this.vf.createLiteral((Integer)value);
        }
        if (value instanceof Long) {
            return this.vf.createLiteral((Long)value);
        }
        if (value instanceof Boolean) {
            return this.vf.createLiteral((Boolean)value);
        }
        if (value instanceof Short) {
            return this.vf.createLiteral((Short)value);
        }
        if (value instanceof Byte) {
            return this.vf.createLiteral((Byte)value);
        }
        if (value instanceof String) {
            return this.vf.createLiteral((String)value);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Object fromLiteral(Literal l) {
        URI datatype = l.getDatatype();
        if (datatype == null) {
            return l.getLabel();
        }
        if (datatype.equals(XSD.FLOAT)) {
            return Float.valueOf(l.floatValue());
        }
        if (datatype.equals(XSD.DOUBLE)) {
            return l.doubleValue();
        }
        if (datatype.equals(XSD.INT)) {
            return l.intValue();
        }
        if (datatype.equals(XSD.LONG)) {
            return l.longValue();
        }
        if (datatype.equals(XSD.BOOLEAN)) {
            return l.booleanValue();
        }
        if (datatype.equals(XSD.SHORT)) {
            return l.shortValue();
        }
        if (datatype.equals(XSD.BYTE)) {
            return l.byteValue();
        }
        return l.getLabel();
    }
}

