/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.blueprints.webapp;

import com.bigdata.blueprints.BigdataGraphBulkLoad;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.webapp.AbstractRestApiTask;
import com.bigdata.rdf.sail.webapp.BigdataRDFServlet;
import com.bigdata.rdf.sail.webapp.BlueprintsServletProxy;
import com.bigdata.rdf.sail.webapp.client.MiniMime;
import com.bigdata.util.NV;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.util.io.graphml.GraphMLReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class BlueprintsServlet
extends BlueprintsServletProxy {
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(BlueprintsServlet.class);
    public static final List<String> mimeTypes = Arrays.asList("application/graphml+xml");

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String mimeType;
        String contentType = req.getContentType();
        if (log.isInfoEnabled()) {
            log.info("Request body: " + contentType);
        }
        if (!mimeTypes.contains(mimeType = new MiniMime(contentType).getMimeType().toLowerCase())) {
            BlueprintsServlet.buildAndCommitResponse(resp, 400, "text/plain", "Content-Type not recognized as graph data: " + contentType, new NV[0]);
            return;
        }
        try {
            this.submitApiTask(new BlueprintsPostTask(req, resp, this.getNamespace(req), 0L)).get();
        }
        catch (Throwable t) {
            BigdataRDFServlet.launderThrowable(t, resp, "");
        }
    }

    @Override
    public void doPostRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doPost(req, resp);
    }

    private static class BlueprintsPostTask
    extends AbstractRestApiTask<Void> {
        public BlueprintsPostTask(HttpServletRequest req, HttpServletResponse resp, String namespace, long timestamp) {
            super(req, resp, namespace, timestamp);
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            long begin = System.currentTimeMillis();
            BigdataSailRepositoryConnection conn = null;
            boolean success = false;
            try {
                conn = this.getConnection();
                BigdataGraphBulkLoad graph = new BigdataGraphBulkLoad(conn);
                GraphMLReader.inputGraph((Graph)graph, this.req.getInputStream());
                graph.commit();
                success = true;
                long nmodified = graph.getMutationCountLastCommit();
                long elapsed = System.currentTimeMillis() - begin;
                this.reportModifiedCount(nmodified, elapsed);
                Void void_ = null;
                return void_;
            }
            finally {
                if (conn != null) {
                    if (!success) {
                        conn.rollback();
                    }
                    conn.close();
                }
            }
        }
    }
}

