/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpBase;
import com.bigdata.bop.BadBOpIdTypeException;
import com.bigdata.bop.CoreBaseBOp;
import com.bigdata.bop.DuplicateBOpIdException;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.NoBOpIdException;
import com.bigdata.bop.NotPipelineOpException;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.bop.solutions.GroupByOp;
import com.bigdata.bop.solutions.GroupByRewriter;
import com.bigdata.bop.solutions.IGroupByRewriteState;
import com.bigdata.rdf.sparql.ast.GroupNodeBase;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import com.bigdata.striterator.CloseableIteratorWrapper;
import cutthecrap.utils.striterators.EmptyIterator;
import cutthecrap.utils.striterators.Expander;
import cutthecrap.utils.striterators.Filter;
import cutthecrap.utils.striterators.ICloseable;
import cutthecrap.utils.striterators.ICloseableIterator;
import cutthecrap.utils.striterators.SingleValueIterator;
import cutthecrap.utils.striterators.Striterator;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.log4j.Logger;

public class BOpUtility {
    private static final transient Logger log = Logger.getLogger(BOpUtility.class);
    public static final IBindingSet[] EMPTY_CHUNK = new IBindingSet[0];

    public static Iterator<BOp> preOrderIterator(BOp op) {
        return new Striterator(new SingleValueIterator<BOp>(op)).append(BOpUtility.preOrderIterator2(0, op));
    }

    private static Iterator<BOp> preOrderIterator2(final int depth, BOp op) {
        if (op == null || op.arity() == 0) {
            return EmptyIterator.DEFAULT;
        }
        return new Striterator(op.argIterator()).addFilter(new Expander(){
            private static final long serialVersionUID = 1L;

            @Override
            protected Iterator expand(Object childObj) {
                BOp child = (BOp)childObj;
                if (child != null && child.arity() > 0) {
                    Striterator itr = new Striterator(new SingleValueIterator<BOp>(child));
                    itr.append(BOpUtility.preOrderIterator2(depth + 1, child));
                    return itr;
                }
                return new SingleValueIterator<BOp>(child);
            }
        });
    }

    public static Iterator<BOp> postOrderIterator(BOp op) {
        return new Striterator(BOpUtility.postOrderIterator2(op)).append(new SingleValueIterator<BOp>(op));
    }

    private static Iterator<BOp> postOrderIterator2(BOp op) {
        if (op == null || op.arity() == 0) {
            return EmptyIterator.DEFAULT;
        }
        return new Striterator(op.argIterator()).addFilter(new Expander(){
            private static final long serialVersionUID = 1L;

            @Override
            protected Iterator expand(Object childObj) {
                BOp child = (BOp)childObj;
                if (child != null && child.arity() > 0) {
                    Striterator itr = new Striterator(BOpUtility.postOrderIterator2(child));
                    itr.append(new SingleValueIterator<BOp>(child));
                    return itr;
                }
                return new SingleValueIterator<BOp>(child);
            }
        });
    }

    public static Iterator<BOp> annotationOpIterator(BOp op) {
        return new Striterator(op.annotations().values().iterator()).addFilter(new Filter(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isValid(Object arg0) {
                return arg0 instanceof BOp;
            }
        });
    }

    public static Iterator<BOp> preOrderIteratorWithAnnotations(BOp op) {
        return new Striterator(BOpUtility.preOrderIterator(op)).addFilter(new Expander(){
            private static final long serialVersionUID = 1L;

            @Override
            protected Iterator expand(Object arg0) {
                BOp op = (BOp)arg0;
                Striterator itr = new Striterator(new SingleValueIterator<BOp>(op));
                Striterator itr2 = new Striterator(BOpUtility.annotationOpIterator(op));
                itr2.addFilter(new Expander(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected Iterator expand(Object ann) {
                        return BOpUtility.preOrderIteratorWithAnnotations((BOp)ann);
                    }
                });
                itr.append(itr2);
                return itr;
            }
        });
    }

    public static Iterator<BOp> postOrderIteratorWithAnnotations(BOp op) {
        Striterator itr = new Striterator(BOpUtility.annotationOpIterator(op));
        itr.append(op.argIterator());
        itr.addFilter(new Expander(){
            private static final long serialVersionUID = 1L;

            @Override
            protected Iterator<BOp> expand(Object ann) {
                return BOpUtility.postOrderIteratorWithAnnotations((BOp)ann);
            }
        });
        itr.append(new SingleValueIterator<BOp>(op));
        return itr;
    }

    public static Iterator<IVariable<?>> getSpannedVariables(BOp op) {
        return new Striterator(BOpUtility.preOrderIteratorWithAnnotations(op)).addFilter(new Filter(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isValid(Object arg0) {
                return arg0 instanceof IVariable;
            }
        }).makeUnique();
    }

    public static <T> List<T> toList(Iterator<T> it) {
        LinkedList<T> c = new LinkedList<T>();
        while (it.hasNext()) {
            T v = it.next();
            c.add(v);
        }
        return c;
    }

    public static IVariable[] toArray(Iterator<IVariable<?>> it) {
        return BOpUtility.toList(it).toArray(new IVariable[0]);
    }

    public static <C> List<C> toList(BOp op, Class<C> clas) {
        LinkedList<C> list = new LinkedList<C>();
        Iterator<C> it = BOpUtility.visitAll(op, clas);
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public static <C> C getOnly(BOp op, Class<C> class1) {
        Iterator<C> it = BOpUtility.visitAll(op, class1);
        if (!it.hasNext()) {
            throw new NoSuchElementException("No instance found: class=" + class1);
        }
        C ret = it.next();
        if (it.hasNext()) {
            throw new RuntimeException("More than one instance exists: class=" + class1);
        }
        return ret;
    }

    public static <C> Iterator<C> visitAll(BOp op, final Class<C> clas) {
        return new Striterator(BOpUtility.preOrderIteratorWithAnnotations(op)).addFilter(new Filter(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isValid(Object arg0) {
                return clas.isAssignableFrom(arg0.getClass());
            }
        });
    }

    public static Iterator<IVariable<?>> getArgumentVariables(BOp op) {
        return new Striterator(op.argIterator()).addFilter(new Filter(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isValid(Object arg0) {
                return arg0 instanceof IVariable;
            }
        });
    }

    public static int getArgumentVariableCount(BOp op) {
        int nvars = 0;
        Iterator<BOp> itr = op.argIterator();
        while (itr.hasNext()) {
            BOp arg = itr.next();
            if (!(arg instanceof IVariable)) continue;
            ++nvars;
        }
        return nvars;
    }

    public static Map<Integer, BOp> getIndex(BOp op) {
        if (op == null) {
            throw new IllegalArgumentException();
        }
        LinkedHashMap<Integer, BOp> map = new LinkedHashMap<Integer, BOp>();
        Iterator<BOp> itr = BOpUtility.preOrderIterator(op);
        while (itr.hasNext()) {
            BOp t = itr.next();
            if (!(t instanceof PipelineOp)) {
                throw new NotPipelineOpException(t.toString());
            }
            Object x = t.getProperty(BOp.Annotations.BOP_ID);
            if (x == null) {
                throw new NoBOpIdException(t.toString());
            }
            if (!(x instanceof Integer)) {
                throw new BadBOpIdTypeException("Must be Integer, not: " + x.getClass() + ": " + BOp.Annotations.BOP_ID);
            }
            Integer id = (Integer)t.getProperty(BOp.Annotations.BOP_ID);
            BOp conflict = map.put(id, t);
            if (conflict == null) continue;
            throw new DuplicateBOpIdException("duplicate id=" + id + " for " + conflict + " and " + t);
        }
        return Collections.unmodifiableMap(map);
    }

    public static BOp getParent(BOp root, BOp op) {
        if (root == null) {
            throw new IllegalArgumentException();
        }
        if (op == null) {
            throw new IllegalArgumentException();
        }
        int arity = root.arity();
        for (int i = 0; i < arity; ++i) {
            BOp current = root.get(i);
            if (current == op) {
                return root;
            }
            BOp found = BOpUtility.getParent(current, op);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public static BOp getPipelineStart(BOp op) {
        if (op == null) {
            throw new IllegalArgumentException();
        }
        while (op.arity() != 0) {
            BOp left = op.get(0);
            if (left == null) {
                return op;
            }
            op = left;
        }
        return op;
    }

    public static Integer getEffectiveDefaultSink(BOp bop, BOp p) {
        if (bop == null) {
            throw new IllegalArgumentException();
        }
        Integer sink = (Integer)bop.getProperty(PipelineOp.Annotations.SINK_REF);
        if (sink == null) {
            if (p == null) {
                return null;
            }
            sink = (Integer)p.getRequiredProperty(BOp.Annotations.BOP_ID);
        }
        return sink;
    }

    public static Integer[] getEvaluationOrder(BOp op) {
        LinkedList<Integer> order = new LinkedList<Integer>();
        BOpUtility.getEvaluationOrder(op, order, 0);
        return order.toArray(new Integer[order.size()]);
    }

    private static void getEvaluationOrder(BOp op, List<Integer> order, int depth) {
        if (!(op instanceof PipelineOp)) {
            return;
        }
        int bopId = op.getId();
        if (!(depth != 0 && op.getProperty(BOp.Annotations.CONTROLLER, false).booleanValue() || op.arity() <= 0)) {
            BOpUtility.getEvaluationOrder(op.get(0), order, depth + 1);
        }
        order.add(bopId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IBindingSet[] toArray(Iterator<IBindingSet[]> itr, BOpStats stats) {
        if (!itr.hasNext()) {
            return EMPTY_CHUNK;
        }
        IBindingSet[] firstChunk = itr.next();
        if (!itr.hasNext()) {
            if (stats != null) {
                stats.chunksIn.add(1L);
                stats.unitsIn.add(firstChunk.length);
            }
            return firstChunk;
        }
        LinkedList<IBindingSet[]> list = new LinkedList<IBindingSet[]>();
        list.add(firstChunk);
        int nchunks = 1;
        int nelements = firstChunk.length;
        try {
            while (itr.hasNext()) {
                IBindingSet[] a = itr.next();
                list.add(a);
                ++nchunks;
                nelements += a.length;
            }
            if (stats != null) {
                stats.chunksIn.add(nchunks);
                stats.unitsIn.add(nelements);
            }
        }
        finally {
            if (itr instanceof ICloseable) {
                ((ICloseable)((Object)itr)).close();
            }
        }
        if (nchunks == 0) {
            return new IBindingSet[0];
        }
        if (nchunks == 1) {
            return (IBindingSet[])list.get(0);
        }
        int n = 0;
        IBindingSet[] a = new IBindingSet[nelements];
        for (IBindingSet[] t : list) {
            try {
                System.arraycopy(t, 0, a, n, t.length);
            }
            catch (IndexOutOfBoundsException ex) {
                IndexOutOfBoundsException ex2 = new IndexOutOfBoundsException("t.length=" + t.length + ", a.length=" + a.length + ", n=" + n);
                ex2.initCause(ex);
                throw ex2;
            }
            n += t.length;
        }
        return a;
    }

    public static ICloseableIterator<IBindingSet[]> asIterator(IBindingSet[] bindingSets) {
        return new CloseableIteratorWrapper<IBindingSet[]>(new SingleValueIterator<IBindingSet[]>(bindingSets));
    }

    public static String toString(BOp bop) {
        StringBuilder sb = new StringBuilder();
        BOpUtility.toString(bop, sb, 0);
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public static String toString2(BOp bop) {
        String s = BOpUtility.toString(bop);
        s = s.replaceAll("com.bigdata.bop.controller.", "");
        s = s.replaceAll("com.bigdata.bop.join.", "");
        s = s.replaceAll("com.bigdata.bop.solutions.", "");
        s = s.replaceAll("com.bigdata.bop.rdf.filter.", "");
        s = s.replaceAll("com.bigdata.bop.bset", "");
        s = s.replaceAll("com.bigdata.bop.", "");
        s = s.replaceAll("com.bigdata.rdf.sail.", "");
        s = s.replaceAll("com.bigdata.rdf.spo.", "");
        s = s.replaceAll("com.bigdata.rdf.internal.constraints.", "");
        return s;
    }

    private static void toString(BOp bop, StringBuilder sb, int indent) {
        sb.append(BOpUtility.indent(indent)).append(bop == null ? "<null>" : bop.toString()).append('\n');
        if (bop == null) {
            return;
        }
        for (Map.Entry<String, Object> e : bop.annotations().entrySet()) {
            if (!(e.getValue() instanceof PipelineOp)) continue;
            sb.append(BOpUtility.indent(indent)).append("@").append(e.getKey()).append(":\n");
            BOpUtility.toString((BOp)e.getValue(), sb, indent + 1);
        }
        Iterator<BOp> itr = bop.argIterator();
        while (itr.hasNext()) {
            BOp arg = itr.next();
            if (arg instanceof IVariableOrConstant) continue;
            BOpUtility.toString(arg, sb, indent + 1);
        }
    }

    private static String indent(int height) {
        return CoreBaseBOp.indent(height);
    }

    public static boolean isConsistent(IConstraint[] constraints, IBindingSet bindingSet) {
        for (int i = 0; i < constraints.length; ++i) {
            IConstraint constraint = constraints[i];
            if (!constraint.accept(bindingSet)) {
                if (log.isDebugEnabled()) {
                    log.debug("Rejected by " + constraint.getClass().getSimpleName() + " : " + bindingSet);
                }
                return false;
            }
            if (!log.isTraceEnabled()) continue;
            log.debug("Accepted by " + constraint.getClass().getSimpleName() + " : " + bindingSet);
        }
        return true;
    }

    public static long copy(Iterator<IBindingSet[]> source, IBlockingBuffer<IBindingSet[]> sink, IBlockingBuffer<IBindingSet[]> sink2, IBindingSet mergeSolution, IVariable<?>[] selectVars, IConstraint[] constraints, BOpStats stats) {
        long nout = 0L;
        while (source.hasNext()) {
            IBindingSet[] chunk = source.next();
            if (stats != null) {
                stats.chunksIn.increment();
                stats.unitsIn.add(chunk.length);
            }
            IBindingSet[] tmp = BOpUtility.applyConstraints(chunk, mergeSolution, selectVars, constraints);
            sink.add(tmp);
            nout += (long)tmp.length;
            if (sink2 == null) continue;
            sink2.add(tmp);
        }
        return nout;
    }

    private static IBindingSet[] applyConstraints(IBindingSet[] chunk, IBindingSet mergeSolution, IVariable<?>[] selectVars, IConstraint[] constraints) {
        if (constraints == null && selectVars == null && mergeSolution == null) {
            return chunk;
        }
        IBindingSet[] t = new IBindingSet[chunk.length];
        int j = 0;
        for (int i = 0; i < chunk.length; ++i) {
            IBindingSet sourceSolution;
            IBindingSet bindingSet = sourceSolution = chunk[i];
            if (constraints != null && !BOpUtility.isConsistent(constraints, bindingSet)) continue;
            if (selectVars != null) {
                bindingSet = bindingSet.copy(selectVars);
            }
            if (mergeSolution != null) {
                Iterator<Map.Entry<IVariable, IConstant>> itr = mergeSolution.iterator();
                while (itr.hasNext()) {
                    Map.Entry<IVariable, IConstant> e = itr.next();
                    IVariable var = e.getKey();
                    IConstant val = e.getValue();
                    IConstant oval = bindingSet.get(var);
                    if (oval != null) {
                        if (!oval.equals(val)) {
                            throw new AssertionError((Object)("Inconsistent binding: var=" + var + ", oval=" + oval + ", nval=" + val));
                        }
                        continue;
                    }
                    bindingSet.set(var, val);
                }
            }
            t[j++] = bindingSet;
        }
        if (j != chunk.length) {
            IBindingSet[] tmp = new IBindingSet[j];
            System.arraycopy(t, 0, tmp, 0, j);
            t = tmp;
        }
        return t;
    }

    public static int[] getPredIds(IPredicate<?>[] path) {
        int[] b = new int[path.length];
        for (int i = 0; i < path.length; ++i) {
            b[i] = path[i].getId();
        }
        return b;
    }

    public static Set<IVariable<?>> getSharedVars(BOp p, BOp c) {
        if (p == null) {
            throw new IllegalArgumentException();
        }
        if (c == null) {
            throw new IllegalArgumentException();
        }
        LinkedHashSet p1vars = null;
        Iterator<IVariable<?>> itr = BOpUtility.getSpannedVariables(p);
        while (itr.hasNext()) {
            if (p1vars == null) {
                p1vars = new LinkedHashSet();
            }
            p1vars.add(itr.next());
        }
        if (p1vars == null) {
            return Collections.emptySet();
        }
        LinkedHashSet sharedVars = null;
        Iterator<IVariable<?>> itr2 = BOpUtility.getSpannedVariables(c);
        while (itr2.hasNext()) {
            IVariable<?> avar = itr2.next();
            if (!p1vars.contains(avar)) continue;
            if (sharedVars == null) {
                sharedVars = new LinkedHashSet();
            }
            sharedVars.add(avar);
        }
        if (sharedVars == null) {
            return Collections.emptySet();
        }
        return sharedVars;
    }

    public static PipelineOp makeAggregateDistinct(PipelineOp subQuery) {
        return (PipelineOp)BOpUtility.makeAggregateDistinct2(subQuery);
    }

    private static BOp makeAggregateDistinct2(BOp op) {
        boolean dirty = false;
        int arity = op.arity();
        BOp[] args = arity == 0 ? BOp.NOARGS : new BOp[arity];
        for (int i = 0; i < arity; ++i) {
            BOp child = op.get(i);
            args[i] = BOpUtility.makeAggregateDistinct2(child);
            if (args[i] == child) continue;
            dirty = true;
        }
        LinkedHashMap<String, Object> anns = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> e : op.annotations().entrySet()) {
            Object nval;
            String name = e.getKey();
            Object oval = e.getValue();
            if (name.equals(GroupByOp.Annotations.GROUP_BY_REWRITE)) {
                nval = new GroupByRewriter((IGroupByRewriteState)oval);
                dirty = true;
            } else {
                nval = oval;
            }
            anns.put(name, nval);
        }
        if (!dirty) {
            return op;
        }
        try {
            Constructor<?> ctor = op.getClass().getConstructor(BOp[].class, Map.class);
            return (BOp)ctor.newInstance(args, anns);
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    public static <T extends BOp> T deepCopy(T op) {
        if (op == null) {
            return op;
        }
        if (op instanceof IVariableOrConstant) {
            return op;
        }
        if (op instanceof BOpBase) {
            return op;
        }
        int arity = op.arity();
        BOp[] args = arity == 0 ? BOp.NOARGS : new BOp[arity];
        for (int i = 0; i < arity; ++i) {
            BOp child = op.get(i);
            args[i] = BOpUtility.deepCopy(child);
        }
        LinkedHashMap<String, Object> anns = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> e : op.annotations().entrySet()) {
            String name = e.getKey();
            Object oval = e.getValue();
            Object nval = oval instanceof BOp ? BOpUtility.deepCopy((BOp)oval) : oval;
            anns.put(name, nval);
        }
        try {
            Constructor<?> ctor = op.getClass().getConstructor(BOp[].class, Map.class);
            BOp copy = (BOp)ctor.newInstance(args, anns);
            if (copy instanceof GroupNodeBase) {
                for (int i = 0; i < arity; ++i) {
                    IGroupMemberNode child = (IGroupMemberNode)copy.get(i);
                    child.setParent((GroupNodeBase)copy);
                }
            }
            return (T)copy;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    public static IConstraint[] concat(IConstraint[] a, IConstraint[] b) {
        LinkedList<IConstraint> list = new LinkedList<IConstraint>();
        if (a != null) {
            for (IConstraint c : a) {
                list.add(c);
            }
        }
        if (b != null) {
            for (IConstraint c : b) {
                list.add(c);
            }
        }
        return list.isEmpty() ? null : list.toArray(new IConstraint[list.size()]);
    }

    public static int countVarOccurrencesOutsideProjections(BOp op, IVariable inputVar) {
        if (op == null || inputVar == null) {
            return 0;
        }
        int innerNodesTotal = 0;
        List<IVariable> vars = BOpUtility.toList(op, IVariable.class);
        for (IVariable var : vars) {
            if (!inputVar.equals(var)) continue;
            ++innerNodesTotal;
        }
        int innerNodesInProj = 0;
        List<ProjectionNode> projs = BOpUtility.toList(op, ProjectionNode.class);
        for (ProjectionNode proj : projs) {
            List<IVariable> innerVars = BOpUtility.toList(proj, IVariable.class);
            for (IVariable innerVar : innerVars) {
                if (!inputVar.equals(innerVar)) continue;
                ++innerNodesInProj;
            }
        }
        return innerNodesTotal - innerNodesInProj;
    }
}

