/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.ap;

import com.bigdata.bop.AbstractAccessPathOp;
import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContextBase;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.ap.Predicate;
import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.filter.Advancer;
import com.bigdata.relation.IRelation;
import com.bigdata.relation.accesspath.AccessPath;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IKeyOrder;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;

public class SampleIndex<E>
extends AbstractAccessPathOp<E> {
    private static final long serialVersionUID = 1L;

    public SampleIndex(SampleIndex<E> op) {
        super(op);
    }

    public SampleIndex(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
    }

    public int limit() {
        return this.getProperty(Annotations.LIMIT, 100);
    }

    public long seed() {
        return this.getProperty(Annotations.SEED, 0L);
    }

    public SampleType getSampleType() {
        return SampleType.valueOf(this.getProperty(Annotations.SAMPLE_TYPE, Annotations.DEFAULT_SAMPLE_TYPE));
    }

    public IPredicate<E> getPredicate() {
        return (IPredicate)this.getRequiredProperty(Annotations.PREDICATE);
    }

    public E[] eval(BOpContextBase context) {
        try {
            return new SampleTask(context).call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class AcceptanceSetOffsetSampler
    implements IOffsetSampler {
        @Override
        public long[] getOffsets(long seed, int limit, long fromIndex, long toIndex) {
            if (limit < 1) {
                throw new IllegalArgumentException();
            }
            if (fromIndex < 0L) {
                throw new IllegalArgumentException();
            }
            if (toIndex < 0L) {
                throw new IllegalArgumentException();
            }
            if (toIndex <= fromIndex) {
                throw new IllegalArgumentException();
            }
            long rangeCount2 = toIndex - fromIndex;
            if (rangeCount2 > Integer.MAX_VALUE) {
                throw new UnsupportedOperationException();
            }
            int rangeCount = (int)rangeCount2;
            if (limit > rangeCount) {
                limit = rangeCount;
            }
            long[] offsets = new long[limit];
            IntOpenHashSet v = new IntOpenHashSet(rangeCount);
            Random rnd = seed == 0L ? new Random() : new Random(seed);
            for (int i = 0; i < limit; ++i) {
                int k = rnd.nextInt(rangeCount);
                int round = 0;
                while (v.contains(k)) {
                    if (++k != rangeCount) continue;
                    if (++round > 1) {
                        throw new AssertionError();
                    }
                    k = 0;
                }
                assert (!v.contains(k));
                v.add(k);
                offsets[i] = fromIndex + (long)k;
                assert (offsets[i] < toIndex);
            }
            Arrays.sort(offsets);
            return offsets;
        }
    }

    public static class BitVectorOffsetSampler
    implements IOffsetSampler {
        @Override
        public long[] getOffsets(long seed, int limit, long fromIndex, long toIndex) {
            if (limit < 1) {
                throw new IllegalArgumentException();
            }
            if (fromIndex < 0L) {
                throw new IllegalArgumentException();
            }
            if (toIndex < 0L) {
                throw new IllegalArgumentException();
            }
            if (toIndex <= fromIndex) {
                throw new IllegalArgumentException();
            }
            long rangeCount2 = toIndex - fromIndex;
            if (rangeCount2 > Integer.MAX_VALUE) {
                throw new UnsupportedOperationException();
            }
            int rangeCount = (int)rangeCount2;
            if (limit > rangeCount) {
                limit = rangeCount;
            }
            long[] offsets = new long[limit];
            LongArrayBitVector v = LongArrayBitVector.ofLength(rangeCount);
            Random rnd = seed == 0L ? new Random() : new Random(seed);
            for (int i = 0; i < limit; ++i) {
                int k = rnd.nextInt(rangeCount);
                if (v.getBoolean((long)k)) {
                    long nextZero = v.nextZero(k);
                    if (nextZero != -1L) {
                        k = (int)nextZero;
                    } else {
                        long priorZero = v.previousZero(k);
                        if (priorZero != -1L) {
                            k = (int)priorZero;
                        } else {
                            throw new AssertionError();
                        }
                    }
                }
                assert (!v.getBoolean(k));
                v.add(k, true);
                assert (v.getBoolean(k));
                offsets[i] = fromIndex + (long)k;
                assert (offsets[i] < toIndex);
            }
            Arrays.sort(offsets);
            return offsets;
        }
    }

    public static class EntireRangeOffsetSampler
    implements IOffsetSampler {
        @Override
        public long[] getOffsets(long seed, int limit, long fromIndex, long toIndex) {
            if (limit < 1) {
                throw new IllegalArgumentException();
            }
            if (fromIndex < 0L) {
                throw new IllegalArgumentException();
            }
            if (toIndex < 0L) {
                throw new IllegalArgumentException();
            }
            if (toIndex <= fromIndex) {
                throw new IllegalArgumentException();
            }
            long rangeCount = toIndex - fromIndex;
            if ((long)limit > rangeCount) {
                limit = (int)rangeCount;
            }
            if ((long)limit != rangeCount) {
                throw new UnsupportedOperationException();
            }
            long[] offsets = new long[limit];
            for (int i = 0; i < limit; ++i) {
                offsets[i] = fromIndex + (long)i;
            }
            return offsets;
        }
    }

    public static class SmartOffsetSampler
    implements IOffsetSampler {
        @Override
        public long[] getOffsets(long seed, int limit, long fromIndex, long toIndex) {
            if (limit < 1) {
                throw new IllegalArgumentException();
            }
            if (fromIndex < 0L) {
                throw new IllegalArgumentException();
            }
            if (toIndex < 0L) {
                throw new IllegalArgumentException();
            }
            if (toIndex <= fromIndex) {
                throw new IllegalArgumentException();
            }
            long rangeCount = toIndex - fromIndex;
            if ((long)limit > rangeCount) {
                limit = (int)rangeCount;
            }
            if ((long)limit == rangeCount) {
                return new EntireRangeOffsetSampler().getOffsets(seed, limit, fromIndex, toIndex);
            }
            return new AcceptanceSetOffsetSampler().getOffsets(seed, limit, fromIndex, toIndex);
        }
    }

    public static interface IOffsetSampler {
        public long[] getOffsets(long var1, int var3, long var4, long var6);
    }

    public static class AccessPathSample<E>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final IPredicate<E> pred;
        private final IKeyOrder<E> keyOrder;
        private final int limit;
        private final E[] sample;

        private AccessPathSample(int limit, IAccessPath<E> accessPath) {
            if (limit <= 0) {
                throw new IllegalArgumentException();
            }
            if (accessPath == null) {
                throw new IllegalArgumentException();
            }
            this.pred = accessPath.getPredicate();
            this.keyOrder = accessPath.getKeyOrder();
            this.limit = limit;
            ArrayList tmp = new ArrayList(limit);
            IChunkedOrderedIterator<E> src = accessPath.iterator(0L, limit, limit);
            for (int nsamples = 0; src.hasNext() && nsamples < limit; ++nsamples) {
                tmp.add(src.next());
            }
            this.sample = tmp.toArray((Object[])Array.newInstance(tmp.get(0).getClass(), tmp.size()));
        }

        public IPredicate<E> getPredicate() {
            return this.pred;
        }

        public boolean isEmpty() {
            return this.sample != null;
        }

        public int sampleSize() {
            return this.sample == null ? 0 : this.sample.length;
        }

        public int limit() {
            return this.limit;
        }

        public E[] getSample() {
            return this.sample;
        }
    }

    private static class RandomSampleAdvancer<E>
    extends Advancer<E> {
        private static final long serialVersionUID = 1L;
        private final long seed;
        private final int limit;
        private final byte[] fromKey;
        private final byte[] toKey;
        private transient long[] offsets;
        private transient int nread = 0;
        private transient long fromIndex;
        private transient long toIndex;

        public RandomSampleAdvancer(long seed, int limit, byte[] fromKey, byte[] toKey) {
            this.seed = seed;
            this.limit = limit;
            this.fromKey = fromKey;
            this.toKey = toKey;
        }

        @Override
        protected boolean init() {
            AbstractBTree ndx = (AbstractBTree)this.src.getIndex();
            long l = this.fromIndex = this.fromKey == null ? 0L : ndx.indexOf(this.fromKey);
            if (this.fromIndex < 0L) {
                this.fromIndex = -this.fromIndex + 1L;
            }
            long l2 = this.toIndex = this.toKey == null ? ndx.getEntryCount() : ndx.indexOf(this.toKey);
            if (this.toIndex < 0L) {
                this.toIndex = -this.toIndex + 1L;
            }
            this.offsets = new SmartOffsetSampler().getOffsets(this.seed, this.limit, this.fromIndex, this.toIndex);
            this.src.seek(ndx.keyAt(this.offsets[0]));
            return true;
        }

        @Override
        protected void advance(ITuple<E> tuple) {
            AbstractBTree ndx = (AbstractBTree)this.src.getIndex();
            if (this.nread < this.offsets.length - 1) {
                long nextIndex = this.offsets[this.nread];
                this.src.seek(ndx.keyAt(nextIndex));
            }
            ++this.nread;
        }
    }

    private static class EvenSampleAdvancer<E>
    extends Advancer<E> {
        private static final long serialVersionUID = 1L;
        private final int limit;
        private final byte[] toKey;
        private transient long skipCount;
        private transient int nread = 0;
        private transient long fromIndex;
        private transient long toIndex;

        public EvenSampleAdvancer(int limit, byte[] fromKey, byte[] toKey) {
            this.limit = limit;
            this.toKey = toKey;
        }

        @Override
        protected void advance(ITuple<E> tuple) {
            AbstractBTree ndx = (AbstractBTree)this.src.getIndex();
            long currentIndex = ndx.indexOf(tuple.getKey());
            if (this.nread == 0) {
                this.fromIndex = currentIndex;
                long l = this.toIndex = this.toKey == null ? ndx.getEntryCount() : ndx.indexOf(this.toKey);
                if (this.toIndex < 0L) {
                    this.toIndex = -this.toIndex + 1L;
                }
                long rangeCount = this.toIndex - this.fromIndex;
                this.skipCount = Math.max(1L, rangeCount / (long)this.limit);
                --this.skipCount;
            }
            ++this.nread;
            if (this.skipCount > 0L) {
                long nextIndex = Math.min(ndx.getEntryCount() - 1L, currentIndex + this.skipCount);
                this.src.seek(ndx.keyAt(nextIndex));
            }
        }
    }

    private static class DenseSampleAdvancer<E>
    extends Advancer<E> {
        private static final long serialVersionUID = 1L;

        private DenseSampleAdvancer() {
        }

        @Override
        protected void advance(ITuple<E> tuple) {
        }
    }

    private class SampleTask
    implements Callable<E[]> {
        private final BOpContextBase context;

        SampleTask(BOpContextBase context) {
            this.context = context;
        }

        @Override
        public E[] call() throws Exception {
            return this.sample(SampleIndex.this.limit(), SampleIndex.this.getSampleType(), SampleIndex.this.getPredicate()).getSample();
        }

        public AccessPathSample<E> sample(int limit, SampleType sampleType, IPredicate<E> predicate) {
            Advancer advancer;
            IRelation relation = this.context.getRelation(predicate);
            AccessPath accessPath = (AccessPath)this.context.getAccessPath(relation, predicate);
            long rangeCount = accessPath.rangeCount(false);
            if ((long)limit >= rangeCount) {
                return new AccessPathSample(limit, accessPath);
            }
            int flags = predicate.getProperty(IPredicate.Annotations.FLAGS, 3) | 0x20 | 0x100;
            predicate = (Predicate)predicate.setProperty(IPredicate.Annotations.FLAGS, flags);
            switch (sampleType) {
                case EVEN: {
                    advancer = new EvenSampleAdvancer(limit, accessPath.getFromKey(), accessPath.getToKey());
                    break;
                }
                case RANDOM: {
                    advancer = new RandomSampleAdvancer(SampleIndex.this.seed(), limit, accessPath.getFromKey(), accessPath.getToKey());
                    break;
                }
                case DENSE: {
                    advancer = new DenseSampleAdvancer();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("SampleType=" + (Object)((Object)sampleType));
                }
            }
            predicate = ((Predicate)predicate).addIndexLocalFilter(advancer);
            return new AccessPathSample(limit, this.context.getAccessPath(relation, predicate));
        }
    }

    public static interface Annotations
    extends BOp.Annotations {
        public static final String LIMIT = (SampleIndex.class.getName() + ".limit").intern();
        public static final int DEFAULT_LIMIT = 100;
        public static final String SEED = (SampleIndex.class.getName() + ".seed").intern();
        public static final long DEFAULT_SEED = 0L;
        public static final String PREDICATE = (SampleIndex.class.getName() + ".predicate").intern();
        public static final String SAMPLE_TYPE = (SampleIndex.class.getName() + ".sampleType").intern();
        public static final String DEFAULT_SAMPLE_TYPE = SampleType.RANDOM.name();
    }

    public static enum SampleType {
        EVEN,
        RANDOM,
        DENSE;

    }
}

