/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.bset;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.NV;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import com.bigdata.relation.accesspath.ThickAsynchronousIterator;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public class CopyOp
extends PipelineOp {
    private static final long serialVersionUID = 1L;

    public CopyOp(CopyOp op) {
        super(op);
    }

    public CopyOp(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
    }

    public CopyOp(BOp[] args, NV ... annotations) {
        this(args, NV.asMap(annotations));
    }

    public IVariable<?>[] getSelect() {
        return this.getProperty(Annotations.SELECT, null);
    }

    public IConstraint[] constraints() {
        return this.getProperty(Annotations.CONSTRAINTS, null);
    }

    public IBindingSet[] bindingSets() {
        return this.getProperty(Annotations.BINDING_SETS, null);
    }

    @Override
    public FutureTask<Void> eval(BOpContext<IBindingSet> context) {
        return new FutureTask<Void>(new CopyTask(this, context));
    }

    private static class CopyTask
    implements Callable<Void> {
        private final CopyOp op;
        private final BOpContext<IBindingSet> context;

        CopyTask(CopyOp op, BOpContext<IBindingSet> context) {
            this.op = op;
            this.context = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            ICloseableIterator<IBindingSet[]> source = this.context.getSource();
            IBlockingBuffer<IBindingSet[]> sink = this.context.getSink();
            IBlockingBuffer<IBindingSet[]> sink2 = this.context.getSink2();
            BOpStats stats = this.context.getStats();
            IVariable<?>[] select = this.op.getSelect();
            IConstraint[] constraints = this.op.constraints();
            try {
                IBindingSet[] bindingSets = this.op.bindingSets();
                if (bindingSets != null) {
                    BOpUtility.copy(new ThickAsynchronousIterator<IBindingSet[]>((E[])new IBindingSet[][]{bindingSets}), sink, sink2, null, select, constraints, stats);
                } else {
                    BOpUtility.copy(source, sink, sink2, null, select, constraints, stats);
                }
                sink.flush();
                if (sink2 != null) {
                    sink2.flush();
                }
                Void void_ = null;
                return void_;
            }
            finally {
                sink.close();
                if (sink2 != null) {
                    sink2.close();
                }
                source.close();
            }
        }
    }

    public static interface Annotations
    extends PipelineOp.Annotations {
        public static final String SELECT = CopyOp.class.getName() + ".select";
        public static final String CONSTRAINTS = CopyOp.class.getName() + ".constraints";
        public static final String BINDING_SETS = CopyOp.class.getName() + ".bindingSets";
    }
}

