/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.engine;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.NoSuchBOpException;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.engine.AbstractRunningQuery;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.bop.engine.BSBundle;
import com.bigdata.bop.engine.HaltOpMessage;
import com.bigdata.bop.engine.IChunkHandler;
import com.bigdata.bop.engine.IChunkMessage;
import com.bigdata.bop.engine.IHaltOpMessage;
import com.bigdata.bop.engine.IQueryClient;
import com.bigdata.bop.engine.LocalNativeChunkMessage;
import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.engine.QueryEngineCounters;
import com.bigdata.bop.engine.QueueStats;
import com.bigdata.bop.engine.SolutionsLog;
import com.bigdata.bop.engine.StartOpMessage;
import com.bigdata.concurrent.FutureTaskMon;
import com.bigdata.jsr166.LinkedBlockingDeque;
import com.bigdata.rdf.sparql.ast.QueryHints;
import com.bigdata.relation.accesspath.BufferClosedException;
import com.bigdata.relation.accesspath.DelegateBuffer;
import com.bigdata.relation.accesspath.IAsynchronousIterator;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import com.bigdata.relation.accesspath.MultiSourceSequentialCloseableIterator;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class ChunkedRunningQuery
extends AbstractRunningQuery {
    private static final transient Logger log = Logger.getLogger(ChunkedRunningQuery.class);
    private static final boolean INFO = log.isInfoEnabled();
    private static final Logger chunkTaskLog = Logger.getLogger(ChunkTask.class);
    private final IChunkHandler chunkHandler;
    private final ConcurrentHashMap<BSBundle, ConcurrentHashMap<ChunkFutureTask, ChunkFutureTask>> operatorFutures;
    private final ConcurrentMap<BSBundle, BlockingQueue<IChunkMessage<IBindingSet>>> operatorQueues;
    private static final boolean orderedOperatorQueueMap = false;
    private static final boolean removeMapOperatorFutureEntries = false;
    private static final boolean removeMapOperatorQueueEntries = false;
    private static final boolean asynchronousHaltMessage = true;

    public ChunkedRunningQuery(QueryEngine queryEngine, UUID queryId, boolean controller, IQueryClient clientProxy, PipelineOp query, IChunkMessage<IBindingSet> realSource) {
        super(queryEngine, queryId, controller, clientProxy, query, realSource);
        this.chunkHandler = this.getChunkHandler(queryEngine, query);
        this.operatorFutures = new ConcurrentHashMap();
        this.operatorQueues = new ConcurrentHashMap<BSBundle, BlockingQueue<IChunkMessage<IBindingSet>>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean acceptChunk(IChunkMessage<IBindingSet> msg) {
        if (msg == null) {
            throw new IllegalArgumentException();
        }
        if (!msg.isMaterialized()) {
            throw new IllegalStateException();
        }
        BSBundle bundle = new BSBundle(msg.getBOpId(), msg.getPartitionId());
        this.lock.lock();
        try {
            PipelineOp bop;
            int capacity;
            if (this.isDone()) {
                msg.release();
                boolean bl = false;
                return bl;
            }
            LinkedBlockingDeque<IChunkMessage<IBindingSet>> queue = (LinkedBlockingDeque<IChunkMessage<IBindingSet>>)this.operatorQueues.get(bundle);
            if (queue == null && this.operatorQueues.put(bundle, queue = new LinkedBlockingDeque<IChunkMessage<IBindingSet>>(capacity = (bop = (PipelineOp)this.getBOp(msg.getBOpId())).isPipelinedEvaluation() ? bop.getProperty(PipelineOp.Annotations.PIPELINE_QUEUE_CAPACITY, 10) : Integer.MAX_VALUE, this.lock)) != null) {
                throw new AssertionError((Object)bundle.toString());
            }
            if (!queue.offer(msg)) {
                this.getQueryEngine().counters.blockedWorkQueueCount.increment();
                this.getQueryEngine().counters.blockedWorkQueueRunningTotal.increment();
                try {
                    queue.put(msg);
                    this.getQueryEngine().counters.bufferedChunkMessageCount.increment();
                    if (msg instanceof LocalNativeChunkMessage) {
                        this.getQueryEngine().counters.bufferedChunkMessageBytesOnNativeHeap.add(((LocalNativeChunkMessage)msg).getByteCount());
                    }
                }
                finally {
                    this.getQueryEngine().counters.blockedWorkQueueCount.decrement();
                }
            }
            this.scheduleNext(bundle);
            boolean bl = true;
            return bl;
        }
        catch (InterruptedException ex) {
            msg.release();
            throw new RuntimeException(ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void consumeChunk() {
        this.lock.lock();
        try {
            for (BSBundle bundle : this.operatorQueues.keySet()) {
                this.scheduleNext(bundle);
            }
        }
        catch (RuntimeException ex) {
            this.halt(ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void haltOp(IHaltOpMessage msg) {
        this.lock.lock();
        try {
            super.haltOp(msg);
            this.consumeChunk();
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean scheduleNext(BSBundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException();
        }
        PipelineOp bop = (PipelineOp)this.getBOp(bundle.bopId);
        int maxParallel = bop.getMaxParallel();
        boolean pipelined = bop.isPipelinedEvaluation();
        int maxMessagesPerTask = bop.getProperty(PipelineOp.Annotations.MAX_MESSAGES_PER_TASK, 10);
        this.lock.lock();
        try {
            ChunkFutureTask cft;
            long solutionsAccepted;
            int naccepted;
            boolean atOnceReady;
            ConcurrentHashMap<ChunkFutureTask, ChunkFutureTask> map;
            block34: {
                if (this.isDone()) {
                    boolean bl = false;
                    return bl;
                }
                map = this.operatorFutures.get(bundle);
                int nrunning = 0;
                if (map != null) {
                    for (ChunkFutureTask cft2 : map.keySet()) {
                        if (cft2.isDone()) {
                            map.remove(cft2);
                        }
                        ++nrunning;
                    }
                    if (nrunning == 0) {
                        // empty if block
                    }
                }
                if (nrunning >= maxParallel) {
                    if (log.isDebugEnabled()) {
                        log.debug("Deferring next execution: " + bundle + ", #running=" + nrunning + ", maxParallel=" + maxParallel + ", runState=" + this.runStateString());
                    }
                    boolean i$ = false;
                    return i$;
                }
                BlockingQueue queue = (BlockingQueue)this.operatorQueues.get(bundle);
                if (queue == null) {
                    boolean cft2 = false;
                    return cft2;
                }
                if (queue.isEmpty()) {
                    boolean cft2 = false;
                    return cft2;
                }
                atOnceReady = false;
                if (!pipelined) {
                    if (!this.isAtOnceReady(bundle.bopId)) {
                        if (log.isDebugEnabled()) {
                            log.debug("Waiting on producer(s): bopId=" + bundle.bopId);
                        }
                        boolean bl = false;
                        return bl;
                    }
                    atOnceReady = true;
                }
                LinkedList<IChunkMessage<IBindingSet>> accepted = new LinkedList<IChunkMessage<IBindingSet>>();
                try {
                    int nremaining;
                    queue.drainTo(accepted, pipelined ? maxMessagesPerTask : Integer.MAX_VALUE);
                    naccepted = accepted.size();
                    this.getQueryEngine().counters.bufferedChunkMessageCount.add(-naccepted);
                    long byteCount = 0L;
                    for (IChunkMessage iChunkMessage : accepted) {
                        if (!(iChunkMessage instanceof LocalNativeChunkMessage)) continue;
                        byteCount += ((LocalNativeChunkMessage)iChunkMessage).getByteCount();
                    }
                    if (byteCount != 0L) {
                        this.getQueryEngine().counters.bufferedChunkMessageBytesOnNativeHeap.add(-byteCount);
                    }
                    if ((nremaining = queue.size()) != 0 && pipelined && INFO) {
                        log.info("Work queue is over capacity: bundle=" + bundle + ", naccepted=" + naccepted + ", nremaining=" + nremaining + ", maxMessagesPerTask=" + maxMessagesPerTask + ", runState=" + this.runStateString());
                    }
                    int nassigned = 1;
                    Iterator mitr = accepted.iterator();
                    IChunkMessage iChunkMessage = (IChunkMessage)mitr.next();
                    boolean isLastInvocation = pipelined && iChunkMessage.isLastInvocation();
                    MultiSourceSequentialCloseableIterator<E[]> source = new MultiSourceSequentialCloseableIterator<E[]>(iChunkMessage.getChunkAccessor().iterator());
                    long na = iChunkMessage.getSolutionCount();
                    while (mitr.hasNext()) {
                        IChunkMessage msg = (IChunkMessage)mitr.next();
                        na += (long)msg.getSolutionCount();
                        source.add(msg.getChunkAccessor().iterator());
                        ++nassigned;
                    }
                    solutionsAccepted = na;
                    if (nassigned != naccepted) {
                        throw new AssertionError();
                    }
                    try {
                        cft = new ChunkFutureTask(new ChunkTask(bundle.bopId, bundle.shardId, naccepted, isLastInvocation, source));
                    }
                    catch (Throwable t2) {
                        this.safeRelease(accepted);
                        this.halt(t2);
                        if (this.getCause() != null) {
                            throw new RuntimeException(t2);
                        }
                        boolean bl = false;
                        this.lock.unlock();
                        return bl;
                    }
                    if (map != null) break block34;
                    map = new ConcurrentHashMap();
                    this.operatorFutures.put(bundle, map);
                }
                catch (Throwable t) {
                    this.safeRelease(accepted);
                    throw new RuntimeException(t);
                }
            }
            map.put(cft, cft);
            if (INFO) {
                log.info("Running task: bop=" + bundle.bopId + (pipelined ? "" : ", atOnceReady=" + atOnceReady) + ", bop=" + bop.toShortString() + ", messages=" + naccepted + ", solutions=" + solutionsAccepted + (log.isDebugEnabled() ? ", runState=" + this.runStateString() : ""));
            }
            this.getQueryEngine().execute(cft);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void safeRelease(List<IChunkMessage<IBindingSet>> accepted) {
        if (accepted == null) {
            return;
        }
        try {
            for (IChunkMessage<IBindingSet> msg : accepted) {
                try {
                    msg.release();
                }
                catch (Throwable t2) {
                    if (ChunkedRunningQuery.isRootCauseInterrupt(t2)) {
                        throw t2;
                    }
                    log.error("Could not release message: " + msg, t2);
                }
            }
        }
        catch (Throwable t2) {
            if (ChunkedRunningQuery.isRootCauseInterrupt(t2)) {
                throw new RuntimeException(t2);
            }
            log.error(t2, t2);
        }
    }

    private final void sendHaltMessage(UUID serviceId, ChunkTask t, Throwable cause) {
        HaltOpMessage msg = new HaltOpMessage(this.getQueryId(), t.bopId, t.partitionId, serviceId, cause, t.sinkMessagesOut.get(), t.altSinkMessagesOut.get(), t.context.getStats());
        try {
            SendHaltMessageTask sendTask = new SendHaltMessageTask(this.getQueryController(), msg, this);
            t.context.getExecutorService().execute(sendTask);
        }
        catch (RejectedExecutionException ex) {
            if (INFO) {
                log.info("Could not send message: " + msg, ex);
            }
        }
        catch (Throwable ex) {
            log.error("Could not send message: " + msg + " : " + ex, ex);
        }
    }

    @Override
    protected boolean cancelRunningOperators(boolean mayInterruptIfRunning) {
        boolean cancelled = false;
        for (ConcurrentHashMap<ChunkFutureTask, ChunkFutureTask> set : this.operatorFutures.values()) {
            for (ChunkFutureTask f : set.keySet()) {
                if (!f.cancel(mayInterruptIfRunning)) continue;
                cancelled = true;
            }
        }
        return cancelled;
    }

    @Override
    protected void releaseAcceptedMessages() {
        for (Map.Entry e : this.operatorQueues.entrySet()) {
            BlockingQueue queue = (BlockingQueue)e.getValue();
            if (queue.isEmpty()) continue;
            LinkedList c = new LinkedList();
            queue.drainTo(c);
            for (IChunkMessage msg : c) {
                msg.release();
            }
        }
    }

    protected Map<Integer, QueueStats> getQueueStats() {
        HashMap<Integer, QueueStats> map = new HashMap<Integer, QueueStats>();
        for (Map.Entry e : this.operatorQueues.entrySet()) {
            BSBundle bundle = (BSBundle)e.getKey();
            BlockingQueue queue = (BlockingQueue)e.getValue();
            IChunkMessage[] chunks = queue.toArray(new IChunkMessage[0]);
            if (chunks.length == 0) continue;
            Integer bopId = bundle.bopId;
            QueueStats stats = (QueueStats)map.get(bopId);
            if (stats == null) {
                stats = new QueueStats();
                map.put(bopId, stats);
            }
            stats.shardSet.add(bundle.shardId);
            for (IChunkMessage msg : chunks) {
                ++stats.chunkCount;
                stats.solutionCount += msg.getSolutionCount();
            }
        }
        return map;
    }

    protected IChunkHandler getChunkHandler(QueryEngine queryEngine, PipelineOp query) {
        return query.getProperty(QueryEngine.Annotations.CHUNK_HANDLER, QueryHints.DEFAULT_QUERY_ENGINE_CHUNK_HANDLER);
    }

    protected final IChunkHandler getChunkHandler() {
        return this.chunkHandler;
    }

    static /* synthetic */ Logger access$800() {
        return chunkTaskLog;
    }

    private static class SendHaltMessageTask
    implements Runnable {
        private final IQueryClient clientProxy;
        private final IHaltOpMessage msg;
        private final ChunkedRunningQuery q;

        public SendHaltMessageTask(IQueryClient clientProxy, IHaltOpMessage msg, ChunkedRunningQuery q) {
            if (clientProxy == null) {
                throw new IllegalArgumentException();
            }
            if (msg == null) {
                throw new IllegalArgumentException();
            }
            if (q == null) {
                throw new IllegalArgumentException();
            }
            this.clientProxy = clientProxy;
            this.msg = msg;
            this.q = q;
        }

        @Override
        public void run() {
            try {
                if (this.q.isController()) {
                    this.q.haltOp(this.msg);
                } else {
                    this.clientProxy.haltOp(this.msg);
                }
            }
            catch (Throwable e) {
                if (!AbstractRunningQuery.isRootCauseInterrupt(e)) {
                    log.error("Could not notify query controller: " + e, e);
                }
                this.q.cancel(true);
            }
        }
    }

    private static class HandleChunkBuffer
    implements IBlockingBuffer<IBindingSet[]> {
        private final ChunkedRunningQuery q;
        private final int bopId;
        private final int partitionId;
        private final int sinkId;
        private final int minChunkSize;
        private final int maxChunkSize;
        private final boolean reorderSolutions;
        private final AtomicInteger sinkMessagesOut;
        private final BOpStats stats;
        private volatile boolean open = true;
        private List<IBindingSet[]> smallChunks = null;
        private int chunkSize = 0;

        public HandleChunkBuffer(ChunkedRunningQuery q, int bopId, int partitionId, int sinkId, int chunkCapacity, boolean reorderSolutions, AtomicInteger sinkMessagesOut, BOpStats stats) {
            this.q = q;
            this.bopId = bopId;
            this.partitionId = partitionId;
            this.sinkId = sinkId;
            this.reorderSolutions = reorderSolutions;
            this.sinkMessagesOut = sinkMessagesOut;
            this.stats = stats;
            this.minChunkSize = chunkCapacity >> 1;
            this.maxChunkSize = chunkCapacity + (chunkCapacity >> 1);
        }

        @Override
        public void add(IBindingSet[] e) {
            if (!this.open) {
                throw new BufferClosedException();
            }
            if (SolutionsLog.INFO) {
                SolutionsLog.log(this.q.getQueryId(), this.q.getBOp(this.bopId), this.bopId, this.partitionId, e);
            }
            if (this.reorderSolutions) {
                this.addReorderAllowed(e);
            } else {
                this.addReorderNotAllowed(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addReorderAllowed(IBindingSet[] e) {
            if (e.length < this.minChunkSize) {
                HandleChunkBuffer handleChunkBuffer = this;
                synchronized (handleChunkBuffer) {
                    if (this.chunkSize + e.length > this.maxChunkSize) {
                        this.outputBufferedChunk();
                    }
                    if (this.smallChunks == null) {
                        this.smallChunks = new LinkedList<IBindingSet[]>();
                    }
                    this.smallChunks.add(e);
                    this.chunkSize += e.length;
                    return;
                }
            }
            this.outputChunk(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addReorderNotAllowed(IBindingSet[] e) {
            HandleChunkBuffer handleChunkBuffer = this;
            synchronized (handleChunkBuffer) {
                if (this.chunkSize + e.length > this.maxChunkSize) {
                    this.outputBufferedChunk();
                    if (e.length > this.minChunkSize) {
                        this.outputChunk(e);
                        return;
                    }
                }
                if (this.smallChunks == null) {
                    this.smallChunks = new LinkedList<IBindingSet[]>();
                }
                this.smallChunks.add(e);
                this.chunkSize += e.length;
            }
        }

        private void outputChunk(IBindingSet[] e) {
            int chunkSize = e.length;
            this.stats.unitsOut.add(chunkSize);
            this.stats.chunksOut.increment();
            int messagesOut = this.q.getChunkHandler().handleChunk(this.q, this.bopId, this.sinkId, e);
            this.sinkMessagesOut.addAndGet(messagesOut);
        }

        private synchronized void outputBufferedChunk() {
            if (this.smallChunks == null || this.chunkSize == 0) {
                return;
            }
            if (this.smallChunks.size() == 1) {
                this.outputChunk(this.smallChunks.get(0));
                this.chunkSize = 0;
                this.smallChunks = null;
                return;
            }
            IBindingSet[] chunk = new IBindingSet[this.chunkSize];
            int destPos = 0;
            for (IBindingSet[] e : this.smallChunks) {
                System.arraycopy(e, 0, chunk, destPos, e.length);
                destPos += e.length;
            }
            this.outputChunk(chunk);
            this.chunkSize = 0;
            this.smallChunks = null;
        }

        @Override
        public synchronized long flush() {
            if (this.open) {
                this.outputBufferedChunk();
            }
            return 0L;
        }

        @Override
        public void abort(Throwable cause) {
            this.open = false;
            this.q.halt(cause);
        }

        @Override
        public void close() {
            this.open = false;
        }

        @Override
        public Future getFuture() {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean isOpen() {
            return this.open && !this.q.isDone();
        }

        @Override
        public IAsynchronousIterator<IBindingSet[]> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
        }

        @Override
        public void setFuture(Future future) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return 0;
        }
    }

    private class NoCloseBuffer<E>
    extends DelegateBuffer<E> {
        private final UUID queryId;
        private final BOp bop;
        private final int bopId;
        final int partitionId;

        public NoCloseBuffer(UUID queryId, BOp bop, int bopId, int partitionId, IBlockingBuffer<E> delegate) {
            super(delegate);
            this.queryId = queryId;
            this.bop = bop;
            this.bopId = bopId;
            this.partitionId = partitionId;
        }

        @Override
        public void add(E e) {
            super.add(e);
            if (SolutionsLog.INFO) {
                SolutionsLog.log(this.queryId, this.bop, this.bopId, this.partitionId, (IBindingSet[])e);
            }
        }

        @Override
        public void close() {
        }
    }

    private class ChunkTask
    implements Callable<Void> {
        private final Logger log = ChunkedRunningQuery.access$800();
        private final int bopId;
        private final int partitionId;
        private final BOp bop;
        private final Integer sinkId;
        private final Integer altSinkId;
        private final IBlockingBuffer<IBindingSet[]> sink;
        private final IBlockingBuffer<IBindingSet[]> altSink;
        private final BOpContext<IBindingSet> context;
        private final FutureTask<Void> ft;
        final int messagesIn;
        final AtomicInteger sinkMessagesOut = new AtomicInteger(0);
        final AtomicInteger altSinkMessagesOut = new AtomicInteger(0);

        public String toString() {
            return "ChunkTask{query=" + ChunkedRunningQuery.this.getQueryId() + ",bopId=" + this.bopId + ",partitionId=" + this.partitionId + ",sinkId=" + this.sinkId + ",altSinkId=" + this.altSinkId + "}";
        }

        public ChunkTask(int bopId, int partitionId, int messagesIn, boolean isLastInvocation, ICloseableIterator<IBindingSet[]> src) {
            this.bopId = bopId;
            this.partitionId = partitionId;
            this.messagesIn = messagesIn;
            this.bop = ChunkedRunningQuery.this.getBOpIndex().get(bopId);
            if (this.bop == null) {
                throw new NoSuchBOpException(bopId);
            }
            if (!(this.bop instanceof PipelineOp)) {
                throw new UnsupportedOperationException(this.bop.getClass().getName());
            }
            PipelineOp op = (PipelineOp)this.bop;
            BOp p = BOpUtility.getParent(ChunkedRunningQuery.this.getQuery(), op);
            this.sinkId = BOpUtility.getEffectiveDefaultSink(this.bop, p);
            this.altSinkId = (Integer)op.getProperty(PipelineOp.Annotations.ALT_SINK_REF);
            if (this.altSinkId != null && !ChunkedRunningQuery.this.getBOpIndex().containsKey(this.altSinkId)) {
                throw new NoSuchBOpException(this.altSinkId);
            }
            if (this.altSinkId != null && this.sinkId == null) {
                throw new RuntimeException("The primary sink must be defined if the altSink is defined: " + this.bop);
            }
            BOpStats stats = ((PipelineOp)this.bop).isSharedState() ? ChunkedRunningQuery.this.getStats(bopId) : op.newStats();
            if (stats == null) {
                throw new AssertionError((Object)("No stats: op=" + op));
            }
            this.sink = p == null ? new NoCloseBuffer<IBindingSet[]>(ChunkedRunningQuery.this.getQueryId(), this.bop, bopId, partitionId, ChunkedRunningQuery.this.getQueryBuffer()) : this.newBuffer(op, this.sinkId, this.sinkMessagesOut, stats);
            this.altSink = this.altSinkId == null ? null : this.newBuffer(op, this.altSinkId, this.altSinkMessagesOut, stats);
            this.context = new BOpContext(ChunkedRunningQuery.this, partitionId, stats, op, isLastInvocation, src, this.sink, this.altSink);
            this.ft = op.eval(this.context);
            if (this.ft == null) {
                throw new RuntimeException("No future: " + op);
            }
        }

        private IBlockingBuffer<IBindingSet[]> newBuffer(PipelineOp op, int sinkId, AtomicInteger sinkMessagesOut, BOpStats stats) {
            return new HandleChunkBuffer(ChunkedRunningQuery.this, this.bopId, this.partitionId, sinkId, op.getChunkCapacity(), op.isReorderSolutions(), sinkMessagesOut, stats);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Running chunk: " + this);
            }
            try {
                this.ft.run();
                this.ft.get();
                if (this.sink != null) {
                    this.sink.flush();
                    this.sink.close();
                }
                if (this.altSink != null) {
                    this.altSink.flush();
                    this.altSink.close();
                }
            }
            catch (Throwable t) {
                ChunkedRunningQuery.this.halt(new Exception("task=" + this.toString() + ", cause=" + t, t));
                if (ChunkedRunningQuery.this.getCause() != null) {
                    // empty if block
                }
            }
            finally {
                this.context.getSource().close();
            }
            return null;
        }
    }

    private class ChunkTaskWrapper
    implements Runnable {
        private final ChunkTask t;

        public ChunkTaskWrapper(ChunkTask chunkTask) {
            if (chunkTask == null) {
                throw new IllegalArgumentException();
            }
            this.t = chunkTask;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            QueryEngine queryEngine = ChunkedRunningQuery.this.getQueryEngine();
            UUID serviceId = queryEngine.getServiceUUID();
            QueryEngineCounters c = queryEngine.counters;
            try {
                ChunkedRunningQuery.this.getQueryController().startOp(new StartOpMessage(ChunkedRunningQuery.this.getQueryId(), this.t.bopId, this.t.partitionId, serviceId, this.t.messagesIn));
                long begin = System.currentTimeMillis();
                try {
                    c.operatorStartCount.increment();
                    c.operatorActiveCount.increment();
                    this.t.call();
                }
                catch (Throwable t2) {
                    ChunkedRunningQuery.this.halt(t2);
                    if (ChunkedRunningQuery.this.getCause() != null) {
                        throw new RuntimeException(t2);
                    }
                }
                finally {
                    c.operatorHaltCount.increment();
                    c.operatorActiveCount.decrement();
                    ((ChunkTask)this.t).context.getStats().elapsed.add(System.currentTimeMillis() - begin);
                }
                ChunkedRunningQuery.this.sendHaltMessage(serviceId, this.t, null);
            }
            catch (Throwable ex1) {
                ChunkedRunningQuery.this.halt(ex1);
                if (ChunkedRunningQuery.this.getCause() != null) {
                    log.error("queryId=" + ChunkedRunningQuery.this.getQueryId() + ", bopId=" + this.t.bopId + ", bop=" + this.t.bop, ex1);
                }
                ChunkedRunningQuery.this.sendHaltMessage(serviceId, this.t, ChunkedRunningQuery.this.getCause());
            }
        }
    }

    private class ChunkFutureTask
    extends FutureTaskMon<Void> {
        private final ChunkTask t;

        public ChunkFutureTask(ChunkTask chunkTask) {
            super((Runnable)new ChunkTaskWrapper(chunkTask), null);
            this.t = chunkTask;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                super.run();
            }
            catch (Throwable t) {
                ChunkedRunningQuery.this.halt(t);
                if (ChunkedRunningQuery.this.getCause() != null) {
                    throw new RuntimeException(t);
                }
            }
            finally {
                ConcurrentHashMap map = (ConcurrentHashMap)ChunkedRunningQuery.this.operatorFutures.get(new BSBundle(this.t.bopId, this.t.partitionId));
                if (map != null) {
                    map.remove(this, this);
                }
            }
            ChunkedRunningQuery.this.scheduleNext(new BSBundle(this.t.bopId, this.t.partitionId));
        }
    }
}

