/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.engine;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IQueryContext;
import com.bigdata.bop.engine.IChunkHandler;
import com.bigdata.bop.engine.IChunkMessage;
import com.bigdata.bop.engine.IRunningQuery;
import com.bigdata.bop.engine.LocalChunkMessage;
import com.bigdata.bop.engine.LocalNativeChunkMessage;
import com.bigdata.bop.engine.ManagedHeapStandloneChunkHandler;
import com.bigdata.bop.engine.NativeHeapStandloneChunkHandler;
import com.bigdata.bop.engine.QueryEngine;

public class StandaloneChunkHandler
implements IChunkHandler {
    public static final IChunkHandler NATIVE_HEAP_INSTANCE = new NativeHeapStandloneChunkHandler();
    public static final IChunkHandler MANAGED_HEAP_INSTANCE = new ManagedHeapStandloneChunkHandler();
    public static final IChunkHandler TEST_INSTANCE = new ManagedHeapStandloneChunkHandler();
    private final boolean nativeHeap;

    protected StandaloneChunkHandler(boolean nativeHeap) {
        this.nativeHeap = nativeHeap;
    }

    @Override
    public int handleChunk(IRunningQuery query, int bopId, int sinkId, IBindingSet[] chunk) {
        if (query == null) {
            throw new IllegalArgumentException();
        }
        if (chunk == null) {
            throw new IllegalArgumentException();
        }
        if (chunk.length == 0) {
            return 0;
        }
        IChunkMessage<IBindingSet> msg = this.nativeHeap ? new LocalNativeChunkMessage(query.getQueryController(), query.getQueryId(), sinkId, -1, (IQueryContext)query, chunk) : new LocalChunkMessage(query.getQueryController(), query.getQueryId(), sinkId, -1, chunk);
        QueryEngine queryEngine = query.getQueryEngine();
        queryEngine.acceptChunk(msg);
        return 1;
    }
}

