/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.fed;

import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.fed.FederatedQueryEngine;
import com.bigdata.bop.fed.IQueryEngineFactory;
import com.bigdata.cache.ConcurrentWeakValueCache;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.IBTreeManager;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.Journal;
import com.bigdata.relation.locator.IResourceLocator;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.service.ManagedResourceService;
import com.bigdata.util.config.NicUtil;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Properties;
import java.util.UUID;
import org.apache.log4j.Logger;

public class QueryEngineFactoryBase
implements IQueryEngineFactory {
    private static final Logger log = Logger.getLogger(QueryEngineFactoryBase.class);
    private static ConcurrentWeakValueCache<IBTreeManager, QueryEngine> standaloneQECache = new ConcurrentWeakValueCache(0);
    private static ConcurrentWeakValueCache<IBigdataFederation<?>, FederatedQueryEngine> federationQECache = new ConcurrentWeakValueCache(0);

    @Override
    public QueryEngine getExistingQueryController(IBTreeManager indexManager) {
        if (indexManager instanceof IBigdataFederation) {
            return federationQECache.get((IBigdataFederation)((Object)indexManager));
        }
        return standaloneQECache.get(indexManager);
    }

    @Override
    public QueryEngine getQueryController(IIndexManager indexManager) {
        if (indexManager instanceof IBigdataFederation) {
            return this.getFederatedQueryController((IBigdataFederation)indexManager);
        }
        return this.getStandaloneQueryController((IBTreeManager)indexManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryEngine getStandaloneQueryController(IBTreeManager indexManager) {
        if (indexManager == null) {
            throw new IllegalArgumentException();
        }
        QueryEngine queryEngine = standaloneQECache.get(indexManager);
        if (queryEngine == null) {
            ConcurrentWeakValueCache<IBTreeManager, QueryEngine> concurrentWeakValueCache = standaloneQECache;
            synchronized (concurrentWeakValueCache) {
                queryEngine = standaloneQECache.get(indexManager);
                if (queryEngine == null) {
                    queryEngine = this.newStandaloneQueryEngine(indexManager);
                    standaloneQECache.put(indexManager, queryEngine);
                }
            }
        }
        return queryEngine;
    }

    protected QueryEngine newStandaloneQueryEngine(IBTreeManager indexManager) {
        if (log.isInfoEnabled()) {
            log.info("Initializing query engine: " + indexManager);
        }
        QueryEngine queryEngine = new QueryEngine(indexManager);
        queryEngine.init();
        return queryEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FederatedQueryEngine getFederatedQueryController(IBigdataFederation<?> fed) {
        if (fed == null) {
            throw new IllegalArgumentException();
        }
        FederatedQueryEngine queryEngine = federationQECache.get(fed);
        if (queryEngine == null) {
            ConcurrentWeakValueCache<IBigdataFederation<?>, FederatedQueryEngine> concurrentWeakValueCache = federationQECache;
            synchronized (concurrentWeakValueCache) {
                queryEngine = federationQECache.get(fed);
                if (queryEngine == null) {
                    queryEngine = this.newFederatedQueryEngine(fed);
                    federationQECache.put(fed, queryEngine);
                }
            }
        }
        return queryEngine;
    }

    private FederatedQueryEngine newFederatedQueryEngine(final IBigdataFederation<?> fed) {
        FederatedQueryController queryEngine;
        if (log.isInfoEnabled()) {
            log.info("Initiallizing query engine: " + fed);
        }
        ManagedResourceService queryEngineResourceService = null;
        AbstractJournal queryEngineStore = null;
        try {
            Properties p = new Properties();
            p.setProperty(Journal.Options.BUFFER_MODE, BufferMode.Temporary.toString());
            p.setProperty(Journal.Options.CREATE_TEMP_FILE, "true");
            queryEngineStore = new Journal(p){

                @Override
                protected IResourceLocator<?> newResourceLocator() {
                    return fed.getResourceLocator();
                }
            };
            queryEngineResourceService = new ManagedResourceService(new InetSocketAddress(InetAddress.getByName(NicUtil.getIpAddress("default.nic", "default", true)), 0), 0){

                @Override
                protected File getResource(UUID uuid) throws Exception {
                    return null;
                }
            };
            queryEngine = new FederatedQueryController(fed.getServiceUUID(), fed, (Journal)queryEngineStore, queryEngineResourceService);
        }
        catch (Throwable t) {
            if (queryEngineStore != null) {
                queryEngineStore.destroy();
            }
            if (queryEngineResourceService != null) {
                queryEngineResourceService.shutdownNow();
            }
            throw new RuntimeException(t);
        }
        queryEngine.init();
        return queryEngine;
    }

    @Override
    public int getQueryControllerCount() {
        return standaloneQECache.size() + federationQECache.size();
    }

    private class FederatedQueryController
    extends FederatedQueryEngine {
        final Journal queryEngineStore;
        final ManagedResourceService queryEngineResourceService;

        public FederatedQueryController(UUID thisService, IBigdataFederation<?> fed, Journal indexManager, ManagedResourceService resourceService) {
            super(thisService, fed, indexManager, resourceService);
            this.queryEngineStore = indexManager;
            this.queryEngineResourceService = resourceService;
        }

        @Override
        public void shutdown() {
            super.shutdown();
            this.queryEngineResourceService.shutdown();
            this.tearDown();
        }

        @Override
        public void shutdownNow() {
            super.shutdownNow();
            this.queryEngineResourceService.shutdownNow();
            this.tearDown();
        }

        private void tearDown() {
            this.queryEngineStore.destroy();
        }
    }
}

