/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.fed.shards;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.fed.shards.Bundle;
import com.bigdata.bop.fed.shards.IShardMapper;
import com.bigdata.bop.fed.shards.MapBindingSetsOverShardsBuffer;
import com.bigdata.mdi.PartitionLocator;
import com.bigdata.relation.accesspath.IBuffer;
import com.bigdata.striterator.IKeyOrder;
import com.bigdata.util.BytesUtil;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.log4j.Logger;

class Algorithm_NestedLocatorScan<E extends IBindingSet, F>
implements IShardMapper<E, F> {
    private static final transient Logger log = Logger.getLogger(Algorithm_NestedLocatorScan.class);
    private final MapBindingSetsOverShardsBuffer<E, F> op;

    public Algorithm_NestedLocatorScan(MapBindingSetsOverShardsBuffer<E, F> op) {
        this.op = op;
    }

    @Override
    public void mapOverShards(Bundle<F>[] bundles) {
        Arrays.sort(bundles);
        PartitionLocator current = null;
        IKeyOrder currentKeyOrder = null;
        for (Bundle<F> bundle : Arrays.asList(bundles)) {
            if (current != null && currentKeyOrder == bundle.keyOrder && BytesUtil.rangeCheck(bundle.fromKey, current.getLeftSeparatorKey(), current.getRightSeparatorKey()) && BytesUtil.rangeCheck(bundle.toKey, current.getLeftSeparatorKey(), current.getRightSeparatorKey())) {
                IBuffer<IBindingSet[]> sink = this.op.getBuffer(current);
                sink.add(new IBindingSet[]{bundle.bindingSet});
                continue;
            }
            Iterator<PartitionLocator> itr = this.op.locatorScan(bundle.keyOrder, bundle.fromKey, bundle.toKey);
            current = null;
            currentKeyOrder = bundle.keyOrder;
            while (itr.hasNext()) {
                PartitionLocator locator = current = itr.next();
                if (log.isTraceEnabled()) {
                    log.trace("adding bindingSet to buffer: asBound=" + bundle.asBound + ", partitionId=" + locator.getPartitionId() + ", dataService=" + locator.getDataServiceUUID() + ", bindingSet=" + bundle.bindingSet);
                }
                IBuffer<IBindingSet[]> sink = this.op.getBuffer(locator);
                sink.add(new IBindingSet[]{bundle.bindingSet});
            }
        }
    }
}

