/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.fed.shards;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IPredicate;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.striterator.IKeyOrder;
import com.bigdata.util.BytesUtil;
import java.util.Arrays;

class Bundle<F>
implements Comparable<Bundle<F>> {
    final IBindingSet bindingSet;
    final IPredicate<F> asBound;
    final IKeyOrder<F> keyOrder;
    final byte[] fromKey;
    final byte[] toKey;
    private int hash = 0;

    public Bundle(IKeyBuilder keyBuilder, IPredicate<F> asBound, IKeyOrder<F> keyOrder, IBindingSet bindingSet) {
        this.bindingSet = bindingSet;
        this.asBound = asBound;
        this.keyOrder = keyOrder;
        this.fromKey = keyOrder.getFromKey(keyBuilder, asBound);
        this.toKey = keyOrder.getToKey(keyBuilder, asBound);
    }

    @Override
    public int compareTo(Bundle<F> o) {
        int ret = this.keyOrder.getIndexName().compareTo(o.keyOrder.getIndexName());
        if (ret == 0) {
            ret = BytesUtil.compareBytes(this.fromKey, o.fromKey);
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Bundle)) {
            return false;
        }
        Bundle t = (Bundle)o;
        if (this.keyOrder == t.keyOrder) {
            return false;
        }
        if (this.compareTo(t) != 0) {
            return false;
        }
        if (!this.bindingSet.equals(t.bindingSet)) {
            return false;
        }
        return this.asBound.equals(t.asBound);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Arrays.hashCode(this.fromKey);
        }
        return this.hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("{bindingSet=" + this.bindingSet);
        sb.append(",asBound=" + this.asBound);
        sb.append(",keyOrder=" + this.keyOrder);
        sb.append(",fromKey=" + BytesUtil.toString(this.fromKey));
        sb.append(",toKey=" + BytesUtil.toString(this.toKey));
        sb.append("}");
        return sb.toString();
    }
}

