/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.join;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.NV;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.bop.join.AccessPathJoinAnnotations;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.filter.Advancer;
import com.bigdata.btree.filter.TupleFilter;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.lexicon.ITermIVFilter;
import com.bigdata.rdf.spo.DistinctMultiTermAdvancer;
import com.bigdata.rdf.spo.DistinctTermAdvancer;
import com.bigdata.relation.IRelation;
import com.bigdata.relation.accesspath.AccessPath;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import com.bigdata.relation.accesspath.UnsyncLocalOutputBuffer;
import com.bigdata.striterator.ChunkedWrappedIterator;
import com.bigdata.striterator.IChunkedIterator;
import com.bigdata.striterator.IKeyOrder;
import cutthecrap.utils.striterators.IStriterator;
import cutthecrap.utils.striterators.Resolver;
import cutthecrap.utils.striterators.Striterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public class DistinctTermScanOp<E>
extends PipelineOp {
    private static final long serialVersionUID = 1L;

    public DistinctTermScanOp(DistinctTermScanOp<E> op) {
        super(op);
    }

    public DistinctTermScanOp(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
        this.getDistinctVar();
        this.getRequiredProperty(Annotations.PREDICATE);
        if (this.isOptional()) {
            throw new UnsupportedOperationException();
        }
    }

    public DistinctTermScanOp(BOp[] args, NV ... annotations) {
        this(args, NV.asMap(annotations));
    }

    protected IVariable<?> getDistinctVar() {
        return (IVariable)this.getRequiredProperty(Annotations.DISTINCT_VAR);
    }

    protected IVariable<?>[] getSelect() {
        return this.getProperty(Annotations.SELECT, null);
    }

    protected IConstraint[] constraints() {
        return this.getProperty(Annotations.CONSTRAINTS, null);
    }

    public IPredicate<E> getPredicate() {
        return (IPredicate)this.getRequiredProperty(Annotations.PREDICATE);
    }

    private boolean isOptional() {
        return this.getPredicate().isOptional();
    }

    @Override
    public FutureTask<Void> eval(BOpContext<IBindingSet> context) {
        return new FutureTask<Void>(new ChunkTask(this, context));
    }

    private static class ChunkTask<E>
    implements Callable<Void> {
        private final DistinctTermScanOp<E> op;
        private final BOpContext<IBindingSet> context;
        private final IVariable<?> distinctVar;
        private final IPredicate<E> predicate;
        private final IRelation<E> relation;

        ChunkTask(DistinctTermScanOp<E> op, BOpContext<IBindingSet> context) {
            this.op = op;
            this.context = context;
            this.distinctVar = op.getDistinctVar();
            this.predicate = op.getPredicate();
            this.relation = context.getRelation(this.predicate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            BOpStats stats = this.context.getStats();
            IBindingSet[] leftSolutions = BOpUtility.toArray(this.context.getSource(), stats);
            IBlockingBuffer<IBindingSet[]> sink = this.context.getSink();
            UnsyncLocalOutputBuffer<IBindingSet> unsyncBuffer = new UnsyncLocalOutputBuffer<IBindingSet>(this.op.getChunkCapacity(), sink);
            IVariable[] selectVars = this.op.getSelect();
            IConstraint[] constraints = this.op.constraints();
            try {
                for (IBindingSet bindingSet : leftSolutions) {
                    IPredicate<E> asBound = this.predicate.asBound(bindingSet);
                    if (asBound == null) continue;
                    IAccessPath<E> accessPath = this.context.getAccessPath(this.relation, asBound);
                    if (accessPath.getPredicate().getIndexLocalFilter() != null) {
                        throw new AssertionError();
                    }
                    if (accessPath.getPredicate().getAccessPathFilter() != null) {
                        throw new AssertionError();
                    }
                    IChunkedIterator<IV> rightItr = ChunkTask.distinctTermScan((AccessPath)accessPath, null);
                    while (rightItr.hasNext()) {
                        ListBindingSet right = new ListBindingSet();
                        right.set(this.distinctVar, new Constant<IV>(rightItr.next()));
                        IBindingSet outSolution = BOpContext.bind(bindingSet, right, constraints, selectVars);
                        if (outSolution == null) continue;
                        unsyncBuffer.add(outSolution);
                    }
                }
                unsyncBuffer.flush();
                sink.flush();
                Void void_ = null;
                return void_;
            }
            finally {
                sink.close();
                this.context.getSource().close();
            }
        }

        private static <E> IChunkedIterator<IV> distinctTermScan(AccessPath<E> ap, final ITermIVFilter termIdFilter) {
            Advancer filter;
            IKeyOrder<E> keyOrder = ap.getKeyOrder();
            byte[] fromKey = ap.getFromKey();
            byte[] toKey = ap.getToKey();
            List<BOp> predicateArgs = ap.getPredicate().args();
            int nrConsts = 0;
            for (int i = 0; i < predicateArgs.size(); ++i) {
                if (!(predicateArgs.get(i) instanceof IConstant)) continue;
                ++nrConsts;
            }
            final int nrConstsFinal = nrConsts;
            Advancer advancer = filter = nrConsts == 0 ? new DistinctTermAdvancer(keyOrder.getKeyArity()) : new DistinctMultiTermAdvancer(keyOrder.getKeyArity(), nrConsts);
            if (termIdFilter != null) {
                filter.addFilter(new TupleFilter<E>(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected boolean isValid(ITuple<E> tuple) {
                        byte[] key = tuple.getKey();
                        IV[] ivs = IVUtility.decode(key, nrConstsFinal + 1);
                        IV iv = ivs[nrConstsFinal];
                        return termIdFilter.isValid(iv);
                    }
                });
            }
            IStriterator itr = new Striterator(ap.getIndex().rangeIterator(fromKey, toKey, 0, 33, filter)).addFilter(new Resolver(){
                private static final long serialVersionUID = 1L;

                @Override
                protected IV resolve(Object obj) {
                    byte[] key = ((ITuple)obj).getKey();
                    IV[] ivs = IVUtility.decode(key, nrConstsFinal + 1);
                    return ivs[nrConstsFinal];
                }
            });
            return new ChunkedWrappedIterator<IV>(itr, ap.getChunkCapacity(), IV.class);
        }
    }

    public static interface Annotations
    extends AccessPathJoinAnnotations {
        public static final String DISTINCT_VAR = DistinctTermScanOp.class.getName() + ".distinctVar";
    }
}

