/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.join;

import com.bigdata.bop.BOpContext;
import com.bigdata.bop.Constant;
import com.bigdata.bop.HTreeAnnotations;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IndexAnnotations;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.ap.Predicate;
import com.bigdata.bop.controller.INamedSolutionSetRef;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.bop.join.HashIndexOp;
import com.bigdata.bop.join.HashJoinAnnotations;
import com.bigdata.bop.join.IHashJoinUtility;
import com.bigdata.bop.join.IHashJoinUtilityFactory;
import com.bigdata.bop.join.JVMHashJoinUtility;
import com.bigdata.bop.join.JoinAnnotations;
import com.bigdata.bop.join.JoinTypeEnum;
import com.bigdata.bop.join.JoinVariableNotBoundException;
import com.bigdata.bop.join.UnconstrainedJoinException;
import com.bigdata.btree.Checkpoint;
import com.bigdata.btree.DefaultTupleSerializer;
import com.bigdata.btree.HTreeIndexMetadata;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.keys.ASCIIKeyBuilderFactory;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.raba.codec.FrontCodedRabaCoderDupKeys;
import com.bigdata.btree.raba.codec.SimpleRabaCoder;
import com.bigdata.counters.CAT;
import com.bigdata.htree.HTree;
import com.bigdata.io.ByteArrayBuffer;
import com.bigdata.rawstore.IRawStore;
import com.bigdata.rdf.internal.encoder.IVBindingSetEncoder;
import com.bigdata.rdf.internal.impl.literal.XSDBooleanIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import com.bigdata.relation.accesspath.BufferClosedException;
import com.bigdata.relation.accesspath.IBuffer;
import com.bigdata.rwstore.sector.IMemoryManager;
import com.bigdata.rwstore.sector.MemStore;
import com.bigdata.rwstore.sector.MemoryManagerClosedException;
import com.bigdata.util.BytesUtil;
import com.bigdata.util.InnerCause;
import cutthecrap.utils.striterators.Expander;
import cutthecrap.utils.striterators.ICloseableIterator;
import cutthecrap.utils.striterators.IStriterator;
import cutthecrap.utils.striterators.Resolver;
import cutthecrap.utils.striterators.SingleValueIterator;
import cutthecrap.utils.striterators.Striterator;
import cutthecrap.utils.striterators.Visitor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;

public class HTreeHashJoinUtility
implements IHashJoinUtility {
    private static final transient Logger log = Logger.getLogger(HTreeHashJoinUtility.class);
    public static final IHashJoinUtilityFactory factory = new IHashJoinUtilityFactory(){
        private static final long serialVersionUID = 1L;

        @Override
        public IHashJoinUtility create(BOpContext<IBindingSet> context, INamedSolutionSetRef namedSetRef, PipelineOp op, JoinTypeEnum joinType) {
            return new HTreeHashJoinUtility(context.getMemoryManager(namedSetRef.getQueryId()), op, joinType);
        }
    };
    private static final int ONE = 1;
    private final AtomicBoolean open = new AtomicBoolean(true);
    private final PipelineOp op;
    private final IVBindingSetEncoder encoder;
    private final JoinTypeEnum joinType;
    private final boolean optional;
    private final boolean filter;
    private final IVariable<?> askVar;
    private final IVariable<?>[] joinVars;
    private final IVariable<?>[] selectVars;
    private boolean outputDistinctJVs = false;
    private final IConstraint[] constraints;
    private final IRawStore store;
    private final AtomicReference<HTree> rightSolutions = new AtomicReference();
    private final AtomicReference<HTree> joinSet = new AtomicReference();
    private final long noJoinVarsLimit = Long.MAX_VALUE;
    protected final CAT nleftConsidered = new CAT();
    protected final CAT nrightConsidered = new CAT();
    protected final CAT nJoinsConsidered = new CAT();

    private static int hashCode(IVariable<?>[] joinVars, IBindingSet bset, boolean ignoreUnboundVariables) throws JoinVariableNotBoundException {
        int h = 1;
        for (IVariable<?> v : joinVars) {
            IConstant c = bset.get(v);
            if (c == null) {
                if (ignoreUnboundVariables) continue;
                throw new JoinVariableNotBoundException(v.getName());
            }
            h = 31 * h + c.hashCode();
        }
        if (log.isTraceEnabled()) {
            log.trace("hashCode=" + h + ", joinVars=" + Arrays.toString(joinVars) + " : " + bset);
        }
        return h;
    }

    protected AtomicBoolean getOpen() {
        return this.open;
    }

    protected IVBindingSetEncoder getEncoder() {
        return this.encoder;
    }

    protected long getNoJoinVarsLimit() {
        return Long.MAX_VALUE;
    }

    protected boolean getOutputDistintcJVs() {
        return this.outputDistinctJVs;
    }

    protected HTree getRightSolutions() {
        return this.rightSolutions.get();
    }

    protected HTree getJoinSet() {
        return this.joinSet.get();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{open=" + this.open);
        sb.append(",joinType=" + (Object)((Object)this.joinType));
        if (this.askVar != null) {
            sb.append(",askVar=" + this.askVar);
        }
        sb.append(",joinVars=" + Arrays.toString(this.joinVars));
        sb.append(",outputDistinctJVs=" + this.outputDistinctJVs);
        if (this.selectVars != null) {
            sb.append(",selectVars=" + Arrays.toString(this.selectVars));
        }
        if (this.constraints != null) {
            sb.append(",constraints=" + Arrays.toString(this.constraints));
        }
        sb.append(",size=" + this.getRightSolutionCount());
        sb.append(",considered(left=" + this.nleftConsidered + ",right=" + this.nrightConsidered + ",joins=" + this.nJoinsConsidered + ")");
        if (this.joinSet.get() != null) {
            sb.append(",joinSetSize=" + this.getJoinSetSize());
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.getRightSolutionCount() == 0L;
    }

    @Override
    public long getRightSolutionCount() {
        HTree htree = this.getRightSolutions();
        if (htree != null) {
            return htree.getEntryCount();
        }
        return 0L;
    }

    protected long getJoinSetSize() {
        HTree htree = this.getJoinSet();
        if (htree != null) {
            return htree.getEntryCount();
        }
        return 0L;
    }

    @Override
    public JoinTypeEnum getJoinType() {
        return this.joinType;
    }

    @Override
    public IVariable<?> getAskVar() {
        return this.askVar;
    }

    @Override
    public IVariable<?>[] getJoinVars() {
        return this.joinVars;
    }

    @Override
    public IVariable<?>[] getSelectVars() {
        return this.selectVars;
    }

    @Override
    public boolean isOutputDistinctJoinVars() {
        return this.outputDistinctJVs;
    }

    @Override
    public IConstraint[] getConstraints() {
        return this.constraints;
    }

    protected static HTreeIndexMetadata getIndexMetadata(PipelineOp op) {
        HTreeIndexMetadata metadata = new HTreeIndexMetadata(UUID.randomUUID());
        int addressBits = op.getProperty(HTreeAnnotations.ADDRESS_BITS, 10);
        int ratio = 32;
        metadata.setAddressBits(addressBits);
        metadata.setRawRecords(op.getProperty(HTreeAnnotations.RAW_RECORDS, false));
        metadata.setMaxRecLen(op.getProperty(HTreeAnnotations.MAX_RECLEN, 128));
        metadata.setWriteRetentionQueueCapacity(op.getProperty(IndexAnnotations.WRITE_RETENTION_QUEUE_CAPACITY, 4000));
        metadata.setKeyLen(4);
        DefaultTupleSerializer tupleSer = new DefaultTupleSerializer(new ASCIIKeyBuilderFactory(4), new FrontCodedRabaCoderDupKeys(32), new SimpleRabaCoder());
        metadata.setTupleSerializer(tupleSer);
        return metadata;
    }

    public HTreeHashJoinUtility(IMemoryManager mmgr, PipelineOp op, JoinTypeEnum joinType) {
        if (mmgr == null) {
            throw new IllegalArgumentException();
        }
        if (op == null) {
            throw new IllegalArgumentException();
        }
        if (joinType == null) {
            throw new IllegalArgumentException();
        }
        this.op = op;
        this.joinType = joinType;
        this.optional = joinType == JoinTypeEnum.Optional;
        this.filter = joinType == JoinTypeEnum.Filter;
        this.askVar = (IVariable)op.getProperty(HashJoinAnnotations.ASK_VAR);
        this.joinVars = (IVariable[])op.getRequiredProperty(HashJoinAnnotations.JOIN_VARS);
        this.outputDistinctJVs = op.getProperty(HashIndexOp.Annotations.OUTPUT_DISTINCT_JVs, false);
        this.selectVars = this.filter ? this.joinVars : (IVariable[])op.getProperty(JoinAnnotations.SELECT);
        this.store = new MemStore(mmgr.createAllocationContext());
        this.encoder = new IVBindingSetEncoder(BigdataValueFactoryImpl.getInstance(((String[])op.getRequiredProperty(Predicate.Annotations.RELATION_NAME))[0]), this.filter);
        this.constraints = (IConstraint[])op.getProperty(JoinAnnotations.CONSTRAINTS);
        this.rightSolutions.set(HTree.create(this.store, HTreeHashJoinUtility.getIndexMetadata(op)));
        switch (joinType) {
            case Optional: 
            case Exists: 
            case NotExists: {
                this.joinSet.set(HTree.create(this.store, HTreeHashJoinUtility.getIndexMetadata(op)));
            }
        }
    }

    public IRawStore getStore() {
        return this.store;
    }

    @Override
    public void saveSolutionSet() {
        if (!this.open.get()) {
            throw new IllegalStateException();
        }
        this.checkpointHTree(this.rightSolutions);
    }

    private void checkpointHTree(AtomicReference<HTree> ref) {
        HTree tmp = ref.get();
        if (tmp != null) {
            HTree readOnly;
            Checkpoint checkpoint = tmp.writeCheckpoint2();
            if (log.isInfoEnabled()) {
                log.info(checkpoint.toString());
            }
            if (!ref.compareAndSet(tmp, readOnly = HTree.load(this.store, checkpoint.getCheckpointAddr(), true))) {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public void release() {
        if (this.open.compareAndSet(true, false)) {
            return;
        }
        this.encoder.release();
        HTree tmp = this.rightSolutions.getAndSet(null);
        if (tmp != null) {
            tmp.close();
        }
        if ((tmp = (HTree)this.joinSet.getAndSet(null)) != null) {
            tmp.close();
        }
        this.store.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long acceptSolutions(ICloseableIterator<IBindingSet[]> itr, BOpStats stats) {
        if (!this.open.get()) {
            throw new IllegalStateException();
        }
        if (itr == null) {
            throw new IllegalArgumentException();
        }
        if (stats == null) {
            throw new IllegalArgumentException();
        }
        try {
            long naccepted = 0L;
            HTree htree = this.getRightSolutions();
            IKeyBuilder keyBuilder = htree.getIndexMetadata().getKeyBuilder();
            try (ICloseableIterator<IBindingSet[]> it = itr;){
                AtomicInteger vectorSize = new AtomicInteger();
                while (it.hasNext()) {
                    BS[] a = this.vector((IBindingSet[])it.next(), this.joinVars, null, false, vectorSize);
                    int n = vectorSize.get();
                    stats.chunksIn.increment();
                    stats.unitsIn.add(a.length);
                    for (int i = 0; i < n; ++i) {
                        BS tmp = a[i];
                        byte[] key = keyBuilder.reset().append(tmp.hashCode).getKey();
                        byte[] val = this.encoder.encodeSolution(tmp.bset);
                        htree.insert(key, val);
                    }
                    naccepted += (long)a.length;
                    this.encoder.flush();
                }
            }
            if (log.isInfoEnabled()) {
                log.info("naccepted=" + naccepted + ", nright=" + htree.getEntryCount());
            }
            return naccepted;
        }
        catch (Throwable t) {
            throw this.launderThrowable(t);
        }
    }

    @Override
    public long filterSolutions(ICloseableIterator<IBindingSet[]> itr, BOpStats stats, IBuffer<IBindingSet> sink) {
        if (itr == null) {
            throw new IllegalArgumentException();
        }
        if (stats == null) {
            throw new IllegalArgumentException();
        }
        try {
            long naccepted = 0L;
            HTree htree = this.getRightSolutions();
            IKeyBuilder keyBuilder = htree.getIndexMetadata().getKeyBuilder();
            ICloseableIterator<IBindingSet[]> it = itr;
            AtomicInteger vectorSize = new AtomicInteger();
            while (it.hasNext()) {
                BS[] a = this.vector((IBindingSet[])it.next(), this.joinVars, this.selectVars, true, vectorSize);
                int n = vectorSize.get();
                stats.chunksIn.increment();
                stats.unitsIn.add(a.length);
                for (int i = 0; i < n; ++i) {
                    BS tmp = a[i];
                    byte[] key = keyBuilder.reset().append(tmp.hashCode).getKey();
                    byte[] val = this.encoder.encodeSolution(tmp.bset, false);
                    boolean found = false;
                    ITupleIterator titr = htree.lookupAll(key);
                    while (titr.hasNext()) {
                        ITuple t = titr.next();
                        ByteArrayBuffer tb = t.getValueBuffer();
                        if (0 != BytesUtil.compareBytesWithLenAndOffset(0, val.length, val, 0, tb.limit(), tb.array())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    htree.insert(key, val);
                    sink.add(tmp.bset);
                    ++naccepted;
                }
            }
            return naccepted;
        }
        catch (Throwable t) {
            throw this.launderThrowable(t);
        }
    }

    protected IBindingSet decodeSolution(ITuple<?> t) {
        ByteArrayBuffer b = t.getValueBuffer();
        return this.encoder.decodeSolution(b.array(), 0, b.limit(), false);
    }

    @Override
    public void hashJoin(ICloseableIterator<IBindingSet[]> leftItr, BOpStats stats, IBuffer<IBindingSet> outputBuffer) {
        this.hashJoin2(leftItr, stats, outputBuffer, this.constraints);
    }

    @Override
    public void hashJoin2(ICloseableIterator<IBindingSet[]> leftItr, BOpStats stats, IBuffer<IBindingSet> outputBuffer, IConstraint[] constraints) {
        if (!this.open.get()) {
            throw new IllegalStateException();
        }
        ICloseableIterator<IBindingSet[]> it = leftItr;
        try {
            HTree rightSolutions = this.getRightSolutions();
            if (log.isInfoEnabled()) {
                log.info("rightSolutions: #nnodes=" + rightSolutions.getNodeCount() + ",#leaves=" + rightSolutions.getLeafCount() + ",#entries=" + rightSolutions.getEntryCount());
            }
            IKeyBuilder keyBuilder = rightSolutions.getIndexMetadata().getKeyBuilder();
            boolean noJoinVars = this.joinVars.length == 0;
            AtomicInteger vectorSize = new AtomicInteger();
            while (it.hasNext()) {
                IBindingSet[] b = (IBindingSet[])it.next();
                if (stats != null) {
                    stats.chunksIn.increment();
                    stats.unitsIn.add(b.length);
                }
                BS[] a = this.vector(b, this.joinVars, null, false, vectorSize);
                int n = vectorSize.get();
                this.nleftConsidered.add(n);
                int fromIndex = 0;
                while (fromIndex < n) {
                    LinkedList<BS2> joined;
                    int hashCode = a[fromIndex].hashCode;
                    int toIndex = n;
                    for (int i = fromIndex + 1; i < n; ++i) {
                        if (a[i].hashCode == hashCode) continue;
                        toIndex = i;
                        break;
                    }
                    int bucketSize = toIndex - fromIndex;
                    if (log.isTraceEnabled()) {
                        log.trace("hashCode=" + hashCode + ": #left=" + bucketSize + ", vectorSize=" + n + ", firstLeft=" + a[fromIndex]);
                    }
                    switch (this.joinType) {
                        case Optional: 
                        case Exists: 
                        case NotExists: {
                            joined = new LinkedList<BS2>();
                            break;
                        }
                        default: {
                            joined = null;
                        }
                    }
                    int njoined = 0;
                    int nrejected = 0;
                    byte[] key = keyBuilder.reset().append(hashCode).getKey();
                    ITupleIterator titr = rightSolutions.lookupAll(key);
                    long sameHashCodeCount = 0L;
                    while (titr.hasNext()) {
                        ++sameHashCodeCount;
                        ITuple t = titr.next();
                        IBindingSet rightSolution = this.decodeSolution(t);
                        this.nrightConsidered.increment();
                        block17: for (int i = fromIndex; i < toIndex; ++i) {
                            IBindingSet leftSolution = a[i].bset;
                            IBindingSet outSolution = BOpContext.bind(leftSolution, rightSolution, constraints, this.selectVars);
                            this.nJoinsConsidered.increment();
                            if (noJoinVars && this.nJoinsConsidered.get() == Long.MAX_VALUE && this.nleftConsidered.get() > 1L && this.nrightConsidered.get() > 1L) {
                                throw new UnconstrainedJoinException();
                            }
                            if (outSolution == null) {
                                ++nrejected;
                                if (log.isTraceEnabled()) {
                                    log.trace("Does not join: hashCode=" + hashCode + ", sameHashCodeCount=" + sameHashCodeCount + ", #left=" + bucketSize + ", #joined=" + njoined + ", #rejected=" + nrejected + ", left=" + leftSolution + ", right=" + rightSolution);
                                }
                            } else {
                                ++njoined;
                                if (log.isDebugEnabled()) {
                                    log.debug("JOIN: hashCode=" + hashCode + ", sameHashCodeCount=" + sameHashCodeCount + ", #left=" + bucketSize + ", #joined=" + njoined + ", #rejected=" + nrejected + ", solution=" + outSolution);
                                }
                            }
                            switch (this.joinType) {
                                case Optional: 
                                case Normal: {
                                    if (outSolution == null) continue block17;
                                    this.encoder.resolveCachedValues(outSolution);
                                    outputBuffer.add(outSolution);
                                    if (!this.optional) continue block17;
                                    joined.add(new BS2(rightSolution.hashCode(), t.getValue()));
                                    continue block17;
                                }
                                case Exists: {
                                    if (outSolution == null) continue block17;
                                    joined.add(new BS2(rightSolution.hashCode(), t.getValue()));
                                    continue block17;
                                }
                                case NotExists: {
                                    if (outSolution == null) continue block17;
                                    joined.add(new BS2(rightSolution.hashCode(), t.getValue()));
                                    continue block17;
                                }
                                default: {
                                    throw new AssertionError();
                                }
                            }
                        }
                    }
                    if (joined != null && !joined.isEmpty()) {
                        Object[] a2 = joined.toArray(new BS2[njoined]);
                        Arrays.sort(a2, 0, njoined);
                        for (int i = 0; i < njoined; ++i) {
                            Object tmp = a2[i];
                            this.saveInJoinSet(((BS2)tmp).hashCode, ((BS2)tmp).value);
                        }
                    }
                    fromIndex = toIndex;
                }
            }
            if (log.isInfoEnabled()) {
                log.info("done: " + this.toString());
            }
        }
        catch (Throwable t) {
            throw this.launderThrowable(t);
        }
        finally {
            leftItr.close();
        }
    }

    protected BS[] vector(IBindingSet[] leftSolutions, IVariable<?>[] joinVars, IVariable<?>[] selectVars, boolean ignoreUnboundVariables, AtomicInteger vectorSize) {
        Object[] a = new BS[leftSolutions.length];
        int n = 0;
        int ndropped = 0;
        for (int i = 0; i < a.length; ++i) {
            int hashCode;
            IBindingSet bset;
            block5: {
                bset = selectVars == null ? leftSolutions[i] : leftSolutions[i].copy(selectVars);
                hashCode = 1;
                try {
                    hashCode = HTreeHashJoinUtility.hashCode(joinVars, bset, ignoreUnboundVariables);
                }
                catch (JoinVariableNotBoundException ex) {
                    if (this.optional) break block5;
                    if (log.isTraceEnabled()) {
                        log.trace(ex);
                    }
                    ++ndropped;
                    continue;
                }
            }
            a[n++] = new BS(hashCode, bset);
        }
        Arrays.sort(a, 0, n);
        vectorSize.set(n);
        if (log.isTraceEnabled()) {
            log.trace("Vectoring chunk for HTree locality: naccepted=" + n + ", ndropped=" + ndropped);
        }
        return a;
    }

    protected void saveInJoinSet(int joinSetHashCode, byte[] val) {
        HTree joinSet = this.getJoinSet();
        IKeyBuilder keyBuilder = joinSet.getIndexMetadata().getKeyBuilder();
        byte[] key = keyBuilder.reset().append(joinSetHashCode).getKey();
        ITupleIterator xitr = joinSet.lookupAll(key);
        while (xitr.hasNext()) {
            ITuple xt = xitr.next();
            ByteArrayBuffer b = xt.getValueBuffer();
            if (0 != BytesUtil.compareBytesWithLenAndOffset(0, val.length, val, 0, b.limit(), b.array())) continue;
            return;
        }
        joinSet.insert(joinSetHashCode, val);
    }

    @Override
    public void outputOptionals(IBuffer<IBindingSet> outputBuffer) {
        if (!this.open.get()) {
            throw new IllegalStateException();
        }
        try {
            Constant<XSDBooleanIV<BigdataLiteral>> f;
            Constant<XSDBooleanIV<BigdataLiteral>> constant = f = this.askVar == null ? null : new Constant<XSDBooleanIV<BigdataLiteral>>(XSDBooleanIV.valueOf(false));
            if (log.isInfoEnabled()) {
                HTree htree = this.getRightSolutions();
                log.info("rightSolutions: #nnodes=" + htree.getNodeCount() + ",#leaves=" + htree.getLeafCount() + ",#entries=" + htree.getEntryCount());
                HTree joinSet = this.getJoinSet();
                log.info("joinSet: #nnodes=" + joinSet.getNodeCount() + ",#leaves=" + joinSet.getLeafCount() + ",#entries=" + joinSet.getEntryCount());
            }
            HTree joinSet = this.getJoinSet();
            IKeyBuilder keyBuilder = joinSet.getIndexMetadata().getKeyBuilder();
            ITupleIterator sitr = this.getRightSolutions().rangeIterator();
            while (sitr.hasNext()) {
                ITuple t = sitr.next();
                ByteArrayBuffer tb = t.getValueBuffer();
                IBindingSet rightSolution = this.decodeSolution(t);
                int hashCode = rightSolution.hashCode();
                byte[] key = keyBuilder.reset().append(hashCode).getKey();
                ITupleIterator jitr = joinSet.lookupAll(key);
                boolean found = false;
                while (jitr.hasNext()) {
                    ITuple xt = jitr.next();
                    ByteArrayBuffer xb = xt.getValueBuffer();
                    if (0 != BytesUtil.compareBytesWithLenAndOffset(0, tb.limit(), tb.array(), 0, xb.limit(), xb.array())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                IBindingSet bs = rightSolution;
                if (this.selectVars != null) {
                    bs = bs.copy(this.selectVars);
                }
                this.encoder.resolveCachedValues(bs);
                if (f != null) {
                    if (bs == rightSolution) {
                        bs = rightSolution.clone();
                    }
                    bs.set(this.askVar, f);
                }
                outputBuffer.add(bs);
            }
        }
        catch (Throwable t) {
            throw this.launderThrowable(t);
        }
    }

    @Override
    public ICloseableIterator<IBindingSet> indexScan() {
        HTree rightSolutions = this.getRightSolutions();
        if (log.isInfoEnabled()) {
            log.info("rightSolutions: #nnodes=" + rightSolutions.getNodeCount() + ",#leaves=" + rightSolutions.getLeafCount() + ",#entries=" + rightSolutions.getEntryCount());
        }
        ITupleIterator solutionsIterator = rightSolutions.rangeIterator();
        IStriterator itr = new Striterator(solutionsIterator);
        itr = itr.addFilter(new Resolver(){
            private static final long serialVersionUID = 1L;

            @Override
            protected Object resolve(Object obj) {
                ITuple t = (ITuple)obj;
                IBindingSet bset = HTreeHashJoinUtility.this.decodeSolution(t);
                HTreeHashJoinUtility.this.encoder.resolveCachedValues(bset);
                return bset;
            }
        });
        return itr;
    }

    @Override
    public void outputSolutions(IBuffer<IBindingSet> out) {
        if (!this.open.get()) {
            throw new IllegalStateException();
        }
        try {
            HTree rightSolutions = this.getRightSolutions();
            if (log.isInfoEnabled()) {
                log.info("rightSolutions: #nnodes=" + rightSolutions.getNodeCount() + ",#leaves=" + rightSolutions.getLeafCount() + ",#entries=" + rightSolutions.getEntryCount());
            }
            HashSet distinctSet = null;
            int lastHashCode = -1;
            ITupleIterator solutionsIterator = rightSolutions.rangeIterator();
            while (solutionsIterator.hasNext()) {
                ITuple t = solutionsIterator.next();
                IBindingSet bset = this.decodeSolution(t);
                if (this.outputDistinctJVs) {
                    boolean newBucket;
                    bset = bset.copy(this.joinVars);
                    int newHashCode = HTreeHashJoinUtility.hashCode(this.joinVars, bset, true);
                    boolean bl = newBucket = distinctSet == null || newHashCode != lastHashCode;
                    if (newBucket) {
                        distinctSet = this.outputDistinctJVs ? new HashSet() : null;
                        lastHashCode = newHashCode;
                    }
                    if (!distinctSet.add(bset)) {
                        continue;
                    }
                } else if (this.selectVars != null) {
                    bset = bset.copy(this.selectVars);
                }
                this.encoder.resolveCachedValues(bset);
                out.add(bset);
            }
        }
        catch (Throwable t) {
            throw this.launderThrowable(t);
        }
    }

    @Override
    public void outputJoinSet(IBuffer<IBindingSet> out) {
        try {
            Constant<XSDBooleanIV<BigdataLiteral>> t = this.askVar == null ? null : new Constant<XSDBooleanIV<BigdataLiteral>>(XSDBooleanIV.valueOf(true));
            HTree joinSet = this.getJoinSet();
            if (log.isInfoEnabled()) {
                log.info("joinSet: #nnodes=" + joinSet.getNodeCount() + ",#leaves=" + joinSet.getLeafCount() + ",#entries=" + joinSet.getEntryCount());
            }
            ITupleIterator solutionsIterator = joinSet.rangeIterator();
            while (solutionsIterator.hasNext()) {
                IBindingSet bset = this.decodeSolution(solutionsIterator.next());
                if (this.selectVars != null) {
                    bset = bset.copy(this.selectVars);
                }
                if (t != null) {
                    if (this.selectVars == null) {
                        bset = bset.clone();
                    }
                    bset.set(this.askVar, t);
                }
                this.encoder.resolveCachedValues(bset);
                out.add(bset);
            }
        }
        catch (Throwable t) {
            throw this.launderThrowable(t);
        }
    }

    @Override
    public void mergeJoin(IHashJoinUtility[] others, IBuffer<IBindingSet> outputBuffer, IConstraint[] constraints, final boolean optional) {
        try {
            if (others == null) {
                throw new IllegalArgumentException();
            }
            if (others.length == 0) {
                throw new IllegalArgumentException();
            }
            if (outputBuffer == null) {
                throw new IllegalArgumentException();
            }
            IHashJoinUtility[] all = new HTreeHashJoinUtility[others.length + 1];
            all[0] = this;
            for (int i = 0; i < others.length; ++i) {
                HTreeHashJoinUtility o = (HTreeHashJoinUtility)others[i];
                if (o == null) {
                    throw new IllegalArgumentException();
                }
                if (!Arrays.equals(this.joinVars, o.joinVars)) {
                    throw new IllegalArgumentException();
                }
                all[i + 1] = o;
            }
            if (this.isEmpty()) {
                return;
            }
            IConstraint[] c = JVMHashJoinUtility.combineConstraints(constraints, all);
            long njoined = 0L;
            long nrejected = 0L;
            final String NULL_VALUE = "NULL";
            int nsources = all.length;
            final ITuple[] set = new ITuple[nsources + 1];
            Striterator sols0 = new Striterator(((HTreeHashJoinUtility)all[0]).getRightSolutions().rangeIterator());
            sols0.addFilter(new Visitor(){
                private static final long serialVersionUID = 1L;

                @Override
                protected void visit(Object obj) {
                    set[0] = (ITuple)obj;
                }
            });
            int i = 1;
            while (i < nsources) {
                final int slot = i++;
                final HTree thisTree = ((HTreeHashJoinUtility)all[slot]).getRightSolutions();
                sols0.addFilter(new Expander(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected Iterator<?> expand(Object obj) {
                        if (obj == NULL_VALUE) {
                            assert (optional);
                            return new SingleValueIterator<Object>(NULL_VALUE);
                        }
                        byte[] key2 = ((ITuple)obj).getKey();
                        ITupleIterator ret = thisTree.lookupAll(key2);
                        if (optional && !ret.hasNext()) {
                            return new SingleValueIterator<Object>(NULL_VALUE);
                        }
                        return ret;
                    }
                });
                sols0.addFilter(new Visitor(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected void visit(Object obj) {
                        set[slot] = (ITuple)(obj == NULL_VALUE ? null : obj);
                    }
                });
            }
            while (sols0.hasNext()) {
                sols0.next();
                IBindingSet in = ((HTreeHashJoinUtility)all[0]).decodeSolution(set[0]);
                for (int i2 = 1; i2 < set.length; ++i2) {
                    IBindingSet left = in;
                    if (set[i2] != null) {
                        IBindingSet right = ((HTreeHashJoinUtility)all[i2]).decodeSolution(set[i2]);
                        in = BOpContext.bind(left, right, c, null);
                    }
                    if (in == null) break;
                }
                if (in == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Output solution: " + in);
                }
                this.encoder.resolveCachedValues(in);
                outputBuffer.add(in);
            }
        }
        catch (Throwable t) {
            throw this.launderThrowable(t);
        }
    }

    private RuntimeException launderThrowable(Throwable t) {
        String msg = "cause=" + t + ", state=" + this.toString();
        if (!(InnerCause.isInnerCause(t, InterruptedException.class) || InnerCause.isInnerCause(t, BufferClosedException.class) || InnerCause.isInnerCause(t, MemoryManagerClosedException.class))) {
            log.error(msg, t);
        }
        return new RuntimeException(msg, t);
    }

    static class BS2
    implements Comparable<BS2> {
        final int hashCode;
        final byte[] value;

        BS2(int hashCode, byte[] value) {
            this.hashCode = hashCode;
            this.value = value;
        }

        @Override
        public int compareTo(BS2 o) {
            if (this.hashCode < o.hashCode) {
                return -1;
            }
            if (this.hashCode > o.hashCode) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return this.getClass().getName() + "{hashCode=" + this.hashCode + ",value=" + BytesUtil.toString(this.value) + "}";
        }
    }

    public static class BS
    implements Comparable<BS> {
        final int hashCode;
        final IBindingSet bset;

        BS(int hashCode, IBindingSet bset) {
            this.hashCode = hashCode;
            this.bset = bset;
        }

        @Override
        public int compareTo(BS o) {
            if (this.hashCode < o.hashCode) {
                return -1;
            }
            if (this.hashCode > o.hashCode) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return this.getClass().getName() + "{hashCode=" + this.hashCode + ",bset=" + this.bset + "}";
        }
    }
}

