/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.join;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.ILocatableResourceAnnotations;
import com.bigdata.bop.IQueryAttributes;
import com.bigdata.bop.ISingleThreadedOp;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.NV;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.controller.INamedSolutionSetRef;
import com.bigdata.bop.controller.NamedSetAnnotations;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.bop.join.HashJoinAnnotations;
import com.bigdata.bop.join.IHashJoinUtility;
import com.bigdata.bop.join.IHashJoinUtilityFactory;
import com.bigdata.bop.join.JoinAnnotations;
import com.bigdata.bop.join.JoinTypeEnum;
import com.bigdata.bop.join.NamedSolutionSetStats;
import cutthecrap.utils.striterators.ICloseableIterator;
import cutthecrap.utils.striterators.SingleValueIterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public abstract class HashIndexOpBase
extends PipelineOp
implements ISingleThreadedOp {
    private static final long serialVersionUID = 1L;

    protected HashIndexOpBase(HashIndexOpBase op) {
        super(op);
    }

    protected HashIndexOpBase(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
        switch (this.getEvaluationContext()) {
            case CONTROLLER: 
            case SHARDED: 
            case HASHED: {
                break;
            }
            default: {
                throw new IllegalArgumentException(BOp.Annotations.EVALUATION_CONTEXT + "=" + (Object)((Object)this.getEvaluationContext()));
            }
        }
        this.assertMaxParallelOne();
        if (!this.isLastPassRequested()) {
            throw new IllegalArgumentException(PipelineOp.Annotations.LAST_PASS + "=" + this.isLastPassRequested());
        }
        this.getRequiredProperty("namedSetRef");
        JoinTypeEnum joinType = (JoinTypeEnum)((Object)this.getRequiredProperty(Annotations.JOIN_TYPE));
        IHashJoinUtilityFactory factory = (IHashJoinUtilityFactory)this.getRequiredProperty(Annotations.HASH_JOIN_UTILITY_FACTORY);
        IVariable[] joinVars = (IVariable[])this.getRequiredProperty(Annotations.JOIN_VARS);
        this.getRequiredProperty(Annotations.RELATION_NAME);
        for (IVariable var : joinVars) {
            if (var != null) continue;
            throw new IllegalArgumentException(Annotations.JOIN_VARS);
        }
    }

    protected HashIndexOpBase(BOp[] args, NV ... annotations) {
        this(args, NV.asMap(annotations));
    }

    @Override
    public BOpStats newStats() {
        return new NamedSolutionSetStats();
    }

    @Override
    public FutureTask<Void> eval(BOpContext<IBindingSet> context) {
        return new FutureTask<Void>(this.createChunkTask(context));
    }

    protected abstract ChunkTaskBase createChunkTask(BOpContext<IBindingSet> var1);

    protected static abstract class ChunkTaskBase
    implements Callable<Void> {
        protected final BOpContext<IBindingSet> context;
        protected final HashIndexOpBase op;
        protected final NamedSolutionSetStats stats;
        protected final IHashJoinUtility state;
        protected final boolean first;
        protected final boolean sourceIsPipeline;

        public ChunkTaskBase(HashIndexOpBase op, BOpContext<IBindingSet> context) {
            if (op == null) {
                throw new IllegalArgumentException();
            }
            if (context == null) {
                throw new IllegalArgumentException();
            }
            this.context = context;
            this.op = op;
            this.stats = (NamedSolutionSetStats)context.getStats();
            INamedSolutionSetRef namedSetRef = (INamedSolutionSetRef)op.getRequiredProperty("namedSetRef");
            IQueryAttributes attrs = context.getQueryAttributes(namedSetRef.getQueryId());
            IHashJoinUtility state = (IHashJoinUtility)attrs.get(namedSetRef);
            if (state == null) {
                JoinTypeEnum joinType = (JoinTypeEnum)((Object)op.getRequiredProperty(Annotations.JOIN_TYPE));
                IHashJoinUtilityFactory factory = (IHashJoinUtilityFactory)op.getRequiredProperty(Annotations.HASH_JOIN_UTILITY_FACTORY);
                state = factory.create(context, namedSetRef, op, joinType);
                if (attrs.putIfAbsent(namedSetRef, state) != null) {
                    throw new AssertionError();
                }
                this.first = true;
            } else {
                this.first = false;
            }
            this.state = state;
            this.sourceIsPipeline = op.getProperty("namedSetSourceRef") == null && op.getProperty("bindingSets") == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void acceptSolutions() {
            ICloseableIterator<IBindingSet[]> src;
            if (this.sourceIsPipeline) {
                src = this.context.getSource();
            } else if (this.op.getProperty("namedSetSourceRef") != null) {
                INamedSolutionSetRef namedSetSourceRef = (INamedSolutionSetRef)this.op.getRequiredProperty("namedSetSourceRef");
                src = this.context.getAlternateSource(namedSetSourceRef);
            } else if (this.op.getProperty("bindingSets") != null) {
                IBindingSet[] bindingSets = (IBindingSet[])this.op.getProperty("bindingSets");
                src = new SingleValueIterator<IBindingSet[]>(bindingSets);
            } else {
                throw new UnsupportedOperationException("Source was not specified");
            }
            try {
                this.state.acceptSolutions(src, this.stats);
            }
            finally {
                src.close();
            }
        }

        protected void checkpointSolutionSet() {
            this.state.saveSolutionSet();
        }
    }

    public static interface Annotations
    extends HashJoinAnnotations,
    JoinAnnotations,
    NamedSetAnnotations,
    ILocatableResourceAnnotations {
        public static final String HASH_JOIN_UTILITY_FACTORY = HashIndexOpBase.class.getName() + ".utilFactory";
        public static final String NAMED_SET_SOURCE_REF = "namedSetSourceRef";
        public static final String BINDING_SETS_SOURCE = "bindingSets";
    }
}

