/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.join;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.NV;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.controller.INamedSolutionSetRef;
import com.bigdata.bop.controller.NamedSetAnnotations;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.bop.join.JoinAnnotations;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import com.bigdata.relation.accesspath.UnsyncLocalOutputBuffer;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public class NestedLoopJoinOp
extends PipelineOp {
    private static final long serialVersionUID = 1L;

    public NestedLoopJoinOp(NestedLoopJoinOp op) {
        super(op);
    }

    public NestedLoopJoinOp(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
        this.getRequiredProperty("namedSetRef");
    }

    public NestedLoopJoinOp(BOp[] args, NV ... annotations) {
        this(args, NV.asMap(annotations));
    }

    protected IVariable<?>[] getSelect() {
        return this.getProperty(Annotations.SELECT, null);
    }

    protected IConstraint[] constraints() {
        return this.getProperty(Annotations.CONSTRAINTS, null);
    }

    @Override
    public FutureTask<Void> eval(BOpContext<IBindingSet> context) {
        return new FutureTask<Void>(new ChunkTask(this, context));
    }

    private static class ChunkTask
    implements Callable<Void> {
        private final NestedLoopJoinOp op;
        private final BOpContext<IBindingSet> context;

        ChunkTask(NestedLoopJoinOp op, BOpContext<IBindingSet> context) {
            this.op = op;
            this.context = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            BOpStats stats = this.context.getStats();
            IBindingSet[] leftSolutions = BOpUtility.toArray(this.context.getSource(), stats);
            IBlockingBuffer<IBindingSet[]> sink = this.context.getSink();
            UnsyncLocalOutputBuffer<IBindingSet> unsyncBuffer = new UnsyncLocalOutputBuffer<IBindingSet>(this.op.getChunkCapacity(), sink);
            IVariable[] selectVars = this.op.getSelect();
            IConstraint[] constraints = this.op.constraints();
            ICloseableIterator<IBindingSet[]> ritr = this.getRightSolutions();
            try {
                while (ritr.hasNext()) {
                    IBindingSet[] a;
                    for (IBindingSet right : a = (IBindingSet[])ritr.next()) {
                        for (IBindingSet left : leftSolutions) {
                            IBindingSet outSolution = BOpContext.bind(right, left, constraints, selectVars);
                            if (outSolution == null) continue;
                            unsyncBuffer.add(outSolution);
                        }
                    }
                }
                unsyncBuffer.flush();
                sink.flush();
                Void void_ = null;
                return void_;
            }
            finally {
                sink.close();
                this.context.getSource().close();
                if (ritr != null) {
                    ritr.close();
                }
            }
        }

        protected ICloseableIterator<IBindingSet[]> getRightSolutions() {
            INamedSolutionSetRef namedSetRef = (INamedSolutionSetRef)this.op.getRequiredProperty("namedSetRef");
            return this.context.getAlternateSource(namedSetRef);
        }
    }

    public static interface Annotations
    extends JoinAnnotations,
    NamedSetAnnotations {
    }
}

