/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.join;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.NV;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.controller.INamedSolutionSetRef;
import com.bigdata.bop.controller.SubqueryAnnotations;
import com.bigdata.bop.join.HashIndexOp;
import com.bigdata.bop.join.HashIndexOpBase;
import com.bigdata.bop.join.HashJoinAnnotations;
import com.bigdata.bop.join.PipelinedHashJoinUtility;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import com.bigdata.relation.accesspath.UnsyncLocalOutputBuffer;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.Map;

public class PipelinedHashIndexAndSolutionSetJoinOp
extends HashIndexOp {
    private static final long serialVersionUID = 3473675701742394157L;

    public PipelinedHashIndexAndSolutionSetJoinOp(PipelinedHashIndexAndSolutionSetJoinOp op) {
        super(op);
        if (this.getMaxParallel() != 1) {
            throw new IllegalArgumentException(Annotations.MAX_PARALLEL + "=" + this.getMaxParallel());
        }
    }

    public PipelinedHashIndexAndSolutionSetJoinOp(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
        if (this.getMaxParallel() != 1) {
            throw new IllegalArgumentException(Annotations.MAX_PARALLEL + "=" + this.getMaxParallel());
        }
    }

    public PipelinedHashIndexAndSolutionSetJoinOp(BOp[] args, NV ... annotations) {
        this(args, NV.asMap(annotations));
    }

    @Override
    protected HashIndexOpBase.ChunkTaskBase createChunkTask(BOpContext<IBindingSet> context) {
        PipelineOp subquery = (PipelineOp)this.getProperty(Annotations.SUBQUERY);
        IBindingSet[] bsFromBindingsSetSource = (IBindingSet[])this.getProperty("bindingSets");
        if (subquery == null && bsFromBindingsSetSource == null) {
            throw new IllegalArgumentException("Neither subquery nor binding set source provided.");
        }
        if (subquery != null && bsFromBindingsSetSource != null) {
            throw new IllegalArgumentException("Both subquery and binding set source provided.");
        }
        IVariable askVar = (IVariable)this.getProperty(HashJoinAnnotations.ASK_VAR);
        IVariable[] projectInVars = (IVariable[])this.getProperty(Annotations.PROJECT_IN_VARS);
        int distinctProjectionBufferThreshold = this.getProperty(Annotations.DISTINCT_PROJECTION_BUFFER_THRESHOLD, 50);
        int incomingBindingsBufferThreshold = this.getProperty(Annotations.INCOMING_BINDINGS_BUFFER_THRESHOLD, 1000);
        return new ChunkTask(this, context, subquery, bsFromBindingsSetSource, projectInVars, askVar, distinctProjectionBufferThreshold, incomingBindingsBufferThreshold);
    }

    private static class ChunkTask
    extends HashIndexOp.ChunkTask {
        final PipelineOp subquery;
        final IBindingSet[] bsFromBindingsSetSource;
        final IConstraint[] joinConstraints;
        final IVariable<?> askVar;
        final IVariable<?>[] projectInVars;
        final int distinctProjectionBufferThreshold;
        final int incomingBindingsBufferThreshold;

        public ChunkTask(PipelinedHashIndexAndSolutionSetJoinOp op, BOpContext<IBindingSet> context, PipelineOp subquery, IBindingSet[] bsFromBindingsSetSource, IVariable<?>[] projectInVars, IVariable<?> askVar, int distinctProjectionBufferThreshold, int incomingBindingsBufferThreshold) {
            super(op, context);
            this.joinConstraints = BOpUtility.concat((IConstraint[])op.getProperty(Annotations.CONSTRAINTS), this.state.getConstraints());
            this.subquery = subquery;
            this.bsFromBindingsSetSource = bsFromBindingsSetSource;
            this.projectInVars = projectInVars;
            this.askVar = askVar;
            this.distinctProjectionBufferThreshold = distinctProjectionBufferThreshold;
            this.incomingBindingsBufferThreshold = incomingBindingsBufferThreshold;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            try {
                this.acceptAndOutputSolutions();
                if (this.context.isLastInvocation()) {
                    this.state.release();
                }
                Void void_ = null;
                return void_;
            }
            finally {
                this.context.getSource().close();
                this.context.getSink().close();
            }
        }

        private void acceptAndOutputSolutions() {
            ICloseableIterator<Object[]> src;
            IBlockingBuffer<E[]> sink = this.context.getSink();
            UnsyncLocalOutputBuffer<IBindingSet> unsyncBuffer = new UnsyncLocalOutputBuffer<IBindingSet>(this.op.getChunkCapacity(), sink);
            if (this.sourceIsPipeline) {
                src = this.context.getSource();
            } else if (this.op.getProperty("namedSetSourceRef") != null) {
                INamedSolutionSetRef namedSetSourceRef = (INamedSolutionSetRef)this.op.getRequiredProperty("namedSetSourceRef");
                src = this.context.getAlternateSource(namedSetSourceRef);
            } else if (this.bsFromBindingsSetSource != null) {
                src = this.context.getSource();
            } else {
                throw new UnsupportedOperationException("Source was not specified");
            }
            ((PipelinedHashJoinUtility)((Object)this.state)).acceptAndOutputSolutions(unsyncBuffer, src, this.stats, this.joinConstraints, this.subquery, this.bsFromBindingsSetSource, this.projectInVars, this.askVar, this.context.isLastInvocation(), this.distinctProjectionBufferThreshold, this.incomingBindingsBufferThreshold, this.context);
            unsyncBuffer.flush();
            sink.flush();
        }
    }

    public static interface Annotations
    extends HashIndexOp.Annotations,
    SubqueryAnnotations {
        public static final String PROJECT_IN_VARS = PipelinedHashIndexAndSolutionSetJoinOp.class.getName() + ".projectInVars";
        public static final String DISTINCT_PROJECTION_BUFFER_THRESHOLD = PipelinedHashIndexAndSolutionSetJoinOp.class.getName() + ".distinctProjectionBufferThreshold";
        public static final int DEFAULT_DISTINCT_PROJECTION_BUFFER_THRESHOLD = 50;
        public static final String INCOMING_BINDINGS_BUFFER_THRESHOLD = PipelinedHashIndexAndSolutionSetJoinOp.class.getName() + ".incomingBindingsBuffer";
        public static final int DEFAULT_INCOMING_BINDINGS_BUFFER_THRESHOLD = 1000;
    }
}

