/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.joinGraph.fast;

import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.joinGraph.IEvaluationPlan;
import com.bigdata.bop.joinGraph.IRangeCountFactory;
import com.bigdata.relation.rule.IAccessPathExpander;
import com.bigdata.relation.rule.IRule;
import com.bigdata.relation.rule.IStarJoin;
import com.bigdata.relation.rule.eval.IJoinNexus;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class DefaultEvaluationPlan2
implements IEvaluationPlan {
    protected static final transient Logger log = Logger.getLogger(DefaultEvaluationPlan2.class);
    protected static final transient boolean DEBUG = log.isDebugEnabled();
    protected static final transient boolean INFO = log.isInfoEnabled();
    private final IRangeCountFactory rangeCountFactory;
    private final IRule rule;
    private final int tailCount;
    private static final transient long BOTH_OPTIONAL = 0x7FFFFFFFFFFFFFFEL;
    private static final transient long ONE_OPTIONAL = 0x7FFFFFFFFFFFFFFDL;
    private static final transient long NO_SHARED_VARS = 0x7FFFFFFFFFFFFFFCL;
    private int[] order;
    private long[] rangeCount;
    private transient boolean[] used;
    private boolean empty = false;

    @Override
    public int[] getOrder() {
        if (this.order == null) {
            throw new IllegalStateException();
        }
        return this.order;
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }

    public DefaultEvaluationPlan2(IJoinNexus joinNexus, IRule rule) {
        this(joinNexus.getRangeCountFactory(), rule);
    }

    public DefaultEvaluationPlan2(IRangeCountFactory rangeCountFactory, IRule rule) {
        if (rangeCountFactory == null) {
            throw new IllegalArgumentException();
        }
        if (rule == null) {
            throw new IllegalArgumentException();
        }
        this.rangeCountFactory = rangeCountFactory;
        this.rule = rule;
        this.tailCount = rule.getTailCount();
        if (DEBUG) {
            log.debug("rule=" + rule);
        }
        this.calc(rule);
        if (DEBUG) {
            for (int i = 0; i < this.tailCount; ++i) {
                log.debug(this.order[i]);
            }
        }
    }

    private void calc(IRule rule) {
        Iterator<IVariable<?>> it;
        int i;
        if (this.order != null) {
            return;
        }
        this.order = new int[this.tailCount];
        this.rangeCount = new long[this.tailCount];
        this.used = new boolean[this.tailCount];
        for (int i2 = 0; i2 < this.tailCount; ++i2) {
            this.order[i2] = -1;
            this.rangeCount[i2] = -1L;
            this.used[i2] = false;
        }
        if (this.tailCount == 1) {
            this.order[0] = 0;
            return;
        }
        HashSet runFirstVars = new HashSet();
        int startIndex = 0;
        for (i = 0; i < this.tailCount; ++i) {
            IPredicate pred = rule.getTail(i);
            IAccessPathExpander expander = pred.getAccessPathExpander();
            if (expander == null || !expander.runFirst()) continue;
            if (DEBUG) {
                log.debug("found a run first, tail " + i);
            }
            it = BOpUtility.getArgumentVariables(pred);
            while (it.hasNext()) {
                runFirstVars.add(it.next());
            }
            this.order[startIndex++] = i;
            this.used[i] = true;
        }
        if (startIndex == this.tailCount) {
            return;
        }
        if (startIndex == this.tailCount - 1) {
            if (DEBUG) {
                log.debug("one tail left");
            }
            for (i = 0; i < this.tailCount; ++i) {
                if (this.used[i]) continue;
                this.order[this.tailCount - 1] = i;
                this.used[i] = true;
                return;
            }
        }
        int preferredFirstTail = -1;
        for (int i3 = 0; i3 < this.tailCount; ++i3) {
            if (this.used[i3]) continue;
            IPredicate pred = rule.getTail(i3);
            it = BOpUtility.getArgumentVariables(pred);
            while (it.hasNext()) {
                if (!runFirstVars.contains(it.next())) continue;
                preferredFirstTail = i3;
            }
            if (preferredFirstTail != -1) break;
        }
        if (startIndex == this.tailCount - 2) {
            if (DEBUG) {
                log.debug("two tails left");
            }
            int t1 = -1;
            int t2 = -1;
            for (int i4 = 0; i4 < this.tailCount; ++i4) {
                if (this.used[i4]) continue;
                if (t1 == -1) {
                    t1 = i4;
                    continue;
                }
                t2 = i4;
                break;
            }
            if (DEBUG) {
                log.debug(t1 + ", " + t2);
            }
            if (preferredFirstTail != -1) {
                this.order[this.tailCount - 2] = preferredFirstTail;
                this.order[this.tailCount - 1] = preferredFirstTail == t1 ? t2 : t1;
            } else {
                this.order[this.tailCount - 2] = this.cardinality(t1) <= this.cardinality(t2) ? t1 : t2;
                this.order[this.tailCount - 1] = this.cardinality(t1) <= this.cardinality(t2) ? t2 : t1;
            }
            return;
        }
        Join join = preferredFirstTail == -1 ? this.getFirstJoin() : this.getFirstJoin(preferredFirstTail);
        int t1 = ((Tail)join.getD1()).getTail();
        int t2 = ((Tail)join.getD2()).getTail();
        if (preferredFirstTail == -1) {
            this.order[startIndex] = this.cardinality(t1) <= this.cardinality(t2) ? t1 : t2;
            this.order[startIndex + 1] = this.cardinality(t1) <= this.cardinality(t2) ? t2 : t1;
        } else {
            this.order[startIndex] = t1;
            this.order[startIndex + 1] = t2;
        }
        this.used[this.order[startIndex]] = true;
        this.used[this.order[startIndex + 1]] = true;
        for (int i5 = startIndex + 2; i5 < this.tailCount; ++i5) {
            join = this.getNextJoin(join);
            this.order[i5] = ((Tail)join.getD2()).getTail();
            this.used[this.order[i5]] = true;
        }
    }

    private Join getFirstJoin() {
        if (DEBUG) {
            log.debug("evaluating first join");
        }
        long minJoinCardinality = Long.MAX_VALUE;
        long minTailCardinality = Long.MAX_VALUE;
        long minOtherTailCardinality = Long.MAX_VALUE;
        Tail minT1 = null;
        Tail minT2 = null;
        for (int i = 0; i < this.tailCount; ++i) {
            if (this.used[i]) continue;
            Tail t1 = new Tail(i, this.rangeCount(i), this.getVars(i));
            long t1Cardinality = this.cardinality(i);
            for (int j = 0; j < this.tailCount; ++j) {
                if (i == j || this.used[j]) continue;
                Tail t2 = new Tail(j, this.rangeCount(j), this.getVars(j));
                long t2Cardinality = this.cardinality(j);
                long joinCardinality = this.computeJoinCardinality(t1, t2);
                long tailCardinality = Math.min(t1Cardinality, t2Cardinality);
                long otherTailCardinality = Math.max(t1Cardinality, t2Cardinality);
                if (DEBUG) {
                    log.debug("evaluating " + i + " X " + j + ": cardinality= " + joinCardinality);
                }
                if (joinCardinality < minJoinCardinality) {
                    if (DEBUG) {
                        log.debug("found a new min: " + joinCardinality);
                    }
                    minJoinCardinality = joinCardinality;
                    minTailCardinality = tailCardinality;
                    minOtherTailCardinality = otherTailCardinality;
                    minT1 = t1;
                    minT2 = t2;
                    continue;
                }
                if (joinCardinality != minJoinCardinality) continue;
                if (tailCardinality < minTailCardinality) {
                    if (DEBUG) {
                        log.debug("found a new min: " + joinCardinality);
                    }
                    minJoinCardinality = joinCardinality;
                    minTailCardinality = tailCardinality;
                    minOtherTailCardinality = otherTailCardinality;
                    minT1 = t1;
                    minT2 = t2;
                    continue;
                }
                if (tailCardinality != minTailCardinality || otherTailCardinality >= minOtherTailCardinality) continue;
                if (DEBUG) {
                    log.debug("found a new min: " + joinCardinality);
                }
                minJoinCardinality = joinCardinality;
                minTailCardinality = tailCardinality;
                minOtherTailCardinality = otherTailCardinality;
                minT1 = t1;
                minT2 = t2;
            }
        }
        HashSet<String> vars = new HashSet<String>();
        vars.addAll(minT1.getVars());
        vars.addAll(minT2.getVars());
        return new Join(minT1, minT2, minJoinCardinality, vars);
    }

    private Join getFirstJoin(int preferredFirstTail) {
        if (DEBUG) {
            log.debug("evaluating first join");
        }
        long minJoinCardinality = Long.MAX_VALUE;
        long minOtherTailCardinality = Long.MAX_VALUE;
        Tail minT2 = null;
        int i = preferredFirstTail;
        Tail t1 = new Tail(i, this.rangeCount(i), this.getVars(i));
        for (int j = 0; j < this.tailCount; ++j) {
            if (i == j || this.used[j]) continue;
            Tail t2 = new Tail(j, this.rangeCount(j), this.getVars(j));
            long t2Cardinality = this.cardinality(j);
            long joinCardinality = this.computeJoinCardinality(t1, t2);
            if (DEBUG) {
                log.debug("evaluating " + i + " X " + j + ": cardinality= " + joinCardinality);
            }
            if (joinCardinality < minJoinCardinality) {
                if (DEBUG) {
                    log.debug("found a new min: " + joinCardinality);
                }
                minJoinCardinality = joinCardinality;
                minOtherTailCardinality = t2Cardinality;
                minT2 = t2;
                continue;
            }
            if (joinCardinality != minJoinCardinality || t2Cardinality >= minOtherTailCardinality) continue;
            if (DEBUG) {
                log.debug("found a new min: " + joinCardinality);
            }
            minJoinCardinality = joinCardinality;
            minOtherTailCardinality = t2Cardinality;
            minT2 = t2;
        }
        HashSet<String> vars = new HashSet<String>();
        vars.addAll(t1.getVars());
        vars.addAll(minT2.getVars());
        return new Join(t1, minT2, minJoinCardinality, vars);
    }

    private Join getNextJoin(IJoinDimension d1) {
        long tailCardinality;
        Tail tail;
        int i;
        if (DEBUG) {
            log.debug("evaluating next join");
        }
        long minJoinCardinality = Long.MAX_VALUE;
        long minTailCardinality = Long.MAX_VALUE;
        Tail minTail = null;
        for (i = 0; i < this.tailCount; ++i) {
            if (this.used[i]) continue;
            tail = new Tail(i, this.rangeCount(i), this.getVars(i));
            tailCardinality = this.cardinality(i);
            long joinCardinality = this.computeJoinCardinality(d1, tail);
            if (DEBUG) {
                log.debug("evaluating " + d1.toJoinString() + " X " + i + ": cardinality= " + joinCardinality);
            }
            if (joinCardinality < minJoinCardinality) {
                if (DEBUG) {
                    log.debug("found a new min: " + joinCardinality);
                }
                minJoinCardinality = joinCardinality;
                minTailCardinality = tailCardinality;
                minTail = tail;
                continue;
            }
            if (joinCardinality != minJoinCardinality || tailCardinality >= minTailCardinality) continue;
            if (DEBUG) {
                log.debug("found a new min: " + joinCardinality);
            }
            minJoinCardinality = joinCardinality;
            minTailCardinality = tailCardinality;
            minTail = tail;
        }
        if (minJoinCardinality == 0x7FFFFFFFFFFFFFFCL) {
            minJoinCardinality = Long.MAX_VALUE;
            for (i = 0; i < this.tailCount; ++i) {
                if (this.used[i]) continue;
                tail = new Tail(i, this.rangeCount(i), this.getVars(i));
                tailCardinality = this.cardinality(i);
                if (tailCardinality >= minJoinCardinality) continue;
                if (DEBUG) {
                    log.debug("found a new min: " + tailCardinality);
                }
                minJoinCardinality = tailCardinality;
                minTail = tail;
            }
        }
        HashSet<String> vars = new HashSet<String>();
        vars.addAll(d1.getVars());
        vars.addAll(minTail.getVars());
        return new Join(d1, minTail, minJoinCardinality, vars);
    }

    @Override
    public long rangeCount(int tailIndex) {
        if (this.rangeCount[tailIndex] == -1L) {
            long rangeCount;
            IPredicate predicate = this.rule.getTail(tailIndex);
            IAccessPathExpander expander = predicate.getAccessPathExpander();
            if (expander != null && expander.runFirst()) {
                return -1L;
            }
            this.rangeCount[tailIndex] = rangeCount = this.rangeCountFactory.rangeCount(this.rule.getTail(tailIndex));
        }
        return this.rangeCount[tailIndex];
    }

    public long cardinality(int tailIndex) {
        IPredicate tail = this.rule.getTail(tailIndex);
        if (tail.isOptional() || tail instanceof IStarJoin) {
            return Long.MAX_VALUE;
        }
        return this.rangeCount(tailIndex);
    }

    public String toString() {
        return Arrays.toString(this.getOrder());
    }

    protected long computeJoinCardinality(IJoinDimension d1, IJoinDimension d2) {
        if (d1.isOptional() && d2.isOptional()) {
            return 0x7FFFFFFFFFFFFFFEL;
        }
        if (d1.isOptional() || d2.isOptional()) {
            return 0x7FFFFFFFFFFFFFFDL;
        }
        boolean sharedVars = this.hasSharedVars(d1, d2);
        boolean unsharedVars = this.hasUnsharedVars(d1, d2);
        long joinCardinality = !sharedVars ? 0x7FFFFFFFFFFFFFFCL : (!unsharedVars ? Math.min(d1.getCardinality(), d2.getCardinality()) : Math.min(d1.getCardinality(), d2.getCardinality()));
        return joinCardinality;
    }

    protected Set<String> getVars(int tail) {
        HashSet<String> vars = new HashSet<String>();
        IPredicate pred = this.rule.getTail(tail);
        for (int i = 0; i < pred.arity(); ++i) {
            IVariableOrConstant term = pred.get(i);
            if (!term.isVar()) continue;
            vars.add(term.getName());
        }
        return vars;
    }

    protected boolean hasSharedVars(IJoinDimension d1, IJoinDimension d2) {
        for (String var : d1.getVars()) {
            if (!d2.getVars().contains(var)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasUnsharedVars(IJoinDimension d1, IJoinDimension d2) {
        for (String var : d1.getVars()) {
            if (d2.getVars().contains(var)) continue;
            return true;
        }
        for (String var : d2.getVars()) {
            if (d1.getVars().contains(var)) continue;
            return true;
        }
        return false;
    }

    private class Tail
    implements IJoinDimension {
        private final int tail;
        private final long cardinality;
        private final Set<String> vars;

        public Tail(int tail, long cardinality, Set<String> vars) {
            this.tail = tail;
            this.cardinality = cardinality;
            this.vars = vars;
        }

        public int getTail() {
            return this.tail;
        }

        @Override
        public long getCardinality() {
            return this.cardinality;
        }

        @Override
        public Set<String> getVars() {
            return this.vars;
        }

        @Override
        public boolean isOptional() {
            return DefaultEvaluationPlan2.this.rule.getTail(this.tail).isOptional();
        }

        @Override
        public String toJoinString() {
            return String.valueOf(this.tail);
        }
    }

    private static class Join
    implements IJoinDimension {
        private final IJoinDimension d1;
        private final IJoinDimension d2;
        private final long cardinality;
        private final Set<String> vars;

        public Join(IJoinDimension d1, IJoinDimension d2, long cardinality, Set<String> vars) {
            this.d1 = d1;
            this.d2 = d2;
            this.cardinality = cardinality;
            this.vars = vars;
        }

        public IJoinDimension getD1() {
            return this.d1;
        }

        public IJoinDimension getD2() {
            return this.d2;
        }

        @Override
        public Set<String> getVars() {
            return this.vars;
        }

        @Override
        public long getCardinality() {
            return this.cardinality;
        }

        @Override
        public boolean isOptional() {
            return false;
        }

        @Override
        public String toJoinString() {
            return this.d1.toJoinString() + " X " + this.d2.toJoinString();
        }
    }

    private static interface IJoinDimension {
        public long getCardinality();

        public Set<String> getVars();

        public String toJoinString();

        public boolean isOptional();
    }
}

