/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.rdf.join;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.NV;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.NotMaterializedException;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.apache.log4j.Logger;

public class InlineMaterializeOp<E>
extends PipelineOp {
    private static final long serialVersionUID = 3371029059242171846L;
    private static final transient Logger log = Logger.getLogger(InlineMaterializeOp.class);

    public InlineMaterializeOp(InlineMaterializeOp<E> op) {
        super(op);
    }

    public InlineMaterializeOp(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
    }

    public InlineMaterializeOp(BOp[] args, NV ... anns) {
        super(args, NV.asMap(anns));
    }

    public IPredicate<E> getPredicate() {
        return (IPredicate)this.getRequiredProperty(Annotations.PREDICATE);
    }

    @Override
    public FutureTask<Void> eval(BOpContext<IBindingSet> context) {
        return new FutureTask<Void>(new MaterializeTask(this, context));
    }

    private static class MaterializeTask
    implements Callable<Void> {
        private final BOpStats stats;
        private final IVariable<IV> v;
        private final LexiconRelation lex;
        private final ICloseableIterator<IBindingSet[]> source;
        private final IBlockingBuffer<IBindingSet[]> sink;

        MaterializeTask(InlineMaterializeOp op, BOpContext<IBindingSet> context) {
            this.stats = context.getStats();
            IPredicate predicate = op.getPredicate();
            if (predicate == null) {
                throw new IllegalArgumentException();
            }
            this.v = (IVariable)predicate.get(1);
            this.lex = (LexiconRelation)context.getRelation(predicate);
            this.source = context.getSource();
            this.sink = context.getSink();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("starting inline materialization");
                }
                while (this.source.hasNext()) {
                    IBindingSet[] chunk = (IBindingSet[])this.source.next();
                    if (log.isDebugEnabled()) {
                        log.debug("chunk length: " + chunk.length);
                    }
                    this.stats.chunksIn.increment();
                    this.stats.unitsIn.add(chunk.length);
                    IBindingSet[] def = new IBindingSet[chunk.length];
                    int ndef = 0;
                    boolean nalt = false;
                    for (int i = 0; i < chunk.length; ++i) {
                        IBindingSet bset = chunk[i];
                        IV iv = (IV)this.v.get(bset);
                        if (log.isDebugEnabled()) {
                            log.debug("materializing: " + iv);
                        }
                        if (iv == null || !iv.isInline()) continue;
                        iv.asValue(this.lex);
                        if (!iv.hasValue()) {
                            throw new NotMaterializedException();
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("value: " + iv.getValue());
                        }
                        def[ndef++] = bset;
                    }
                    if (ndef <= 0) continue;
                    if (ndef == def.length) {
                        this.sink.add(def);
                        continue;
                    }
                    this.sink.add(Arrays.copyOf(def, ndef));
                }
                this.sink.flush();
                Void void_ = null;
                return void_;
            }
            finally {
                this.sink.close();
                if (log.isDebugEnabled()) {
                    log.debug("finished inline materialization");
                }
            }
        }
    }

    public static interface Annotations
    extends PipelineOp.Annotations {
        public static final String PREDICATE = InlineMaterializeOp.class.getName() + ".predicate";
    }
}

