/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.rdf.update;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.ILocatableResourceAnnotations;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.PipelineOp;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.apache.log4j.Logger;
import org.openrdf.model.Value;

public class ChunkedResolutionOp
extends PipelineOp {
    private static final transient Logger log = Logger.getLogger(ChunkedResolutionOp.class);
    private static final long serialVersionUID = 1L;

    public ChunkedResolutionOp(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
    }

    public ChunkedResolutionOp(ChunkedResolutionOp op) {
        super(op);
    }

    @Override
    public FutureTask<Void> eval(BOpContext<IBindingSet> context) {
        return new FutureTask<Void>(new ChunkTask(context, this));
    }

    private static class ChunkTask
    implements Callable<Void> {
        private final BOpContext<IBindingSet> context;
        private final LexiconRelation lex;
        private final boolean readOnly;
        private final IVariable<?>[] vars;

        public ChunkTask(BOpContext<IBindingSet> context, ChunkedResolutionOp op) {
            this.context = context;
            String namespace = ((String[])op.getRequiredProperty(Annotations.RELATION_NAME))[0];
            long timestamp = (Long)op.getRequiredProperty(Annotations.TIMESTAMP);
            this.lex = (LexiconRelation)context.getResource(namespace, timestamp);
            this.readOnly = TimestampUtility.isReadOnly(timestamp);
            this.vars = (IVariable[])op.getProperty(Annotations.VARS);
        }

        @Override
        public Void call() throws Exception {
            IBindingSet[] a = BOpUtility.toArray(this.context.getSource(), this.context.getStats());
            IBindingSet[] b = this.resolve(a);
            this.context.getSink().add(b);
            this.context.getSink().flush();
            return null;
        }

        private IBindingSet[] resolve(IBindingSet[] bindingSets) {
            IV iv;
            LinkedHashMap values = new LinkedHashMap();
            BigdataValueFactory valueFactory = this.lex.getValueFactory();
            for (IBindingSet bindings : bindingSets) {
                if (this.vars == null) {
                    Iterator<Map.Entry<IVariable, IConstant>> it = bindings.iterator();
                    while (it.hasNext()) {
                        Map.Entry<IVariable, IConstant> e = it.next();
                        IV iv2 = (IV)e.getValue().get();
                        Object val = iv2.getValue();
                        values.put(val, valueFactory.asValue((Value)val));
                    }
                    continue;
                }
                for (IVariable<?> var : this.vars) {
                    IConstant iConstant = bindings.get(var);
                    if (iConstant == null) continue;
                    iv = (IV)iConstant.get();
                    Object val = iv.getValue();
                    values.put(val, valueFactory.asValue((Value)val));
                }
            }
            BigdataValue[] terms = values.values().toArray(new BigdataValue[0]);
            long ndistinct = this.lex.addTerms(terms, terms.length, this.readOnly);
            long mutationCount = !this.readOnly ? ndistinct : 0L;
            for (BigdataValue bigdataValue : terms) {
                iv = bigdataValue.getIV();
                if (iv == null) {
                    if (log.isInfoEnabled()) {
                        log.info("Not in knowledge base: " + bigdataValue);
                    }
                    TermId<?> dummy = TermId.mockIV(VTE.valueOf(bigdataValue));
                    bigdataValue.setIV(dummy);
                    dummy.setValue(bigdataValue);
                    continue;
                }
                iv.setValue(bigdataValue);
            }
            IBindingSet[] bindingSets2 = new IBindingSet[bindingSets.length];
            for (int i = 0; i < bindingSets.length; ++i) {
                IBindingSet bindingSet = bindingSets2[i] = bindingSets[i].clone();
                if (this.vars == null) {
                    Iterator<Map.Entry<IVariable, IConstant>> it = bindingSet.iterator();
                    while (it.hasNext()) {
                        Map.Entry<IVariable, IConstant> e = it.next();
                        IV iv3 = (IV)e.getValue().get();
                        Object v = iv3.getValue();
                        BigdataValue val2 = (BigdataValue)values.get(v);
                        assert (this.readOnly || val2 != null) : "value not found: " + val2;
                        if (log.isDebugEnabled()) {
                            log.debug("value: " + v + " : " + val2 + " (" + val2.getIV() + ")");
                        }
                        bindingSet.set(e.getKey(), new Constant<IV>(val2.getIV()));
                    }
                    continue;
                }
                for (Serializable serializable : this.vars) {
                    IConstant c = bindingSet.get((IVariable)serializable);
                    if (c == null) continue;
                    IV iv4 = (IV)c.get();
                    Object val = iv4.getValue();
                    BigdataValue val2 = (BigdataValue)values.get(val);
                    assert (this.readOnly || val2 != null) : "value not found: " + val2;
                    assert (val2.getIV() == val2);
                    if (log.isDebugEnabled()) {
                        log.debug("value: " + val + " : " + val2 + " (" + val2.getIV() + ")");
                    }
                    bindingSet.set((IVariable)serializable, new Constant<IV>(val2.getIV()));
                }
            }
            if (mutationCount != 0L) {
                this.context.getStats().mutationCount.add(mutationCount);
            }
            return bindingSets2;
        }
    }

    public static interface Annotations
    extends PipelineOp.Annotations,
    ILocatableResourceAnnotations {
        public static final String VARS = ChunkedResolutionOp.class.getName() + ".vars";
    }
}

