/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.solutions;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IBind;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.IValueExpressionConstraint;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.aggregate.IAggregate;
import com.bigdata.bop.solutions.IGroupByState;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

public class GroupByState
implements IGroupByState,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(GroupByState.class);
    private final IValueExpression<?>[] select;
    private final IValueExpression<?>[] groupBy;
    private final IConstraint[] having;
    private final LinkedHashSet<IVariable<?>> groupByVars = new LinkedHashSet();
    private final LinkedHashSet<IVariable<?>> selectVars = new LinkedHashSet();
    private final LinkedHashSet<IVariable<?>> columnVars = new LinkedHashSet();
    private final boolean anyDistinct;
    private final boolean selectDependency;
    private final boolean nestedAggregates;
    private final boolean simpleHaving;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{select=" + Arrays.toString(this.select));
        sb.append(",groupBy=" + Arrays.toString(this.groupBy));
        sb.append(",having=" + Arrays.toString(this.having));
        sb.append("}");
        return sb.toString();
    }

    @Override
    public IValueExpression<?>[] getGroupByClause() {
        return this.groupBy;
    }

    @Override
    public LinkedHashSet<IVariable<?>> getGroupByVars() {
        return this.groupByVars;
    }

    @Override
    public IValueExpression<?>[] getSelectClause() {
        return this.select;
    }

    @Override
    public LinkedHashSet<IVariable<?>> getSelectVars() {
        return this.selectVars;
    }

    @Override
    public IConstraint[] getHavingClause() {
        return this.having;
    }

    @Override
    public LinkedHashSet<IVariable<?>> getColumnVars() {
        return this.columnVars;
    }

    @Override
    public boolean isAnyDistinct() {
        return this.anyDistinct;
    }

    @Override
    public boolean isSelectDependency() {
        return this.selectDependency;
    }

    @Override
    public boolean isNestedAggregates() {
        return this.nestedAggregates;
    }

    @Override
    public boolean isSimpleHaving() {
        return this.simpleHaving;
    }

    public GroupByState(IValueExpression<?>[] select, IValueExpression<?>[] groupBy, IConstraint[] having) {
        this.groupBy = groupBy != null && groupBy.length == 0 ? null : groupBy;
        this.select = select;
        if (select == null) {
            throw new IllegalArgumentException();
        }
        if (select.length == 0) {
            throw new IllegalArgumentException();
        }
        this.having = having != null && having.length == 0 ? null : having;
        AtomicBoolean anyDistinct = new AtomicBoolean(false);
        AtomicBoolean nestedAggregates = new AtomicBoolean(false);
        if (groupBy != null) {
            for (IValueExpression<?> expr : groupBy) {
                if (expr instanceof IVariable) {
                    this.groupByVars.add((IVariable)expr);
                    continue;
                }
                if (!(expr instanceof IBind)) continue;
                IBind iBind = (IBind)expr;
                IValueExpression e = iBind.getExpr();
                if (this.isAggregate(e, false, null, nestedAggregates, anyDistinct)) {
                    throw new IllegalArgumentException("Aggregate expression not allowed in GROUP_BY: " + expr);
                }
                this.groupByVars.add(iBind.getVar());
            }
        }
        AtomicBoolean selectDependency = new AtomicBoolean(false);
        for (IValueExpression<?> iValueExpression : select) {
            if (iValueExpression instanceof IVariable) {
                IVariable var = (IVariable)iValueExpression;
                if (!this.groupByVars.contains(var)) {
                    throw new IllegalArgumentException("Bare variable not declared by GROUP_BY clause: " + var);
                }
                this.selectVars.add(var);
                continue;
            }
            if (iValueExpression instanceof IBind) {
                IBind bindExpr = (IBind)iValueExpression;
                IValueExpression e = bindExpr.getExpr();
                if (!this.isAggregate(e, true, selectDependency, nestedAggregates, anyDistinct)) {
                    throw new IllegalArgumentException("Not an aggregate: " + bindExpr);
                }
                this.selectVars.add(bindExpr.getVar());
                continue;
            }
            throw new IllegalArgumentException("Top-level of SELECT expression must be IVariable or IBind: " + iValueExpression);
        }
        this.selectDependency = selectDependency.get();
        boolean simpleHaving = true;
        if (having != null) {
            block2: for (BOp bOp : having) {
                if (!this.isAggregate(bOp, false, null, nestedAggregates, anyDistinct)) {
                    throw new IllegalArgumentException("Not an aggregate: " + bOp);
                }
                if (!simpleHaving) continue;
                IValueExpression expr = ((IValueExpressionConstraint)bOp).getValueExpression();
                Iterator<BOp> itr = BOpUtility.preOrderIterator(expr);
                while (itr.hasNext()) {
                    BOp t = itr.next();
                    if (!(t instanceof IAggregate)) continue;
                    simpleHaving = false;
                    continue block2;
                }
            }
        }
        this.simpleHaving = simpleHaving;
        this.nestedAggregates = nestedAggregates.get();
        this.anyDistinct = anyDistinct.get();
    }

    protected boolean isAggregate(BOp op, boolean isSelectClause, AtomicBoolean isSelectDependency, AtomicBoolean isNestedAggregates, AtomicBoolean isAnyDistinct) {
        if (op == null) {
            throw new IllegalArgumentException();
        }
        if (op instanceof IConstant && isSelectClause) {
            return true;
        }
        return this.isAggregate(op, isSelectClause, isSelectDependency, isNestedAggregates, isAnyDistinct, false);
    }

    private boolean isAggregate(BOp op, boolean isSelectClause, AtomicBoolean isSelectDependency, AtomicBoolean isNestedAggregates, AtomicBoolean isAnyDistinct, boolean withinAggregateFunction) {
        boolean aggregationContext;
        if (op instanceof IAggregate) {
            if (withinAggregateFunction) {
                isNestedAggregates.set(true);
            }
            if (((IAggregate)op).isDistinct()) {
                isAnyDistinct.set(true);
            }
        }
        boolean isAggregate = aggregationContext = withinAggregateFunction || op instanceof IAggregate;
        BOp t = op;
        if (t instanceof IVariable) {
            IVariable v = (IVariable)t;
            if (aggregationContext) {
                if (!this.groupByVars.contains(v) && !this.selectVars.contains(v)) {
                    this.columnVars.add(v);
                }
                return false;
            }
            if (this.groupByVars.contains(v)) {
                isAggregate = true;
                return true;
            }
            if (this.selectVars.contains(v)) {
                if (isSelectClause) {
                    isSelectDependency.set(true);
                }
                isAggregate = true;
                return true;
            }
            if (isSelectClause) {
                throw new IllegalArgumentException("Non-aggregate variable in select expression: " + v);
            }
        }
        Iterator<BOp> itr = op.argIterator();
        while (itr.hasNext()) {
            BOp arg = itr.next();
            if (!(arg instanceof IValueExpression)) continue;
            if (log.isTraceEnabled()) {
                log.trace("op=" + op.getClass() + ", isSelectClause=" + isSelectClause + ", isSelectDependency=" + isSelectDependency + ", isNestedAggregates=" + isNestedAggregates + ", isAnyDistinct=" + isAnyDistinct + ", withinAggregateFunction=" + withinAggregateFunction + ", aggregationContext=" + aggregationContext + ", groupByVars=" + this.groupByVars + ", selectVars=" + this.selectVars + ", arg=" + arg);
            }
            isAggregate |= this.isAggregate(arg, isSelectClause, isSelectDependency, isNestedAggregates, isAnyDistinct, aggregationContext);
        }
        return isAggregate;
    }
}

