/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.solutions;

import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.impl.literal.LiteralExtensionIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import info.aduna.lang.ObjectUtil;
import java.io.Serializable;
import java.util.Comparator;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.query.algebra.Compare;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.util.QueryEvaluationUtil;

public class IVComparator
implements Comparator<IV>,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public int compare(IV o1, IV o2) {
        if (ObjectUtil.nullEquals(o1, o2)) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        boolean b1 = o1.isBNode();
        boolean b2 = o2.isBNode();
        if (b1 && b2) {
            return this.compareBNodes(o1, o2);
        }
        if (b1) {
            return -1;
        }
        if (b2) {
            return 1;
        }
        boolean s1 = o1.isStatement();
        boolean s2 = o2.isStatement();
        if (s1 && s2) {
            return this.compareSIDs(o1, o2);
        }
        if (s1) {
            return -1;
        }
        if (s2) {
            return 1;
        }
        boolean u1 = o1.isURI();
        boolean u2 = o2.isURI();
        if (u1 && u2) {
            return this.compareURIs((URI)((Object)o1), (URI)((Object)o2));
        }
        if (u1) {
            return -1;
        }
        if (u2) {
            return 1;
        }
        return this.compareLiterals(o1, o2);
    }

    private int compareBNodes(IV leftBNode, IV rightBNode) {
        return leftBNode.compareTo(rightBNode);
    }

    private int compareSIDs(IV leftSid, IV rightSid) {
        return leftSid.compareTo(rightSid);
    }

    private int compareURIs(URI leftURI, URI rightURI) {
        return leftURI.stringValue().compareTo(rightURI.stringValue());
    }

    private int compareLiterals(IV<BigdataLiteral, ?> left, IV<BigdataLiteral, ?> right) {
        IV<BigdataURI, ?> rightDatatype;
        IV<BigdataURI, ?> leftDatatype;
        if (left instanceof LiteralExtensionIV && right instanceof LiteralExtensionIV && (leftDatatype = ((LiteralExtensionIV)left).getExtensionIV()).equals(rightDatatype = ((LiteralExtensionIV)right).getExtensionIV())) {
            return left.compareTo(right);
        }
        return this.compareLiterals((Literal)((Object)left), (Literal)((Object)right));
    }

    private int compareLiterals(Literal leftLit, Literal rightLit) {
        if (!QueryEvaluationUtil.isStringLiteral(leftLit) || !QueryEvaluationUtil.isStringLiteral(rightLit)) {
            try {
                boolean isSmaller = QueryEvaluationUtil.compareLiterals(leftLit, rightLit, Compare.CompareOp.LT);
                if (isSmaller) {
                    return -1;
                }
                return 1;
            }
            catch (ValueExprEvaluationException e) {
                // empty catch block
            }
        }
        int result = 0;
        URI leftDatatype = leftLit.getDatatype();
        URI rightDatatype = rightLit.getDatatype();
        if (leftDatatype != null) {
            result = rightDatatype != null ? this.compareDatatypes(leftDatatype, rightDatatype) : 1;
        } else if (rightDatatype != null) {
            result = -1;
        }
        if (result == 0) {
            String leftLanguage = leftLit.getLanguage();
            String rightLanguage = rightLit.getLanguage();
            if (leftLanguage != null) {
                result = rightLanguage != null ? leftLanguage.compareTo(rightLanguage) : 1;
            } else if (rightLanguage != null) {
                result = -1;
            }
        }
        if (result == 0) {
            result = leftLit.getLabel().compareTo(rightLit.getLabel());
        }
        return result;
    }

    private int compareDatatypes(URI leftDatatype, URI rightDatatype) {
        if (XMLDatatypeUtil.isNumericDatatype(leftDatatype)) {
            if (XMLDatatypeUtil.isNumericDatatype(rightDatatype)) {
                return this.compareURIs(leftDatatype, rightDatatype);
            }
            return -1;
        }
        if (XMLDatatypeUtil.isNumericDatatype(rightDatatype)) {
            return 1;
        }
        if (XMLDatatypeUtil.isCalendarDatatype(leftDatatype)) {
            if (XMLDatatypeUtil.isCalendarDatatype(rightDatatype)) {
                return this.compareURIs(leftDatatype, rightDatatype);
            }
            return -1;
        }
        if (XMLDatatypeUtil.isCalendarDatatype(rightDatatype)) {
            return 1;
        }
        return this.compareURIs(leftDatatype, rightDatatype);
    }
}

