/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.solutions;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.ConcurrentHashMapAnnotations;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IQueryAttributes;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.NV;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.bop.join.IDistinctFilter;
import com.bigdata.bop.join.JVMDistinctFilter;
import com.bigdata.bop.solutions.DistinctAnnotations;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import com.bigdata.relation.accesspath.UnsyncLocalOutputBuffer;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public class JVMDistinctBindingSetsOp
extends PipelineOp {
    private static final long serialVersionUID = 1L;

    public JVMDistinctBindingSetsOp(JVMDistinctBindingSetsOp op) {
        super(op);
    }

    public JVMDistinctBindingSetsOp(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
        switch (this.getEvaluationContext()) {
            case CONTROLLER: 
            case HASHED: {
                break;
            }
            default: {
                throw new UnsupportedOperationException(Annotations.EVALUATION_CONTEXT + "=" + (Object)((Object)this.getEvaluationContext()));
            }
        }
        if (!this.isSharedState()) {
            throw new UnsupportedOperationException(Annotations.SHARED_STATE + "=" + this.isSharedState());
        }
        IVariable[] vars = (IVariable[])this.getProperty(Annotations.VARIABLES);
        if (vars == null) {
            throw new IllegalArgumentException();
        }
    }

    public JVMDistinctBindingSetsOp(BOp[] args, NV ... annotations) {
        this(args, NV.asMap(annotations));
    }

    public int getInitialCapacity() {
        return this.getProperty(Annotations.INITIAL_CAPACITY, 16);
    }

    public float getLoadFactor() {
        return this.getProperty(Annotations.LOAD_FACTOR, Float.valueOf(0.75f)).floatValue();
    }

    public int getConcurrencyLevel() {
        return this.getProperty(Annotations.CONCURRENCY_LEVEL, 16);
    }

    public IVariable<?>[] getVariables() {
        return (IVariable[])this.getRequiredProperty(Annotations.VARIABLES);
    }

    @Override
    public FutureTask<Void> eval(BOpContext<IBindingSet> context) {
        return new FutureTask<Void>(new DistinctTask(this, context));
    }

    private static class DistinctTask
    implements Callable<Void> {
        private final BOpContext<IBindingSet> context;
        private final IDistinctFilter filter;
        private final int chunkCapacity;

        DistinctTask(JVMDistinctBindingSetsOp op, BOpContext<IBindingSet> context) {
            IDistinctFilter tmp;
            this.context = context;
            this.chunkCapacity = op.getChunkCapacity();
            IVariable<?>[] vars = op.getVariables();
            Integer key = op.getId();
            IQueryAttributes attribs = context.getRunningQuery().getAttributes();
            IDistinctFilter filter = (IDistinctFilter)attribs.get(key);
            if (filter == null && (tmp = (IDistinctFilter)attribs.putIfAbsent(key, filter = new JVMDistinctFilter(vars, op.getInitialCapacity(), op.getLoadFactor(), op.getConcurrencyLevel()))) != null) {
                filter = tmp;
            }
            this.filter = filter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            BOpStats stats = this.context.getStats();
            ICloseableIterator<IBindingSet[]> itr = this.context.getSource();
            IBlockingBuffer<IBindingSet[]> sink = this.context.getSink();
            try {
                UnsyncLocalOutputBuffer<IBindingSet> unsyncBuffer = new UnsyncLocalOutputBuffer<IBindingSet>(this.chunkCapacity, sink);
                this.filter.filterSolutions(itr, stats, unsyncBuffer);
                unsyncBuffer.flush();
                sink.flush();
                Void void_ = null;
                return void_;
            }
            finally {
                if (this.context.isLastInvocation()) {
                    this.filter.release();
                }
                sink.close();
            }
        }
    }

    public static interface Annotations
    extends PipelineOp.Annotations,
    ConcurrentHashMapAnnotations,
    DistinctAnnotations {
    }
}

