/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.solutions;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.Constant;
import com.bigdata.bop.ContextBindingSet;
import com.bigdata.bop.HashMapAnnotations;
import com.bigdata.bop.IBind;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.aggregate.IAggregate;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.bop.solutions.GroupByOp;
import com.bigdata.bop.solutions.IGroupByRewriteState;
import com.bigdata.bop.solutions.IGroupByState;
import com.bigdata.bop.solutions.TypeErrorLog;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import com.bigdata.util.InnerCause;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.apache.log4j.Logger;

public class MemoryGroupByOp
extends GroupByOp {
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MemoryGroupByOp.class);

    @Override
    public final boolean isPipelinedAggregationOp() {
        return false;
    }

    public MemoryGroupByOp(MemoryGroupByOp op) {
        super(op);
    }

    public MemoryGroupByOp(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
        switch (this.getEvaluationContext()) {
            case CONTROLLER: {
                break;
            }
            default: {
                throw new UnsupportedOperationException(Annotations.EVALUATION_CONTEXT + "=" + (Object)((Object)this.getEvaluationContext()));
            }
        }
        this.assertAtOnceJavaHeapOp();
        this.getRequiredProperty(Annotations.GROUP_BY_STATE);
        this.getRequiredProperty(Annotations.GROUP_BY_REWRITE);
    }

    public int getInitialCapacity() {
        return this.getProperty(Annotations.INITIAL_CAPACITY, 16);
    }

    public float getLoadFactor() {
        return this.getProperty(Annotations.LOAD_FACTOR, Float.valueOf(0.75f)).floatValue();
    }

    @Override
    public FutureTask<Void> eval(BOpContext<IBindingSet> context) {
        return new FutureTask<Void>(new GroupByTask(this, context));
    }

    private static void doAggregate(IAggregate<?> expr, IVariable<?> var, boolean selectDependency, IBindingSet aggregates, Iterable<IBindingSet> solutions, BOpStats stats) {
        try {
            Constant c = null;
            if (expr.isWildcard() && expr.isDistinct()) {
                LinkedHashSet<IBindingSet> set = new LinkedHashSet<IBindingSet>();
                expr.reset();
                for (IBindingSet bset : solutions) {
                    if (!set.add(bset)) continue;
                    if (selectDependency) {
                        MemoryGroupByOp.propagateAggregateBindings(aggregates, bset);
                    }
                    expr.get(bset);
                }
                Object result = expr.done();
                if (result != null) {
                    c = new Constant(result);
                }
            } else if (expr.isDistinct()) {
                LinkedHashSet<Solution> set = new LinkedHashSet<Solution>();
                expr.reset();
                for (IBindingSet bset : solutions) {
                    Object[] constants = new Object[expr.arity()];
                    for (int i = 0; i < expr.arity(); ++i) {
                        constants[i] = ((IValueExpression)expr.get(i)).get(bset);
                    }
                    Solution sol = new Solution(constants);
                    if (!set.add(sol)) continue;
                    if (selectDependency) {
                        MemoryGroupByOp.propagateAggregateBindings(aggregates, bset);
                    }
                    expr.get(bset);
                }
                Object result = expr.done();
                if (result != null) {
                    c = new Constant(result);
                }
            } else {
                expr.reset();
                for (IBindingSet bset : solutions) {
                    if (selectDependency) {
                        MemoryGroupByOp.propagateAggregateBindings(aggregates, bset);
                    }
                    expr.get(bset);
                }
                Object result = expr.done();
                if (result != null) {
                    c = new Constant(result);
                }
            }
            if (c != null) {
                aggregates.set(var, c);
            }
        }
        catch (Throwable t) {
            if (InnerCause.isInnerCause(t, SparqlTypeErrorException.class)) {
                TypeErrorLog.handleTypeError(t, expr, stats);
                return;
            }
            throw new RuntimeException(t);
        }
    }

    private static void propagateAggregateBindings(IBindingSet aggregates, IBindingSet bset) {
        Iterator<Map.Entry<IVariable, IConstant>> itr = aggregates.iterator();
        while (itr.hasNext()) {
            Map.Entry<IVariable, IConstant> e = itr.next();
            bset.set(e.getKey(), e.getValue());
        }
    }

    private static class Solution
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int hash;
        private final Object[] vals;

        public Solution(Object[] vals) {
            this.vals = vals;
            this.hash = Arrays.hashCode(vals);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Solution)) {
                return false;
            }
            Solution t = (Solution)o;
            if (this.vals.length != t.vals.length) {
                return false;
            }
            for (int i = 0; i < this.vals.length; ++i) {
                if (this.vals[i] == t.vals[i]) continue;
                if (this.vals[i] == null) {
                    return false;
                }
                if (this.vals[i].equals(t.vals[i])) continue;
                return false;
            }
            return true;
        }
    }

    private static class GroupByTask
    implements Callable<Void> {
        private final BOpContext<IBindingSet> context;
        private final LinkedHashMap<SolutionGroup, SolutionMultiSet> map;
        private final IGroupByState groupByState;
        private final IGroupByRewriteState rewrite;
        private final IValueExpression<?>[] groupBy;
        private final BOpStats stats;

        GroupByTask(MemoryGroupByOp op, BOpContext<IBindingSet> context) {
            this.context = context;
            this.stats = context.getStats();
            this.groupByState = (IGroupByState)op.getRequiredProperty(Annotations.GROUP_BY_STATE);
            this.rewrite = (IGroupByRewriteState)op.getRequiredProperty(Annotations.GROUP_BY_REWRITE);
            this.groupBy = this.groupByState.getGroupByClause();
            this.map = this.groupBy == null ? null : new LinkedHashMap(op.getInitialCapacity(), op.getLoadFactor());
        }

        private void accept(IBindingSet bset) {
            if (this.groupBy == null || this.groupBy.length == 0) {
                throw new IllegalArgumentException();
            }
            if (bset == null) {
                throw new IllegalArgumentException();
            }
            SolutionGroup s = SolutionGroup.newInstance(this.groupBy, bset, this.stats);
            assert (s != null);
            SolutionMultiSet m = this.map.get(s);
            if (m == null) {
                m = new SolutionMultiSet();
                this.map.put(s, m);
            }
            if (log.isTraceEnabled()) {
                log.trace("Accepting solution: " + bset);
            }
            m.add(bset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            ICloseableIterator<IBindingSet[]> itr = this.context.getSource();
            try (IBlockingBuffer<IBindingSet[]> sink = this.context.getSink();){
                LinkedList<IBindingSet> accepted = new LinkedList<IBindingSet>();
                int naccepted = 0;
                if (this.groupBy == null) {
                    SolutionMultiSet m = new SolutionMultiSet();
                    while (itr.hasNext()) {
                        IBindingSet[] a = (IBindingSet[])itr.next();
                        this.stats.chunksIn.increment();
                        this.stats.unitsIn.add(a.length);
                        for (IBindingSet bset : a) {
                            m.add(bset);
                        }
                    }
                    IBindingSet bset = this.aggregate(m.solutions);
                    if (bset != null) {
                        if (log.isDebugEnabled()) {
                            log.debug("output: solution=" + bset);
                        }
                        accepted.add(bset);
                        ++naccepted;
                    } else if (log.isDebugEnabled()) {
                        log.debug("output : no solution.");
                    }
                } else {
                    while (itr.hasNext()) {
                        IBindingSet[] a = (IBindingSet[])itr.next();
                        this.stats.chunksIn.increment();
                        this.stats.unitsIn.add(a.length);
                        for (IBindingSet bset : a) {
                            this.accept(bset);
                        }
                    }
                    for (Map.Entry<SolutionGroup, SolutionMultiSet> e : this.map.entrySet()) {
                        SolutionMultiSet m = e.getValue();
                        IBindingSet bset = this.aggregate(m.solutions);
                        if (bset != null) {
                            if (log.isDebugEnabled()) {
                                log.debug("output: groupBy=" + e.getKey() + ", solution=" + bset);
                            }
                            accepted.add(bset);
                            ++naccepted;
                            continue;
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug("output: groupBy=" + e.getKey() + " : dropped.");
                    }
                    this.map.clear();
                }
                if (naccepted > 0) {
                    IBindingSet[] b = accepted.toArray(new IBindingSet[naccepted]);
                    sink.add(b);
                    sink.flush();
                }
                Void void_ = null;
                return void_;
            }
        }

        private IBindingSet aggregate(Iterable<IBindingSet> solutions) {
            IBindingSet out;
            ContextBindingSet aggregates = new ContextBindingSet(this.context, new ListBindingSet());
            if (this.groupBy != null) {
                IBindingSet aSolution = solutions.iterator().next();
                for (IValueExpression<?> expr : this.groupBy) {
                    if (expr instanceof IVariable) {
                        IVariable var = (IVariable)expr;
                        Object varValue = var.get(aSolution);
                        Constant val = varValue == null ? Constant.errorValue() : new Constant(varValue.getClass().cast(varValue));
                        aggregates.set(var, val);
                        continue;
                    }
                    if (!(expr instanceof IBind)) continue;
                    IBind bindExpr = (IBind)expr;
                    Object exprValue = bindExpr.get(aSolution);
                    Constant val = exprValue == null ? Constant.errorValue() : new Constant(exprValue.getClass().cast(exprValue));
                    IVariable ovar = ((IBind)expr).getVar();
                    aggregates.set(ovar, val);
                }
            }
            boolean nestedAggregates = this.groupByState.isNestedAggregates();
            for (Map.Entry<IAggregate<?>, IVariable<?>> e : this.rewrite.getAggExpr().entrySet()) {
                MemoryGroupByOp.doAggregate(e.getKey(), e.getValue(), nestedAggregates, aggregates, solutions, this.stats);
            }
            if (log.isTraceEnabled()) {
                log.trace("aggregates: " + aggregates);
            }
            for (IValueExpression<?> expr : this.rewrite.getSelect2()) {
                try {
                    expr.get(aggregates);
                }
                catch (SparqlTypeErrorException ex) {
                    TypeErrorLog.handleTypeError(ex, expr, this.stats);
                }
                catch (IllegalArgumentException ex) {
                    TypeErrorLog.handleTypeError(ex, expr, this.stats);
                }
            }
            IConstraint[] having2 = this.rewrite.getHaving2();
            boolean drop = having2 != null && !BOpUtility.isConsistent(having2, aggregates);
            if (log.isInfoEnabled()) {
                log.info((drop ? "drop" : "keep") + " : " + aggregates);
            }
            if (drop) {
                return null;
            }
            if (this.groupBy == null) {
                assert (!aggregates.containsErrorValues());
                out = aggregates.copy(this.groupByState.getSelectVars().toArray(new IVariable[0]));
            } else {
                out = aggregates.copyMinusErrors(this.groupByState.getSelectVars().toArray(new IVariable[0]));
            }
            return out;
        }
    }

    private static class SolutionMultiSet {
        private List<IBindingSet> solutions = new LinkedList<IBindingSet>();

        private SolutionMultiSet() {
        }

        public void add(IBindingSet bset) {
            if (bset == null) {
                throw new IllegalArgumentException();
            }
            this.solutions.add(bset);
        }
    }

    private static class SolutionGroup {
        private final int hash;
        private final IConstant<?>[] vals;

        public String toString() {
            return super.toString() + "{group=" + Arrays.toString(this.vals) + "}";
        }

        static SolutionGroup newInstance(IValueExpression<?>[] groupBy, IBindingSet bset, BOpStats stats) {
            IConstant[] r = new IConstant[groupBy.length];
            for (int i = 0; i < groupBy.length; ++i) {
                Object exprValue;
                IValueExpression<?> expr = groupBy[i];
                try {
                    exprValue = expr.get(bset);
                }
                catch (SparqlTypeErrorException ex) {
                    exprValue = null;
                }
                Constant<Object> x = exprValue == null ? Constant.errorValue() : new Constant(exprValue);
                r[i] = x;
            }
            return new SolutionGroup(r);
        }

        private SolutionGroup(IConstant<?>[] vals) {
            this.vals = vals;
            this.hash = Arrays.hashCode(vals);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SolutionGroup)) {
                return false;
            }
            SolutionGroup t = (SolutionGroup)o;
            if (this.vals.length != t.vals.length) {
                return false;
            }
            for (int i = 0; i < this.vals.length; ++i) {
                if (this.vals[i] == t.vals[i]) continue;
                if (this.vals[i] == null) {
                    return false;
                }
                if (this.vals[i].equals(t.vals[i])) continue;
                return false;
            }
            return true;
        }
    }

    public static interface Annotations
    extends GroupByOp.Annotations,
    HashMapAnnotations {
    }
}

