/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.solutions;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.IBind;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IQueryAttributes;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.bop.solutions.BindingSetComparator;
import com.bigdata.bop.solutions.ISortOrder;
import com.bigdata.bop.solutions.SortOp;
import com.bigdata.bop.solutions.TypeErrorLog;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.apache.log4j.Logger;

public class MemorySortOp
extends SortOp {
    private static final transient Logger log = Logger.getLogger(MemorySortOp.class);
    private static final long serialVersionUID = 1L;

    public MemorySortOp(MemorySortOp op) {
        super(op);
    }

    public MemorySortOp(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
        switch (this.getEvaluationContext()) {
            case CONTROLLER: {
                break;
            }
            default: {
                throw new UnsupportedOperationException(SortOp.Annotations.EVALUATION_CONTEXT + "=" + (Object)((Object)this.getEvaluationContext()));
            }
        }
        if (!this.isLastPassRequested()) {
            throw new UnsupportedOperationException(SortOp.Annotations.LAST_PASS + "=" + this.isLastPassRequested());
        }
        if (this.isReorderSolutions()) {
            throw new UnsupportedOperationException(SortOp.Annotations.REORDER_SOLUTIONS + "=" + this.isReorderSolutions());
        }
        this.getValueComparator();
        for (ISortOrder s : this.getSortOrder()) {
            IValueExpression expr = s.getExpr();
            if (expr instanceof IVariableOrConstant || expr instanceof IBind) continue;
            throw new IllegalArgumentException("Value expression not wrapped by bind: " + expr);
        }
    }

    @Override
    public FutureTask<Void> eval(BOpContext<IBindingSet> context) {
        return new FutureTask<Void>(new SortTask(this, context));
    }

    private static class SortTask
    implements Callable<Void> {
        private final MemorySortOp op;
        private final BOpContext<IBindingSet> context;
        private final BOpStats stats;
        private final ISortOrder<?>[] sortOrder;
        private final IQueryAttributes attrs;
        private transient LinkedList<IBindingSet> solutions;
        private final String key;

        SortTask(MemorySortOp op, BOpContext<IBindingSet> context) {
            this.op = op;
            this.context = context;
            this.stats = context.getStats();
            this.sortOrder = op.getSortOrder();
            this.attrs = context.getQueryAttributes();
            this.key = Integer.toString(op.getId());
            this.solutions = (LinkedList)this.attrs.get(this.key);
            if (this.solutions == null) {
                this.solutions = new LinkedList();
                if (this.attrs.putIfAbsent(this.key, this.solutions) != null) {
                    throw new AssertionError();
                }
            }
        }

        void release() {
            if (log.isInfoEnabled()) {
                log.info("Releasing state");
            }
            this.attrs.remove(this.key);
            this.solutions = null;
        }

        @Override
        public Void call() throws Exception {
            ICloseableIterator<IBindingSet[]> itr = this.context.getSource();
            IBlockingBuffer<IBindingSet[]> sink = this.context.getSink();
            boolean lastInvocation = this.context.isLastInvocation();
            try {
                this.acceptSolutions(itr);
                if (lastInvocation) {
                    this.doOrderBy(sink);
                }
            }
            catch (Throwable t) {
                log.error(t, t);
                throw new RuntimeException(t);
            }
            finally {
                if (lastInvocation) {
                    this.release();
                }
                sink.close();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void acceptSolutions(ICloseableIterator<IBindingSet[]> itr) {
            try {
                while (itr.hasNext()) {
                    IBindingSet[] a = (IBindingSet[])itr.next();
                    this.stats.chunksIn.increment();
                    this.stats.unitsIn.add(a.length);
                    for (IBindingSet bset : a) {
                        IValueExpression<?> expr = null;
                        try {
                            for (ISortOrder<?> s : this.sortOrder) {
                                expr = s.getExpr();
                                expr.get(bset);
                            }
                        }
                        catch (SparqlTypeErrorException ex) {
                            TypeErrorLog.handleTypeError(ex, expr, this.stats);
                        }
                        this.solutions.add(bset);
                    }
                }
                if (log.isInfoEnabled()) {
                    log.info("Buffered " + this.solutions.size() + " solutions so far");
                }
            }
            finally {
                itr.close();
            }
        }

        private void doOrderBy(IBlockingBuffer<IBindingSet[]> sink) {
            if (log.isInfoEnabled()) {
                log.info("Sorting.");
            }
            IBindingSet[] all = this.solutions.toArray(new IBindingSet[0]);
            BindingSetComparator c = new BindingSetComparator(this.sortOrder, this.op.getValueComparator());
            long begin = System.currentTimeMillis();
            Arrays.sort(all, c);
            long elapsed = System.currentTimeMillis() - begin;
            if (log.isInfoEnabled()) {
                log.info("Sorted " + all.length + " solutions in " + elapsed + "ms.");
            }
            for (IBindingSet bset : all) {
                for (ISortOrder<?> s : this.sortOrder) {
                    IValueExpression<?> expr = s.getExpr();
                    if (!(expr instanceof IBind)) continue;
                    bset.clear(((IBind)expr).getVar());
                }
            }
            sink.add(all);
            sink.flush();
        }
    }
}

