/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.ITupleSerializer;
import com.bigdata.util.BytesUtil;

public class DumpIndex {
    public static void dumpIndex(AbstractBTree ndx, boolean showTuples) {
        StringBuilder sb = new StringBuilder();
        ITupleIterator itr = ndx.rangeIterator(null, null);
        long begin = System.currentTimeMillis();
        int i = 0;
        while (itr.hasNext()) {
            ITuple tuple = itr.next();
            if (showTuples) {
                DumpIndex.dumpTuple(i, sb, tuple);
            }
            ++i;
        }
        long elapsed = System.currentTimeMillis() - begin;
        System.out.println("Visited " + i + " tuples in " + elapsed + "ms");
    }

    private static void dumpTuple(int recno, StringBuilder tupleSB, ITuple<?> tuple) {
        ITupleSerializer tupleSer = tuple.getTupleSerializer();
        tupleSB.setLength(0);
        tupleSB.append("rec=" + recno);
        try {
            tupleSB.append("\nkey=" + tupleSer.deserializeKey(tuple));
        }
        catch (Throwable t) {
            tupleSB.append("\nkey=" + BytesUtil.toString(tuple.getKey()));
        }
        try {
            tupleSB.append("\nval=" + tupleSer.deserialize(tuple));
        }
        catch (Throwable t) {
            tupleSB.append("\nval=" + BytesUtil.toString(tuple.getValue()));
        }
        System.out.println(tupleSB);
    }
}

