/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import org.apache.log4j.Logger;

public class IndexSegmentPlan {
    protected static final transient Logger log = Logger.getLogger(IndexSegmentPlan.class);
    public final int m;
    public final int m2;
    public final long nentries;
    public final long nleaves;
    public final long nnodes;
    public final int height;
    public final int[] numInLeaf;
    public final long[] numInLevel;
    public final int[][] numInNode;

    public String toString() {
        return this.getClass() + "{branchingFactor=" + this.m + ", nentries=" + this.nentries + ", height=" + this.height + ", nnodes=" + this.nnodes + ", nleaves=" + this.nleaves + "}";
    }

    public IndexSegmentPlan(int m, long nentries) {
        if (m < 3) {
            throw new IllegalArgumentException();
        }
        if (nentries < 0L) {
            throw new IllegalArgumentException();
        }
        this.m = m;
        this.nentries = nentries;
        this.m2 = (m + 1) / 2;
        if (nentries == 0L) {
            if (log.isInfoEnabled()) {
                log.info("Empty tree.");
            }
            this.nleaves = 1L;
            this.height = 0;
            this.numInLeaf = new int[]{0};
            this.numInNode = new int[][]{{0}};
            this.numInLevel = new long[]{1L};
            this.nnodes = 0L;
            return;
        }
        this.nleaves = (int)Math.ceil((double)nentries / (double)m);
        this.height = IndexSegmentPlan.getMinimumHeight(m, this.nleaves);
        if (log.isInfoEnabled()) {
            log.info("branchingFactor=" + m + ", nentries=" + nentries + ", nleaves=" + this.nleaves + ", height=" + this.height);
        }
        this.numInLeaf = IndexSegmentPlan.distributeKeys(m, this.m2, this.nleaves, nentries);
        this.numInNode = new int[this.height + 1][];
        this.numInLevel = new long[this.height + 1];
        long nchildren = this.nleaves;
        int nnodes = 0;
        for (int h = this.height - 1; h >= 0; --h) {
            long numThisLevel;
            this.numInLevel[h] = numThisLevel = (long)Math.ceil((double)nchildren / (double)m);
            this.numInNode[h] = IndexSegmentPlan.distributeChildren(m, this.m2, numThisLevel, nchildren);
            nchildren = numThisLevel;
            nnodes = (int)((long)nnodes + numThisLevel);
        }
        this.numInNode[this.height] = this.numInLeaf;
        this.numInLevel[this.height] = this.nleaves;
        this.nnodes = nnodes;
    }

    public static int getMinimumHeight(int m, long nleaves) {
        int maxHeight = 10;
        for (int h = 0; h <= 10; ++h) {
            double d = Math.pow(m, h);
            if (!(d >= (double)nleaves)) continue;
            return h;
        }
        throw new UnsupportedOperationException("Can not build tree with height less than 10 given branchingFactor=" + m + ",  nleaves=" + nleaves);
    }

    public static int[] distributeKeys(int m, int m2, long nleaves, long nentries) {
        if (m < 3) {
            throw new IllegalArgumentException();
        }
        if (m > 10240) {
            throw new IllegalArgumentException();
        }
        if (m2 < (m + 1) / 2) {
            throw new IllegalArgumentException();
        }
        if (m2 > m) {
            throw new IllegalArgumentException();
        }
        if (nleaves <= 0L) {
            throw new IllegalArgumentException();
        }
        if (nleaves > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        if (nentries <= 0L) {
            throw new IllegalArgumentException();
        }
        if (nleaves == 1L) {
            if (nentries > (long)m) {
                throw new RuntimeException();
            }
            return new int[]{(int)nentries};
        }
        int[] n = new int[(int)nleaves];
        int i = 0;
        while ((long)i < nleaves) {
            n[i] = m;
            ++i;
        }
        long remaining = nentries - (nleaves - 1L) * (long)m;
        int shortage = (int)(remaining < (long)m2 ? (long)m2 - remaining : 0L);
        n[(int)(nleaves - 1L)] = remaining < (long)m2 ? m2 : (int)remaining;
        if (shortage > 0) {
            while (shortage > 0) {
                int i2 = (int)(nleaves - 2L);
                while (i2 >= 0 && shortage > 0) {
                    int n2 = i2--;
                    n[n2] = n[n2] - 1;
                    --shortage;
                }
            }
        }
        return n;
    }

    public static int[] distributeChildren(int m, int m2, long nnodes, long nchildren) {
        return IndexSegmentPlan.distributeKeys(m, m2, nnodes, nchildren);
    }
}

