/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.BloomFilter;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.IndexSegment;
import com.bigdata.btree.IndexSegmentAddressManager;
import com.bigdata.btree.IndexSegmentCheckpoint;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.Instrument;
import com.bigdata.counters.OneShotInstrument;
import com.bigdata.io.DirectBufferPool;
import com.bigdata.io.FileChannelUtility;
import com.bigdata.io.IBufferAccess;
import com.bigdata.io.IReopenChannel;
import com.bigdata.io.SerializerUtil;
import com.bigdata.mdi.IResourceMetadata;
import com.bigdata.mdi.SegmentMetadata;
import com.bigdata.rawstore.AbstractRawStore;
import com.bigdata.service.Event;
import com.bigdata.service.EventResource;
import com.bigdata.service.EventType;
import com.bigdata.service.IBigdataFederation;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class IndexSegmentStore
extends AbstractRawStore {
    protected static final Logger log = Logger.getLogger(IndexSegmentStore.class);
    protected static final String mode = "r";
    protected final File file;
    private final SegmentMetadata segmentMetadata;
    private final IndexSegmentAddressManager addressManager;
    @Deprecated
    private final ConcurrentMap<Long, Object> storeCache;
    private volatile IBufferAccess buf_nodes;
    private volatile RandomAccessFile raf;
    private final IndexSegmentCheckpoint checkpoint;
    private final IndexMetadata indexMetadata;
    private final IndexSegmentStoreCounters counters = new IndexSegmentStoreCounters();
    private volatile boolean open = false;
    protected final IBigdataFederation<?> fed;
    private volatile Event openCloseEvent;
    private volatile WeakReference<IndexSegment> ref = null;
    protected final ReentrantLock lock = new ReentrantLock();
    private final IReopenChannel<FileChannel> opener = new IReopenChannel<FileChannel>(){

        @Override
        public String toString() {
            return IndexSegmentStore.this.toString();
        }

        @Override
        public FileChannel reopenChannel() throws IOException {
            return IndexSegmentStore.this.reopenChannel();
        }
    };

    @Override
    public final IndexSegmentAddressManager getAddressManager() {
        return this.addressManager;
    }

    public final IndexSegmentCheckpoint getCheckpoint() {
        return this.checkpoint;
    }

    @Override
    public final UUID getUUID() {
        return this.segmentMetadata.getUUID();
    }

    public final IndexMetadata getIndexMetadata() {
        return this.indexMetadata;
    }

    public IndexSegmentStore(File file) {
        this(file, null);
    }

    public IndexSegmentStore(File file, IBigdataFederation<?> fed) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        this.file = file;
        this.fed = fed;
        this.open = true;
        try {
            this.reopenChannel();
            this.checkpoint = new IndexSegmentCheckpoint(this.raf);
            this.segmentMetadata = new SegmentMetadata(file, this.checkpoint.segmentUUID, this.checkpoint.commitTime);
            this.addressManager = new IndexSegmentAddressManager(this.checkpoint);
            this.storeCache = null;
            this.indexMetadata = this.readMetadata();
        }
        catch (IOException ex) {
            this._close();
            throw new RuntimeException(ex);
        }
        if (log.isInfoEnabled()) {
            log.info(this.checkpoint.toString());
        }
    }

    protected void finalize() throws Exception {
        if (this.open) {
            if (log.isInfoEnabled()) {
                log.info("Closing IndexSegmentStore: " + this.getFile());
            }
            this._close();
        }
    }

    public String toString() {
        return this.file.toString();
    }

    @Override
    public IResourceMetadata getResourceMetadata() {
        return this.segmentMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reopen() {
        this.lock.lock();
        try {
            if (this.open) {
                return;
            }
            try {
                this.open = true;
                this.reopenChannel();
                ++this.counters.openCount;
                if (this.fed != null) {
                    this.openCloseEvent = new Event(this.fed, new EventResource(this.indexMetadata, this.file), (Object)EventType.IndexSegmentStoreOpenClose).start();
                }
            }
            catch (Throwable t) {
                this._close();
                throw new RuntimeException("Could not (re-) open: file=" + this.file, t);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public IndexSegment loadIndexSegment() {
        IndexSegment seg = this.ref == null ? null : (IndexSegment)this.ref.get();
        this.lock.lock();
        try {
            IndexSegment indexSegment = seg != null ? seg : (seg = this.ref == null ? null : (IndexSegment)this.ref.get());
            if (seg != null) {
                seg.reopen();
                IndexSegment indexSegment2 = seg;
                return indexSegment2;
            }
            Class<?> cl = Class.forName(this.indexMetadata.getBTreeClassName());
            Constructor<?> ctor = cl.getConstructor(IndexSegmentStore.class);
            seg = (IndexSegment)ctor.newInstance(this);
            this.getCounters().attach(seg.getBtreeCounters().getCounters(), true);
            this.ref = new WeakReference<IndexSegment>(seg);
            IndexSegment indexSegment3 = seg;
            return indexSegment3;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final boolean isOpen() {
        return this.open;
    }

    @Override
    public final boolean isReadOnly() {
        return true;
    }

    @Override
    public final boolean isStable() {
        return true;
    }

    @Override
    public final boolean isFullyBuffered() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNodesFullyBuffered() {
        this.lock.lock();
        try {
            boolean bl = this.isOpen() && this.buf_nodes != null;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final File getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.lock.lock();
        try {
            if (log.isInfoEnabled()) {
                log.info(this.file.toString());
            }
            if (this.isOpen()) {
                this._close();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _close() {
        this.lock.lock();
        try {
            if (this.raf != null) {
                try {
                    this.raf.close();
                }
                catch (IOException ex) {
                    log.error("Problem closing file: " + this.file, ex);
                }
                this.raf = null;
            }
            if (this.buf_nodes != null) {
                try {
                    this.buf_nodes.release();
                }
                catch (Throwable t) {
                    log.error(this, t);
                }
                finally {
                    this.buf_nodes = null;
                }
            }
            this.open = false;
            ++this.counters.closeCount;
            if (this.openCloseEvent != null) {
                try {
                    this.openCloseEvent.end();
                }
                catch (Throwable t) {
                    log.error(this, t);
                }
                finally {
                    this.openCloseEvent = null;
                }
            }
            if (log.isInfoEnabled()) {
                log.info("Closed: file=" + this.getFile());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteResources() {
        this.lock.lock();
        try {
            if (this.open) {
                throw new IllegalStateException();
            }
            if (!this.file.delete()) {
                throw new RuntimeException("Could not delete: " + this.file.getAbsolutePath());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this.lock.lock();
        try {
            if (this.isOpen()) {
                this.close();
            }
            this.deleteResources();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final long write(ByteBuffer data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void force(boolean metadata) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final long size() {
        return this.checkpoint.length;
    }

    @Override
    public CounterSet getCounters() {
        CounterSet counterSet = new CounterSet();
        counterSet.addCounter("file", new OneShotInstrument<String>(this.file.toString()));
        CounterSet tmp = counterSet.makePath("checkpoint");
        tmp.addCounter("segment UUID", new OneShotInstrument<String>(this.checkpoint.segmentUUID.toString()));
        tmp.addCounter("length", new OneShotInstrument<String>(Long.toString(this.checkpoint.length)));
        tmp.addCounter("#nodes", new OneShotInstrument<String>(Long.toString(this.checkpoint.nnodes)));
        tmp.addCounter("#leaves", new OneShotInstrument<String>(Long.toString(this.checkpoint.nleaves)));
        tmp.addCounter("#entries", new OneShotInstrument<String>(Long.toString(this.checkpoint.nentries)));
        tmp.addCounter("height", new OneShotInstrument<String>(Long.toString(this.checkpoint.height)));
        tmp = counterSet.makePath("metadata");
        tmp.addCounter("name", new OneShotInstrument<String>(this.indexMetadata.getName()));
        tmp.addCounter("index UUID", new OneShotInstrument<String>(this.indexMetadata.getIndexUUID().toString()));
        tmp = counterSet.makePath("store");
        tmp.addCounter("nodesBuffered", new Instrument<Boolean>(){

            @Override
            protected void sample() {
                this.setValue(IndexSegmentStore.this.buf_nodes != null);
            }
        });
        tmp.addCounter("openCount", new Instrument<String>(){

            @Override
            protected void sample() {
                this.setValue(Long.toString(((IndexSegmentStore)IndexSegmentStore.this).counters.openCount));
            }
        });
        tmp.addCounter("closeCount", new Instrument<String>(){

            @Override
            protected void sample() {
                this.setValue(Long.toString(((IndexSegmentStore)IndexSegmentStore.this).counters.closeCount));
            }
        });
        tmp.addCounter("nodesRead", new Instrument<String>(){

            @Override
            protected void sample() {
                this.setValue(Long.toString(((IndexSegmentStore)IndexSegmentStore.this).counters.nodesRead));
            }
        });
        tmp.addCounter("nodeReadFromDisk", new Instrument<String>(){

            @Override
            protected void sample() {
                this.setValue(Long.toString(((IndexSegmentStore)IndexSegmentStore.this).counters.nodesReadFromDisk));
            }
        });
        tmp.addCounter("leavesReadFromDisk", new Instrument<String>(){

            @Override
            protected void sample() {
                this.setValue(Long.toString(((IndexSegmentStore)IndexSegmentStore.this).counters.leavesReadFromDisk));
            }
        });
        return counterSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer read(long addr) {
        boolean isNodeAddr = this.addressManager.isNodeAddr(addr);
        if (log.isDebugEnabled()) {
            log.debug("addr=" + addr + "(" + this.addressManager.toString(addr) + "), isNodeAddr=" + isNodeAddr);
        }
        long offset = this.addressManager.getOffset(addr);
        int length = this.addressManager.getByteCount(addr);
        if (isNodeAddr) {
            ++this.counters.nodesRead;
            if (this.buf_nodes != null) {
                this.lock.lock();
                try {
                    if (this.buf_nodes != null) {
                        ByteBuffer byteBuffer = this.readFromBuffer(offset, length);
                        return byteBuffer;
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            ++this.counters.nodesReadFromDisk;
            return this.readFromFile(offset, length);
        }
        ++this.counters.leavesReadFromDisk;
        return this.readFromFile(offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ByteBuffer readFromBuffer(long offset, int length) {
        ByteBuffer tmp;
        ByteBuffer t;
        ByteBuffer byteBuffer = t = this.buf_nodes.buffer();
        synchronized (byteBuffer) {
            tmp = t.slice();
        }
        long off = offset - this.checkpoint.offsetNodes;
        tmp.limit((int)(off + (long)length));
        tmp.position((int)off);
        if (tmp.isDirect()) {
            ByteBuffer slice = tmp.slice();
            byte[] a = new byte[length];
            slice.get(a);
            return ByteBuffer.wrap(a);
        }
        return tmp.slice();
    }

    private final ByteBuffer readFromFile(long offset, int length) {
        try {
            ByteBuffer dst = ByteBuffer.allocate(length);
            FileChannelUtility.readAll(this.opener, dst, offset);
            dst.flip();
            return dst;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    final void readFromFile(long offset, ByteBuffer dst) throws IOException {
        FileChannelUtility.readAll(this.opener, dst, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final FileChannel reopenChannel() throws IOException {
        FileChannel channel;
        Closeable tmp = this.raf;
        if (tmp != null && (channel = tmp.getChannel()).isOpen()) {
            return channel;
        }
        this.lock.lock();
        try {
            block16: {
                if (!this.open) {
                    this.reopen();
                }
                if (this.raf != null && this.raf.getChannel().isOpen()) {
                    tmp = this.raf.getChannel();
                    return tmp;
                }
                this.raf = new RandomAccessFile(this.file, mode);
                if (log.isInfoEnabled()) {
                    log.info("(Re-)opened file: " + this.file);
                }
                try {
                    FileLock fileLock = this.raf.getChannel().tryLock(0L, Long.MAX_VALUE, true);
                    if (fileLock == null) {
                        try {
                            this.raf.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        throw new IOException("File already locked: file=" + this.getFile());
                    }
                    if (!fileLock.isShared()) {
                        fileLock.release();
                    }
                }
                catch (OverlappingFileLockException ex) {
                    if (log.isInfoEnabled()) {
                        log.info("Will proceed without lock: file=" + this.file + " : " + ex);
                    }
                }
                catch (IOException ex) {
                    if (!log.isInfoEnabled()) break block16;
                    log.info("FileLock not supported: file=" + this.getFile(), ex);
                }
            }
            FileChannel fileChannel = this.raf.getChannel();
            return fileChannel;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bufferIndexNodes() throws IOException {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        if (this.buf_nodes != null) {
            return;
        }
        if (this.checkpoint.nnodes == 0) {
            throw new IllegalStateException();
        }
        if (this.checkpoint.offsetNodes == 0L) {
            throw new IllegalStateException();
        }
        if (this.checkpoint.extentNodes > (long)DirectBufferPool.INSTANCE.getBufferCapacity()) {
            log.warn("Node extent exceeds buffer capacity: index=" + this.getIndexMetadata().getName() + ", file=" + this.file + ", " + "extent=" + this.checkpoint.extentNodes + ", bufferCapacity=" + DirectBufferPool.INSTANCE.getBufferCapacity());
            return;
        }
        try {
            this.buf_nodes = DirectBufferPool.INSTANCE.acquire(100L, TimeUnit.MILLISECONDS);
            if (log.isInfoEnabled()) {
                log.info("Buffering nodes: #nodes=" + this.checkpoint.nnodes + ", #bytes=" + this.checkpoint.extentNodes + ", file=" + this.file);
            }
            ByteBuffer tmp = this.buf_nodes.buffer();
            tmp.limit((int)this.checkpoint.extentNodes);
            FileChannelUtility.readAll(this.opener, tmp, this.checkpoint.offsetNodes);
            tmp.flip();
        }
        catch (Throwable t1) {
            if (this.buf_nodes != null) {
                try {
                    this.buf_nodes.release();
                }
                catch (Throwable t) {
                    log.error(this, t);
                }
                finally {
                    this.buf_nodes = null;
                }
            }
            log.error(this, t1);
        }
    }

    protected BloomFilter readBloomFilter() throws IOException {
        BloomFilter bloomFilter;
        long addr = this.checkpoint.addrBloom;
        if (addr == 0L) {
            return null;
        }
        if (this.storeCache != null && (bloomFilter = (BloomFilter)this.storeCache.get(addr)) != null) {
            return bloomFilter;
        }
        if (log.isInfoEnabled()) {
            log.info("reading bloom filter: " + this.addressManager.toString(addr));
        }
        long off = this.addressManager.getOffset(addr);
        int len = this.addressManager.getByteCount(addr);
        ByteBuffer buf = ByteBuffer.allocate(len);
        buf.limit(len);
        buf.position(0);
        try {
            FileChannelUtility.readAll(this.opener, buf, off);
            buf.flip();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        assert (buf.position() == 0);
        assert (buf.limit() == len);
        BloomFilter bloomFilter2 = (BloomFilter)SerializerUtil.deserialize(buf);
        if (log.isInfoEnabled()) {
            log.info("Read bloom filter: bytesOnDisk=" + len);
        }
        if (this.storeCache != null) {
            this.storeCache.putIfAbsent(addr, bloomFilter2);
        }
        return bloomFilter2;
    }

    private final IndexMetadata readMetadata() throws IOException {
        IndexMetadata md;
        long addr = this.checkpoint.addrMetadata;
        assert (addr != 0L);
        if (this.storeCache != null && (md = (IndexMetadata)this.storeCache.get(addr)) != null) {
            return md;
        }
        if (log.isInfoEnabled()) {
            log.info("reading metadata: " + this.addressManager.toString(addr));
        }
        long off = this.addressManager.getOffset(addr);
        int len = this.addressManager.getByteCount(addr);
        ByteBuffer buf = ByteBuffer.allocate(len);
        buf.limit(len);
        buf.position(0);
        try {
            FileChannelUtility.readAll(this.opener, buf, off);
            buf.flip();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        assert (buf.position() == 0);
        assert (buf.limit() == len);
        IndexMetadata md2 = (IndexMetadata)SerializerUtil.deserialize(buf);
        if (log.isInfoEnabled()) {
            log.info("Read metadata: " + md2);
        }
        if (this.storeCache != null) {
            this.storeCache.putIfAbsent(addr, md2);
        }
        return md2;
    }

    @Override
    public final int getByteCount(long addr) {
        return this.addressManager.getByteCount(addr);
    }

    @Override
    public final long getOffset(long addr) {
        return this.addressManager.getOffset(addr);
    }

    @Override
    public final long getPhysicalAddress(long addr) {
        return this.addressManager.getPhysicalAddress(addr);
    }

    @Override
    public final long toAddr(int nbytes, long offset) {
        return this.addressManager.toAddr(nbytes, offset);
    }

    @Override
    public final String toString(long addr) {
        return this.addressManager.toString(addr);
    }

    private static class IndexSegmentStoreCounters {
        long openCount;
        long closeCount;
        long nodesRead;
        long nodesReadFromDisk;
        long leavesReadFromDisk;

        private IndexSegmentStoreCounters() {
        }
    }
}

