/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.AbstractNode;
import com.bigdata.btree.BTree;
import com.bigdata.btree.IAbstractNode;
import com.bigdata.btree.IRawRecordAccess;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.IndexSegment;
import com.bigdata.btree.LeafTupleIterator;
import com.bigdata.btree.MutableLeafData;
import com.bigdata.btree.MutableNodeData;
import com.bigdata.btree.Node;
import com.bigdata.btree.Tuple;
import com.bigdata.btree.data.DefaultLeafCoder;
import com.bigdata.btree.data.ILeafData;
import com.bigdata.btree.filter.EmptyTupleIterator;
import com.bigdata.btree.raba.IRaba;
import com.bigdata.btree.raba.MutableKeyBuffer;
import com.bigdata.btree.raba.MutableValueBuffer;
import com.bigdata.io.AbstractFixedByteArrayBuffer;
import com.bigdata.util.BytesUtil;
import cutthecrap.utils.striterators.EmptyIterator;
import cutthecrap.utils.striterators.SingleValueIterator;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.WeakHashMap;
import org.apache.log4j.Level;

public class Leaf
extends AbstractNode<Leaf>
implements ILeafData,
IRawRecordAccess {
    ILeafData data;
    private transient WeakHashMap<ILeafListener, Void> leafListeners = null;

    @Override
    protected final int minKeys() {
        return this.btree.minChildren;
    }

    @Override
    protected final int maxKeys() {
        return this.btree.branchingFactor;
    }

    @Override
    public final ILeafData getDelegate() {
        return this.data;
    }

    @Override
    public final boolean isLeaf() {
        return true;
    }

    @Override
    public final boolean isReadOnly() {
        return this.data.isReadOnly();
    }

    @Override
    public final boolean isCoded() {
        return this.data.isCoded();
    }

    @Override
    public final AbstractFixedByteArrayBuffer data() {
        return this.data.data();
    }

    @Override
    public final boolean getDeleteMarker(int index) {
        return this.data.getDeleteMarker(index);
    }

    @Override
    public final int getKeyCount() {
        return this.data.getKeyCount();
    }

    @Override
    public final IRaba getKeys() {
        if (this.data == null) {
            throw new NullPointerException("leaf=" + this.toString());
        }
        return this.data.getKeys();
    }

    @Override
    public final int getValueCount() {
        return this.data.getValueCount();
    }

    @Override
    public final IRaba getValues() {
        return this.data.getValues();
    }

    public byte[] getValue(int index) {
        if (!this.hasRawRecords()) {
            return this.getValues().get(index);
        }
        long addr = this.getRawRecord(index);
        if (addr == 0L) {
            return this.getValues().get(index);
        }
        ByteBuffer tmp = this.btree.readRawRecord(addr);
        if (tmp.hasArray() && tmp.arrayOffset() == 0 && tmp.position() == 0 && tmp.limit() == tmp.capacity()) {
            return tmp.array();
        }
        int len = tmp.remaining();
        byte[] a = new byte[len];
        tmp.get(a);
        return a;
    }

    @Override
    public final long getVersionTimestamp(int index) {
        return this.data.getVersionTimestamp(index);
    }

    @Override
    public final long getRawRecord(int index) {
        return this.data.getRawRecord(index);
    }

    @Override
    public final boolean hasDeleteMarkers() {
        return this.data.hasDeleteMarkers();
    }

    @Override
    public final boolean hasVersionTimestamps() {
        return this.data.hasVersionTimestamps();
    }

    @Override
    public final long getMinimumVersionTimestamp() {
        return this.data.getMinimumVersionTimestamp();
    }

    @Override
    public final long getMaximumVersionTimestamp() {
        return this.data.getMaximumVersionTimestamp();
    }

    @Override
    public final boolean hasRawRecords() {
        return this.data.hasRawRecords();
    }

    @Override
    public final boolean isDoubleLinked() {
        return this.data.isDoubleLinked();
    }

    @Override
    public final long getPriorAddr() {
        return this.data.getPriorAddr();
    }

    @Override
    public final long getNextAddr() {
        return this.data.getNextAddr();
    }

    protected Leaf(AbstractBTree btree, long addr, ILeafData data) {
        super(btree, false);
        assert (data != null);
        assert (data.hasDeleteMarkers() == btree.getIndexMetadata().getDeleteMarkers());
        assert (data.hasVersionTimestamps() == btree.getIndexMetadata().getVersionTimestamps());
        this.setIdentity(addr);
        this.data = data;
    }

    protected Leaf(AbstractBTree btree) {
        super(btree, true);
        IndexMetadata md = btree.getIndexMetadata();
        this.data = new MutableLeafData(btree.branchingFactor, md.getVersionTimestamps(), md.getDeleteMarkers(), md.getRawRecords());
    }

    protected Leaf(Leaf src) {
        super(src);
        assert (!src.isDirty());
        assert (src.isReadOnly());
        this.data = src.isReadOnly() ? new MutableLeafData(src.getBranchingFactor(), src.data) : src.data;
        src.data = null;
    }

    @Override
    public void delete() {
        this.fireInvalidateLeafEvent();
        super.delete();
        this.data = null;
        this.leafListeners = null;
    }

    @Override
    public Tuple insert(byte[] searchKey, byte[] newval, boolean delete, boolean putIfAbsent, long timestamp, Tuple tuple) {
        if (delete && !this.data.hasDeleteMarkers()) {
            throw new UnsupportedOperationException();
        }
        if (this.btree.debug) {
            this.assertInvariants();
        }
        int entryIndex = Integer.MAX_VALUE;
        if (!(!putIfAbsent || (entryIndex = this.getKeys().search(searchKey)) < 0 || this.hasDeleteMarkers() && this.getDeleteMarker(entryIndex))) {
            if (tuple != null) {
                tuple.copy(entryIndex, this);
            }
            return tuple;
        }
        Leaf copy = (Leaf)this.copyOnWrite();
        if (copy != this) {
            return copy.insert(searchKey, newval, delete, false, timestamp, tuple);
        }
        if (!putIfAbsent) {
            entryIndex = this.getKeys().search(searchKey);
        }
        if (entryIndex >= 0) {
            if (tuple != null) {
                tuple.copy(entryIndex, this);
            }
            MutableLeafData data = (MutableLeafData)this.data;
            if (this.hasRawRecords()) {
                long oaddr = this.getRawRecord(entryIndex);
                if (oaddr != 0L) {
                    this.btree.deleteRawRecord(oaddr);
                }
                long maxRecLen = this.btree.getMaxRecLen();
                if (newval != null && (long)newval.length > maxRecLen) {
                    long naddr = this.btree.writeRawRecord(newval);
                    data.vals.values[entryIndex] = ((BTree)this.btree).encodeRecordAddr(naddr);
                    data.rawRecords[entryIndex] = true;
                } else {
                    data.vals.values[entryIndex] = newval;
                    data.rawRecords[entryIndex] = false;
                }
            } else {
                data.vals.values[entryIndex] = newval;
            }
            if (data.deleteMarkers != null) {
                if (!data.deleteMarkers[entryIndex] && delete) {
                    ++this.btree.getBtreeCounters().ntupleUpdateDelete;
                } else if (!delete) {
                    ++this.btree.getBtreeCounters().ntupleUpdateValue;
                }
                data.deleteMarkers[entryIndex] = delete;
            } else {
                ++this.btree.getBtreeCounters().ntupleUpdateValue;
            }
            if (data.versionTimestamps != null) {
                boolean propagateMinMax = false;
                data.versionTimestamps[entryIndex] = timestamp;
                if (data.minimumVersionTimestamp > timestamp) {
                    data.minimumVersionTimestamp = timestamp;
                    propagateMinMax = true;
                }
                if (data.maximumVersionTimestamp < timestamp) {
                    data.maximumVersionTimestamp = timestamp;
                    propagateMinMax = true;
                }
                if (propagateMinMax && this.parent != null) {
                    ((Node)this.parent.get()).updateMinMaxVersionTimestamp(this);
                }
            }
            return tuple;
        }
        int nkeys = this.getKeyCount();
        if ((entryIndex = -entryIndex - 1) < nkeys) {
            int count = nkeys - entryIndex;
            assert (count >= 1);
            this.copyDown(entryIndex, count);
        }
        MutableLeafData data = (MutableLeafData)this.data;
        MutableKeyBuffer keys = data.keys;
        MutableValueBuffer vals = data.vals;
        keys.keys[entryIndex] = searchKey;
        if (this.hasRawRecords()) {
            long maxRecLen = this.btree.getMaxRecLen();
            if (newval != null && (long)newval.length > maxRecLen) {
                long naddr = this.btree.writeRawRecord(newval);
                data.vals.values[entryIndex] = ((BTree)this.btree).encodeRecordAddr(naddr);
                data.rawRecords[entryIndex] = true;
            } else {
                data.vals.values[entryIndex] = newval;
                data.rawRecords[entryIndex] = false;
            }
        } else {
            vals.values[entryIndex] = newval;
        }
        if (data.deleteMarkers != null) {
            if (delete) {
                ++this.btree.getBtreeCounters().ntupleInsertDelete;
            } else if (!delete) {
                ++this.btree.getBtreeCounters().ntupleInsertValue;
            }
            data.deleteMarkers[entryIndex] = delete;
        } else {
            ++this.btree.getBtreeCounters().ntupleInsertValue;
        }
        if (data.versionTimestamps != null) {
            data.versionTimestamps[entryIndex] = timestamp;
            if (data.minimumVersionTimestamp > timestamp) {
                data.minimumVersionTimestamp = timestamp;
            }
            if (data.maximumVersionTimestamp < timestamp) {
                data.maximumVersionTimestamp = timestamp;
            }
        }
        ++keys.nkeys;
        ++vals.nvalues;
        ++((BTree)this.btree).nentries;
        if (this.parent != null) {
            ((Node)this.parent.get()).updateEntryCount(this, 1L);
        }
        if (this.data.getKeyCount() == this.maxKeys() + 1) {
            Leaf rightSibling = (Leaf)this.split();
            if (this.btree.debug) {
                rightSibling.assertInvariants();
                this.getParent().assertInvariants();
            }
        }
        if (this.btree.debug) {
            this.assertInvariants();
        }
        this.fireInvalidateLeafEvent();
        return null;
    }

    @Override
    public Tuple lookup(byte[] searchKey, Tuple tuple) {
        this.btree.touch(this);
        int entryIndex = this.getKeys().search(searchKey);
        if (entryIndex < 0) {
            return null;
        }
        tuple.copy(entryIndex, this);
        return tuple;
    }

    @Override
    public long indexOf(byte[] key) {
        this.btree.touch(this);
        return this.getKeys().search(key);
    }

    @Override
    public byte[] keyAt(long entryIndex) {
        this.rangeCheck2(entryIndex);
        return this.getKeys().get((int)entryIndex);
    }

    @Override
    public void valueAt(long entryIndex, Tuple tuple) {
        this.rangeCheck2(entryIndex);
        tuple.copy((int)entryIndex, this);
    }

    protected final boolean rangeCheck2(long index) throws IndexOutOfBoundsException {
        if (index > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException();
        }
        return this.rangeCheck((int)index);
    }

    protected final boolean rangeCheck(int index) throws IndexOutOfBoundsException {
        int nkeys = this.data.getKeyCount();
        if (index < 0 || index >= nkeys) {
            throw new IndexOutOfBoundsException("index=" + index + ", nkeys=" + nkeys);
        }
        return true;
    }

    @Override
    protected IAbstractNode split() {
        Node p;
        int maxKeys = this.maxKeys();
        assert (this.isDirty());
        assert (this.getKeyCount() == maxKeys + 1);
        BTree btree = (BTree)this.btree;
        ++btree.getBtreeCounters().leavesSplit;
        int nentriesBeforeSplit = this.getKeyCount();
        int splitIndex = (maxKeys + 1) / 2;
        byte[] separatorKey = BytesUtil.getSeparatorKey(this.getKeys().get(splitIndex), this.getKeys().get(splitIndex - 1));
        if (this.getParent() != null) {
            int leafIndex = this.getParent().getIndexOf(this);
            int separatorIndex = this.getParent().getKeys().search(separatorKey);
            if (separatorIndex >= 0) {
                throw new AssertionError((Object)("Split on existing key: leafIndex=" + leafIndex + ", splitIndexInLeaf=" + splitIndex + ", separatorIndexInParent=" + separatorIndex + ", separatorKey=" + Leaf.keyAsString(separatorKey) + "\nparent=" + this.getParent() + "\nleaf=" + this));
            }
        }
        Leaf rightSibling = new Leaf(btree);
        MutableLeafData data = (MutableLeafData)this.data;
        MutableLeafData sdata = (MutableLeafData)rightSibling.data;
        ++btree.nleaves;
        if (DEBUG) {
            log.debug("this=" + this + ", nkeys=" + this.getKeyCount() + ", splitIndex=" + splitIndex + ", separatorKey=" + Leaf.keyAsString(separatorKey));
        }
        int j = 0;
        int i = splitIndex;
        while (i <= maxKeys) {
            rightSibling.copyKey(j, this.getKeys(), i);
            sdata.vals.values[j] = data.vals.values[i];
            if (data.deleteMarkers != null) {
                sdata.deleteMarkers[j] = data.deleteMarkers[i];
            }
            if (data.versionTimestamps != null) {
                sdata.versionTimestamps[j] = data.versionTimestamps[i];
            }
            if (data.rawRecords != null) {
                sdata.rawRecords[j] = data.rawRecords[i];
            }
            data.keys.keys[i] = null;
            data.vals.values[i] = null;
            if (data.deleteMarkers != null) {
                data.deleteMarkers[i] = false;
            }
            if (data.versionTimestamps != null) {
                data.versionTimestamps[i] = 0L;
            }
            if (data.rawRecords != null) {
                data.rawRecords[i] = false;
            }
            --data.keys.nkeys;
            --data.vals.nvalues;
            ++sdata.keys.nkeys;
            ++sdata.vals.nvalues;
            ++i;
            ++j;
        }
        if (data.versionTimestamps != null) {
            data.recalcMinMaxVersionTimestamp();
        }
        if (sdata.versionTimestamps != null) {
            sdata.recalcMinMaxVersionTimestamp();
        }
        if ((p = this.getParent()) == null) {
            p = new Node(btree, this, nentriesBeforeSplit);
        } else {
            assert (!p.isReadOnly());
            int n = p.getIndexOf(this);
            ((MutableNodeData)p.data).childEntryCounts[n] = ((MutableNodeData)p.data).childEntryCounts[n] - (long)rightSibling.getKeyCount();
            if (p != btree.root && p.isRightMostNode()) {
                ++btree.getBtreeCounters().tailSplit;
            } else if (p != btree.root && p.isLeftMostNode()) {
                ++btree.getBtreeCounters().headSplit;
            }
        }
        p.insertChild(separatorKey, rightSibling);
        return rightSibling;
    }

    @Override
    protected void redistributeKeys(AbstractNode sibling, boolean isRightSibling) {
        Leaf s = (Leaf)sibling;
        assert (s != null);
        int nkeys = this.getKeyCount();
        int snkeys = s.getKeyCount();
        int minKeys = this.minKeys();
        assert (this.dirty);
        assert (!this.deleted);
        assert (!this.isPersistent());
        assert (nkeys < minKeys);
        assert (nkeys == minKeys - 1);
        assert (snkeys > minKeys);
        assert (s.dirty);
        assert (!s.deleted);
        assert (!s.isPersistent());
        Node p = this.getParent();
        assert (s.getParent() == p);
        if (DEBUG) {
            log.debug("this=" + this + ", sibling=" + sibling + ", rightSibling=" + isRightSibling);
        }
        int index = p.getIndexOf(this);
        MutableLeafData data = (MutableLeafData)this.data;
        MutableLeafData sdata = (MutableLeafData)s.data;
        MutableNodeData pdata = (MutableNodeData)p.data;
        MutableKeyBuffer keys = data.keys;
        MutableKeyBuffer skeys = sdata.keys;
        MutableValueBuffer vals = data.vals;
        MutableValueBuffer svals = sdata.vals;
        if (isRightSibling) {
            this.copyKey(nkeys, s.getKeys(), 0);
            vals.values[nkeys] = svals.values[0];
            if (data.deleteMarkers != null) {
                data.deleteMarkers[nkeys] = sdata.deleteMarkers[0];
            }
            boolean updateMinMaxVersionTimestampOnSibling = false;
            if (data.versionTimestamps != null) {
                long t;
                data.versionTimestamps[nkeys] = t = sdata.versionTimestamps[0];
                if (t < data.minimumVersionTimestamp) {
                    data.minimumVersionTimestamp = t;
                }
                if (t > data.maximumVersionTimestamp) {
                    data.maximumVersionTimestamp = t;
                }
                if (t == sdata.minimumVersionTimestamp || t == sdata.maximumVersionTimestamp) {
                    updateMinMaxVersionTimestampOnSibling = true;
                }
            }
            if (data.rawRecords != null) {
                data.rawRecords[nkeys] = sdata.rawRecords[0];
            }
            System.arraycopy(skeys.keys, 1, skeys.keys, 0, snkeys - 1);
            System.arraycopy(svals.values, 1, svals.values, 0, snkeys - 1);
            if (data.deleteMarkers != null) {
                System.arraycopy(sdata.deleteMarkers, 1, sdata.deleteMarkers, 0, snkeys - 1);
            }
            if (data.versionTimestamps != null) {
                System.arraycopy(sdata.versionTimestamps, 1, sdata.versionTimestamps, 0, snkeys - 1);
            }
            if (data.rawRecords != null) {
                System.arraycopy(sdata.rawRecords, 1, sdata.rawRecords, 0, snkeys - 1);
            }
            skeys.keys[snkeys - 1] = null;
            svals.values[snkeys - 1] = null;
            if (data.deleteMarkers != null) {
                sdata.deleteMarkers[snkeys - 1] = false;
            }
            if (data.versionTimestamps != null) {
                sdata.versionTimestamps[snkeys - 1] = 0L;
            }
            if (data.rawRecords != null) {
                sdata.rawRecords[snkeys - 1] = false;
            }
            --skeys.nkeys;
            --svals.nvalues;
            ++keys.nkeys;
            ++vals.nvalues;
            if (updateMinMaxVersionTimestampOnSibling) {
                sdata.recalcMinMaxVersionTimestamp();
            }
            p.copyKey(index, s.getKeys(), 0);
            int n = index;
            pdata.childEntryCounts[n] = pdata.childEntryCounts[n] + 1L;
            int n2 = index + 1;
            pdata.childEntryCounts[n2] = pdata.childEntryCounts[n2] - 1L;
            if (this.btree.debug) {
                this.assertInvariants();
                s.assertInvariants();
            }
        } else {
            System.arraycopy(keys.keys, 0, keys.keys, 1, nkeys);
            System.arraycopy(vals.values, 0, vals.values, 1, nkeys);
            if (data.deleteMarkers != null) {
                System.arraycopy(data.deleteMarkers, 0, data.deleteMarkers, 1, nkeys);
            }
            if (data.versionTimestamps != null) {
                System.arraycopy(data.versionTimestamps, 0, data.versionTimestamps, 1, nkeys);
            }
            if (data.rawRecords != null) {
                System.arraycopy(data.rawRecords, 0, data.rawRecords, 1, nkeys);
            }
            this.copyKey(0, s.getKeys(), snkeys - 1);
            vals.values[0] = svals.values[snkeys - 1];
            if (data.deleteMarkers != null) {
                data.deleteMarkers[0] = sdata.deleteMarkers[snkeys - 1];
            }
            boolean updateMinMaxVersionTimestampOnSibling = false;
            if (data.versionTimestamps != null) {
                long t;
                data.versionTimestamps[0] = t = sdata.versionTimestamps[snkeys - 1];
                if (t < data.minimumVersionTimestamp) {
                    data.minimumVersionTimestamp = t;
                }
                if (t > data.maximumVersionTimestamp) {
                    data.maximumVersionTimestamp = t;
                }
                if (t == sdata.minimumVersionTimestamp || t == sdata.maximumVersionTimestamp) {
                    updateMinMaxVersionTimestampOnSibling = true;
                }
            }
            if (data.rawRecords != null) {
                data.rawRecords[0] = sdata.rawRecords[snkeys - 1];
            }
            skeys.keys[snkeys - 1] = null;
            svals.values[snkeys - 1] = null;
            if (data.deleteMarkers != null) {
                sdata.deleteMarkers[snkeys - 1] = false;
            }
            if (data.versionTimestamps != null) {
                sdata.versionTimestamps[snkeys - 1] = 0L;
            }
            if (data.rawRecords != null) {
                sdata.rawRecords[snkeys - 1] = false;
            }
            --skeys.nkeys;
            --svals.nvalues;
            ++keys.nkeys;
            ++vals.nvalues;
            if (updateMinMaxVersionTimestampOnSibling) {
                sdata.recalcMinMaxVersionTimestamp();
            }
            p.copyKey(index - 1, this.getKeys(), 0);
            int n = index;
            pdata.childEntryCounts[n] = pdata.childEntryCounts[n] + 1L;
            int n3 = index - 1;
            pdata.childEntryCounts[n3] = pdata.childEntryCounts[n3] - 1L;
            if (this.btree.debug) {
                this.assertInvariants();
                s.assertInvariants();
            }
        }
    }

    @Override
    protected void merge(AbstractNode sibling, boolean isRightSibling) {
        Leaf s = (Leaf)sibling;
        assert (s != null);
        int nkeys = this.getKeyCount();
        int snkeys = s.getKeyCount();
        assert (!s.deleted);
        assert (nkeys < this.minKeys());
        assert (nkeys == this.minKeys() - 1);
        assert (snkeys == s.minKeys());
        Node p = this.getParent();
        assert (s.getParent() == p) : "this.parent=" + (p == null ? null : p) + " != s.parent=" + (s.getParent() == null ? null : s.getParent());
        if (DEBUG) {
            log.debug("this=" + this + ", sibling=" + sibling + ", rightSibling=" + isRightSibling);
        }
        int index = p.getIndexOf(this);
        MutableLeafData data = (MutableLeafData)this.data;
        MutableLeafData sdata = s.isReadOnly() ? new MutableLeafData(this.getBranchingFactor(), s.data) : (MutableLeafData)s.data;
        MutableNodeData pdata = (MutableNodeData)p.data;
        if (isRightSibling) {
            System.arraycopy(sdata.keys.keys, 0, data.keys.keys, nkeys, snkeys);
            System.arraycopy(sdata.vals.values, 0, data.vals.values, nkeys, snkeys);
            if (data.deleteMarkers != null) {
                System.arraycopy(sdata.deleteMarkers, 0, data.deleteMarkers, nkeys, snkeys);
            }
            if (data.versionTimestamps != null) {
                System.arraycopy(sdata.versionTimestamps, 0, data.versionTimestamps, nkeys, snkeys);
                if (sdata.minimumVersionTimestamp < data.minimumVersionTimestamp) {
                    data.minimumVersionTimestamp = sdata.minimumVersionTimestamp;
                }
                if (sdata.maximumVersionTimestamp > data.maximumVersionTimestamp) {
                    data.maximumVersionTimestamp = sdata.maximumVersionTimestamp;
                }
            }
            if (data.rawRecords != null) {
                System.arraycopy(sdata.rawRecords, 0, data.rawRecords, nkeys, snkeys);
            }
            data.keys.nkeys += snkeys;
            data.vals.nvalues += snkeys;
            p.copyKey(index, p.getKeys(), index + 1);
            int n = index;
            pdata.childEntryCounts[n] = pdata.childEntryCounts[n] + (long)s.getKeyCount();
            if (this.btree.debug) {
                this.assertInvariants();
            }
        } else {
            System.arraycopy(data.keys.keys, 0, data.keys.keys, snkeys, nkeys);
            System.arraycopy(data.vals.values, 0, data.vals.values, snkeys, nkeys);
            if (data.deleteMarkers != null) {
                System.arraycopy(data.deleteMarkers, 0, data.deleteMarkers, snkeys, nkeys);
            }
            if (data.versionTimestamps != null) {
                System.arraycopy(data.versionTimestamps, 0, data.versionTimestamps, snkeys, nkeys);
            }
            if (data.rawRecords != null) {
                System.arraycopy(data.rawRecords, 0, data.rawRecords, snkeys, nkeys);
            }
            System.arraycopy(sdata.keys.keys, 0, data.keys.keys, 0, snkeys);
            System.arraycopy(sdata.vals.values, 0, data.vals.values, 0, snkeys);
            if (data.deleteMarkers != null) {
                System.arraycopy(sdata.deleteMarkers, 0, data.deleteMarkers, 0, snkeys);
            }
            if (data.versionTimestamps != null) {
                System.arraycopy(sdata.versionTimestamps, 0, data.versionTimestamps, 0, snkeys);
                if (sdata.minimumVersionTimestamp < data.minimumVersionTimestamp) {
                    data.minimumVersionTimestamp = sdata.minimumVersionTimestamp;
                }
                if (sdata.maximumVersionTimestamp > data.maximumVersionTimestamp) {
                    data.maximumVersionTimestamp = sdata.maximumVersionTimestamp;
                }
            }
            if (data.rawRecords != null) {
                System.arraycopy(sdata.rawRecords, 0, data.rawRecords, 0, snkeys);
            }
            data.keys.nkeys += snkeys;
            data.vals.nvalues += snkeys;
            int n = index;
            pdata.childEntryCounts[n] = pdata.childEntryCounts[n] + (long)s.getKeyCount();
            if (this.btree.debug) {
                this.assertInvariants();
            }
        }
        p.removeChild(s);
    }

    protected void copyDown(int entryIndex, int count) {
        MutableLeafData data = (MutableLeafData)this.data;
        MutableKeyBuffer keys = data.keys;
        MutableValueBuffer vals = data.vals;
        System.arraycopy(keys.keys, entryIndex, keys.keys, entryIndex + 1, count);
        System.arraycopy(vals.values, entryIndex, vals.values, entryIndex + 1, count);
        if (data.deleteMarkers != null) {
            System.arraycopy(data.deleteMarkers, entryIndex, data.deleteMarkers, entryIndex + 1, count);
        }
        if (data.versionTimestamps != null) {
            System.arraycopy(data.versionTimestamps, entryIndex, data.versionTimestamps, entryIndex + 1, count);
        }
        if (data.rawRecords != null) {
            System.arraycopy(data.rawRecords, entryIndex, data.rawRecords, entryIndex + 1, count);
        }
        keys.keys[entryIndex] = null;
        vals.values[entryIndex] = null;
        if (data.deleteMarkers != null) {
            data.deleteMarkers[entryIndex] = false;
        }
        if (data.versionTimestamps != null) {
            data.versionTimestamps[entryIndex] = 0L;
        }
        if (data.rawRecords != null) {
            data.rawRecords[entryIndex] = false;
        }
    }

    @Override
    public Tuple remove(byte[] key, Tuple tuple) {
        long oldVersionTimestamp;
        long addr;
        if (this.btree.debug) {
            this.assertInvariants();
        }
        this.btree.touch(this);
        int entryIndex = this.getKeys().search(key);
        if (entryIndex < 0) {
            return null;
        }
        Leaf copy = (Leaf)this.copyOnWrite();
        if (copy != this) {
            return copy.remove(key, tuple);
        }
        if (tuple != null) {
            tuple.copy(entryIndex, this);
        }
        if (this.data.hasDeleteMarkers()) {
            throw new UnsupportedOperationException();
        }
        if (this.data.hasRawRecords() && (addr = this.data.getRawRecord(entryIndex)) != 0L) {
            this.btree.deleteRawRecord(addr);
        }
        int nkeys = this.getKeyCount();
        int length = nkeys - entryIndex - 1;
        MutableLeafData data = (MutableLeafData)this.data;
        MutableKeyBuffer keys = data.keys;
        MutableValueBuffer vals = data.vals;
        if (length > 0) {
            System.arraycopy(keys.keys, entryIndex + 1, keys.keys, entryIndex, length);
            System.arraycopy(vals.values, entryIndex + 1, vals.values, entryIndex, length);
            if (data.versionTimestamps != null) {
                System.arraycopy(data.versionTimestamps, entryIndex + 1, data.versionTimestamps, entryIndex, length);
            }
            if (data.rawRecords != null) {
                System.arraycopy(data.rawRecords, entryIndex + 1, data.rawRecords, entryIndex, length);
            }
        }
        keys.keys[nkeys - 1] = null;
        vals.values[nkeys - 1] = null;
        if (data.versionTimestamps != null) {
            data.versionTimestamps[nkeys - 1] = 0L;
        }
        if (data.rawRecords != null) {
            data.rawRecords[nkeys - 1] = false;
        }
        --keys.nkeys;
        --vals.nvalues;
        --((BTree)this.btree).nentries;
        assert (((BTree)this.btree).nentries >= 0L);
        ++this.btree.getBtreeCounters().ntupleRemove;
        if (data.versionTimestamps != null && ((oldVersionTimestamp = tuple.getVersionTimestamp()) == data.minimumVersionTimestamp || oldVersionTimestamp == data.maximumVersionTimestamp)) {
            data.recalcMinMaxVersionTimestamp();
        }
        if (this.btree.root != this) {
            ((Node)this.parent.get()).updateEntryCount(this, -1L);
            if (this.data.getKeyCount() < this.minKeys()) {
                this.join();
            }
        }
        if (this.btree.debug) {
            this.assertInvariants();
        }
        this.fireInvalidateLeafEvent();
        return tuple;
    }

    @Override
    public Iterator<AbstractNode> postOrderNodeIterator(boolean dirtyNodesOnly, boolean nodesOnly) {
        if (dirtyNodesOnly && !this.isDirty()) {
            return EmptyIterator.DEFAULT;
        }
        if (nodesOnly) {
            return EmptyIterator.DEFAULT;
        }
        return new SingleValueIterator<AbstractNode>(this);
    }

    @Override
    public Iterator<AbstractNode> postOrderIterator(byte[] fromKey, byte[] toKey) {
        return new SingleValueIterator<AbstractNode>(this);
    }

    @Override
    public ITupleIterator entryIterator() {
        if (this.getKeys().isEmpty()) {
            return EmptyTupleIterator.INSTANCE;
        }
        return new LeafTupleIterator(this);
    }

    @Override
    public boolean dump(Level level, PrintStream out, int height, boolean recursive) {
        boolean isRoot;
        boolean debug = level.toInt() <= Level.DEBUG.toInt();
        boolean ok = true;
        int branchingFactor = this.getBranchingFactor();
        int nkeys = this.getKeyCount();
        int minKeys = this.minKeys();
        int maxKeys = this.maxKeys();
        boolean bl = isRoot = this.btree.root == this || this.btree instanceof IndexSegment && this.btree.getEntryCount() == 0L;
        if (!isRoot && nkeys < minKeys) {
            out.println(Leaf.indent(height) + "ERROR: too few keys: m=" + branchingFactor + ", minKeys=" + minKeys + ", nkeys=" + nkeys + ", isLeaf=" + this.isLeaf() + ", isRoot=" + isRoot);
            ok = false;
        }
        if (nkeys > branchingFactor) {
            out.println(Leaf.indent(height) + "ERROR: too many keys: m=" + branchingFactor + ", maxKeys=" + maxKeys + ", nkeys=" + nkeys + ", isLeaf=" + this.isLeaf() + ", isRoot=" + isRoot);
            ok = false;
        }
        if (height != -1 && height != this.btree.getHeight()) {
            out.println(Leaf.indent(height) + "WARN: height=" + height + ", but btree height=" + this.btree.getHeight());
            ok = false;
        }
        try {
            this.assertKeysMonotonic();
        }
        catch (AssertionError ex) {
            out.println(Leaf.indent(height) + "  ERROR: " + ex);
            ok = false;
        }
        if (debug || !ok) {
            out.println(Leaf.indent(height) + this.toString());
        }
        return ok;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("{ isDirty=" + this.isDirty());
        sb.append(", isDeleted=" + this.isDeleted());
        sb.append(", addr=" + this.identity);
        Node p = this.parent == null ? null : (Node)this.parent.get();
        sb.append(", parent=" + (p == null ? "N/A" : p.toShortString()));
        sb.append(", isRoot=" + (this.btree.root == this));
        if (this.data == null) {
            sb.append(", data=NA}");
            return sb.toString();
        }
        sb.append(", nkeys=" + this.getKeyCount());
        sb.append(", minKeys=" + this.minKeys());
        sb.append(", maxKeys=" + this.maxKeys());
        DefaultLeafCoder.toString(this, sb);
        sb.append("}");
        return sb.toString();
    }

    public final void addLeafListener(ILeafListener l) {
        if (l == null) {
            throw new IllegalArgumentException();
        }
        this.btree.assertNotReadOnly();
        if (this.leafListeners == null) {
            this.leafListeners = new WeakHashMap();
        }
        this.leafListeners.put(l, null);
    }

    protected final void fireInvalidateLeafEvent() {
        if (this.leafListeners == null) {
            return;
        }
        for (ILeafListener l : this.leafListeners.keySet()) {
            l.invalidateLeaf();
        }
    }

    @Override
    public final ByteBuffer readRawRecord(long addr) {
        return this.btree.readRawRecord(addr);
    }

    public static interface ILeafListener {
        public void invalidateLeaf();
    }
}

