/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.data;

import com.bigdata.btree.data.AbstractReadOnlyNodeData;
import com.bigdata.btree.data.IAbstractNodeDataCoder;
import com.bigdata.btree.data.INodeData;
import com.bigdata.btree.raba.IRaba;
import com.bigdata.btree.raba.codec.ICodedRaba;
import com.bigdata.btree.raba.codec.IRabaCoder;
import com.bigdata.io.AbstractFixedByteArrayBuffer;
import com.bigdata.io.DataOutputBuffer;
import com.bigdata.util.BytesUtil;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.io.OutputBitStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class DefaultNodeCoder
implements IAbstractNodeDataCoder<INodeData>,
Externalizable {
    private static final long serialVersionUID = 3998574101917337169L;
    private static final transient byte VERSION0 = 0;
    private IRabaCoder keysCoder;

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        switch (version) {
            case 0: {
                break;
            }
            default: {
                throw new IOException();
            }
        }
        this.keysCoder = (IRabaCoder)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.write(0);
        out.writeObject(this.keysCoder);
    }

    @Override
    public final boolean isLeafDataCoder() {
        return false;
    }

    @Override
    public boolean isNodeDataCoder() {
        return true;
    }

    public String toString() {
        return super.toString() + "{keysCoder=" + this.keysCoder + "}";
    }

    public DefaultNodeCoder() {
    }

    public DefaultNodeCoder(IRabaCoder keysCoder) {
        if (keysCoder == null) {
            throw new IllegalArgumentException();
        }
        this.keysCoder = keysCoder;
    }

    @Override
    public INodeData decode(AbstractFixedByteArrayBuffer data) {
        return new ReadOnlyNodeData(data, this.keysCoder);
    }

    @Override
    public INodeData encodeLive(INodeData node, DataOutputBuffer buf) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        if (this.keysCoder == null) {
            throw new IllegalArgumentException();
        }
        if (buf == null) {
            throw new IllegalArgumentException();
        }
        boolean version = true;
        int nkeys = node.getKeyCount();
        long nentries = node.getSpannedTupleCount();
        int O_origin = buf.pos();
        buf.putByte((byte)0);
        buf.putShort((short)1);
        boolean hasVersionTimestamps = node.hasVersionTimestamps();
        short flags = 0;
        if (hasVersionTimestamps) {
            flags = (short)(flags | 2);
        }
        buf.putShort(flags);
        buf.putInt(nkeys);
        if (nentries < 0L) {
            throw new RuntimeException();
        }
        buf.putLong(nentries);
        int O_keysSize = buf.pos();
        buf.skip(4);
        ICodedRaba encodedKeys = this.keysCoder.encodeLive(node.getKeys(), buf);
        buf.putInt(O_keysSize, encodedKeys.data().len());
        for (int i = 0; i <= nkeys; ++i) {
            long childAddr = node.getChildAddr(i);
            if (childAddr == 0L) {
                throw new AssertionError((Object)("Child is not persistent: index=" + i + " out of " + nkeys + " entries, " + node.toString()));
            }
            buf.putLong(childAddr);
        }
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        long sum = 0L;
        for (int i = 0; i <= nkeys; ++i) {
            long nchildren = node.getChildEntryCount(i);
            sum += nchildren;
            if (nchildren < 0L) {
                throw new RuntimeException();
            }
            if (min > nchildren) {
                min = nchildren;
            }
            if (max >= nchildren) continue;
            max = nchildren;
        }
        if (sum != nentries) {
            throw new RuntimeException("spannedTupleCount=" + nentries + ", but sum over children=" + sum);
        }
        if (sum == 0L) {
            max = 0L;
            min = 0L;
        }
        long delta = max - min;
        assert (delta >= 0L);
        byte nbits = (byte)(Fast.mostSignificantBit(delta) + 1);
        buf.putByte(nbits);
        buf.putLong(min);
        if (nbits > 0) {
            int byteLength = BytesUtil.bitFlagByteLength((nkeys + 1) * nbits);
            byte[] a = new byte[byteLength];
            OutputBitStream obs = new OutputBitStream(a);
            try {
                for (int i = 0; i <= nkeys; ++i) {
                    long d = node.getChildEntryCount(i) - min;
                    assert (d >= 0L);
                    obs.writeLong(d, nbits);
                }
                obs.flush();
                buf.put(a);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (hasVersionTimestamps) {
            buf.putLong(node.getMinimumVersionTimestamp());
            buf.putLong(node.getMaximumVersionTimestamp());
        }
        AbstractFixedByteArrayBuffer slice = buf.slice(O_origin, buf.pos() - O_origin);
        return new ReadOnlyNodeData(slice, encodedKeys);
    }

    @Override
    public AbstractFixedByteArrayBuffer encode(INodeData node, DataOutputBuffer buf) {
        return this.encodeLive(node, buf).data();
    }

    public static StringBuilder toString(INodeData node, StringBuilder sb) {
        int i;
        int nchildren = node.getChildCount();
        sb.append(", nchildren=" + nchildren);
        sb.append(", spannedTupleCount=" + node.getSpannedTupleCount());
        sb.append(",\nkeys=" + node.getKeys());
        sb.append(",\nchildAddr=[");
        for (i = 0; i < nchildren; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(node.getChildAddr(i));
        }
        sb.append("]");
        sb.append(",\nchildEntryCount=[");
        for (i = 0; i < nchildren; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(node.getChildEntryCount(i));
        }
        sb.append("]");
        if (node.hasVersionTimestamps()) {
            sb.append(",\nversionTimestamps={min=" + node.getMinimumVersionTimestamp() + ",max=" + node.getMaximumVersionTimestamp() + "}");
        }
        return sb;
    }

    private static class ReadOnlyNodeData
    extends AbstractReadOnlyNodeData<INodeData>
    implements INodeData {
        private final AbstractFixedByteArrayBuffer b;
        private final short version;
        private final short flags;
        private final int nkeys;
        private final long nentries;
        private final int O_keys;
        private final ICodedRaba keys;
        private final int O_childAddr;
        private final int O_childEntryCount;
        private final byte childEntryCountBits;
        private final long minChildEntryCount;

        @Override
        public final AbstractFixedByteArrayBuffer data() {
            return this.b;
        }

        public ReadOnlyNodeData(AbstractFixedByteArrayBuffer buf, ICodedRaba keys) {
            if (buf == null) {
                throw new IllegalArgumentException();
            }
            if (keys == null) {
                throw new IllegalArgumentException();
            }
            int pos = 0;
            byte type = buf.getByte(pos);
            ++pos;
            switch (type) {
                case 0: {
                    break;
                }
                case 1: {
                    throw new AssertionError();
                }
                case 2: {
                    throw new AssertionError();
                }
                default: {
                    throw new AssertionError((Object)("type=" + type));
                }
            }
            this.version = buf.getShort(pos);
            pos += 2;
            switch (this.version) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)("version=" + this.version));
                }
            }
            this.flags = buf.getShort(pos);
            this.nkeys = buf.getInt(pos += 2);
            pos += 4;
            if (this.version == 0) {
                this.nentries = buf.getInt(pos);
                pos += 4;
            } else {
                this.nentries = buf.getLong(pos);
                pos += 8;
            }
            if (this.nentries < 0L) {
                throw new RuntimeException();
            }
            int keysSize = buf.getInt(pos);
            this.O_keys = pos += 4;
            this.keys = keys;
            pos += keysSize;
            if (keys.size() != this.nkeys) {
                throw new RuntimeException("nkeys=" + this.nkeys + ", keys.size=" + keys.size());
            }
            this.O_childAddr = pos;
            this.O_childEntryCount = this.O_childAddr + (this.nkeys + 1) * 8;
            this.childEntryCountBits = this.version >= 1 ? buf.getByte(this.O_childEntryCount) : (byte)-1;
            this.minChildEntryCount = buf.getLong(this.O_childEntryCount + 1);
            this.b = buf;
        }

        public ReadOnlyNodeData(AbstractFixedByteArrayBuffer buf, IRabaCoder keysCoder) {
            if (buf == null) {
                throw new IllegalArgumentException();
            }
            if (keysCoder == null) {
                throw new IllegalArgumentException();
            }
            int pos = 0;
            byte type = buf.getByte(pos);
            ++pos;
            switch (type) {
                case 0: {
                    break;
                }
                case 1: {
                    throw new AssertionError();
                }
                case 2: {
                    throw new AssertionError();
                }
                default: {
                    throw new AssertionError((Object)("type=" + type));
                }
            }
            this.version = buf.getShort(pos);
            pos += 2;
            switch (this.version) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)("version=" + this.version));
                }
            }
            this.flags = buf.getShort(pos);
            this.nkeys = buf.getInt(pos += 2);
            pos += 4;
            if (this.version == 0) {
                this.nentries = buf.getInt(pos);
                pos += 4;
            } else {
                this.nentries = buf.getLong(pos);
                pos += 8;
            }
            if (this.nentries < 0L) {
                throw new RuntimeException();
            }
            int keysSize = buf.getInt(pos);
            this.O_keys = pos += 4;
            this.keys = keysCoder.decode(buf.slice(this.O_keys, keysSize));
            pos += keysSize;
            if (this.keys.size() != this.nkeys) {
                throw new RuntimeException("nkeys=" + this.nkeys + ", keys.size=" + this.keys.size());
            }
            this.O_childAddr = pos;
            this.O_childEntryCount = this.O_childAddr + (this.nkeys + 1) * 8;
            this.childEntryCountBits = this.version >= 1 ? buf.getByte(this.O_childEntryCount) : (byte)-1;
            this.minChildEntryCount = buf.getLong(this.O_childEntryCount + 1);
            this.b = buf;
        }

        private int getVersionTimestampOffset() {
            if (this.version == 0) {
                return this.O_childEntryCount + (this.nkeys + 1) * 4;
            }
            return this.O_childEntryCount + 1 + 8 + BytesUtil.bitFlagByteLength((this.nkeys + 1) * this.childEntryCountBits);
        }

        @Override
        public final boolean hasVersionTimestamps() {
            return (this.flags & 2) != 0;
        }

        @Override
        public final long getMinimumVersionTimestamp() {
            if (!this.hasVersionTimestamps()) {
                throw new UnsupportedOperationException();
            }
            int off = this.getVersionTimestampOffset();
            return this.b.getLong(off);
        }

        @Override
        public final long getMaximumVersionTimestamp() {
            if (!this.hasVersionTimestamps()) {
                throw new UnsupportedOperationException();
            }
            int off = this.getVersionTimestampOffset() + 8;
            return this.b.getLong(off);
        }

        @Override
        public final boolean isLeaf() {
            return false;
        }

        @Override
        public final boolean isReadOnly() {
            return true;
        }

        @Override
        public final boolean isCoded() {
            return true;
        }

        @Override
        public final int getKeyCount() {
            return this.nkeys;
        }

        @Override
        public final int getChildCount() {
            return this.nkeys + 1;
        }

        @Override
        public final long getSpannedTupleCount() {
            return this.nentries;
        }

        protected boolean assertChildIndex(int index) {
            if (index < 0 || index > this.nkeys + 1) {
                throw new IndexOutOfBoundsException("index=" + index + ", nkeys=" + this.nkeys);
            }
            return true;
        }

        @Override
        public final long getChildAddr(int index) {
            assert (this.assertChildIndex(index));
            return this.b.getLong(this.O_childAddr + index * 8);
        }

        @Override
        public final long getChildEntryCount(int index) {
            assert (this.assertChildIndex(index));
            if (this.version == 0) {
                return this.b.getInt(this.O_childEntryCount + index * 4);
            }
            long bitpos = (long)(this.O_childEntryCount + 1 + 8 << 3) + (long)index * (long)this.childEntryCountBits;
            long bitIndex = (long)(this.b.off() << 3) + bitpos;
            long deltat = BytesUtil.getBits64(this.b.array(), (int)bitIndex, this.childEntryCountBits);
            return this.minChildEntryCount + deltat;
        }

        @Override
        public final IRaba getKeys() {
            return this.keys;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getName() + "{");
            DefaultNodeCoder.toString(this, sb);
            sb.append("}");
            return sb.toString();
        }
    }
}

