/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.filter;

import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleCursor;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.filter.ITupleFilter;
import com.bigdata.btree.keys.SuccessorUtil;
import com.bigdata.util.BytesUtil;
import cutthecrap.utils.striterators.FilterBase;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class PrefixFilter<E>
extends FilterBase
implements ITupleFilter<E> {
    protected static final transient Logger log = Logger.getLogger(PrefixFilter.class);
    private static final long serialVersionUID = 1828228416774862469L;
    private final byte[][] keyPrefix;

    public PrefixFilter(byte[] keyPrefix) {
        this(new byte[][]{keyPrefix});
    }

    public PrefixFilter(byte[][] keyPrefix) {
        if (keyPrefix == null) {
            throw new IllegalArgumentException();
        }
        if (keyPrefix.length == 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < keyPrefix.length; ++i) {
            if (keyPrefix[i] != null) continue;
            throw new IllegalArgumentException();
        }
        this.keyPrefix = keyPrefix;
    }

    @Override
    public ITupleIterator<E> filterOnce(Iterator src, Object context) {
        return new PrefixFilterator((ITupleCursor)src, context, this);
    }

    private static class PrefixFilterator<E>
    implements ITupleIterator<E> {
        private final ITupleCursor<E> src;
        private final Object context;
        private final PrefixFilter<E> filter;
        private int index = 0;
        protected byte[] toKey;
        private ITuple<E> current = null;

        public PrefixFilterator(ITupleCursor<E> src, Object context, PrefixFilter<E> filter) {
            if (src == null) {
                throw new IllegalArgumentException();
            }
            if (filter == null) {
                throw new IllegalArgumentException();
            }
            this.src = src;
            this.context = context;
            this.filter = filter;
            this.index = 0;
            this.nextPrefix();
        }

        @Override
        public boolean hasNext() {
            if (this.current != null) {
                return true;
            }
            while (this.src.hasNext()) {
                ITuple<E> tuple = this.src.next();
                byte[] key = tuple.getKey();
                if (BytesUtil.compareBytes(key, this.toKey) >= 0) {
                    if (log.isInfoEnabled()) {
                        log.info("Scanned beyond prefix: toKey=" + BytesUtil.toString(this.toKey) + ", tuple=" + tuple);
                    }
                    if (this.index + 1 < ((PrefixFilter)this.filter).keyPrefix.length) {
                        ++this.index;
                        this.nextPrefix();
                        if (this.current == null) continue;
                        return true;
                    }
                    if (log.isInfoEnabled()) {
                        log.info("No more prefixes.");
                    }
                    return false;
                }
                this.current = tuple;
                return true;
            }
            if (log.isInfoEnabled()) {
                log.info("No more tuples.");
            }
            return false;
        }

        protected void nextPrefix() {
            byte[] prefix = ((PrefixFilter)this.filter).keyPrefix[this.index];
            this.toKey = SuccessorUtil.successor((byte[])prefix.clone());
            this.current = this.src.seek(prefix);
            if (log.isInfoEnabled()) {
                log.info("index=" + this.index + ", prefix=" + BytesUtil.toString(prefix) + ", current=" + this.current);
            }
        }

        @Override
        public ITuple<E> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            assert (this.current != null);
            ITuple<E> t = this.current;
            this.current = null;
            return t;
        }

        @Override
        public void remove() {
            this.src.remove();
        }
    }
}

