/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.keys;

import com.bigdata.btree.keys.CollatorEnum;
import com.bigdata.btree.keys.DecompositionEnum;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.IKeyBuilderFactory;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.btree.keys.StrengthEnum;
import java.io.Serializable;
import java.util.Locale;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DefaultKeyBuilderFactory
implements IKeyBuilderFactory,
Serializable {
    protected static final transient Logger log = Logger.getLogger(DefaultKeyBuilderFactory.class);
    private static final long serialVersionUID = -3285057306742134508L;
    private final int initialCapacity;
    private final CollatorEnum collator;
    private final Locale locale;
    private final Object strength;
    private final DecompositionEnum decompositionMode;
    public static final String ICU_NOT_AVAILABLE = "The ICU library is not available.";

    public final int getInitialCapacity() {
        return this.initialCapacity;
    }

    public final CollatorEnum getCollator() {
        return this.collator;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public final Object getStrength() {
        return this.strength;
    }

    public final DecompositionEnum getDecompositionMode() {
        return this.decompositionMode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("{ initialCapacity=" + this.initialCapacity);
        sb.append(", collator=" + (Object)((Object)this.collator));
        sb.append(", locale=" + this.locale);
        sb.append(", strength=" + this.strength);
        sb.append(", decomposition=" + (Object)((Object)this.decompositionMode));
        sb.append("}");
        return sb.toString();
    }

    private static String getProperty(Properties properties, String key) {
        return DefaultKeyBuilderFactory.getProperty(properties, key, null);
    }

    private static String getProperty(Properties properties, String key, String def) {
        String val = null;
        if (properties != null) {
            val = properties.getProperty(key);
        }
        if (val == null) {
            val = System.getProperty(key, def);
        }
        if (log.isDebugEnabled()) {
            log.debug("name=" + key + ",val=" + val);
        }
        return val;
    }

    public DefaultKeyBuilderFactory(Properties properties) {
        boolean explicitCollatorChoice;
        this.initialCapacity = 0;
        boolean icu_avail = DefaultKeyBuilderFactory.isICUAvailable();
        if (log.isInfoEnabled()) {
            log.info("ICU library is" + (icu_avail ? "" : " not") + " available.");
        }
        this.collator = CollatorEnum.valueOf(DefaultKeyBuilderFactory.getProperty(properties, KeyBuilder.Options.COLLATOR, CollatorEnum.ICU.toString()));
        boolean bl = explicitCollatorChoice = DefaultKeyBuilderFactory.getProperty(properties, KeyBuilder.Options.COLLATOR) != null;
        if (!explicitCollatorChoice && log.isInfoEnabled()) {
            log.info("Defaulting: " + KeyBuilder.Options.COLLATOR + "=" + (Object)((Object)this.collator));
        }
        String language = DefaultKeyBuilderFactory.getProperty(properties, "user.language");
        String country = DefaultKeyBuilderFactory.getProperty(properties, "user.country");
        String variant = DefaultKeyBuilderFactory.getProperty(properties, "user.variant");
        this.locale = language == null ? Locale.getDefault() : (country == null ? new Locale(language) : (variant == null ? new Locale(language, country) : new Locale(language, country, variant)));
        if (log.isInfoEnabled()) {
            log.info("Using default locale: " + this.locale.getDisplayName());
        }
        Object tmpStrength = null;
        String val = DefaultKeyBuilderFactory.getProperty(properties, KeyBuilder.Options.STRENGTH);
        if (val != null) {
            try {
                tmpStrength = StrengthEnum.valueOf(val);
            }
            catch (RuntimeException ex) {
                tmpStrength = Integer.parseInt(val);
            }
        }
        if (log.isInfoEnabled()) {
            log.info(KeyBuilder.Options.STRENGTH + "=" + (Object)tmpStrength);
        }
        this.strength = tmpStrength;
        DecompositionEnum mode = null;
        if (DefaultKeyBuilderFactory.getProperty(properties, KeyBuilder.Options.DECOMPOSITION) != null) {
            mode = DecompositionEnum.valueOf(DefaultKeyBuilderFactory.getProperty(properties, KeyBuilder.Options.DECOMPOSITION));
            if (log.isInfoEnabled()) {
                log.info(KeyBuilder.Options.DECOMPOSITION + "=" + (Object)((Object)mode));
            }
        }
        this.decompositionMode = mode;
        if (log.isInfoEnabled()) {
            log.info(this.toString());
        }
    }

    @Override
    public IKeyBuilder getKeyBuilder() {
        if (log.isDebugEnabled()) {
            log.debug(this.toString());
        }
        return KeyBuilder.newInstance(this.initialCapacity, this.collator, this.locale, this.strength, this.decompositionMode);
    }

    @Override
    public IKeyBuilder getPrimaryKeyBuilder() {
        if (log.isDebugEnabled()) {
            log.debug(this.toString());
        }
        return KeyBuilder.newInstance(this.initialCapacity, this.collator, this.locale, (Object)StrengthEnum.Primary, this.decompositionMode);
    }

    public static boolean isICUAvailable() {
        boolean icu_avail;
        try {
            Class.forName("com.ibm.icu.text.RuleBasedCollator");
            icu_avail = true;
        }
        catch (Throwable t) {
            log.warn("ICU library is not available");
            icu_avail = false;
        }
        return icu_avail;
    }
}

