/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.keys;

import com.bigdata.btree.keys.DecompositionEnum;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.btree.keys.StrengthEnum;
import com.bigdata.btree.keys.UnicodeSortKeyGenerator;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RawCollationKey;
import com.ibm.icu.text.RuleBasedCollator;
import java.util.Locale;
import org.apache.log4j.Logger;

class ICUSortKeyGenerator
implements UnicodeSortKeyGenerator {
    private static final Logger log = Logger.getLogger(ICUSortKeyGenerator.class);
    private final RuleBasedCollator collator;
    private final Locale locale;
    private final RawCollationKey raw = new RawCollationKey(128);

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    ICUSortKeyGenerator(Locale locale, Object strength, DecompositionEnum mode) {
        if (locale == null) {
            throw new IllegalArgumentException();
        }
        this.locale = locale;
        if (log.isInfoEnabled()) {
            log.info("locale=" + locale);
        }
        this.collator = (RuleBasedCollator)Collator.getInstance(locale);
        if (strength != null) {
            if (strength instanceof Integer) {
                int str = (Integer)strength;
                if (log.isInfoEnabled()) {
                    log.info("strength=" + str);
                }
                this.collator.setStrength(str);
            } else {
                StrengthEnum str = (StrengthEnum)((Object)strength);
                if (log.isInfoEnabled()) {
                    log.info("strength=" + (Object)((Object)str));
                }
                switch (str) {
                    case Primary: {
                        this.collator.setStrength(0);
                        break;
                    }
                    case Secondary: {
                        this.collator.setStrength(1);
                        break;
                    }
                    case Tertiary: {
                        this.collator.setStrength(2);
                        break;
                    }
                    case Quaternary: {
                        this.collator.setStrength(3);
                        break;
                    }
                    case Identical: {
                        this.collator.setStrength(15);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("strength=" + strength);
                    }
                }
            }
        }
        if (mode != null) {
            if (log.isInfoEnabled()) {
                log.info("mode=" + (Object)((Object)mode));
            }
            switch (mode) {
                case None: {
                    this.collator.setDecomposition(16);
                    break;
                }
                case Full: {
                    this.collator.setDecomposition(15);
                    break;
                }
                case Canonical: {
                    this.collator.setDecomposition(17);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("mode=" + (Object)((Object)mode));
                }
            }
        }
    }

    @Override
    public void appendSortKey(KeyBuilder keyBuilder, String s) {
        this.collator.getRawCollationKey(s, this.raw);
        keyBuilder.append(this.raw.bytes, 0, this.raw.size - 1);
    }
}

